(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  16237231,     391451]
NotebookOptionsPosition[  15062137,     376728]
NotebookOutlinePosition[  15062617,     376747]
CellTagsIndexPosition[  15062574,     376744]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Tessellatica 14.2", "Title",
 CellChangeTimes->{{3.457792620618486*^9, 3.457792620974999*^9}, {
   3.4579944457748117`*^9, 3.457994446282468*^9}, {3.4629297099118633`*^9, 
   3.462929712462698*^9}, {3.485269851217624*^9, 3.485269856049508*^9}, 
   3.4861662793961477`*^9, 3.496172986157518*^9, 3.517321412986227*^9, {
   3.533503953514316*^9, 3.533503955114033*^9}, 3.533594557302519*^9, 
   3.534429204691238*^9, 3.551725159072982*^9, 3.5894638193664494`*^9, {
   3.591634795864259*^9, 3.591634798012656*^9}, 3.594211804447933*^9, 
   3.596205321848703*^9, 3.614958237636065*^9, 3.616153860367366*^9, {
   3.61642347881201*^9, 3.616423480258227*^9}, 3.624282295341617*^9, 
   3.626360881338809*^9, 3.6264801862182627`*^9, 3.627342389390836*^9, {
   3.627406828398653*^9, 3.627406828795569*^9}, 3.628116844123356*^9, 
   3.628892489278029*^9, 3.628948429095629*^9, 3.628956296830711*^9, {
   3.629217042902162*^9, 3.629217043219812*^9}, 3.6297613295516872`*^9, {
   3.630324111365421*^9, 3.630324111726664*^9}, 3.6310325745899982`*^9, 
   3.635167858921955*^9, {3.6353723752134743`*^9, 3.635372379306448*^9}, {
   3.636743026333481*^9, 3.63674302724434*^9}, 3.642795811259375*^9, 
   3.643725204020472*^9, 3.649874952651349*^9, 3.654264588164856*^9, {
   3.668362256508966*^9, 3.668362258036422*^9}, {3.668362523294218*^9, 
   3.668362524603133*^9}, 3.6722236253377934`*^9, {3.673104820998529*^9, 
   3.673104828673683*^9}, {3.675961139975892*^9, 3.675961140463188*^9}, 
   3.687461599503474*^9, 3.687461891653948*^9, {3.690999044201602*^9, 
   3.690999051155261*^9}, 3.69323964902561*^9, 3.693239679166033*^9, 
   3.693482448340544*^9, 3.693484526858531*^9, 3.693743453459585*^9, 
   3.694003261664761*^9, 3.6952374232902937`*^9, 3.701092610798036*^9, 
   3.703099771493504*^9, {3.703147280129395*^9, 3.703147280718824*^9}, 
   3.703531686195765*^9, 3.703682993297179*^9, 3.703797641770874*^9, 
   3.703966549781073*^9, 3.704482539891323*^9, 3.70560517282502*^9, 
   3.706380510751614*^9, 3.706380546965843*^9, {3.706690675364018*^9, 
   3.706690677121455*^9}, 3.707643474146594*^9, 3.707753173885192*^9, 
   3.708019936222739*^9, 3.708341865337739*^9, 3.709563636761651*^9, 
   3.718286347243129*^9, 3.7196133579322844`*^9, 3.720298961252321*^9, {
   3.721815130279512*^9, 3.721815130371229*^9}, 3.726082362810327*^9, 
   3.731190613125602*^9, {3.7315142352530193`*^9, 3.731514235947957*^9}, {
   3.731921155136392*^9, 3.731921156860082*^9}, 3.732649883081918*^9, 
   3.732657371466859*^9, 3.734527361639373*^9, 3.735650592734146*^9, 
   3.755703403910738*^9, 3.757339408548603*^9, 3.761415711002795*^9, {
   3.7650461775598793`*^9, 3.765046178994303*^9}, 3.765147183357684*^9, 
   3.7686629665772257`*^9, {3.775848762955277*^9, 3.775848763103836*^9}, 
   3.778421365129572*^9, 3.780786670716008*^9, 3.781970976722039*^9, 
   3.782513589111908*^9, 3.794837192505724*^9, 3.795279909564438*^9, 
   3.7972560696861*^9, 3.825771551634033*^9, {3.854917060134527*^9, 
   3.854917060580337*^9}, 3.911673720796988*^9, {3.913831833917452*^9, 
   3.913831834346286*^9}, 3.962633966461218*^9, {3.966630167123497*^9, 
   3.966630170092634*^9}, {3.970397486730558*^9, 
   3.970397486867506*^9}},ExpressionUUID->"b90ed607-891e-40e1-8a57-\
cc316db23201"],

Cell[TextData[{
 "Tessellatica by Robert J. Lang is licensed under a Creative Commons \
Attribution-NonCommercial 4.0 International License. See ",
 ButtonBox["http://creativecommons.org/licenses/by-nc/4.0/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://creativecommons.org/licenses/by-nc/4.0/"], None},
  ButtonNote->"http://creativecommons.org/licenses/by-nc/4.0/"],
 "."
}], "Text",
 CellChangeTimes->{{3.616506523488019*^9, 3.616506558610367*^9}, {
   3.6165066239235363`*^9, 3.616506623936784*^9}, {3.616506691314033*^9, 
   3.6165066922479057`*^9}, 3.626360922439748*^9, 3.6264803519575787`*^9, 
   3.627342396946111*^9, {3.627406833123294*^9, 3.627406833540222*^9}, {
   3.627934569917226*^9, 3.627934570052445*^9}, 3.628116846120318*^9, 
   3.628956298867755*^9, 3.635167861798008*^9, {3.690999056875606*^9, 
   3.690999057546198*^9}},ExpressionUUID->"c698617c-0e6f-4817-ace2-\
0be944e15cf4"],

Cell["\<\
Tessellatica is a package containing many routines useful in the analysis of \
origami. It brings together many functions I\[CloseCurlyQuote]ve developed \
over the years for generating origami twists, tessellations, tilings, and \
other interesting single-sheet folded geometric shapes.\
\>", "Text",
 CellChangeTimes->{{3.485269863081852*^9, 3.485269912338503*^9}, {
  3.591812106819248*^9, 3.591812107871888*^9}, {3.604780196106495*^9, 
  3.604780296638391*^9}, {3.617441145387471*^9, 3.617441169782213*^9}, {
  3.62811685030481*^9, 3.628116855336693*^9}, {3.691002211761092*^9, 
  3.691002213909664*^9}, {3.719663316556574*^9, 3.719663318908763*^9}, {
  3.722109790644408*^9, 
  3.722109797053973*^9}},ExpressionUUID->"d78045b3-c112-452d-a0c9-\
effd071f5f19"],

Cell["\<\
The documentation is associated with each function definition. First-time \
users should set $ShowExample to True in the early section \
\[OpenCurlyDoubleQuote]Examples and debugging\[CloseCurlyDoubleQuote], then \
expand the entire notebook, select and execute all cells, then look at the \
descriptions, examples, and output. For general usage, leave $ShowExample set \
to False.\
\>", "Text",
 CellChangeTimes->{{3.616423345397451*^9, 3.6164234459802313`*^9}, {
  3.6759611141991997`*^9, 3.67596112186454*^9}, {3.691002225714607*^9, 
  3.691002226167451*^9}},ExpressionUUID->"5cb3f891-34c9-49f1-bf9d-\
ab66f29f75fc"],

Cell["\<\
On a 2016 MacBook Pro, Tessellatica takes 2\[Dash]3 minutes to load with \
$ShowExample turned off. (It\[CloseCurlyQuote]s 15-20 minutes with it turned \
on.) Tessellatica plays an arpeggio when it\[CloseCurlyQuote]s done loading, \
so you can do other things while you\[CloseCurlyQuote]re waiting.\
\>", "Text",
 CellChangeTimes->{{3.691002816914444*^9, 3.691002834488009*^9}, {
   3.6912346962902107`*^9, 3.691234708447953*^9}, 3.691266047890123*^9, {
   3.693490592990169*^9, 3.693490595174103*^9}, {3.731517853482868*^9, 
   3.731517857063253*^9}, {3.734527398775342*^9, 3.734527429334045*^9}, 
   3.746192967876734*^9, {3.768663579376147*^9, 
   3.768663580228085*^9}},ExpressionUUID->"d2d63cc8-6d01-4c9a-ab32-\
15a0ae1b340f"],

Cell[TextData[{
 "Beginning with Mathematica 11.0, the Windows version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " runs into an out-of-memory error as it is loading Tessellatica. The Mac \
and Linux versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " do not exhibit this bug."
}], "Text",
 CellChangeTimes->{{3.7686635042240887`*^9, 3.768663539978367*^9}, {
  3.778572514981544*^9, 
  3.778572522687289*^9}},ExpressionUUID->"a60a5ce7-57d8-4a91-a4a4-\
1fefd0e723c8"],

Cell[CellGroupData[{

Cell["How to use Tessellatica", "Subsubsection",
 CellChangeTimes->{{3.533660675533967*^9, 3.53366067610798*^9}, {
  3.722110018251099*^9, 
  3.722110030219554*^9}},ExpressionUUID->"5b6b7a82-2bd6-425f-9eec-\
00cbeaf60e84"],

Cell[TextData[{
 "The suggested way of using this package is to copy everything in the \
\[OpenCurlyDoubleQuote]Tessellatica\[CloseCurlyDoubleQuote] level-1 cell \
group to your example notebook, select it all, and execute all the cells, \
then put your own code in a separate level-1 cell group that follows. This \
will create and load all the functions you need for the specific example, and \
it ensures that your example always contains a fully compatible version of \
the package. (At least until ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " releases their next version; every version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has broken something in Tessellatica since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.)"
}], "Text",
 CellChangeTimes->{{3.731514338121024*^9, 
  3.731514398212901*^9}},ExpressionUUID->"c34348d0-2b22-4e50-9088-\
4970511882f6"],

Cell[TextData[{
 "I am pretty much continually modifying this package, adding functions, \
fixing bugs, making changes when a new version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " breaks things that formerly worked, and sometimes just renaming functions \
because the new names seem to make more sense than the old names. I do try to \
name functions that do similar things in similar ways. Because of the \
constant changes, rather than creating using an externally loadable package \
and keeping track of a million versions, including the package in your \
notebook ensures that code based on Tessellatica is always packaged with the \
version of Tessellatica that it relies upon."
}], "Text",
 CellChangeTimes->{{3.533660679899901*^9, 3.533660952697608*^9}, {
   3.533684820713748*^9, 3.533684857627153*^9}, {3.551725401913883*^9, 
   3.551725402534231*^9}, {3.592644967773076*^9, 3.592645040062185*^9}, {
   3.628787718370359*^9, 3.628787718577873*^9}, {3.67595490754117*^9, 
   3.675954910196919*^9}, 3.731514336045793*^9, {3.731514419796993*^9, 
   3.73151444686103*^9}, {3.732657224368231*^9, 
   3.732657230144537*^9}},ExpressionUUID->"16ff44ea-8aa5-44dc-9b1e-\
3f5084c623e1"],

Cell["\<\
Tessellatica has strict chronological dependency: every function depends only \
on functions that come before it in the package. If you wish to use a \
Tessellatica function, you should load ALL functions that precede the one you \
want. It\[CloseCurlyQuote]s usually easiest to just load the whole package.\
\>", "Text",
 CellChangeTimes->{{3.722109867129922*^9, 
  3.722109964321975*^9}},ExpressionUUID->"d33fb4db-cc7c-463b-a559-\
641ec6ed2ce1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Where\[CloseCurlyQuote]s the documentation?", "Subsubsection",
 CellChangeTimes->{{3.731514489924514*^9, 
  3.731514495252342*^9}},ExpressionUUID->"bd1113b1-44dc-4f29-bcf3-\
e59c75731e54"],

Cell["\<\
I\[CloseCurlyQuote]ve tried to document each function at the point of its \
definition. If you want to know what a function does, do a search for the \
function by its name, searching from the beginning of the file; in most \
cases, the first time a function name appears is at the point of its \
definition, where you will find documentation, description, and, usually, an \
example of its usage. Reach the section \[OpenCurlyDoubleQuote]Examples and \
debugging\[CloseCurlyDoubleQuote] below for more information on how the \
examples work.\
\>", "Text",
 CellChangeTimes->{{3.7315144999645243`*^9, 
  3.731514588668506*^9}},ExpressionUUID->"35c2a180-832a-46c6-b845-\
85587ae1a1a6"],

Cell["\<\
Version information and changes from version to version are in the last \
section.\
\>", "Text",
 CellChangeTimes->{{3.73452737551118*^9, 3.734527393765714*^9}, {
  3.734527436959038*^9, 
  3.7345274425026426`*^9}},ExpressionUUID->"ad252cc3-6727-48b2-ae76-\
2fb9851dcb5e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Startup", "Section",
 CellChangeTimes->{{3.691002044064433*^9, 
  3.691002047143536*^9}},ExpressionUUID->"c2ae12aa-431e-47c3-9305-\
c4ae1323ee16"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.691002054820223*^9, 
  3.691002055357183*^9}},ExpressionUUID->"06e6c2ea-f427-4f66-9161-\
602eea9f4d42"],

Cell["\<\
We record the start time for loading Tessellatica so that we can see how long \
it took at the end.\
\>", "Text",
 CellChangeTimes->{{3.691002058035529*^9, 
  3.69100209887337*^9}},ExpressionUUID->"8e90f8fe-df52-48e3-be94-\
1bd32a23780b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$TessellaticaLoadStartTime", "=", 
   RowBox[{"SessionTime", "[", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.691002100502837*^9, 3.691002112003022*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"11190a59-e473-4201-a151-0090d9abb86e"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples and debugging", "Section",
 CellChangeTimes->{{3.615302982917232*^9, 
  3.615302992052252*^9}},ExpressionUUID->"f501eb0d-8fbd-40d9-a685-\
d89bf6c508bf"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.6759548780692472`*^9, 3.675954879725427*^9}, {
  3.708400526367096*^9, 
  3.708400527297492*^9}},ExpressionUUID->"c9cc2675-fc4e-4e55-a5c1-\
078a2317a680"],

Cell["\<\
This package contains examples of most functions that illustrate the behavior \
of the function, and also give you prototypes to copy and edit when you\
\[CloseCurlyQuote]re building your own examples. All of the example code is \
wrapped by the function ShowExample (see next section). If you want to see \
some or all examples, set the variable $ShowExample to True, and all of the \
examples encountered after your change will be evaluated and will generate \
output. This also lets you use the examples as a set of unit tests; if you \
make a change to low-level functions, you can run all the examples afterward \
and see if you get any errors.\
\>", "Text",
 CellChangeTimes->{{3.533660956209618*^9, 3.533661049827254*^9}, {
  3.533684874882035*^9, 3.533684886991224*^9}, {3.592158620249253*^9, 
  3.592158620409463*^9}, {3.592645052357283*^9, 3.5926451018101864`*^9}, {
  3.628787741704773*^9, 3.628787747783353*^9}, {3.708400536103963*^9, 
  3.708400559207007*^9}},ExpressionUUID->"a81aa9d8-9517-488e-9406-\
5e2e4b6ba9f9"],

Cell["\<\
There are some examples that contain intentional errors (they are there to \
check or demonstrate error-checking). They are wrapped in a different \
function, ShowErrorExample. You should leave this turned off when you\
\[CloseCurlyQuote]re running unit tests.\
\>", "Text",
 CellChangeTimes->{{3.592645108257622*^9, 
  3.592645158518008*^9}},ExpressionUUID->"ddc62780-6992-4912-8451-\
9455a065b541"],

Cell["\<\
Some of the examples involve reading and writing files. In order to avoid \
cluttering up the local filesystem when you\[CloseCurlyQuote]re running \
examples, all example files are stored in a special directory set by the \
global variable $ExamplesDir. See usage (and change its value) in the next \
section.\
\>", "Text",
 CellChangeTimes->{{3.675954785132431*^9, 
  3.675954868285989*^9}},ExpressionUUID->"91cbd2e6-ce9a-4581-8933-\
a4f1962aeb65"]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples flags", "Subsection",
 CellChangeTimes->{{3.675953350615927*^9, 
  3.675953352238573*^9}},ExpressionUUID->"32abbfe6-5377-4ba2-aaf5-\
d34b4af2b177"],

Cell[CellGroupData[{

Cell[TextData[{
 "ShowExample[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]\n$ShowExample"
}], "Subsubsection",
 CellChangeTimes->{{3.456329278713707*^9, 3.456329292858005*^9}, {
   3.45653302409159*^9, 3.456533027736541*^9}, {3.4575288138787823`*^9, 
   3.457528817149901*^9}, {3.592214342830651*^9, 3.592214354307988*^9}, 
   3.615303518793036*^9},ExpressionUUID->"935a3475-3d11-4ca8-a147-\
e2fdef8567af"],

Cell[TextData[{
 "ShowExample[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] resolves to either Null or Evaluate[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] depending on the value of $ShowExample. if you turn $ShowExample on, all \
example cells will be evaluated and displayed, otherwise nothing will happen \
for each."
}], "Text",
 CellChangeTimes->{{3.456329295041719*^9, 3.456329343486969*^9}, {
  3.456533032971216*^9, 3.456533036323051*^9}, {3.592214382594751*^9, 
  3.592214383146118*^9}, {3.592827934455015*^9, 3.592827946068602*^9}, {
  3.757442665052378*^9, 
  3.757442666996913*^9}},ExpressionUUID->"acd993b9-5b46-428f-9abf-\
f46a73ab6484"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ShowExample", "[", "expr_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{"$ShowExample", ",", "expr", ",", "Null"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ShowExample", ",", "HoldAllComplete"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.45632934554023*^9, 3.456329351609036*^9}, {
  3.456329429783335*^9, 3.456329470026037*^9}, {3.456533049846699*^9, 
  3.456533057701126*^9}, {3.757441879194008*^9, 3.757441918081097*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"dc8055bb-6f89-4464-8028-effb09e30cae"],

Cell["\<\
You can change the value of $ShowExample here or on the fly to turn on/off \
example display.\
\>", "Text",
 CellChangeTimes->{{3.45632951936366*^9, 3.456329539122192*^9}, 
   3.592214565693589*^9, {3.617440780291971*^9, 
   3.617440782741289*^9}},ExpressionUUID->"2e789f87-2211-41d8-a42e-\
56b358084fff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ShowExample", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdzntUk3UcBvDBGZcAcTAFxTURUaeVEZ2Mo2T+DHbIDZpAgLaMJiAoomy4
BkEgASoePTJm6jhySUwURAMklHGRcccht3AI5IWj8L4vlwwRTu5Ev9/3j+/5
/PGc5znfNbIjgZHmLBYrEh+xsUv8NLaRQp3Ng2PEkI1nGKI4dRwc3LY4+xDL
r7F7TQxPYgt7sH89swftxrWzxIm118Ei0aPk6iYKnT71DIzdsZul0VOoL1QG
dhtMqlfYKrF1IlGypLqf3Uwhv2g9GGZySbHvpFDU2w1gQOvCCaLS2vIkcWKI
pybK+wWg92D9WS42Wx6nJqoV2/2XYUNqxOD7T5l97djw9jdgsiTjUT/2zW41
eHF5zjCxp/Y3MGNZjK9TF4WO2irBrDC/+zxs7KVFsEsRbySOHU4FNxTFnHmJ
1T5OABNKPjxPLKn0BiWDrz4NnsP7JrYXUd4/cpRoavkmnsj3HUssw36VNQM+
jj+ZRqy3uAj+fCinmHinpwjcWyrqIr44shfMGDJ6tL+h0CL3BXh7PjmaeI9d
CXKGKOsurN/ZebBmzQERsf5QAjibzq0rCKJRDcUHJ89fiu3F7qhtAM+pKEVm
HY2SKuZBneTUMdN9GjXSpWBtyTXG0ESjo8KHk0SN8d9Jlp5GEl+bKaL2v7uL
xLLePrAur2fPMLb22hNQUxgoGcHK74SDuXdbfayaaZR2xwh2XD4SSXwyzY8i
GjNb44jrt42Czn966qqwISwRuF2pTW3Fml0pB5UDw51t2Lz8GZBT0ba2D5u5
bgHkr3x9Kr2FRh9XWWQTl3pp24i+9tfBknKhZ0IbjYIdg0HBQI7jL9hr/vmg
Z3fmR8RYFzW4KVVaegHbsfogOH21wC+/A/81dQPkOC/2VWOnlcJ+ojCv29Ta
SSM9bxRc1mlj24a1c3QBm7h6j0NG3NcZQXtLgfIwVhbmC27fIHA3TdNoIf4T
0Mt1fn/wDI2aA1ZEEHfGVF8uxmrCm8GG0pcU0fDZHOhl5dB0z5JBzx344Ipn
mtJa7L7jf4BiwYGkm1YM+rvoR3DE27aXaGC7gOx3FSruOwxSGLPAocpLUg9s
XM8t0OwE94GU5O18MMXSzv9bbEbHKrBivmHzOSyHegDai+11Gqz4Jx64xfqm
9RVbBr08WA+GaJdqrmJ9Rl3BYoXnGXo5g9xWfg6ai7j8Sez6MlfQ9NxiE5Fz
3hmcSotnT2ET3NJBd+0/iWbrGFS+1TyJyEtNdDLHuo0Vgo/n0lOC9zOoveQs
KKr70ikUy3PeA1aP77wQGMGgqrTdoI0syu1r7K7TSjB+cw7Vm8sggU8BWLO1
8Ys+bO6NOZDVQkcSvRfmQY1+5fcDWF3vRnD2g6i3uwoZFB2lAmVSUbgYW/ae
FHT5bqg5CHv893HQ3EeYtKWIQb+qQkFVYr6aKOu8DWbfYpWJDQySHnMAtyh0
qwKwy+VdoKOT4RhaMomadCOgq/uYXo6t7XsNRpiZTazOmkKtQRxQ5p79gyuW
9SgP/B8jnmYM
  "],
 CellLabel->"In[4]:=",ExpressionUUID->"5317f76f-ea92-4d1f-8cc6-9164ebc78611"],

Cell[BoxData[
 RowBox[{"ShowExample", "[", 
  RowBox[{"Print", "[", "\"\<ShowExample is turned on\>\"", "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.456329489347595*^9, 3.456329497271352*^9}, {
  3.456329543388857*^9, 3.4563295474437447`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"884b009f-8a94-44b8-a50c-26e56000eb6e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ShowErrorExample[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]\n$ShowErrorExample"
}], "Subsubsection",
 CellChangeTimes->{{3.6153035227404346`*^9, 
  3.615303526418508*^9}},ExpressionUUID->"56806274-fe70-4347-915d-\
ed7bc90b25e3"],

Cell[TextData[{
 "ShowErrorExample[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] resolves to either Null or Evaluate[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] depending on the value of $ShowErrorExample. Example cells that \
intentionally throw errors are wrapped in ShowErrorExample, rather than \
ShowExample."
}], "Text",
 CellChangeTimes->{{3.456329295041719*^9, 3.456329343486969*^9}, {
  3.456533032971216*^9, 3.456533036323051*^9}, {3.5922143641902933`*^9, 
  3.592214450965918*^9}, {3.592827956452107*^9, 3.592827976466679*^9}, {
  3.757442672032612*^9, 
  3.757442676182122*^9}},ExpressionUUID->"204cd1b6-7303-410b-9e4f-\
b00d86b51fd5"],

Cell["\<\
The reason for both ShowExample and ShowErrorExample is that the examples \
serve the role of unit tests; if you make a change to a low-level routine or \
rename a function Tessellatica-wide, you can turn on ShowExample and execute \
the entire notebook and then check the Messages window for errors to see if \
your change broke anything. If you leave ShowErrorExamples turned off, then \
you won\[CloseCurlyQuote]t see intentional errors, only unintentional ones.\
\>", "Text",
 CellChangeTimes->{{3.592214453662489*^9, 3.5922145370634003`*^9}, {
  3.592214595460044*^9, 3.592214625426161*^9}, {3.592827989514027*^9, 
  3.592828003225102*^9}, {3.617440817556352*^9, 
  3.61744082259765*^9}},ExpressionUUID->"8daa5a78-ed8f-48fd-84b9-\
42b6a199922b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ShowErrorExample", "[", "expr_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{"$ShowErrorExample", ",", "expr", ",", "Null"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"ShowErrorExample", ",", "HoldAllComplete"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.45632934554023*^9, 3.456329351609036*^9}, {
  3.456329429783335*^9, 3.456329470026037*^9}, {3.456533049846699*^9, 
  3.456533057701126*^9}, {3.592214542371984*^9, 3.592214552243997*^9}, {
  3.75744192344168*^9, 3.757441927619241*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"a2236b45-212c-4f1b-86ca-3acf0e93920c"],

Cell["\<\
You can change the value here or on the fly to turn on/off error example \
display.\
\>", "Text",
 CellChangeTimes->{{3.45632951936366*^9, 3.456329539122192*^9}, {
  3.59221456392082*^9, 
  3.5922145718929796`*^9}},ExpressionUUID->"937b92d6-2a31-480c-93c4-\
a745d0bef00e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ShowErrorExample", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.456329474399872*^9, 3.456329502711522*^9}, {
   3.456329564411296*^9, 3.456329567234289*^9}, {3.456532383976054*^9, 
   3.456532384397475*^9}, {3.456533040139939*^9, 3.456533040465072*^9}, {
   3.456534428840704*^9, 3.456534429285633*^9}, {3.457528806727982*^9, 
   3.45752880704804*^9}, {3.457982466539114*^9, 3.45798246707322*^9}, {
   3.4581738959001226`*^9, 3.458173896259363*^9}, {3.458213533689125*^9, 
   3.458213534106479*^9}, {3.461379048843305*^9, 3.461379049249439*^9}, {
   3.461379135774207*^9, 3.461379136188533*^9}, {3.4613792169016*^9, 
   3.461379217275811*^9}, {3.461389429963651*^9, 3.461389459451482*^9}, {
   3.461390953951608*^9, 3.461390954397502*^9}, {3.4617597353711147`*^9, 
   3.46175973571196*^9}, {3.4617832281348248`*^9, 3.461783228572505*^9}, {
   3.461783260533886*^9, 3.461783261210428*^9}, {3.4619192752837543`*^9, 
   3.461919275688896*^9}, {3.461932554260806*^9, 3.461932559987479*^9}, {
   3.461932739545385*^9, 3.461932739982164*^9}, {3.462345835300922*^9, 
   3.462345835651684*^9}, {3.462345897489313*^9, 3.462345897896931*^9}, {
   3.484066239557411*^9, 3.484066240155861*^9}, {3.484066694900811*^9, 
   3.484066698867918*^9}, {3.484246991102187*^9, 3.484246991485145*^9}, {
   3.484247044263898*^9, 3.484247044750701*^9}, {3.484247332544374*^9, 
   3.484247333056727*^9}, {3.484247642364667*^9, 3.484247642826159*^9}, {
   3.484828038776552*^9, 3.484828039158691*^9}, {3.484828483905235*^9, 
   3.484828485594327*^9}, {3.484833863307747*^9, 3.484833863736119*^9}, {
   3.484834395222866*^9, 3.484834395638152*^9}, {3.533503976609735*^9, 
   3.53350397696603*^9}, {3.533605732799551*^9, 3.5336057339916077`*^9}, {
   3.589024671295967*^9, 3.589024671740538*^9}, {3.591365548291106*^9, 
   3.591365549372406*^9}, {3.591794525239347*^9, 3.591794534477349*^9}, {
   3.591898983838937*^9, 3.591898984320961*^9}, {3.591899133812329*^9, 
   3.591899134588094*^9}, 3.592214560194449*^9, {3.592346301777478*^9, 
   3.592346302233653*^9}, {3.592352385340465*^9, 3.592352386092733*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"d5476b5c-a3ce-44a5-a1ee-cc65752e2d1b"],

Cell[BoxData[
 RowBox[{"ShowErrorExample", "[", 
  RowBox[{"Print", "[", "\"\<ShowErrorExample is turned on\>\"", "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.456329489347595*^9, 3.456329497271352*^9}, {
  3.456329543388857*^9, 3.4563295474437447`*^9}, {3.59221455458921*^9, 
  3.592214556035076*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"30f52d83-8d33-4071-9181-340d6fc8894c"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples directory", "Subsection",
 CellChangeTimes->{{3.675953259780084*^9, 
  3.67595326219607*^9}},ExpressionUUID->"70c43c37-d9f1-44ce-9e5e-\
a91b43525323"],

Cell[CellGroupData[{

Cell["\<\
$ExamplesDir
ExamplesDir[]\
\>", "Subsubsection",
 CellChangeTimes->{{3.6759534516103*^9, 3.6759534889130917`*^9}, {
  3.675953806980458*^9, 3.675953834806718*^9}, {3.675953878612337*^9, 
  3.675953907042697*^9}},ExpressionUUID->"8a2d8ed4-200a-489b-a4ee-\
4e66c599512b"],

Cell["\<\
$ExamplesDir is a folder in which Tessellatica will put files used in \
examples when $ShowExample is turned on. This variable only has an effect \
when $ShowExample is turned on. If it is turned on, the package will attempt \
to create this directory. If $ShowExample is off, nothing happens.\
\>", "Text",
 CellChangeTimes->{{3.675953494053394*^9, 3.6759536442190313`*^9}, 
   3.67595368380819*^9, 3.675953887045984*^9, {3.675953922033928*^9, 
   3.675953948583631*^9}, {3.675954973616816*^9, 3.675955008789719*^9}, {
   3.67595505108311*^9, 
   3.6759550982997503`*^9}},ExpressionUUID->"7ad0ae17-8661-45e6-a6e8-\
59b70bac2a6d"],

Cell["\<\
You can change the value here or on the fly to set the examples directory. \
The default value is safe to use on *nix systems. Change it here if you are \
executing the entire notebook and set $ShowExample to True above.\
\>", "Text",
 CellChangeTimes->{{3.675954104471608*^9, 3.675954137699614*^9}, {
   3.675955016398036*^9, 3.675955044075508*^9}, {3.675955107846561*^9, 
   3.675955135101112*^9}, 
   3.67603392589397*^9},ExpressionUUID->"030825a1-5f07-4c86-8330-\
d4bb28218ec3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ExamplesDir", "=", "\"\<~/Desktop/tessellatica-examples\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.675954141593174*^9, 3.675954160635638*^9}, 
   3.676033882067528*^9, 3.676033977942711*^9, {3.676034759737619*^9, 
   3.676034761318117*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"6a58aa2c-3705-457d-8df2-1a1375d905e7"],

Cell["\<\
ExamplesDir[] is the function used internally to encapsulate $ExamplesDir to \
refer to the examples directory. It tries to create the examples directory if \
it doesn\[CloseCurlyQuote]t yet exist and then returns that directory. This \
function is only called from within example code so if you don\
\[CloseCurlyQuote]t have $ShowExamples turned on, it will never be called and \
the directory will never be created.\
\>", "Text",
 CellChangeTimes->{{3.675953771371639*^9, 3.675953780867118*^9}, {
  3.675953851702478*^9, 3.675953862997441*^9}, {3.67595395378336*^9, 
  3.6759540501939096`*^9}, {3.675955144276737*^9, 
  3.675955144997195*^9}},ExpressionUUID->"8ee9475f-6892-4db6-a0f7-\
128510dd97da"],

Cell["\<\
If it is not possible to create the directory, a fatal error is generated.\
\>", "Text",
 CellChangeTimes->{{3.675954054353627*^9, 
  3.675954067632845*^9}},ExpressionUUID->"90c5a72b-19fd-4b3c-976f-\
3b888dbb1e2e"],

Cell["\<\
Note that $ExamplesDir does not include a terminal \[OpenCurlyDoubleQuote]/\
\[CloseCurlyDoubleQuote] delimiter, but ExamplesDir[] does, so that you can \
append a file name to it directly to add further examples.\
\>", "Text",
 CellChangeTimes->{{3.676034007296389*^9, 3.6760340572207613`*^9}, {
  3.676034138672229*^9, 
  3.676034145709734*^9}},ExpressionUUID->"fcb136f1-0b2e-4c32-97f6-\
cb652674cd5c"],

Cell["\<\
The recommended naming convention for example export files is to name the \
file with the function name that it is demonstrating an example of.\
\>", "Text",
 CellChangeTimes->{{3.676034318143922*^9, 
  3.676034381319756*^9}},ExpressionUUID->"3240e9ab-6267-40e9-9a9a-\
4f46da20090e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExamplesDir", "::", "nocreate"}], 
   "=", "\"\<Tessellatica was unsable to create the examples directory at \
`1`.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.675954292672937*^9, 3.675954323385565*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"96c5fed8-4028-4cd7-8fda-48ee7b7f83b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExamplesDir", "[", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"path", ",", "dir"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"path", "=", "$ExamplesDir"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"DirectoryQ", "[", "path", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"path", "<>", "\"\</\>\""}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dir", "=", 
         RowBox[{"CreateDirectory", "[", "path", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"dir", "===", "$Failed"}], ",", 
          RowBox[{
           RowBox[{"Message", "[", "]"}], ";", 
           RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"path", "<>", "\"\</\>\""}]}]}], "]"}]}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.675954192266355*^9, 3.675954216730591*^9}, {
   3.675954273255913*^9, 3.675954290171629*^9}, {3.675954369593163*^9, 
   3.6759544465882387`*^9}, {3.6760339862056227`*^9, 3.676033987789201*^9}, 
   3.67603479338494*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"64f5d591-6548-4dd0-b0d9-0a518f5fd21b"],

Cell["\<\
Example, which will create the examples directory if $ShowExample is turned \
on.\
\>", "Text",
 CellChangeTimes->{{3.675954489982101*^9, 
  3.675954536187188*^9}},ExpressionUUID->"1d5fa793-e4d2-4c24-9dd1-\
a5119ee7fdb6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ExamplesDir", "[", "]"}]}], "\[IndentingNewLine]", "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.67595450899528*^9, 3.675954541850883*^9}, {
  3.675955169012184*^9, 3.675955170932123*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"57db38d3-0639-4f85-8bbf-f624c04738f1"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Debugging utilities", "Subsection",
 CellChangeTimes->{{3.675953356886351*^9, 
  3.6759533596135187`*^9}},ExpressionUUID->"bb17ac89-782c-4aa5-89fd-\
8d9d8891d468"],

Cell[CellGroupData[{

Cell[TextData[{
 "PrintThis[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.45752870432848*^9, 
  3.457528704696002*^9}},ExpressionUUID->"dc1b9544-67cc-4f49-9ba5-\
ae3193e2ab24"],

Cell[TextData[{
 "PrintThis[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] is a function used in debugging that takes an expression and prints to \
the console the display form of the expression ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " and its value, and then returns the evaluated value of ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " as its return value. It's particularly useful because you can temporarily \
insert \"PrintThis@\" before an expression to display it without otherwise \
altering the flow of the function. However, since it returns a copy of the \
return value, you can't apply PrintThis[] to an lvalue (",
 StyleBox["e.g.",
  FontSlant->"Italic"],
 ", the argument of Set or AppendTo)."
}], "Text",
 CellChangeTimes->{
  3.457528710683627*^9, {3.457528746831794*^9, 3.457528746959401*^9}, {
   3.6759533690776253`*^9, 
   3.675953389212805*^9}},ExpressionUUID->"c5529506-3527-4c88-b10e-\
fd9cc567a7d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrintThis", "[", "expr_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y", "=", "expr"}], "}"}], ",", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"HoldForm", "[", "expr", "]"}], ",", "\"\< = \>\"", ",", "y"}],
       "]"}], ";", "y"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.457528715932825*^9, 3.457528725441883*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"deb802d7-adfb-4e04-be82-b20d5f8eab1f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"PrintThis", ",", "HoldFirst"}], "]"}], ";"}]], "Input",
 CellLabel->"In[15]:=",ExpressionUUID->"b4185eb6-720c-4f3f-9f2e-48857cdb15f9"],

Cell["Example", "Text",ExpressionUUID->"20de35ac-b2a5-4726-80b3-60cc503290a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"foo", "=", "1"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PrintThis", "[", 
     RowBox[{"++", "foo"}], "]"}]}], "\[IndentingNewLine]", "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.45752875711287*^9, 3.45752878189353*^9}, 
   3.457528887012565*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"f950efda-407e-43a6-812d-f34d53668ad9"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General utilities", "Section",
 CellChangeTimes->{{3.45789803503389*^9, 3.45789803839126*^9}, 
   3.462972663212628*^9},ExpressionUUID->"820ba282-3c74-49b3-bdb8-\
b79a0900b295"],

Cell[CellGroupData[{

Cell["General setup", "Subsection",
 CellChangeTimes->{
  3.593213511601623*^9},ExpressionUUID->"e3c3ab12-9764-4b4c-8f6e-\
4511d8e6e596"],

Cell[CellGroupData[{

Cell["Off[General::spell, General::spell1]", "Subsubsection",
 CellChangeTimes->{
  3.45589736043391*^9},ExpressionUUID->"6f654f51-d4f0-4005-a5a3-98cd58b75e00"],

Cell["Turn off spelling messages we don't care about.", "Text",ExpressionUUID->"3f7580ac-2b58-41ff-8c9d-f635eb2c82d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{
    RowBox[{"General", "::", "spell"}], ",", 
    RowBox[{"General", "::", "spell1"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"60fcd4f3-c778-46a6-ad95-abeafba58729"]
}, Closed]],

Cell[CellGroupData[{

Cell["SetOptions[Graphics, ...]", "Subsubsection",
 CellChangeTimes->{{3.455897313491186*^9, 3.455897317895329*^9}, {
  3.731514774766974*^9, 
  3.731514779163458*^9}},ExpressionUUID->"bfaa08c6-8516-495d-9719-\
ae02cf880853"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Graphics", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.45589731920096*^9, 3.4558973443193607`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"75885c1a-2c2a-4150-8563-b4ea816c502d"]
}, Closed]],

Cell[CellGroupData[{

Cell["SetOptions[Graphics3D, ...]", "Subsubsection",
 CellChangeTimes->{{3.442671046230528*^9, 
  3.442671066279542*^9}},ExpressionUUID->"bfecd5df-987a-4fc2-8bcf-\
a6a6aad320bd"],

Cell["\<\
Make all 3D plots with automatic aspect ratios and plot all points and use \
neutral lighting.\
\>", "Text",
 CellChangeTimes->{{3.442671088936442*^9, 
  3.442671101392929*^9}},ExpressionUUID->"41274161-1af8-400a-a86b-\
61acb06bbb17"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Graphics3D", ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", " ", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.442671072180904*^9, 3.4426710769961233`*^9}, {
  3.442671147224654*^9, 3.442671147652195*^9}, {3.4563618011543922`*^9, 
  3.456361803249324*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"74d83506-4ba8-42ba-909c-75a2b01c0bd1"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Colors", "Subsection",
 CellChangeTimes->{{3.45752883163302*^9, 
  3.45752883510456*^9}},ExpressionUUID->"50ca599d-9981-4511-928b-\
26aef65bd5f2"],

Cell[CellGroupData[{

Cell["\<\
AllColors
Red, Green, Blue, Cyan, Magenta, Orange, White, LightGray, Gray, DarkGray, \
Black\
\>", "Subsubsection",
 CellChangeTimes->{{3.484770749568613*^9, 3.484770759494554*^9}, 
   3.484770804099783*^9, {3.6317849353003407`*^9, 
   3.631784937987058*^9}},ExpressionUUID->"62c5bf14-9c30-4b3b-9ef1-\
446b5498aff9"],

Cell["The following are some predefined colors we can use by name.", "Text",ExpressionUUID->"e37b4a89-68c4-46b0-9f4d-8a7a98932792"],

Cell[TextData[{
 "2005-11-29. Some of these are now predefined by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Comments give the original definitions."
}], "Text",
 CellChangeTimes->{{3.708400701898536*^9, 3.708400718811882*^9}, 
   3.731514787923581*^9},ExpressionUUID->"c50312d1-de38-42ba-bf9c-\
74b3519bc10d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AllColors", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"Red", ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"=", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"1", ",", "0", ",", "0"}], "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", "Green", ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"=", " ", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "1", ",", "0"}], "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", "Blue", ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"=", " ", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "0", ",", "1"}], "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", "Cyan", ",", "\[IndentingNewLine]", "Magenta", ",",
      "\[IndentingNewLine]", "Orange", ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"=", " ", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"1", ",", ".5", ",", "0"}], "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", "White", ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"=", 
       RowBox[{"GrayLevel", "[", "1", "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", "LightGray", " ", ",", 
     RowBox[{"(*", " ", 
      RowBox[{"=", 
       RowBox[{"GrayLevel", "[", ".75", "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", "Gray", ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"=", " ", 
       RowBox[{"GrayLevel", "[", ".5", "]"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"DarkGray", "=", 
      RowBox[{"GrayLevel", "[", ".25", "]"}]}], ",", "\[IndentingNewLine]", 
     "Black"}], " ", 
    RowBox[{"(*", " ", 
     RowBox[{"=", " ", 
      RowBox[{"GrayLevel", "[", "0", "]"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.484770844929075*^9, 3.484770901704277*^9}, {
  3.631784862277186*^9, 3.631784867200292*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"f99c9749-32d4-420e-9803-0bba37673866"],

Cell[BoxData[
 TemplateBox[{
  "Set", "wrsym", 
   "\"Symbol \\!\\(\\*RowBox[{\\\"DarkGray\\\"}]\\) is Protected.\"", 2, 20, 
   1, 34357434793564800611, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.966628791352172*^9, 3.967120789414194*^9},
 CellLabel->
  "During evaluation of \
In[20]:=",ExpressionUUID->"fbd1cdc6-1012-45ab-ae44-1fec8162fa6e"]
}, Closed]],

Cell["Example", "Text",ExpressionUUID->"88cf7081-552c-4f84-8c95-2cf3b8f1e793"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AllColors", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Polygon", "[", "#", "]"}], ",", "Black", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"Append", "[", 
            RowBox[{"#", ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}], "}"}], "&"}], 
       "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "AllColors", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.4575288643861313`*^9, 3.45752887052098*^9}, {
   3.484770918614937*^9, 3.4847709236881227`*^9}, 3.631785256957553*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"e43f3289-ae87-4584-b646-8267b96039b0"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
AllCMYKColors
RedCMYK, GreenCMYK, BlueCMYK, CyanCMYK, MagentaCMYK, OrangeCMYK, WhiteCMYK, \
LightGrayCMYK, GrayCMYK, DarkGrayCMYK, BlackCMYK\
\>", "Subsubsection",
 CellChangeTimes->{{3.631784912278942*^9, 
  3.6317849955045*^9}},ExpressionUUID->"a478b41a-dc82-4aa7-8eca-8da82eb9cb99"],

Cell["For print, we should use CMYK colors.", "Text",
 CellChangeTimes->{{3.631785001633918*^9, 
  3.631785007231118*^9}},ExpressionUUID->"78c1a08e-e6cd-4190-92e9-\
8634185bd709"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AllColorsCMYK", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"RedCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Red", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"GreenCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Green", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BlueCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Blue", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"CyanCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Cyan", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"MagentaCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Magenta", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"OrangeCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Orange", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"WhiteCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"White", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LightGrayCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"LightGray", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"GrayCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Gray", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DarkGrayCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"DarkGray", ",", "\"\<CMYK\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BlackCMYK", "=", 
      RowBox[{"ColorConvert", "[", 
       RowBox[{"Black", ",", "\"\<CMYK\>\""}], "]"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6317850125646343`*^9, 3.631785179844404*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"34b1c32f-a485-4c62-ba8f-1fd8ac5763b7"],

Cell["Example", "Text",ExpressionUUID->"543cbe85-6a04-422e-89b1-12b607ae8050"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AllColorsCMYK", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"Polygon", "[", "#", "]"}], ",", "Black", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"Append", "[", 
            RowBox[{"#", ",", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}], "}"}], "&"}], 
       "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"i", "+", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "AllColors", "]"}]}], "}"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.4575288643861313`*^9, 3.45752887052098*^9}, {
   3.484770918614937*^9, 3.4847709236881227`*^9}, {3.6317851660657263`*^9, 
   3.631785167632419*^9}, 3.631785259677748*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"ebd71558-5fcd-4bbc-bca1-630588b8ac5f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Rainbow[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.7005975877949886`*^9, 
  3.7005975940555487`*^9}},ExpressionUUID->"a0816c65-a6ca-4d5c-8b82-\
fe04963867ff"],

Cell[TextData[{
 "Rainbow[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns a list of ",
 StyleBox["n",
  FontSlant->"Italic"],
 " colors spanning the rainbow, from red to violet."
}], "Text",
 CellChangeTimes->{{3.7005976128474717`*^9, 
  3.700597641535849*^9}},ExpressionUUID->"481bb55e-7e49-40ea-9440-\
c30a9b35dc1e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rainbow", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hue", "[", 
     RowBox[{".75", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"i", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.700597603937405*^9, 3.700597610082672*^9}, {
  3.700597701679429*^9, 3.700597724073336*^9}, {3.700597882692567*^9, 
  3.700597883291312*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"837dcba2-64ea-40d6-a939-08ea325d52a0"],

Cell["Example", "Text",
 CellChangeTimes->{{3.700597727296576*^9, 
  3.700597727992475*^9}},ExpressionUUID->"a70e6c15-9a16-4a8f-bf5e-\
37afddfbe0eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rainbow", "[", "7", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.700597863566201*^9, 3.700597901218213*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"39ccf2ec-d0d1-46c1-883d-f8779a157360"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["List utilities", "Subsection",
 CellChangeTimes->{{3.4575294104783177`*^9, 3.4575294113418293`*^9}, {
   3.484018240152065*^9, 3.484018248004361*^9}, 
   3.484065901914776*^9},ExpressionUUID->"de41be0f-7786-4ae8-b55e-\
f8217a1dae33"],

Cell[CellGroupData[{

Cell[TextData[{
 "Mod4[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.441992266859961*^9, 
  3.4419922696732597`*^9}},ExpressionUUID->"b6517c22-e89f-485a-bcce-\
e76f985f86e2"],

Cell[TextData[{
 "Mod4[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] is shorthand for Mod[",
 StyleBox["n",
  FontSlant->"Italic"],
 ",4,1], useful for cyclic reference into a list of 4 items."
}], "Text",
 CellChangeTimes->{{3.441992273505816*^9, 
  3.4419922947460203`*^9}},ExpressionUUID->"e03db4bb-1497-462b-b223-\
085986a86127"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mod4", "[", "n_", "]"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{"n", ",", "4", ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.441992303821642*^9, 3.441992310198207*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"acd6130a-20f8-4839-8127-2d0bdfe4ed02"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ListEmptyQ[",
 StyleBox["list",
  FontSlant->"Italic"],
 "]\nNot",
 "ListEmptyQ",
 "[",
 StyleBox["list",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.45752895779803*^9, 3.457528966195747*^9}, {
  3.457529000009531*^9, 3.457529000615954*^9}, {3.458217300740511*^9, 
  3.4582173007572203`*^9}},ExpressionUUID->"028e2630-da22-47d3-8739-\
1f2d4fb98c45"],

Cell[TextData[{
 "ListEmptyQ",
 "[",
 StyleBox["list",
  FontSlant->"Italic"],
 "] returns True if the list is empty."
}], "Text",
 CellChangeTimes->{
  3.458217300773197*^9},ExpressionUUID->"c71bc46b-7dbe-4efd-8d65-\
b4434d265deb"],

Cell[TextData[{
 "This was previously just EmptyQ[], but that now causes a namespace \
collision with the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " package."
}], "Text",
 CellChangeTimes->{{3.458217330417517*^9, 
  3.458217350704287*^9}},ExpressionUUID->"b69ef8a1-6cdc-409c-94a2-\
bbdd84455328"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ListEmptyQ", "[", "list_List", "]"}], ":=", 
  RowBox[{
   RowBox[{"Length", "[", "list", "]"}], "\[Equal]", "0"}]}]], "Input",
 CellChangeTimes->{{3.45821687779585*^9, 3.458216878178237*^9}, 
   3.458217300785782*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"6a664ade-3a84-42b4-851a-32ee13fb028f"],

Cell[TextData[{
 "Not",
 "ListEmptyQ",
 "[",
 StyleBox["list",
  FontSlant->"Italic"],
 "] returns True if the list is not empty."
}], "Text",
 CellChangeTimes->{
  3.458217300810644*^9},ExpressionUUID->"95c63d37-daf4-4e7b-adfd-\
876d9d8731f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotListEmptyQ", "[", "list_List", "]"}], ":=", 
  RowBox[{
   RowBox[{"Length", "[", "list", "]"}], "\[NotEqual]", "0"}]}]], "Input",
 CellChangeTimes->{{3.458216881338397*^9, 3.45821688173754*^9}, 
   3.4582173008518667`*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"27391beb-d13a-447f-b0a2-167ab5699ad2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "IntersectingQ[",
 StyleBox["list1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["list2",
  FontSlant->"Italic"],
 "] replaces IntersectsQ[",
 StyleBox["list1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["list2",
  FontSlant->"Italic"],
 "]\nMemberQ[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["elem",
  FontSlant->"Italic"],
 "] replaces ContainsQ[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["elem",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.455907926383439*^9, 3.45590793627962*^9}, {
   3.457660977309129*^9, 3.457660983684253*^9}, {3.458217159695476*^9, 
   3.458217200378636*^9}, {3.466088941035633*^9, 3.466088942402978*^9}, {
   3.484834050147419*^9, 3.4848340573057*^9}, {3.484834095440961*^9, 
   3.484834096942853*^9}, {3.591639526205349*^9, 3.5916395290595837`*^9}, 
   3.592441954994583*^9, {3.643721445077238*^9, 3.643721451283771*^9}, {
   3.675843523186791*^9, 3.6758435268809443`*^9}, {3.706726657907048*^9, 
   3.7067266892506847`*^9}, {3.7067267603582377`*^9, 3.706726766084889*^9}, {
   3.8256867747306957`*^9, 3.82568677474715*^9}, {3.825687096382723*^9, 
   3.825687096402303*^9}, {3.825687159494542*^9, 
   3.825687200144193*^9}},ExpressionUUID->"c1ac0031-59a8-4229-b280-\
32a7b24998cd"],

Cell[TextData[{
 "IntersectingQ[",
 StyleBox["list1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["list2",
  FontSlant->"Italic"],
 "] returns True if list1 and list2 share any elements."
}], "Text",
 CellChangeTimes->{{3.457660987675905*^9, 3.457661007938542*^9}, 
   3.8256871452847443`*^9, 
   3.825687230577605*^9},ExpressionUUID->"62f3d16a-4569-4cd7-9dc6-\
f563084f1707"],

Cell["Redefined to use the built-in function.", "Text",
 CellChangeTimes->{{3.64372153637499*^9, 3.643721545637218*^9}, {
  3.643721584002862*^9, 3.643721607601613*^9}, {3.8256872809198713`*^9, 
  3.825687304183351*^9}},ExpressionUUID->"2bc884c8-f879-483d-9c98-\
5de293f5305e"],

Cell["Examples", "Text",
 CellChangeTimes->{{3.64372161961872*^9, 3.643721620392288*^9}, 
   3.643721673492882*^9},ExpressionUUID->"332ee5c5-da6c-4c93-a885-\
8dcc81378730"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntersectingQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.643721624235935*^9, 3.643721638200732*^9}, 
   3.825687145302587*^9, 3.825687230590005*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"50774730-cf43-456f-9feb-d7fd1354546a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntersectingQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "e"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.643721624235935*^9, 3.643721666632966*^9}, 
   3.8256871453068647`*^9, 3.825687230591484*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"9493c21f-f0c2-46c8-8f02-28ab6d027f55"],

Cell[TextData[{
 "MemberQ[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["elem",
  FontSlant->"Italic"],
 "] returns True if ",
 StyleBox["list",
  FontSlant->"Italic"],
 " contains ",
 StyleBox["elem",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.675843536695741*^9, 3.6758435510462637`*^9}, 
   3.825686774765926*^9, 
   3.825687096420412*^9},ExpressionUUID->"2d570418-3561-4f3a-86fa-\
1b133baba624"],

Cell["Redefined to use the built-in function.", "Text",
 CellChangeTimes->{{3.675843554446563*^9, 3.6758435782610908`*^9}, {
  3.825687309223897*^9, 
  3.825687313127309*^9}},ExpressionUUID->"ad90c493-7842-423c-bfaa-\
35fae842c7e3"],

Cell["Examples", "Text",
 CellChangeTimes->{{3.64372161961872*^9, 3.643721620392288*^9}, 
   3.643721673492882*^9},ExpressionUUID->"398bfd79-2843-4ba4-8986-\
883b3ee395a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "a"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.643721624235935*^9, 3.643721638200732*^9}, {
   3.643721682141366*^9, 3.64372168560023*^9}, 3.8256867747872148`*^9, 
   3.825687096433819*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"e87cce4e-7af4-4265-91d8-42c4c02215f3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "d"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.643721624235935*^9, 3.643721690015798*^9}, 
   3.825686774792263*^9, 3.825687096435058*^9},
 CellLabel->"In[32]:=",ExpressionUUID->"8467de23-343e-4ad7-9dff-de6a861a5b02"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "CyclicSameQ[",
 StyleBox["l1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["l2",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.457743675663949*^9, 3.457743684617128*^9}, {
  3.457921634581307*^9, 
  3.457921636436393*^9}},ExpressionUUID->"42f427eb-13d5-49aa-ade7-\
8a7f842992ed"],

Cell[TextData[{
 "CyclicSameQ[",
 StyleBox["l1, l2",
  FontSlant->"Italic"],
 "] returns True if the two lists ",
 StyleBox["l1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["l2",
  FontSlant->"Italic"],
 "  are the same under any cyclic permutation."
}], "Text",
 CellChangeTimes->{
  3.457743687620278*^9},ExpressionUUID->"33020341-2de1-4198-ae69-\
67f94f92be06"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CyclicSameQ", "[", 
   RowBox[{"l1_", ",", "l2_"}], "]"}], ":=", 
  RowBox[{"Or", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"SameQ", "[", 
       RowBox[{"l1", ",", "#"}], "]"}], "&"}], "/@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"RotateLeft", "[", 
        RowBox[{"l2", ",", "n"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"Length", "[", "l2", "]"}]}], "}"}]}], "]"}]}], 
    ")"}]}]}]], "Input",
 CellLabel->"In[33]:=",ExpressionUUID->"e354349e-08ab-485a-a763-87f356e63614"],

Cell["Example", "Text",ExpressionUUID->"170ca456-bc69-4d43-9b3f-c4c958ef6b3b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CyclicSameQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "1", ",", "5"}], "}"}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"4a8c3c06-024a-4e78-8ddc-e51f572d41c3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "DeleteItem[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["pattern",
  FontSlant->"Italic"],
 "]\nDeleteItems[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["patterns",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.455900028775937*^9, 3.455900034751507*^9}, {
  3.455900210104105*^9, 3.455900210717457*^9}, {3.455903864751861*^9, 
  3.4559038707317657`*^9}, {3.592002755741381*^9, 3.592002756546948*^9}, {
  3.592002788059928*^9, 
  3.59200278898466*^9}},ExpressionUUID->"a75adfff-fce5-4263-ac66-\
dd64621bfa18"],

Cell[TextData[{
 "DeleteItem[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["pattern",
  FontSlant->"Italic"],
 "] returns ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " with all occurrences of ",
 StyleBox["pattern",
  FontSlant->"Italic"],
 " removed. Similar to Delete, but the item is specified by value rather than \
by position. If there are multiple copies present, they will all be removed."
}], "Text",
 CellChangeTimes->{{3.455900036871779*^9, 3.455900052503988*^9}, 
   3.45590021577037*^9, {3.4559002467113676`*^9, 3.455900283167685*^9}, {
   3.592002761381888*^9, 3.592002762671218*^9}, {3.592002820303023*^9, 
   3.592002820447257*^9}},ExpressionUUID->"d13b5623-84eb-46e7-a240-\
5ab63bd00049"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteItem", "[", 
   RowBox[{"expr_", ",", 
    StyleBox["pattern_",
     FontSlant->"Italic"]}], "]"}], ":=", 
  RowBox[{"Delete", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"Position", "[", 
     RowBox[{"expr", ",", 
      StyleBox["pattern",
       FontSlant->"Italic"]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.455899980391329*^9, 3.455900025476111*^9}, {
   3.455900180660254*^9, 3.4559001813692*^9}, 3.455900217544487*^9, {
   3.592002767939651*^9, 3.592002769530209*^9}, {3.592002839402504*^9, 
   3.592002852106952*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"c835ce25-fd9f-449f-9a62-8926deffdc5b"],

Cell[TextData[{
 "DeleteItems[expr, {item1, item2...}] returns expr with all occurrences of \
any of the ",
 StyleBox["patterns",
  FontSlant->"Italic"],
 " removed."
}], "Text",
 CellChangeTimes->{{3.45590387348416*^9, 3.455903897620698*^9}, {
  3.592002804890566*^9, 
  3.5920028124764757`*^9}},ExpressionUUID->"5f883e22-078a-4716-9eb2-\
ef7be2022a51"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteItems", "[", 
   RowBox[{"expr_", ",", 
    StyleBox[
     RowBox[{
      StyleBox["patterns_",
       FontSlant->"Italic"], "List"}]]}], "]"}], ":=", 
  RowBox[{"Delete", "[", 
   RowBox[{"expr", " ", ",", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Position", "[", 
         RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", 
       StyleBox["patterns",
        FontSlant->"Italic"]}], ",", "1"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.455903900781418*^9, 3.455903936339551*^9}, {
  3.592002798686748*^9, 3.592002801440487*^9}, {3.592002855065425*^9, 
  3.592002855744623*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"853374e2-c00e-45ad-8259-b661957fefd8"],

Cell["Additional functions for manipulating lists of objects.", "Text",ExpressionUUID->"9680ee6b-79fb-45e1-8bf9-34b5a0c5421b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "DropFirst[",
 StyleBox["list",
  FontSlant->"Italic"],
 "]\nDropLast[",
 StyleBox["list",
  FontSlant->"Italic"],
 "]\nDropEnds[",
 StyleBox["list",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.456358665779338*^9, 3.456358675317102*^9}, {
  3.484018251365489*^9, 
  3.4840182542521887`*^9}},ExpressionUUID->"471988c3-197c-4282-bb16-\
76c24556f09c"],

Cell[TextData[{
 "DropFirst[",
 StyleBox["list",
  FontSlant->"Italic"],
 "] returns ",
 StyleBox["list",
  FontSlant->"Italic"],
 " with its first element dropped."
}], "Text",
 CellChangeTimes->{{3.456358679004848*^9, 3.45635868267639*^9}, {
  3.456358738065947*^9, 
  3.456358745993805*^9}},ExpressionUUID->"c0343050-0e16-4a5c-8a94-\
92565bcc3fc7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DropFirst", "[", "list_List", "]"}], ":=", 
  RowBox[{"Drop", "[", 
   RowBox[{"list", ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.45635868473722*^9, 3.456358696310717*^9}, {
  3.456358730765349*^9, 3.456358733414057*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"d3508691-5e6f-49db-b0bf-62c0d60df164"],

Cell[TextData[{
 "DropLast[",
 StyleBox["list",
  FontSlant->"Italic"],
 "] returns ",
 StyleBox["list",
  FontSlant->"Italic"],
 " with its last element dropped."
}], "Text",
 CellChangeTimes->{{3.456358699619885*^9, 3.456358715955144*^9}, {
  3.456358750089739*^9, 
  3.4563587545614653`*^9}},ExpressionUUID->"9dd8d854-ae90-453c-aa60-\
f2fc30943272"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DropLast", "[", "list_List", "]"}], ":=", 
  RowBox[{"Drop", "[", 
   RowBox[{"list", ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.456358719003369*^9, 3.456358728445195*^9}, 
   3.456358772947981*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"92ab0847-73ac-44c8-9677-a05d2362b19c"],

Cell[TextData[{
 "DropEnds[",
 StyleBox["list",
  FontSlant->"Italic"],
 "] returns ",
 StyleBox["list",
  FontSlant->"Italic"],
 " with both first and last elements dropped."
}], "Text",
 CellChangeTimes->{{3.48401826643565*^9, 
  3.484018278634811*^9}},ExpressionUUID->"15dc295f-e80a-41fd-820f-\
a3baca41f788"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DropEnds", "[", "list_List", "]"}], ":=", 
  RowBox[{"Drop", "[", 
   RowBox[{
    RowBox[{"Drop", "[", 
     RowBox[{"list", ",", "1"}], "]"}], ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4840182803116198`*^9, 3.4840182965649014`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"2d0a5769-a4e4-4653-8823-3d6bbf7a8157"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "AppendFirst",
 "[",
 StyleBox["list",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.461846515981999*^9, 3.461846520317515*^9}, 
   3.6288520018134623`*^9},ExpressionUUID->"85d86ef9-a335-4015-8c1f-\
9357098c187e"],

Cell[TextData[{
 "AppendFirst",
 "[",
 StyleBox["list",
  FontSlant->"Italic"],
 "] appends the first element to the end of the list; useful for closing a \
list of points."
}], "Text",
 CellChangeTimes->{{3.4618465230615783`*^9, 3.461846547051289*^9}, 
   3.628852002049252*^9},ExpressionUUID->"f0f3ddd9-e1db-4161-b4c7-\
890209e981c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendFirst", "[", "list_", "]"}], ":=", 
  RowBox[{"Append", "[", 
   RowBox[{"list", ",", 
    RowBox[{"list", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.461846554245798*^9, 3.461846567238271*^9}, 
   3.628852002083693*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"2e84f01e-46f2-4ffb-923b-3a26eeabe2b2"],

Cell["Example", "Text",
 CellChangeTimes->{{3.461846570427933*^9, 
  3.461846571066041*^9}},ExpressionUUID->"45d4a649-9daf-473d-a269-\
78642a24bd1e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendFirst", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.4618465729900093`*^9, 3.4618465841169024`*^9}, 
   3.628852002116939*^9},
 CellLabel->"In[41]:=",ExpressionUUID->"62614858-eedd-4ab0-b41e-f43cf21a15ba"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "JoinTo[",
 StyleBox["list1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["list2, ...",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.4852575268487864`*^9, 3.485257535288665*^9}, {
  3.4852585749176188`*^9, 
  3.485258575989367*^9}},ExpressionUUID->"b9a310a7-0973-4a8b-bb51-\
2908db6d427f"],

Cell[TextData[{
 "JoinTo[",
 StyleBox["list1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["list2, ...",
  FontSlant->"Italic"],
 "] joints the contents of ",
 StyleBox["list2",
  FontSlant->"Italic"],
 " and subsequent lists",
 " to ",
 StyleBox["list1",
  FontSlant->"Italic"],
 ", changing ",
 StyleBox["list1",
  FontSlant->"Italic"],
 ". It's the Join equivalent of AppendTo."
}], "Text",
 CellChangeTimes->{{3.485257546688945*^9, 3.485257562576047*^9}, {
  3.485257974330764*^9, 3.485257994154459*^9}, {3.485258583038093*^9, 
  3.485258590325277*^9}},ExpressionUUID->"f669c543-0919-4d7b-80c8-\
a75830e4e248"],

Cell["\<\
4/2/2020. Mathematica 12.1 has its own version of JoinTo, but that isn\
\[CloseCurlyQuote]t always loaded. We can cause it to be loaded by invoking \
this command:\
\>", "Text",
 CellChangeTimes->{{3.794852706493486*^9, 
  3.7948527470368853`*^9}},ExpressionUUID->"4155032b-e948-4c32-ac70-\
b062f1e23b77"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphicsRow", "[", 
   RowBox[{"{", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", "}"}], "]"}], "}"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{
  3.794852028377004*^9, {3.7948520680347233`*^9, 3.794852095065261*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"866df73e-ed13-4be6-8c60-70cf22f549f5"],

Cell["\<\
And after doing that, we no longer need these definitions, so they\
\[CloseCurlyQuote]re commented out.\
\>", "Text",
 CellChangeTimes->{{3.7948527553818502`*^9, 
  3.794852768685388*^9}},ExpressionUUID->"c5aed214-f4d1-44f8-85ce-\
1f330b20abc2"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"SetAttributes", "[", 
    RowBox[{"JoinTo", ",", "HoldFirst"}], "]"}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.4852575639067497`*^9, 3.485257572978914*^9}, {
  3.485257741763356*^9, 3.485257764344206*^9}, {3.7948508217491903`*^9, 
  3.794850825920974*^9}, {3.794852771656621*^9, 3.794852774741822*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"f12525b2-8d50-4fb3-ae39-ec3d6182a901"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"JoinTo", "[", 
    RowBox[{"list1_", ",", "list2___"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"list1", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", "list1", "]"}], ",", "list2"}], "]"}]}], 
    ")"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.485257574348585*^9, 3.48525759774736*^9}, {
  3.485257646307532*^9, 3.485257646882921*^9}, {3.4852577133218517`*^9, 
  3.485257716648623*^9}, {3.485257789385936*^9, 3.4852578132177677`*^9}, {
  3.485257903721144*^9, 3.4852579070949793`*^9}, {3.485257938424087*^9, 
  3.485257939392127*^9}, {3.485258616720599*^9, 3.485258616896611*^9}, {
  3.794850828962532*^9, 3.794850832176618*^9}, {3.794852777176759*^9, 
  3.794852779836913*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"323cd6d6-a419-49d0-ac3e-9f6432af8f60"],

Cell["\<\
12/15/2023. Well, that no longer works in Mathematica 13, so we\
\[CloseCurlyQuote]ll rebuild the command, using the suggestion in \
https://mathematica.stackexchange.com/questions/103238/how-to-implement-\
jointo-efficiently.\
\>", "Text",
 CellChangeTimes->{{3.911673415446302*^9, 
  3.911673461496264*^9}},ExpressionUUID->"97c34db1-764a-4ca3-82cb-\
ea7dd9fcf1bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"JoinTo", ",", "HoldFirst"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"JoinTo", "[", 
   RowBox[{"a_", ",", "b__List"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"Join", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}], ";"}], ")"}]}]}], "Input",
 CellChangeTimes->{{3.911673596325186*^9, 3.9116736225130367`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"601e7856-3601-40ff-ac47-609275b741a5"],

Cell["Example", "Text",
 CellChangeTimes->{{3.48525760531172*^9, 
  3.485257606007654*^9}},ExpressionUUID->"5ce92b20-11a8-4d22-8db2-\
8bb8b13702c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"list1", ",", "list2", ",", "list3"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"list1", "=", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"list2", "=", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"list3", "=", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"JoinTo", "[", 
     RowBox[{"list1", ",", "list2", ",", "list3"}], "]"}], ";", 
    "\[IndentingNewLine]", "list1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.485257607909653*^9, 3.485257640603683*^9}, 
   3.485257916743518*^9, {3.485257956184121*^9, 3.485257957855152*^9}, {
   3.485258633851387*^9, 3.485258652863657*^9}, 3.911673500828011*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"d7743e73-4fc8-4b7e-92d3-3502022a76c7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", "h", ",",
    "i"}], "}"}]], "Output",
 CellChangeTimes->{3.962635223682666*^9, 3.9666287916250477`*^9, 
  3.9671207895635653`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"8f004c5c-9e42-496a-8e12-bb7f222c51e2"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Rule list utilities", "Subsection",
 CellChangeTimes->{{3.675846699905624*^9, 
  3.675846702567829*^9}},ExpressionUUID->"9900740d-bb48-4bd5-a727-\
4be03d524a99"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.675846729309764*^9, 
  3.6758467297093678`*^9}},ExpressionUUID->"4c78d7fd-7ecb-4e68-ac41-\
a41783e7f189"],

Cell[TextData[{
 "These functions are convenient for working with lists of Rules of the form \
{",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 ", ...}, such as the FoldObject format used in file import/export."
}], "Text",
 CellChangeTimes->{{3.67584673153279*^9, 3.675846749132175*^9}, {
  3.675846871295197*^9, 3.675846887602593*^9}, {3.675854384711513*^9, 
  3.6758544070211277`*^9}, {3.675950737957703*^9, 
  3.6759507500847273`*^9}},ExpressionUUID->"336a027a-2686-425d-8807-\
318c9ddecce9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "HasRuleQ[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.6758486474353113`*^9, 
  3.6758486525945473`*^9}},ExpressionUUID->"e883be18-b71c-456f-b1bc-\
b13e1694695c"],

Cell[TextData[{
 "HasRuleQ[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "] returns True if the list has a rule of the form ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.675846897433286*^9, 
  3.675846924396317*^9}},ExpressionUUID->"28ad564f-cf87-4638-81e2-\
5fc3f4038faf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HasRuleQ", "[", 
   RowBox[{"list_List", ",", "lhs_"}], "]"}], ":=", 
  RowBox[{"MemberQ", "[", 
   RowBox[{"list", ",", 
    RowBox[{"lhs", "\[Rule]", "_"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6758467078430443`*^9, 3.67584671992691*^9}, {
  3.67584676012354*^9, 3.675846811118721*^9}, {3.675846846287559*^9, 
  3.675846868551173*^9}, {3.675846934476434*^9, 3.6758469432770863`*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"407db2f6-701c-4fed-a38c-d5ea053003dd"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.6758485861127863`*^9, 3.6758485875515337`*^9}, 
   3.675848858634997*^9},ExpressionUUID->"27a56e87-41e6-4262-b1c1-\
d7d76053e440"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HasRuleQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}]}], "}"}], ",", "a"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675848589835062*^9, 3.67584860071104*^9}, 
   3.675850399893337*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"0c30cfc3-52c7-4f6f-9124-cf8831b29bca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HasRuleQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}]}], "}"}], ",", "c"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675848589835062*^9, 3.675848607977988*^9}, 
   3.675850398227829*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"380dde87-64fb-4701-af28-40eaa65ff83d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "RulePositionFirst[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.675848733038877*^9, 3.675848747582869*^9}, {
  3.675848786293185*^9, 
  3.675848786872745*^9}},ExpressionUUID->"0d23a3e0-4131-4fcc-a0bd-\
5048861337b0"],

Cell[TextData[{
 "RulePosition[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "] returns the position of the first rule ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 " within the list ",
 StyleBox["list",
  FontSlant->"Italic"],
 ". It returns 0 if there is no rule."
}], "Text",
 CellChangeTimes->{{3.6758486902957163`*^9, 3.6758487121099777`*^9}, {
  3.675848756732338*^9, 
  3.675848791704294*^9}},ExpressionUUID->"142b575b-7b16-4c45-9dca-\
8b084db78313"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RulePositionFirst", "[", 
   RowBox[{"list_List", ",", " ", "lhs_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "pos", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pos", "=", 
      RowBox[{"Position", "[", 
       RowBox[{"list", ",", 
        RowBox[{"lhs", "\[Rule]", "_"}], ",", 
        RowBox[{"{", "1", "}"}], ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ListEmptyQ", "[", "pos", "]"}], ",", "0", ",", 
       RowBox[{"pos", "\[LeftDoubleBracket]", 
        RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.675848631011829*^9, 3.675848639965639*^9}, {
  3.675848671458778*^9, 3.675848685041654*^9}, {3.675848777050351*^9, 
  3.675848851604848*^9}, {3.675848886237369*^9, 3.675848944415226*^9}, {
  3.675854355893697*^9, 3.6758543576585817`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"937614c4-02a3-4f59-a034-c6da317fb4aa"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.675848855028232*^9, 
  3.675848856875799*^9}},ExpressionUUID->"f42242d6-666b-40e1-8ed6-\
7c13b8cb5851"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RulePositionFirst", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"b", "\[Rule]", "3"}]}], "}"}], ",", "b"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675848861206921*^9, 3.675848878086361*^9}, 
   3.675850395012574*^9, 3.675854364121443*^9, 3.675855610332119*^9},
 CellLabel->"In[52]:=",ExpressionUUID->"4f70cd61-e63f-47e5-b111-6cfc11e78a9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RulePositionFirst", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"b", "\[Rule]", "3"}]}], "}"}], ",", "c"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675848861206921*^9, 3.675848878086361*^9}, 
   3.675848957542983*^9, 3.675850393469345*^9, 3.675854366597703*^9, 
   3.675855611493515*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"6f85d9b0-32e7-457e-8ecb-0bf8ed177f73"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ReplaceRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.675848998968644*^9, 
  3.675849010119595*^9}},ExpressionUUID->"582393a1-a8bd-4b5f-8d2e-\
1c46335ebb30"],

Cell[TextData[{
 "ReplaceRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 "] replaces any occurrence of a rule lhs\[Rule]_ with the specified rule lhs\
\[Rule]rhs."
}], "Text",
 CellChangeTimes->{{3.675849019874346*^9, 
  3.675849055197153*^9}},ExpressionUUID->"f327e0cb-4092-4f25-ab21-\
cf423f73bc98"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceRule", "[", 
   RowBox[{"list_List", ",", 
    RowBox[{"lhs_", "\[Rule]", "rhs_"}]}], "]"}], ":=", 
  RowBox[{"list", "/.", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"lhs", "\[Rule]", "_"}], ")"}], "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"lhs", "\[Rule]", "rhs"}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6758490721194353`*^9, 3.675849125780517*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"e978eb01-32af-4e12-9056-a0d6d2ef3a69"],

Cell["Examples", "Text",
 CellChangeTimes->{{3.675849132200184*^9, 
  3.675849132991138*^9}},ExpressionUUID->"a10d8d78-c812-4485-83a6-\
f03404f4d3cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", 
    RowBox[{"b", "\[Rule]", "4"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6758491528785877`*^9, 3.675849191855741*^9}, 
   3.6758503917815228`*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"6a3f4aeb-4d44-4f44-8922-6759c1f55500"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", 
    RowBox[{"d", "\[Rule]", "4"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6758491528785877`*^9, 3.675849193222024*^9}, 
   3.6758503902362967`*^9},
 CellLabel->"In[56]:=",ExpressionUUID->"e399dca0-91f7-4178-9120-8dc88d35035a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ReplaceOrAppendRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.675849210107653*^9, 
  3.675849253853956*^9}},ExpressionUUID->"b042fc46-e997-4a10-a8a4-\
ddb111c6aafd"],

Cell[TextData[{
 "ReplaceOrAppendRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 "] replaces a rule in a list if it exists, or appends it if it doesn\
\[CloseCurlyQuote]t."
}], "Text",
 CellChangeTimes->{{3.675849240031514*^9, 3.675849270420149*^9}, {
  3.675849412025758*^9, 
  3.675849413857987*^9}},ExpressionUUID->"54fe1900-d2ab-4ad2-8f97-\
4acb4c9a1a91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceOrAppendRule", "[", 
   RowBox[{"list_", ",", 
    RowBox[{"lhs_", "\[Rule]", "rhs_"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"HasRuleQ", "[", 
     RowBox[{"list", ",", "lhs"}], "]"}], ",", 
    RowBox[{"ReplaceRule", "[", 
     RowBox[{"list", ",", 
      RowBox[{"lhs", "\[Rule]", "rhs"}]}], "]"}], ",", 
    RowBox[{"Append", "[", 
     RowBox[{"list", ",", 
      RowBox[{"lhs", "\[Rule]", "rhs"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.675849274671555*^9, 3.675849348033814*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"3c9e3c4f-8fe6-4ee8-b047-6264058eeaab"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.6758493525660543`*^9, 
  3.675849353566003*^9}},ExpressionUUID->"54ef52bf-7280-4cb3-a239-\
4c977524e7a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceOrAppendRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", 
    RowBox[{"b", "\[Rule]", "4"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6758491528785877`*^9, 3.675849191855741*^9}, 
   3.675849382832795*^9, 3.675850387693701*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"be42705c-7347-4063-b77f-6542801bbce6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceOrAppendRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", 
    RowBox[{"d", "\[Rule]", "4"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6758491528785877`*^9, 3.675849193222024*^9}, 
   3.675849384105061*^9, 3.6758503864058027`*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"f086c3ed-971b-417a-9341-cf8458584062"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ReplaceOrPrependRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.675849210107653*^9, 3.675849253853956*^9}, {
  3.675849405284486*^9, 
  3.675849407474033*^9}},ExpressionUUID->"e68bbbcf-fadc-425c-9115-\
14757ef7aa59"],

Cell[TextData[{
 "ReplaceOrPrependRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 "] replaces a rule in a list if it exists, or prepends it if it doesn\
\[CloseCurlyQuote]t."
}], "Text",
 CellChangeTimes->{{3.675849240031514*^9, 3.675849270420149*^9}, {
  3.675849416873472*^9, 
  3.675849422352962*^9}},ExpressionUUID->"10ba0f8a-6fd9-41e6-afd0-\
b48f0ffeab2e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceOrPrependRule", "[", 
   RowBox[{"list_", ",", 
    RowBox[{"lhs_", "\[Rule]", "rhs_"}]}], "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"HasRuleQ", "[", 
     RowBox[{"list", ",", "lhs"}], "]"}], ",", 
    RowBox[{"ReplaceRule", "[", 
     RowBox[{"list", ",", 
      RowBox[{"lhs", "\[Rule]", "rhs"}]}], "]"}], ",", 
    RowBox[{"Prepend", "[", 
     RowBox[{"list", ",", 
      RowBox[{"lhs", "\[Rule]", "rhs"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.675849274671555*^9, 3.675849348033814*^9}, {
  3.675849425627557*^9, 3.675849432449449*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"a4995008-7391-4950-99df-30a3943b672e"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.6758493525660543`*^9, 
  3.675849353566003*^9}},ExpressionUUID->"28da5597-64d9-4c05-88f5-\
5dc39de26f33"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceOrPrependRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", 
    RowBox[{"b", "\[Rule]", "4"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6758491528785877`*^9, 3.675849191855741*^9}, 
   3.675849382832795*^9, 3.675849438956935*^9, 3.67585038331825*^9},
 CellLabel->"In[61]:=",ExpressionUUID->"25fd203e-72b2-4798-b8e8-388eba9586c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceOrPrependRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", 
    RowBox[{"d", "\[Rule]", "4"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6758491528785877`*^9, 3.675849193222024*^9}, 
   3.675849384105061*^9, 3.675849440221377*^9, 3.675850381479203*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"5c23774c-9615-47bd-b3f0-1e56b0c0f19a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "DeleteRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.675854114620274*^9, 
  3.675854127245339*^9}},ExpressionUUID->"d94c9666-466d-4ffa-8934-\
357c3f80249b"],

Cell[TextData[{
 "DeleteRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "] removes any Rule from ",
 StyleBox["list",
  FontSlant->"Italic"],
 " of the form ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 " but otherwise preserves order."
}], "Text",
 CellChangeTimes->{{3.675854142059012*^9, 
  3.675854175078238*^9}},ExpressionUUID->"d07a09e0-1e89-4762-9d97-\
465b57c434c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteRule", "[", 
   RowBox[{"list_List", ",", "lhs_"}], "]"}], ":=", 
  RowBox[{"DeleteCases", "[", 
   RowBox[{"list", ",", 
    RowBox[{"lhs", "\[Rule]", "_"}], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6758541826265182`*^9, 3.67585422200448*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"b12c1c22-182f-444c-af9e-a133d4bd6d15"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.675854241323372*^9, 
  3.675854243713137*^9}},ExpressionUUID->"eacea934-1ae2-4f54-befc-\
6d1a5e51f1e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", "b"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675854246213347*^9, 3.675854264841997*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"795f4785-dbb4-4527-9e8d-a322360f028f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "MoveRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 ", ",
 StyleBox["n",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.675854331427535*^9, 3.675854337969621*^9}, 
   3.675854472536075*^9},ExpressionUUID->"10c90e5b-8005-429c-ac3d-\
16cac9a2432d"],

Cell[TextData[{
 "MoveRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 ", ",
 StyleBox["n",
  FontSlant->"Italic"],
 "] moves the first occurence of a rule ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 " to the specified position. An error is generated if there is no matching \
rule, so always use HasRuleQ if in doubt."
}], "Text",
 CellChangeTimes->{{3.675854423272571*^9, 3.675854424948126*^9}, {
   3.6758544566915407`*^9, 3.675854523532346*^9}, 
   3.675854610902253*^9},ExpressionUUID->"c361ba9f-6ded-4d67-a5a1-\
59eb86e39e7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MoveRule", "::", "norule"}], 
   "=", "\"\<List `1` does not contain a rule with lhs `2`.\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.675854707673015*^9, 3.67585472859056*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"06e76051-a05c-410c-b1b6-732558ad9f9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveRule", "[", 
   RowBox[{"list_List", ",", " ", "lhs_", ",", " ", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "pos", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pos", "=", 
      RowBox[{"RulePositionFirst", "[", 
       RowBox[{"list", ",", "lhs"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"pos", "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"MoveRule", "::", "norule"}], ",", "list", ",", "lhs"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Insert", "[", 
      RowBox[{
       RowBox[{"DeleteRule", "[", 
        RowBox[{"list", ",", "lhs"}], "]"}], ",", 
       RowBox[{
       "list", "\[LeftDoubleBracket]", "pos", "\[RightDoubleBracket]"}], ",", 
       "n"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6758545262001123`*^9, 3.675854594488873*^9}, {
  3.6758546815263042`*^9, 3.675854704393021*^9}, {3.67585473450545*^9, 
  3.675854749569903*^9}, {3.6758547835253057`*^9, 3.6758548221983*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"be37963c-a2af-4e79-9b53-57a855e5918a"],

Cell["Example. Move to front.", "Text",
 CellChangeTimes->{{3.6758546246067467`*^9, 
  3.675854632916732*^9}},ExpressionUUID->"088e7d85-418d-4a68-aac6-\
6b79ab930d76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", "b", ",", "1"}], "]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675854634775612*^9, 3.675854654772254*^9}, 
   3.675854882389533*^9},
 CellLabel->"In[67]:=",ExpressionUUID->"57470a70-b099-4e6d-9aea-b6e4add38006"],

Cell["Example. Move to end.", "Text",
 CellChangeTimes->{{3.6758546246067467`*^9, 3.675854632916732*^9}, {
  3.675854838981988*^9, 
  3.675854839228201*^9}},ExpressionUUID->"2a2e4562-8842-4763-ae96-\
c3f25dffde13"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", "b", ",", 
    RowBox[{"-", "1"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675854634775612*^9, 3.675854654772254*^9}, 
   3.67585484158257*^9, 3.675854880831423*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"8ddf779c-35db-40fe-b8a9-54a048c289c8"],

Cell["Example. No match.", "Text",
 CellChangeTimes->{{3.67585485120326*^9, 
  3.675854854841126*^9}},ExpressionUUID->"93806de2-156b-4faf-9fa6-\
4671fbb0651d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MoveRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "3"}]}], "}"}], ",", "d", ",", "1"}], "]"}], "//",
   "ShowErrorExample"}]], "Input",
 CellChangeTimes->{{3.675854634775612*^9, 3.675854654772254*^9}, {
  3.67585484158257*^9, 3.675854874058808*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"e59b3cf1-3a21-4d51-a709-afe71aa488a2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "AppendToInRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 ", ",
 StyleBox["elem",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.675849475623117*^9, 3.675849520593841*^9}, {
  3.675849635193448*^9, 
  3.6758496386016393`*^9}},ExpressionUUID->"e9b6f1cb-c22b-45a8-8ac7-\
78ba7a194482"],

Cell[TextData[{
 "AppendToInRule[",
 StyleBox["list",
  FontSlant->"Italic"],
 ", ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 ", ",
 StyleBox["elem",
  FontSlant->"Italic"],
 "] looks for a Rule within ",
 StyleBox["list",
  FontSlant->"Italic"],
 " of the form ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 "\[Rule]",
 StyleBox["rhs",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["rhs",
  FontSlant->"Italic"],
 " is a List, and appends ",
 StyleBox["elem",
  FontSlant->"Italic"],
 " to ",
 StyleBox["rhs",
  FontSlant->"Italic"],
 ". If ",
 StyleBox["lhs",
  FontSlant->"Italic"],
 " does not exist or ",
 StyleBox["rhs",
  FontSlant->"Italic"],
 " is not a List, then an error is generated."
}], "Text",
 CellChangeTimes->{{3.67584952859124*^9, 3.6758495836051183`*^9}, {
  3.675849642676046*^9, 3.675849660135132*^9}, {3.6758497430815067`*^9, 
  3.675849746129168*^9}},ExpressionUUID->"122be822-54b0-40fe-af23-\
c6746a2e8b79"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AppendToInRule", "::", "nolhs"}], 
   "=", "\"\<A rule for `1` does not exist in `2`.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.675849752835487*^9, 3.675849786455143*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"dc7803bd-53a4-497c-befa-9b07356e9123"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AppendToInRule", "::", "notlist"}], 
   "=", "\"\<The rule `1` does not specify a List.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.675849848569921*^9, 3.675849874289708*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"b515cd7a-50c5-4ded-8593-87e2229e760c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendToInRule", "[", 
   RowBox[{"list_List", ",", "lhs_", ",", "elem_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pos", ",", "rhs"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pos", "=", 
      RowBox[{"RulePositionFirst", "[", 
       RowBox[{"list", ",", "lhs"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"pos", "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"AppendToInRule", "::", "nolhs"}], ",", "lhs", ",", 
          "list"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"rhs", "=", 
      RowBox[{"lhs", "/.", 
       RowBox[{
       "list", "\[LeftDoubleBracket]", "pos", "\[RightDoubleBracket]"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{
         RowBox[{"Head", "[", "rhs", "]"}], "===", "List"}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"AppendToInRule", "::", "notlist"}], ",", 
          RowBox[{"lhs", "\[Rule]", "rhs"}]}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"ReplaceRule", "[", 
      RowBox[{"list", ",", 
       RowBox[{"lhs", "\[Rule]", 
        RowBox[{"Append", "[", 
         RowBox[{"rhs", ",", "elem"}], "]"}]}]}], "]"}]}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.675849669106987*^9, 3.6758497375315537`*^9}, {
  3.675849792841234*^9, 3.675849842868474*^9}, {3.675849880155415*^9, 
  3.675849891224908*^9}, {3.67585023264881*^9, 3.6758502654611263`*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"258ea172-3d70-4afe-ab97-1f3fd9bdec6c"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.67585026998501*^9, 
  3.67585027468357*^9}},ExpressionUUID->"0441692e-ce1b-4a27-9e9f-\
d3b53589d080"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendToInRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], ",", 
      RowBox[{"c", "\[Rule]", "5"}]}], "}"}], ",", "b", ",", "6"}], "]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.675850279052231*^9, 3.675850306849497*^9}, {
  3.675850373405726*^9, 3.675850375140293*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"bde0db5b-e694-44b0-ae32-08219f940d25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendToInRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], ",", 
      RowBox[{"c", "\[Rule]", "5"}]}], "}"}], ",", "d", ",", "6"}], "]"}], "//",
   "ShowErrorExample"}]], "Input",
 CellChangeTimes->{{3.675850319538923*^9, 3.67585032766543*^9}, {
  3.675850361365637*^9, 3.675850365380754*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"5ebe5b37-a81f-4292-824c-d835bbec96c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendToInRule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "\[Rule]", "1"}], ",", 
      RowBox[{"b", "\[Rule]", "2"}], ",", 
      RowBox[{"c", "\[Rule]", "5"}]}], "}"}], ",", "b", ",", "6"}], "]"}], "//",
   "ShowErrorExample"}]], "Input",
 CellChangeTimes->{{3.675850351962087*^9, 3.67585037096037*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"ab41c373-cf5b-420e-b43c-e103383b524c"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Transformations on Graphics/Graphics3D expressions", "Subsection",
 CellChangeTimes->{{3.64320723192043*^9, 3.643207279396064*^9}, 
   3.643208402324501*^9},ExpressionUUID->"d05f9bc8-f02d-4727-9524-\
ad7a4b013f1e"],

Cell[CellGroupData[{

Cell[TextData[{
 "FunctionTransform[",
 StyleBox["g",
  FontSlant->"Italic"],
 ", ",
 StyleBox["f",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.441499817406665*^9, 3.441499825012174*^9}, 
   3.441505257024347*^9},ExpressionUUID->"6618b6fd-01f0-4775-9053-\
fafc94e78d1d"],

Cell[TextData[{
 "FunctionTransform[",
 StyleBox["g",
  FontSlant->"Italic"],
 ",",
 StyleBox["f",
  FontSlant->"Italic"],
 "] takes the graphics object ",
 StyleBox["g",
  FontSlant->"Italic"],
 " and transforms every Graphics or Graphics3D object appearing in it by \
applying the function ",
 StyleBox["f",
  FontSlant->"Italic"],
 " to coordinate values."
}], "Text",
 CellChangeTimes->{{3.441499828484799*^9, 3.441499846405086*^9}, {
  3.595973128478859*^9, 3.595973130005908*^9}, {3.708870159602699*^9, 
  3.708870181202079*^9}},ExpressionUUID->"ec1993fa-a21c-4812-afc7-\
7d64cb119fec"],

Cell["\<\
This works for both ordinary and GraphicsComplex expressions.\
\>", "Text",
 CellChangeTimes->{{3.708870717960732*^9, 
  3.7088707531756787`*^9}},ExpressionUUID->"8152c746-3067-4dfb-9e1f-\
75d39c8041a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionTransform", "[", 
   RowBox[{"g_", ",", "f_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "point", ",", "line", ",", "polygon", ",", "sphere", ",", "tube", ",", 
      "text", ",", "arrow", ",", "g1", ",", "g2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"g1", "=", 
      RowBox[{"g", "/.", 
       RowBox[{
        RowBox[{"GraphicsComplex", "[", 
         RowBox[{"verts_", ",", "expr_"}], "]"}], "\[RuleDelayed]", 
        RowBox[{"GraphicsComplex", "[", 
         RowBox[{
          RowBox[{"f", "/@", "verts"}], ",", 
          RowBox[{"expr", "/.", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"Point", "[", "x_", "]"}], "\[RuleDelayed]", 
              RowBox[{"point", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
             
             RowBox[{
              RowBox[{"Line", "[", "x_", "]"}], "\[RuleDelayed]", 
              RowBox[{"line", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Polygon", "[", "x_", "]"}], "\[RuleDelayed]", 
              RowBox[{"polygon", "[", "x", "]"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Sphere", "[", "x___", "]"}], "\[RuleDelayed]", 
              RowBox[{"sphere", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Tube", "[", "x_", "]"}], "\[RuleDelayed]", 
              RowBox[{"tube", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Arrow", "[", "x___", "]"}], "\[RuleDelayed]", 
              RowBox[{"arrow", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
             
             RowBox[{
              RowBox[{"Text", "[", "x___", "]"}], "\[RuleDelayed]", 
              RowBox[{"text", "[", "x", "]"}]}]}], "\[IndentingNewLine]", 
            "}"}]}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"g2", "=", 
      RowBox[{"g1", "/.", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"Point", "[", "x_", "]"}], "\[RuleDelayed]", 
          RowBox[{"Point", "[", 
           RowBox[{"f", "[", "x", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
         
         RowBox[{
          RowBox[{"Line", "[", "x_", "]"}], "\[RuleDelayed]", 
          RowBox[{"Line", "[", 
           RowBox[{"f", "/@", "x"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Polygon", "[", "x_", "]"}], "\[RuleDelayed]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"f", "/@", "x"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Sphere", "[", 
           RowBox[{"x_", ",", "y___"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"Sphere", "[", 
           RowBox[{
            RowBox[{"f", "[", "x", "]"}], ",", "y"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Arrow", "[", 
           RowBox[{
            RowBox[{"Tube", "[", 
             RowBox[{"x_", ",", "r___"}], "]"}], ",", "y___"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"Arrow", "[", 
           RowBox[{
            RowBox[{"Tube", "[", 
             RowBox[{
              RowBox[{"f", "/@", "x"}], ",", "r"}], "]"}], ",", "y"}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Tube", "[", "x_", "]"}], "\[RuleDelayed]", 
          RowBox[{"Tube", "[", 
           RowBox[{"f", "/@", "x"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Arrow", "[", 
           RowBox[{"x_", ",", "y___"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"Arrow", "[", 
           RowBox[{
            RowBox[{"f", "/@", "x"}], ",", "y"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{"x_", ",", "y_", ",", "z___"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"Text", "[", 
           RowBox[{"x", ",", 
            RowBox[{"f", "[", "y", "]"}], ",", "z"}], "]"}]}]}], 
        "\[IndentingNewLine]", "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"g2", "/.", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"point", "[", "x_", "]"}], "\[RuleDelayed]", 
         RowBox[{"Point", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"line", "[", "x_", "]"}], "\[RuleDelayed]", 
         RowBox[{"Line", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"polygon", "[", "x_", "]"}], "\[RuleDelayed]", 
         RowBox[{"Polygon", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sphere", "[", "x___", "]"}], "\[RuleDelayed]", 
         RowBox[{"Sphere", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"tube", "[", "x___", "]"}], "\[RuleDelayed]", 
         RowBox[{"Tube", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"arrow", "[", "x___", "]"}], "\[RuleDelayed]", 
         RowBox[{"Arrow", "[", "x", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"text", "[", "x___", "]"}], "\[RuleDelayed]", 
         RowBox[{"Text", "[", "x", "]"}]}]}], "\[IndentingNewLine]", 
       "}"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.441499806434039*^9, {3.441499886194187*^9, 3.441499911189625*^9}, {
   3.441500071117656*^9, 3.441500100297089*^9}, {3.442874120133608*^9, 
   3.442874163063097*^9}, {3.485107678052824*^9, 3.485107744726961*^9}, {
   3.708870247860578*^9, 3.70887071119737*^9}, {3.800575192081542*^9, 
   3.80057524924175*^9}, {3.800575303298084*^9, 3.800575385207344*^9}, {
   3.800575415901012*^9, 3.8005754171040077`*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"6dec6096-2fea-43bf-a6ce-2bc5d22212ba"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.708870765779439*^9, 
  3.708870767635215*^9}},ExpressionUUID->"6f1d2117-6ff5-4280-96ef-\
2f93eacfbe3f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "g", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"g", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
        RowBox[{"GraphicsComplex", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"FunctionTransform", "[", 
      RowBox[{"g", ",", 
       RowBox[{
        RowBox[{"2", "#"}], "&"}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}], 
  "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.708870768971808*^9, 3.708870801904078*^9}, {
  3.70887091291048*^9, 3.708870981151857*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"46aa8a96-23a5-47d4-b4eb-7fc59f9c96a8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "MatrixTransform[",
 StyleBox["g",
  FontSlant->"Italic"],
 ", ",
 StyleBox["m",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{3.4414998063921638`*^9, 
  3.441505258432224*^9},ExpressionUUID->"b6098ec9-be5b-4844-b510-\
33c0eb3e6fc1"],

Cell[TextData[{
 "MatrixTransform[",
 StyleBox["g",
  FontSlant->"Italic"],
 ",",
 StyleBox["m",
  FontSlant->"Italic"],
 "] takes the graphic object ",
 StyleBox["g",
  FontSlant->"Italic"],
 " and transforms every point appearing in it by multiplying by the matrix ",
 StyleBox["m",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{
  3.441499806413416*^9},ExpressionUUID->"5eaf6a83-3b36-4869-850d-\
c9196fa94e1a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixTransform", "[", 
   RowBox[{"g_", ",", "m_"}], "]"}], ":=", 
  RowBox[{"FunctionTransform", "[", 
   RowBox[{"g", ",", 
    RowBox[{
     RowBox[{"m", ".", "#"}], "&"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.441499806434039*^9, {3.442874101244857*^9, 3.442874108750825*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"b00b0ea8-939f-4fb0-b778-3d4085274141"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Additional trig functions", "Subsection",
 CellChangeTimes->{{3.636736685939354*^9, 
  3.636736689325651*^9}},ExpressionUUID->"2684cfcd-26ff-4a35-b693-\
bad1856b8f23"],

Cell[CellGroupData[{

Cell["\<\
Hav[\[Xi]]
ArcHav[\[Xi]]\
\>", "Subsubsection",
 CellChangeTimes->{{3.636736973840451*^9, 
  3.636736985550141*^9}},ExpressionUUID->"5f5e8ff0-fc33-4a1f-8403-\
db1c083b78a2"],

Cell["Hav[\[Xi]] returns the haversine of \[Xi] using the cosine formula.", \
"Text",
 CellChangeTimes->{{3.636736694592572*^9, 3.636736702152853*^9}, {
  3.636736734965323*^9, 3.636736740357993*^9}, {3.636736777701243*^9, 
  3.636736780343999*^9}},ExpressionUUID->"ea2699d4-3295-48b4-8805-\
c189ed5cc8c9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Hav", "[", "\[Xi]_", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", "2"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "\[Xi]", "]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.636736720492048*^9, 3.636736732247995*^9}, {
  3.63673676765324*^9, 3.636736782132106*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"4fbfb274-3442-4cfd-9cd3-292d963cac6e"],

Cell["Example", "Text",
 CellChangeTimes->{{3.636736795961818*^9, 
  3.6367367967063446`*^9}},ExpressionUUID->"e0533249-e5be-4a08-9d4a-\
22bb2deadadf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Hav", "[", 
     RowBox[{"\[Xi]", " ", "\[Degree]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Xi]", ",", "0", ",", "360"}], "}"}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.63673679839532*^9, 3.636736845584235*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"99ef223b-13fb-41c8-8c44-b37f5361c423"],

Cell["\<\
ArcHav[x] returns the first-quadrant (between 0 and \[Pi]) inverse haversine.\
\
\>", "Text",
 CellChangeTimes->{{3.636736747149167*^9, 3.636736792419359*^9}, {
  3.6367368780845613`*^9, 
  3.636736893075803*^9}},ExpressionUUID->"22258200-a58c-41ab-bb71-\
40cd28ddad28"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcHav", "[", "x_", "]"}], ":=", 
  RowBox[{"ArcCos", "[", 
   RowBox[{"1", "-", 
    RowBox[{"2", "x"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.636736902878374*^9, 3.636736919139248*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"16fcf01f-f1e6-4062-b5a5-87114cc22014"],

Cell["Example", "Text",
 CellChangeTimes->{{3.636736925309696*^9, 
  3.636736926041678*^9}},ExpressionUUID->"542395e0-31e2-4363-8975-\
e9463e93a0fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcHav", "[", "x", "]"}], "/", "\[Degree]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.63673679839532*^9, 3.636736845584235*^9}, {
  3.6367369327660017`*^9, 3.63673694255399*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"aac325a4-4225-4f60-8b6a-c652b230ed2a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ArcTanAlt[",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.806332712327552*^9, 
  3.806332716599142*^9}},ExpressionUUID->"3b43d017-4c1d-4a13-83cd-\
fc1fe4102fe1"],

Cell[TextData[{
 "ArcTanAlt[",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "] is an alternative to the 4-quadrant arctangent that gives a 4-quadrant \
value by solving for the arctangent of the half-angle."
}], "Text",
 CellChangeTimes->{{3.806332722313876*^9, 
  3.806332753520518*^9}},ExpressionUUID->"0e3e6cf3-cfe1-4547-a2e6-\
6b83c90dad97"],

Cell["\<\
Note that it returns a divide-by-zero error if the result should be \
\[PlusMinus]\[Pi]. We don\[CloseCurlyQuote]t catch that state with an If, so \
that the result can be further analytically simplified.\
\>", "Text",
 CellChangeTimes->{{3.806332884472516*^9, 
  3.806332961122244*^9}},ExpressionUUID->"6ee6b960-e399-4e32-b4f8-\
000390b062a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTanAlt", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox["y", 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]], "+", "x"}]], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.806332526239554*^9, 3.806332554415539*^9}, {
  3.806332653458982*^9, 3.806332663439322*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"24665173-aedf-4d34-bb59-14576ee5f4fb"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.806332765570815*^9, 
  3.806332767408601*^9}},ExpressionUUID->"e9e222f5-bdc0-47fe-ab0c-\
c12d153ca3a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", 
        RowBox[{"ArcTanAlt", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", 
        RowBox[{"ArcTanAlt", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"ArcTanAlt", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "}"}], "//", "Simplify"}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", 
        RowBox[{"ArcTanAlt", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}]}], ";", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"ArcTanAlt", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "}"}], "//", "Simplify"}], "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.806332770270097*^9, 3.8063328736737*^9}, {
  3.806332966208846*^9, 3.806333052570467*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"09a811b1-1038-4e35-a392-6a55acdbc4e9"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Simplification", "Subsection",
 CellChangeTimes->{{3.690986789104944*^9, 
  3.690986791675293*^9}},ExpressionUUID->"440a706b-656e-4182-a8b7-\
c45beb3aecf5"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.690986793559874*^9, 
  3.690986794002119*^9}},ExpressionUUID->"e481fa53-adb3-4cc1-ae7c-\
e86543451ccd"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s expression simplification functions Simplify and \
FullSimplify are awesome, and we use them liberally, with the caveat that \
FullSimplify can take a REALLY long time for not much benefit. When working \
with analytic expressions, it is often useful to try to simplify results at \
each stage of the computation (see, for example, the tools for working with \
curved functions). Here we provide some useful utilities for working with \
simplification."
}], "Text",
 CellChangeTimes->{{3.69098679762967*^9, 
  3.690986945745198*^9}},ExpressionUUID->"95954d01-502a-4e5f-91c5-\
b75fd49d693b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Simplification, Assumptions", "Subsubsection",
 CellChangeTimes->{{3.6909869734220257`*^9, 3.6909869753746853`*^9}, {
  3.6912321296606627`*^9, 
  3.691232131405732*^9}},ExpressionUUID->"2c54c628-10c5-4be4-a607-\
db7f57d926f7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Simplification", "::", "usage"}], 
   "=", "\"\<Simplification is an option to various functions that specifies \
the form of simplification to use on intermediate results within the \
function.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.690986980871654*^9, 3.69098701599144*^9}, {
  3.69123202782592*^9, 3.691232030553076*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"b5420f14-5800-4b9b-8888-c4a0d76c1807"],

Cell["\<\
Simplification is an option used in many functions that lets you specify how \
to perform simplification on intermediate results. That\[CloseCurlyQuote]s \
because you\[CloseCurlyQuote]ll often have better luck simplifying \
intermediate expressions as you go, rather than trying to do all the \
simplification at the end.\
\>", "Text",
 CellChangeTimes->{{3.690987019589222*^9, 3.6909870438359756`*^9}, {
  3.691232014187291*^9, 3.6912320203912783`*^9}, {3.691232068872264*^9, 
  3.6912320997793083`*^9}},ExpressionUUID->"0dbf4e77-4088-4360-a524-\
ad9e25512ec6"],

Cell[TextData[{
 "Options:\n\tSimplification \[Rule] None | Simplify | FullSimplify, \
specifies the level of simplification of intermediate results.\n\tAssumptions \
\[Rule] ",
 StyleBox["list",
  FontSlant->"Italic"],
 ", assumptions that should be passed to Simplify or FullSimplify."
}], "Text",
 CellChangeTimes->{{3.691235065551579*^9, 3.691235071734006*^9}, {
  3.691235123137779*^9, 
  3.691235148876122*^9}},ExpressionUUID->"5c012753-b66e-435e-98c8-\
a5094e581ead"],

Cell["\<\
Simplify and FullSimplify both take Assumptions as an option. Functions that \
support Simplification should also support Assumptions and should add their \
own assumptions to any passed as options.\
\>", "Text",
 CellChangeTimes->{{3.6912322674742393`*^9, 
  3.69123234799215*^9}},ExpressionUUID->"0cce05db-896b-4ca8-b708-\
296a65861de9"],

Cell["\<\
Default behavior should usually be no simplification attempted.\
\>", "Text",
 CellChangeTimes->{{3.690988129650765*^9, 
  3.6909881408940988`*^9}},ExpressionUUID->"622a726e-36dc-4eeb-9e06-\
b77e4d1f5b9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "Simplification", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplification", "\[Rule]", "None"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Assumptions", "\[Rule]", "$Assumptions"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.690987995000527*^9, 3.69098800858436*^9}, {
  3.691232481067936*^9, 3.691232487455567*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"42ca7191-de63-4aae-81de-6fcdeb978b49"],

Cell["\<\
This example is a prototype for how you would use this option in functions \
that support it and its effect.\
\>", "Text",
 CellChangeTimes->{{3.690987893671658*^9, 3.690987910774537*^9}, 
   3.690988116192151*^9, {3.690988376708977*^9, 3.6909883870408893`*^9}, {
   3.6912326485773373`*^9, 3.691232651025248*^9}, {3.691232712945214*^9, 
   3.691232719893112*^9}, {3.691232908986012*^9, 
   3.691232909368866*^9}},ExpressionUUID->"62da48f9-239f-41e6-b217-\
a41703d3af80"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"si", ",", "as", ",", "sfn", ",", "opts"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"opts", "=", 
      RowBox[{"Sequence", "[", 
       RowBox[{"Simplification", "\[Rule]", "None"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"si", "=", 
      RowBox[{
       RowBox[{"Simplification", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "Simplification", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"as", "=", 
      RowBox[{
       RowBox[{"Assumptions", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "Simplification", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"sfn", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"si", "===", "None"}], ",", 
        RowBox[{"#", "&"}], ",", 
        RowBox[{
         RowBox[{"si", "[", 
          RowBox[{"#", ",", 
           RowBox[{"Assumptions", "\[Rule]", "as"}]}], "]"}], "&"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "sfn", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], "+", "1"}], "//", 
      "sfn"}]}]}], "\[IndentingNewLine]", "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.690987912116748*^9, 3.690987982558473*^9}, {
  3.690988016113279*^9, 3.690988059983576*^9}, {3.690988092813447*^9, 
  3.690988093665613*^9}, {3.690988226562254*^9, 3.690988368154851*^9}, {
  3.6912324540683203`*^9, 3.691232508162667*^9}, {3.6912325422485*^9, 
  3.691232589898942*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"a9f48c3e-493d-4984-9f1d-d588dbd920db"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"si", ",", "as", ",", "sfn", ",", "opts"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"opts", "=", 
      RowBox[{"Sequence", "[", 
       RowBox[{"Simplification", "\[Rule]", "Simplify"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"si", "=", 
      RowBox[{
       RowBox[{"Simplification", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "Simplification", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"as", "=", 
      RowBox[{
       RowBox[{"Assumptions", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "Simplification", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"sfn", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"si", "===", "None"}], ",", 
        RowBox[{"#", "&"}], ",", 
        RowBox[{
         RowBox[{"si", "[", 
          RowBox[{"#", ",", 
           RowBox[{"Assumptions", "\[Rule]", "as"}]}], "]"}], "&"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "sfn", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], "+", "1"}], "//", 
      "sfn"}]}]}], "\[IndentingNewLine]", "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.690987912116748*^9, 3.690987982558473*^9}, {
  3.690988016113279*^9, 3.690988059983576*^9}, {3.690988092813447*^9, 
  3.690988093665613*^9}, {3.690988226562254*^9, 3.690988368154851*^9}, {
  3.6912324540683203`*^9, 3.691232508162667*^9}, {3.6912325422485*^9, 
  3.691232589898942*^9}, {3.691232625249425*^9, 3.69123262653059*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"bb4e1325-17c5-480f-b3bb-62dd504398fd"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Additional simplification functions", "Subsection",
 CellChangeTimes->{{3.799780233024329*^9, 
  3.7997802518245716`*^9}},ExpressionUUID->"43a707de-b241-4ee1-9017-\
35cfa5fa2815"],

Cell[CellGroupData[{

Cell[TextData[{
 "CombineSquareRootsInProducts[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{
  3.799780206896166*^9},ExpressionUUID->"98b9fa6f-83a0-4e80-8b08-\
696ed6e26eee"],

Cell[TextData[{
 "CombineSquareRootsInProducts[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] performs a simplification that I would have expected to be part of \
FullSimplify, but isn\[CloseCurlyQuote]t. In any products that contain more \
than one square root, we combine the square roots, which allows \
simplifications to happen inside the square root."
}], "Text",
 CellChangeTimes->{{3.799780016045574*^9, 3.799780037277291*^9}, {
  3.799780158447197*^9, 
  3.799780200590955*^9}},ExpressionUUID->"29e015a1-8d93-4714-98ee-\
3183216d0822"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CombineSquareRootsInProducts", "[", "expr_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "combi", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"combi", "[", "times_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"sr", ",", "nsr"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sr", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"times", ",", 
            RowBox[{
             RowBox[{"MatchQ", "[", 
              RowBox[{"#", ",", 
               RowBox[{"Power", "[", 
                RowBox[{"_", ",", 
                 RowBox[{"Rational", "[", 
                  RowBox[{"1", ",", "2"}], "]"}]}], "]"}]}], "]"}], "&"}]}], 
           "]"}]}], ";", 
         RowBox[{"nsr", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"times", ",", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"MatchQ", "[", 
               RowBox[{"#", ",", 
                RowBox[{"Power", "[", 
                 RowBox[{"_", ",", 
                  RowBox[{"Rational", "[", 
                   RowBox[{"1", ",", "2"}], "]"}]}], "]"}]}], "]"}]}], 
             "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "sr", "]"}], ">", "1"}], ",", 
           RowBox[{
            RowBox[{"Power", "[", 
             RowBox[{
              RowBox[{"Times", "@@", 
               RowBox[{"(", 
                RowBox[{"First", "/@", "sr"}], ")"}]}], ",", 
              RowBox[{"Rational", "[", 
               RowBox[{"1", ",", "2"}], "]"}]}], "]"}], 
            RowBox[{"Times", "@@", "nsr"}]}], ",", "times"}], "]"}]}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"expr", "/.", 
      RowBox[{"prod_Times", "\[RuleDelayed]", 
       RowBox[{"combi", "[", "prod", "]"}]}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.799778887911768*^9, 3.799778994639428*^9}, {
   3.799779116321234*^9, 3.799779249704908*^9}, {3.799779284225365*^9, 
   3.799779346177669*^9}, {3.7997793788348217`*^9, 3.799779457259057*^9}, {
   3.799779589717595*^9, 3.7997796532532578`*^9}, {3.799779702799859*^9, 
   3.799779708372445*^9}, {3.799779756279581*^9, 3.799779859349361*^9}, {
   3.799779900240957*^9, 3.79977997267166*^9}, 3.799780071006147*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"19c2b8c1-be04-447a-9d75-246352e7ca03"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.799779465714395*^9, 3.7997794665382147`*^9}, 
   3.799780000070158*^9},ExpressionUUID->"005d6216-b887-4b15-9d99-\
4ce356c1054e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "expr"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"expr", "=", 
      RowBox[{"2", " ", "*", " ", 
       SqrtBox["x"], "*", " ", "y", " ", "*", " ", 
       SqrtBox["z"]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<expr = \>\"", ",", "expr"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<FullSimplify[expr] = \>\"", ",", 
       RowBox[{"FullSimplify", "[", "expr", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"expr", "=", 
      RowBox[{"CombineSquareRootsInProducts", "[", "expr", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<CombineSquareRootsInProducts[expr] = \>\"", ",", "expr"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.7997794706676273`*^9, 3.799779586787649*^9}, 
   3.7997796938472424`*^9, 3.79978001193053*^9, {3.799780043728324*^9, 
   3.79978014917562*^9}, {3.799780214235687*^9, 3.799780221903541*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"0d2c4517-2c19-4b06-8042-3587ccab09f4"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pure function utilities", "Subsection",
 CellChangeTimes->{{3.688986938755375*^9, 3.688986942695174*^9}, {
  3.689207082644895*^9, 3.689207082755927*^9}, {3.68985529855757*^9, 
  3.689855302114946*^9}},ExpressionUUID->"6ca37c44-c5d1-4a81-8b31-\
82dc11679950"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.688986948194057*^9, 
  3.688986948684675*^9}},ExpressionUUID->"4bf0ca79-c3d8-467e-847f-\
90326d13bbbd"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports working with pure functions (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Function) of one or more variables. Functionize helps us convert an \
algebraic expression into a pure function. (This is the equivalent of Maple\
\[CloseCurlyQuote]s ",
 StyleBox["unapply",
  FontSlant->"Italic"],
 ")."
}], "Text",
 CellChangeTimes->{{3.688986952756979*^9, 3.688987027396494*^9}, 
   3.688995355459616*^9, {3.689207093201556*^9, 3.689207093827743*^9}, {
   3.689855333457053*^9, 3.689855355259595*^9}, {3.689855390413579*^9, 
   3.689855393835216*^9}, 3.798622843847621*^9, {3.798622937433813*^9, 
   3.798622937910318*^9}},ExpressionUUID->"e6f3286a-31d8-47ae-997f-\
e2119eddecf4"],

Cell["\<\
When working with pure functions parameterized on 1 or a few variables, it is \
often prettier to display the functions with letter variables (t, u, v), \
rather than slots (#, #1, #2). PrettyParameters makes that conversion, using \
strings for the variable names.\
\>", "Text",
 CellChangeTimes->{{3.6881363877837*^9, 3.688136472457959*^9}, {
  3.688136663581558*^9, 3.688136663957933*^9}, {3.689855426415754*^9, 
  3.68985545298505*^9}, {3.689855497659433*^9, 
  3.689855500711069*^9}},ExpressionUUID->"e4eff20b-bf10-47c8-87c5-\
0f9ed31d68db"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "SlotCount[",
 StyleBox["f",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.6898478011117897`*^9, 3.689847806996665*^9}, {
  3.691233050964887*^9, 
  3.691233062779962*^9}},ExpressionUUID->"6ea15e99-b860-4999-bd50-\
f091ba8e208f"],

Cell[TextData[{
 "SlotCount[",
 StyleBox["f",
  FontSlant->"Italic"],
 "] returns the maximum number of Slot[i] objects in a function object."
}], "Text",
 CellChangeTimes->{{3.689847810016361*^9, 3.689847816603245*^9}, {
  3.68984785173699*^9, 
  3.689847862318909*^9}},ExpressionUUID->"dd02c041-31d2-41b5-986c-\
d6ec5bfcce31"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SlotCount", "[", "f_Function", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "sls", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"sls", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"Union", "[", 
        RowBox[{"Cases", "[", 
         RowBox[{"f", ",", 
          RowBox[{"Slot", "[", "_", "]"}], ",", "\[Infinity]"}], "]"}], "]"}],
        "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ListEmptyQ", "[", "sls", "]"}], ",", "0", ",", 
       RowBox[{"sls", "\[LeftDoubleBracket]", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "\[RightDoubleBracket]"}]}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.689847888267715*^9, 3.68984795684336*^9}, {
  3.691233056679605*^9, 3.691233057213866*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"62eca03a-6c12-48c9-bfd6-c7bbb8cc86d2"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.689847965902403*^9, 
  3.6898479679632683`*^9}},ExpressionUUID->"2a1133ac-70dc-4d93-ab71-\
d6341c1a2ccb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SlotCount", "[", 
   RowBox[{
    RowBox[{"{", "}"}], "&"}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6898479698205748`*^9, 3.689847982396739*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"2d3556aa-8c28-477a-9588-e11b783da57a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SlotCount", "[", 
   RowBox[{
    RowBox[{"{", "#", "}"}], "&"}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6898479915645237`*^9, 3.689848016837536*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"f32e4340-6df7-4382-af02-d3a8ce573c6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SlotCount", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#1", ",", "#2"}], "}"}], "&"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6898479915645237`*^9, 3.689848017571727*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"60396252-c294-4198-b569-41b374b9c738"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SlotCount", "[", 
   RowBox[{
    RowBox[{"{", "#2", "}"}], "&"}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6898479915645237`*^9, 3.689848018631431*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"dbeef05e-55f8-4358-b52f-443f09f8517f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Functionize[x, ",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]\nFunctionize[ {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 ",...}, ",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.68898702980818*^9, 3.688987054155849*^9}, {
   3.68898709959233*^9, 3.688987116259305*^9}, {3.6889953537025557`*^9, 
   3.688995353725535*^9}, 3.690988443559346*^9, {3.691232782475604*^9, 
   3.69123280924415*^9}, {3.69123286797189*^9, 3.691232872633645*^9}, {
   3.691233025191627*^9, 3.691233034439118*^9}, {3.7986230421021757`*^9, 
   3.798623053812511*^9}},ExpressionUUID->"d099cf07-a01f-4d9b-8b3a-\
13a6bb7f1780"],

Cell[TextData[{
 "Functionize[x, ",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] takes an expression ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " in terms of a variable ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and returns a pure function of the relationship."
}], "Text",
 CellChangeTimes->{{3.690988526937256*^9, 3.690988596334168*^9}, {
   3.691232734650044*^9, 3.691232766876895*^9}, 3.691232884634517*^9, {
   3.691233039833653*^9, 3.691233048039056*^9}, {3.691254816979806*^9, 
   3.6912548178516083`*^9}, 
   3.798623062774129*^9},ExpressionUUID->"5f8aecd7-ff27-4877-9f19-\
08921d14a071"],

Cell[TextData[{
 "Functionize[ {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 ",...}, ",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] does the same thing for an expression with multiple variables."
}], "Text",
 CellChangeTimes->{{3.690988614485464*^9, 3.690988641923769*^9}, 
   3.691233049546685*^9, 
   3.798623072151846*^9},ExpressionUUID->"e0c68d5e-a606-48dd-ae27-\
ba2bf2d07572"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Functionize", "[", 
   RowBox[{"x_", ",", "expr_"}], "]"}], ":=", 
  RowBox[{"Functionize", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", "expr"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.688987194174798*^9, 3.688987210167776*^9}, {
  3.688995353763188*^9, 3.688995353778818*^9}, {3.691233076895434*^9, 
  3.691233111464261*^9}, {3.798623095191458*^9, 3.798623120291413*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"076a26b1-f4de-4d5d-908e-6119400f6b05"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Functionize", "[", 
   RowBox[{"vars_List", ",", "expr_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"fs", ",", "vr", ",", "sl", ",", "fn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"rules", " ", "to", " ", "substitute", " ", 
      RowBox[{"Slot", "[", "i", "]"}], " ", "for", " ", "variables"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"vr", "=", 
      RowBox[{
       RowBox[{"MapIndexed", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "\[Rule]", 
           RowBox[{"sl", "[", 
            RowBox[{
            "#2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            "]"}]}], "&"}], ",", 
         RowBox[{"Flatten", "[", "vars", "]"}]}], "]"}], "/.", 
       RowBox[{"sl", "\[Rule]", "Slot"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"replace", " ", "variables", " ", "with", " ", 
       RowBox[{"Slot", "[", "i", "]"}], " ", "and", " ", "wrap", " ", "with", 
       " ", "Function"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fn", "[", 
       RowBox[{"expr", "/.", "vr"}], "]"}], "/.", 
      RowBox[{"fn", "\[Rule]", "Function"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.688987066968246*^9, 3.688987097760138*^9}, {
  3.688987213612932*^9, 3.688987215077746*^9}, {3.688987286293028*^9, 
  3.688987427057816*^9}, {3.68898751006995*^9, 3.688987516889538*^9}, {
  3.688987866985034*^9, 3.688987869374758*^9}, {3.688987936227222*^9, 
  3.688988029559819*^9}, {3.688988882493145*^9, 3.688988903743311*^9}, {
  3.688995353795556*^9, 3.68899535380962*^9}, {3.690988721050604*^9, 
  3.69098873346517*^9}, {3.690988764268079*^9, 3.690988815966273*^9}, {
  3.69098887388802*^9, 3.690988906888825*^9}, {3.690989022229207*^9, 
  3.690989026353751*^9}, {3.690989170247964*^9, 3.690989197263489*^9}, {
  3.690989233998023*^9, 3.690989236719207*^9}, {3.691233086666751*^9, 
  3.6912331251975813`*^9}, {3.798623087982921*^9, 3.798623091896442*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"896dc79e-3a23-4388-8a96-5b375e82b434"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.688987154748624*^9, 3.688987155436357*^9}, {
  3.6889880395385237`*^9, 
  3.6889880409782557`*^9}},ExpressionUUID->"dcfed00c-cb4e-4823-9643-\
fcb47bc3a8fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "f", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"1", "+", 
       RowBox[{"x", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Functionize", "[", 
      RowBox[{"f", ",", "x"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688987160375759*^9, 3.688987179477875*^9}, {
   3.688987228668455*^9, 3.688987234570127*^9}, {3.68898745451655*^9, 
   3.688987455864179*^9}, {3.688987496940661*^9, 3.688987497212625*^9}, {
   3.688988058618702*^9, 3.688988077614317*^9}, 3.688995353828266*^9},
 CellLabel->"In[98]:=",ExpressionUUID->"99775e11-fb60-4153-87bf-91079e98f8c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "f", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}], " ", "+", " ", 
       RowBox[{"y", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Functionize", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688987160375759*^9, 3.688987179477875*^9}, {
   3.688987228668455*^9, 3.688987234570127*^9}, {3.68898745451655*^9, 
   3.688987455864179*^9}, {3.688987496940661*^9, 3.688987497212625*^9}, {
   3.688988052123987*^9, 3.688988053693043*^9}, {3.68898809590478*^9, 
   3.688988103211513*^9}, {3.688988150228406*^9, 3.688988154475798*^9}, {
   3.688988238067464*^9, 3.688988246014211*^9}, 3.688995353851626*^9, 
   3.690989114481599*^9},
 CellLabel->"In[99]:=",ExpressionUUID->"f6c749ba-8fdd-43c8-b5d5-894ff914211f"],

Cell[TextData[{
 "Note that Function[x, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]],ExpressionUUID->
  "ac3a32e1-12a8-4ca0-b506-a38474ff3a6e"],
 "] and Functionize[x, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]],ExpressionUUID->
  "8898f19a-941e-45cc-af3c-3390c7b6ca1d"],
 "] return exactly the same thing. The times when Functionize is preferred is \
when you\[CloseCurlyQuote]re carrying out an algebraic derivation inside of a \
module and you want to turn the result into a function. Compare the two \
here."
}], "Text",
 CellChangeTimes->{{3.798623205196609*^9, 3.798623342398203*^9}, {
  3.7986234146666813`*^9, 3.798623420176343*^9}, {3.798623668033628*^9, 
  3.798623671548616*^9}},ExpressionUUID->"d1728a2a-6c71-470c-8cbb-\
02bec9da26c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "expr", ",", "f1", ",", "f2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"expr", "=", 
      SuperscriptBox["x", "2"]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"Function", "[", 
       RowBox[{"x", ",", "expr"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"x", ",", "expr"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f2", "]"}], ";"}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.798623344428443*^9, 3.798623395430756*^9}, {
   3.798623435548325*^9, 3.798623453745655*^9}, 3.798623709826112*^9},
 CellLabel->
  "In[100]:=",ExpressionUUID->"37d8e2f1-4431-4ae6-b054-441b18ab628a"],

Cell["\<\
Note, too, that while Function holds all its arguments, Functionize evaluates \
them first, so you can Simplify expressions inside the call.\
\>", "Text",
 CellChangeTimes->{{3.798623490731546*^9, 3.7986235223891377`*^9}, {
  3.798623630811518*^9, 
  3.798623654202086*^9}},ExpressionUUID->"b61f923c-a8e7-4e20-916f-\
ef845c1ee52b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "f1", ",", "f2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f1", "=", 
      RowBox[{"Function", "[", 
       RowBox[{"x", ",", 
        RowBox[{"2", "+", 
         RowBox[{"2", 
          SuperscriptBox["x", "2"]}], "-", "1", "-", 
         SuperscriptBox["x", "2"]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"x", ",", 
        RowBox[{"2", "+", 
         SuperscriptBox["x", "2"], "-", "1", "-", 
         SuperscriptBox["x", "2"]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f2", "]"}], ";"}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.798623344428443*^9, 3.798623395430756*^9}, {
  3.798623435548325*^9, 3.798623453745655*^9}, {3.798623533612971*^9, 
  3.798623611003933*^9}, {3.798623689556614*^9, 3.798623707982079*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"306dbf82-461a-4519-937b-b4ef28c54d05"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "FunctionizeOld[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["x",
  FontSlant->"Italic"],
 "] [DEPRECATED]\nFunctionizeOld[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 ",...}] [DEPRECATED]"
}], "Subsubsection",
 CellChangeTimes->{{3.68898702980818*^9, 3.688987054155849*^9}, {
   3.68898709959233*^9, 3.688987116259305*^9}, {3.6889953537025557`*^9, 
   3.688995353725535*^9}, 3.690988443559346*^9, {3.691232782475604*^9, 
   3.69123280924415*^9}, {3.69123286797189*^9, 3.691232872633645*^9}, {
   3.691233025191627*^9, 3.691233034439118*^9}, {3.798622843908182*^9, 
   3.798622843928368*^9}, {3.798622948991427*^9, 
   3.7986229557822447`*^9}},ExpressionUUID->"0ccfd708-f58d-4296-95c2-\
c5112e09fc3a"],

Cell["\<\
FunctionizeOld is the original version of this function, in which the \
expression precedes the variables. In Tessellatica 12.1d8, I redefined \
Functionize so that the variables precede the expression, so that its syntax \
matches that of Function.\
\>", "Text",
 CellChangeTimes->{{3.798622963683497*^9, 
  3.798623035465897*^9}},ExpressionUUID->"c74b1898-37bd-4bda-b32b-\
88bc54712512"],

Cell[TextData[{
 "FunctionizeOld[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["x",
  FontSlant->"Italic"],
 "] takes an expression ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " in terms of a variable ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and returns a pure function of the relationship."
}], "Text",
 CellChangeTimes->{{3.690988526937256*^9, 3.690988596334168*^9}, {
   3.691232734650044*^9, 3.691232766876895*^9}, 3.691232884634517*^9, {
   3.691233039833653*^9, 3.691233048039056*^9}, {3.691254816979806*^9, 
   3.6912548178516083`*^9}, 
   3.798622843944573*^9},ExpressionUUID->"eac706f6-8900-451b-9091-\
0a594aedff93"],

Cell[TextData[{
 "FunctionizeOld[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", {",
 StyleBox["x, y, ...}",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] does the same thing for an expression with multiple variables."
}], "Text",
 CellChangeTimes->{{3.690988614485464*^9, 3.690988641923769*^9}, 
   3.691233049546685*^9, 
   3.798622843959737*^9},ExpressionUUID->"39750f83-c990-4f50-80f0-\
1be9b4719247"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionizeOld", "[", 
   RowBox[{"expr_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"FunctionizeOld", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"{", "x", "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.688987194174798*^9, 3.688987210167776*^9}, {
  3.688995353763188*^9, 3.688995353778818*^9}, {3.691233076895434*^9, 
  3.691233111464261*^9}, {3.798622843975928*^9, 3.798622843978826*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"6d78000e-f0c3-4be3-8354-cf7aaf4c9d65"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionizeOld", "[", 
   RowBox[{"expr_", ",", "vars_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"fs", ",", "vr", ",", "sl", ",", "fn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"rules", " ", "to", " ", "substitute", " ", 
      RowBox[{"Slot", "[", "i", "]"}], " ", "for", " ", "variables"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"vr", "=", 
      RowBox[{
       RowBox[{"MapIndexed", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#1", "\[Rule]", 
           RowBox[{"sl", "[", 
            RowBox[{
            "#2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            "]"}]}], "&"}], ",", 
         RowBox[{"Flatten", "[", "vars", "]"}]}], "]"}], "/.", 
       RowBox[{"sl", "\[Rule]", "Slot"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"replace", " ", "variables", " ", "with", " ", 
       RowBox[{"Slot", "[", "i", "]"}], " ", "and", " ", "wrap", " ", "with", 
       " ", "Function"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fn", "[", 
       RowBox[{"expr", "/.", "vr"}], "]"}], "/.", 
      RowBox[{"fn", "\[Rule]", "Function"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.688987066968246*^9, 3.688987097760138*^9}, {
   3.688987213612932*^9, 3.688987215077746*^9}, {3.688987286293028*^9, 
   3.688987427057816*^9}, {3.68898751006995*^9, 3.688987516889538*^9}, {
   3.688987866985034*^9, 3.688987869374758*^9}, {3.688987936227222*^9, 
   3.688988029559819*^9}, {3.688988882493145*^9, 3.688988903743311*^9}, {
   3.688995353795556*^9, 3.68899535380962*^9}, {3.690988721050604*^9, 
   3.69098873346517*^9}, {3.690988764268079*^9, 3.690988815966273*^9}, {
   3.69098887388802*^9, 3.690988906888825*^9}, {3.690989022229207*^9, 
   3.690989026353751*^9}, {3.690989170247964*^9, 3.690989197263489*^9}, {
   3.690989233998023*^9, 3.690989236719207*^9}, {3.691233086666751*^9, 
   3.6912331251975813`*^9}, 3.79862284398597*^9},
 CellLabel->
  "In[103]:=",ExpressionUUID->"e03da8d0-4509-4842-a095-79216c5e41ef"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.688987154748624*^9, 3.688987155436357*^9}, {
  3.6889880395385237`*^9, 
  3.6889880409782557`*^9}},ExpressionUUID->"5f6ba66e-b8ba-4463-b154-\
6fb8c755efde"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "f", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"1", "+", 
       RowBox[{"x", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"FunctionizeOld", "[", 
      RowBox[{"f", ",", "x"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688987160375759*^9, 3.688987179477875*^9}, {
   3.688987228668455*^9, 3.688987234570127*^9}, {3.68898745451655*^9, 
   3.688987455864179*^9}, {3.688987496940661*^9, 3.688987497212625*^9}, {
   3.688988058618702*^9, 3.688988077614317*^9}, 3.688995353828266*^9, 
   3.7986228439938307`*^9},
 CellLabel->
  "In[104]:=",ExpressionUUID->"36644edd-dc9a-414b-aebb-e0d94a25d822"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "f", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", " ", "x", " ", "y"}], " ", "+", " ", 
       RowBox[{"y", "^", "2"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"FunctionizeOld", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688987160375759*^9, 3.688987179477875*^9}, {
   3.688987228668455*^9, 3.688987234570127*^9}, {3.68898745451655*^9, 
   3.688987455864179*^9}, {3.688987496940661*^9, 3.688987497212625*^9}, {
   3.688988052123987*^9, 3.688988053693043*^9}, {3.68898809590478*^9, 
   3.688988103211513*^9}, {3.688988150228406*^9, 3.688988154475798*^9}, {
   3.688988238067464*^9, 3.688988246014211*^9}, 3.688995353851626*^9, 
   3.690989114481599*^9, 3.7986228439990253`*^9},
 CellLabel->
  "In[105]:=",ExpressionUUID->"dc3ab7bf-fd25-49f7-b832-a1777c278a85"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "PrettyParameters[",
 StyleBox["f",
  FontSlant->"Italic"],
 "]\nPrettyParameters[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]\nPrettyParameters[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["vars",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.688136666741826*^9, 3.6881366717249618`*^9}, {
  3.689809689141575*^9, 3.6898096940094337`*^9}, {3.802168264001377*^9, 
  3.802168270686996*^9}},ExpressionUUID->"c8629d56-267a-4d29-b085-\
0042de8d60e7"],

Cell[TextData[{
 "PrettyParameters[",
 StyleBox["f",
  FontSlant->"Italic"],
 "] replaces Slots with letters in functions for up to six slots. This makes \
pure functions more easily readable."
}], "Text",
 CellChangeTimes->{{3.6881366743815207`*^9, 3.688136700683188*^9}, {
  3.688136999576573*^9, 3.68813700289596*^9}, {3.689809874360628*^9, 
  3.689809885540591*^9}},ExpressionUUID->"09718930-301f-4efd-87c6-\
29a97a44a65b"],

Cell[TextData[{
 "PrettyParameters[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] replaces Slots with letters in functions anywhere within ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " for up to six slots."
}], "Text",
 CellChangeTimes->{{3.6881366743815207`*^9, 3.688136700683188*^9}, {
  3.688136999576573*^9, 3.68813700289596*^9}, {3.689809733614194*^9, 
  3.689809741638826*^9}},ExpressionUUID->"b0d157f9-13b3-4519-ad2a-\
dc22a4424b77"],

Cell[TextData[{
 "PrettyParameters[",
 StyleBox["expr, vars",
  FontSlant->"Italic"],
 "] replaces Slots with letters in functions anywhere with an externally \
supplied list of variable names (or actual variables)."
}], "Text",
 CellChangeTimes->{{3.6881366743815207`*^9, 3.688136700683188*^9}, {
  3.688136999576573*^9, 3.68813700289596*^9}, {3.689809733614194*^9, 
  3.689809741638826*^9}, {3.802168279421804*^9, 3.8021682802394323`*^9}, {
  3.802169288376541*^9, 
  3.8021693050250673`*^9}},ExpressionUUID->"caee9b4c-c939-40c0-9ac9-\
5e37eff2fae4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PrettyParameters", "::", "badvars"}], 
   "=", "\"\<There are not enough variables in `1` to cover `2` function \
slots.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.802168867484073*^9, 3.80216891474171*^9}},
 CellLabel->
  "In[106]:=",ExpressionUUID->"b19dc62b-505e-4e56-9df8-7fe0b8787def"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrettyParameters", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"vars_List", ":", 
     RowBox[{"{", "}"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "ppfn", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"ppfn", "[", "f_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"sls", ",", "sn"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sn", "=", 
          RowBox[{"SlotCount", "[", "f", "]"}]}], ";", "\[IndentingNewLine]", 
         
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"sn", "\[Equal]", "0"}], ",", 
           RowBox[{"f", "[", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"sn", "\[Equal]", "1"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ListEmptyQ", "[", "vars", "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"f", "[", "\"\<t\>\"", "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"f", "@@", 
              RowBox[{"Take", "[", 
               RowBox[{"vars", ",", "1"}], "]"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"sn", "\[GreaterEqual]", "2"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ListEmptyQ", "[", "vars", "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"sn", ">", "6"}], ",", 
                RowBox[{
                 RowBox[{"Message", "[", 
                  RowBox[{
                   RowBox[{"PrettyParameters", "::", "badvars"}], 
                   ",", "\"\<the default list\>\"", ",", "sn"}], "]"}], ";", 
                 RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"f", "@@", 
               RowBox[{"Take", "[", 
                RowBox[{
                 RowBox[{"{", 
                  
                  RowBox[{"\"\<u\>\"", ",", "\"\<v\>\"", ",", "\"\<w\>\"", 
                   ",", "\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], 
                  "}"}], ",", "sn"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"sn", ">", 
                 RowBox[{"Length", "[", "vars", "]"}]}], ",", 
                RowBox[{
                 RowBox[{"Message", "[", 
                  RowBox[{
                   RowBox[{"PrettyParameters", "::", "badvars"}], ",", "vars",
                    ",", "sn"}], "]"}], ";", 
                 RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"f", "@@", 
               RowBox[{"Take", "[", 
                RowBox[{"vars", ",", "sn"}], "]"}]}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", "True", ",", "f"}], "]"}]}]}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"expr", "/.", 
      RowBox[{"{", 
       RowBox[{"ff_Function", "\[RuleDelayed]", 
        RowBox[{"ppfn", "[", "ff", "]"}]}], "}"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.802168374560161*^9, 3.802168444576193*^9}, {
   3.802168540921502*^9, 3.802168856404142*^9}, {3.802168921152182*^9, 
   3.802168984967454*^9}, 3.802169080707075*^9},
 CellLabel->
  "In[107]:=",ExpressionUUID->"55d5ed90-1c2f-41c7-ba3f-e8c1947d7468"],

Cell["Examples", "Text",
 CellChangeTimes->{{3.688136645135027*^9, 3.6881366458149657`*^9}, 
   3.688137107090384*^9},ExpressionUUID->"c995bc86-4142-4916-92cc-\
0021aa1df37b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", "}"}], "&"}], "//", "PrettyParameters"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688137973208097*^9, 3.688137982763233*^9}, 
   3.802169068044979*^9},
 CellLabel->
  "In[108]:=",ExpressionUUID->"3baf47d1-ed31-454d-b092-6388c027af83"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", "#", "}"}], "&"}], "//", "PrettyParameters"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688136647983724*^9, 3.688136655592948*^9}, {
  3.688137085807802*^9, 3.688137087613331*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"9b7c7c12-de5a-4d20-8290-d5001abca650"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#2", ",", "#1", ",", 
      RowBox[{
       SuperscriptBox["#2", "2"], 
       RowBox[{"Sin", "[", "#1", "]"}]}]}], "}"}], "&"}], "//", 
   "PrettyParameters"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688136728780598*^9, 3.688136749570627*^9}, {
  3.688137090263538*^9, 3.688137092044115*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"67950af2-8367-4a9d-add1-89b84a0e6980"],

Cell["\<\
Note that even if Slot[1] isn\[CloseCurlyQuote]t used, we correctly deduce \
the right variables.\
\>", "Text",
 CellChangeTimes->{{3.6881376918520613`*^9, 
  3.688137709330982*^9}},ExpressionUUID->"285fc7d7-769c-4b17-968f-\
971559cf2ce5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#2", ",", "#3", ",", 
      RowBox[{
       SuperscriptBox["#2", "2"], 
       RowBox[{"Sin", "[", "#3", "]"}]}]}], "}"}], "&"}], "//", 
   "PrettyParameters"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688136728780598*^9, 3.688136749570627*^9}, {
  3.688137090263538*^9, 3.688137092044115*^9}, {3.688137683777314*^9, 
  3.688137687846744*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"bebc3f3d-d687-49b9-89ae-e8123b861cb6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", "}"}], "&"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "#", "}"}], "&"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#2", ",", "#1", ",", 
         RowBox[{
          SuperscriptBox["#2", "2"], 
          RowBox[{"Sin", "[", "#1", "]"}]}]}], "}"}], "&"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#2", ",", "#3", ",", 
         RowBox[{
          SuperscriptBox["#2", "2"], 
          RowBox[{"Sin", "[", "#3", "]"}]}]}], "}"}], "&"}]}], "}"}], "//", 
    "PrettyParameters"}], "//", "ColumnForm"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.689809791049294*^9, 3.6898098363656263`*^9}, {
  3.689848105156726*^9, 3.689848106237857*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"fdc8259f-4366-4030-bbb9-ac56535d9f16"],

Cell["And we can use our own variables, if we wish.", "Text",
 CellChangeTimes->{{3.802169106062741*^9, 
  3.8021691113511553`*^9}},ExpressionUUID->"890d1c67-295a-4ae1-974a-\
58a4164011d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#2", ",", "#3", ",", 
      RowBox[{
       SuperscriptBox["#2", "2"], 
       RowBox[{"Sin", "[", "#3", "]"}]}]}], "}"}], "&"}], "//", 
   RowBox[{
    RowBox[{"PrettyParameters", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}]}], 
     "]"}], "&"}]}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688136728780598*^9, 3.688136749570627*^9}, {
  3.688137090263538*^9, 3.688137092044115*^9}, {3.688137683777314*^9, 
  3.688137687846744*^9}, {3.802169120241243*^9, 3.802169138382669*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"d321d966-aec2-4921-82a5-f1c87a581523"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interpolating function utilities", "Subsection",
 CellChangeTimes->{{3.6911895891286383`*^9, 
  3.691189594816711*^9}},ExpressionUUID->"ed2f1817-0535-468e-aa0a-\
1cbd56b5ca67"],

Cell[CellGroupData[{

Cell["Notes: scalar-valued functions", "Subsubsection",
 CellChangeTimes->{{3.691190624120576*^9, 3.691190624622396*^9}, {
  3.784387808673888*^9, 
  3.784387813128957*^9}},ExpressionUUID->"a6665c5e-1950-4b03-8a9a-\
ed16c26412e6"],

Cell["\<\
Working with pure functions lets us do many calculations analytically, but \
with curved folds in particular, the analytic expressions rapidly explode in \
complexity and intractability. By working with InterpolatingFunctions, we can \
handle far more.\
\>", "Text",
 CellChangeTimes->{{3.691190631037631*^9, 3.691190682208819*^9}, {
  3.69119077300654*^9, 3.691190807791368*^9}, {3.69119085547955*^9, 
  3.691190868236703*^9}, {3.691264874644619*^9, 
  3.691264875624667*^9}},ExpressionUUID->"d7ea11bd-b30b-4a0d-99b4-\
153511d06664"],

Cell["\<\
One can use FunctionInterpolation to create an InterpolatingFunction from any \
expression, but it has some weird limitations. First, because it has the \
attribute HoldAll, if you feed it an expression that contains derivatives, it \
substitutes before evaluating the derivative, which results in an error, as \
here:\
\>", "Text",
 CellChangeTimes->{{3.7843878357487497`*^9, 3.7843878531736608`*^9}, {
  3.784387885534811*^9, 
  3.78438795582983*^9}},ExpressionUUID->"98f09c02-5f26-421b-b0f6-\
106b1c2816d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", "fn", ",", "t0", ",", "t1", ",", "fni"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fn", "=", 
      RowBox[{
       SuperscriptBox["#", "2"], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", "t1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fni", "=", 
      RowBox[{"FunctionInterpolation", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"fn", "[", "t", "]"}], ",", "t"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "t1"}], "}"}]}], "]"}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowErrorExample"}]], "Input",
 CellChangeTimes->{{3.784387444006405*^9, 3.784387571067606*^9}, {
  3.784387970814895*^9, 3.784387971221547*^9}, {3.784389372149332*^9, 
  3.784389375600262*^9}, {3.800014092033444*^9, 3.80001410748205*^9}},
 CellLabel->
  "In[114]:=",ExpressionUUID->"2d11fc1d-ba5f-4c00-b2f5-2c97f8208e21"],

Cell["\<\
One can avoid this problem by evaluating such expressions first, then \
plugging them into FunctionInterpolation, like this:\
\>", "Text",
 CellChangeTimes->{{3.7843881660302258`*^9, 
  3.784388197345673*^9}},ExpressionUUID->"1a5d0e0c-7bf2-4b19-bab9-\
76dc1550090c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", "fn", ",", "t0", ",", "t1", ",", "fni", ",", "fopts"}],
      "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fn", "=", 
      RowBox[{
       SuperscriptBox["#", "2"], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", "t1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fni", "=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"fnt", "=", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"fn", "[", "t", "]"}], ",", "t"}], "]"}]}], "}"}], ",", 
        RowBox[{"FunctionInterpolation", "[", 
         RowBox[{"fnt", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "t0", ",", "t1"}], "}"}]}], "]"}]}], "]"}]}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.784387444006405*^9, 3.784387618562057*^9}, {
  3.78438937908295*^9, 3.784389381646208*^9}, {3.800014092042674*^9, 
  3.800014107491368*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"2e53393a-9391-43aa-ba02-008300e3fae9"],

Cell[TextData[{
 "Second, although you can pass options like InterpolationPoints \[Rule] ",
 StyleBox["n",
  FontSlant->"Italic"],
 " as a final literal argument, you can\[CloseCurlyQuote]t pass them as a \
Sequence of options, as here:"
}], "Text",
 CellChangeTimes->{{3.784387974753062*^9, 
  3.7843880579985743`*^9}},ExpressionUUID->"fe95ada4-0182-4b8d-ac3f-\
d3fd6719e56a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", "fn", ",", "t0", ",", "t1", ",", "fni", ",", "fopts"}],
      "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fn", "=", 
      RowBox[{
       SuperscriptBox["#", "2"], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", "t1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fopts", "=", 
      RowBox[{"Sequence", "[", 
       RowBox[{"InterpolationPoints", "\[Rule]", "20"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"fni", "=", 
      RowBox[{"FunctionInterpolation", "[", 
       RowBox[{
        RowBox[{"fn", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "t1"}], "}"}], ",", "fopts"}], "]"}]}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], "//", 
  "ShowErrorExample"}]], "Input",
 CellChangeTimes->{{3.784387444006405*^9, 3.784387571067606*^9}, {
  3.784388073911401*^9, 3.784388098728128*^9}, {3.784389385275133*^9, 
  3.784389388352086*^9}, {3.800014092051817*^9, 3.800014107500724*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"99410d12-2215-4836-b32f-77bb7f3258ad"],

Cell[TextData[{
 "But we can get around this issue by wrapping ",
 StyleBox["fopts",
  FontSlant->"Italic"],
 " in Evaluate within FunctionInterpolation."
}], "Text",
 CellChangeTimes->{{3.784388222716114*^9, 3.7843882563777046`*^9}, {
  3.784389409752464*^9, 
  3.784389422017854*^9}},ExpressionUUID->"cb0a0c5f-759f-4311-a07e-\
d5f823229bfa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", "fn", ",", "t0", ",", "t1", ",", "fni", ",", "fopts"}],
      "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"fn", "=", 
      RowBox[{
       SuperscriptBox["#", "2"], "&"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", "t1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fopts", "=", 
      RowBox[{"Sequence", "[", 
       RowBox[{"InterpolationPoints", "\[Rule]", "20"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"fni", "=", 
      RowBox[{"FunctionInterpolation", "[", 
       RowBox[{
        RowBox[{"fn", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "t1"}], "}"}], ",", 
        RowBox[{"Evaluate", "[", "fopts", "]"}]}], "]"}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.784387444006405*^9, 3.784387571067606*^9}, {
  3.784388073911401*^9, 3.784388098728128*^9}, {3.784388263319201*^9, 
  3.784388266511451*^9}, {3.784389391147538*^9, 3.784389393042897*^9}, {
  3.800014092061822*^9, 3.800014107510647*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"82b8148b-4038-4167-a159-bea1291dd850"],

Cell["\<\
So we do have workarounds for both issues,  but they require some extra code \
to generate the intermediate result and we have to remember to use the \
Evaluate wrapper. To get around this, we create the function \
ScalarFunctionInterpolation, which has the same syntax as \
FunctionInterpolate, but doesn\[CloseCurlyQuote]t force us to do the extra \
intermediate variable or Evaluate wrapping. See examples below.\
\>", "Text",
 CellChangeTimes->{{3.784388109888773*^9, 3.78438815842312*^9}, {
  3.784388297856805*^9, 3.784388329557585*^9}, {3.784389430552711*^9, 
  3.784389484149125*^9}, {3.785594019367374*^9, 
  3.785594020645709*^9}},ExpressionUUID->"2fae8c82-5d35-485b-8e3e-\
49b8dabee13b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Notes: vector-valued functions", "Subsubsection",
 CellChangeTimes->{{3.784387801419971*^9, 
  3.78438780585137*^9}},ExpressionUUID->"469faefc-32ec-439a-9950-\
237ac7e1e6e3"],

Cell["\<\
Vector-valued functions require some special handling, because \
FunctionInterpolation doesn\[CloseCurlyQuote]t work with vector-valued \
functions. So for vector-valued functions, we will use pure functions whose \
components are InterpolatingFunctions.\
\>", "Text",
 CellChangeTimes->{{3.691264877459755*^9, 
  3.691264919788293*^9}},ExpressionUUID->"9de3c1d3-eff5-4a52-8e2e-\
da57c6402347"],

Cell["\<\
Interestingly, though, Mathematica supports vector-valued \
InterpolatingFunctions. They can be returned by NDSolve and \
ListInterpolation. So note that vector-valued functions could have the head \
Function (if they were created by VectorFunctionInterpolation) or the head \
InterpolatingFunction (if they were returned from NDSolve).\
\>", "Text",
 CellChangeTimes->{{3.787502179881269*^9, 3.787502265881624*^9}, {
  3.80141401859461*^9, 3.8014140211233473`*^9}, {3.801699742910273*^9, 
  3.801699745892117*^9}},ExpressionUUID->"d680ab37-a662-4874-89d1-\
1328843a7dbb"],

Cell["\<\
We can actually use NDSolve to directly interpolate functions by setting up a \
very simple differential equation whose solution is the vector-valued \
InterpolatingFunction. However, for multidimensional functions, we need to \
fall back on the old way of doing things. So we will standardize on using a \
Function wrapper for all vector-valued functions.\
\>", "Text",
 CellChangeTimes->{{3.797193324508492*^9, 3.79719338671616*^9}, {
  3.797193477653799*^9, 3.797193490165197*^9}, {3.799511273144072*^9, 
  3.799511309137263*^9}, {3.801731997420725*^9, 
  3.801731998331628*^9}},ExpressionUUID->"0551703e-b6e5-4d3f-8ce8-\
c459d5eae448"]
}, Closed]],

Cell[CellGroupData[{

Cell["Notes: resampling", "Subsubsection",
 CellChangeTimes->{{3.801419030846404*^9, 
  3.801419033526878*^9}},ExpressionUUID->"58b21247-3371-42ee-8c7e-\
94035418ff6f"],

Cell["\<\
One of the issues that arises with interpolated functions is that since the \
default interpolation order is 3, when a sequence of operations involving \
interpolated functions involves differentiating, the results can end up with \
ripples that get amplified by the differentiation process or glitches from \
discontinuities, as in this example.\
\>", "Text",
 CellChangeTimes->{{3.80141903855841*^9, 3.801419091190546*^9}, {
  3.801419126879648*^9, 3.80141915187147*^9}, {3.801420215160034*^9, 
  3.8014202302551126`*^9}},ExpressionUUID->"c7dc52e8-e0d7-4f88-a589-\
f8ed090d08c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "f0", ",", "f1", ",", "f2", ",", "f3"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f0", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3"}], "}"}], "//", 
         "N"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f0", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"f0", "'"}], "[", "s", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"f1", "'"}], "[", "s", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f2", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f0", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f0\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f1", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f1\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f2", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f2\>\""}]}], "]"}]}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.8014191638828*^9, 3.801419231075392*^9}, {
  3.801419268075495*^9, 3.801419345377836*^9}, {3.801419386286841*^9, 
  3.801419428402166*^9}, {3.801699825129287*^9, 3.8016998556861153`*^9}, {
  3.801732050402259*^9, 3.801732054507895*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"7e53088d-3b17-4359-880d-71c2aa6fdbdf"],

Cell["\<\
If one simply reinterpolates, then one could get quite nasty artifacts.\
\>", "Text",
 CellChangeTimes->{{3.8014202484789133`*^9, 
  3.80142027407928*^9}},ExpressionUUID->"a50e128b-dac1-438e-ba46-\
79785653720a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "f0", ",", "f1", ",", "f1a", ",", "f2", ",", "f3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f0", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3"}], "}"}], "//", 
         "N"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f0", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"f0", "'"}], "[", "s", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f1a", "=", 
      RowBox[{"FunctionInterpolation", "[", 
       RowBox[{
        RowBox[{"f1", "[", "s", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f1a", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"f1a", "'"}], "[", "s", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f2", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f0", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f0\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"f1", "[", "s", "]"}], ",", 
            RowBox[{"f1a", "[", "s", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f1,f1a\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f2", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f2\>\""}]}], "]"}]}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.8014191638828*^9, 3.801419231075392*^9}, {
   3.801419268075495*^9, 3.801419345377836*^9}, {3.801419386286841*^9, 
   3.801419428402166*^9}, {3.801420287650713*^9, 3.8014203303165483`*^9}, {
   3.801420361035799*^9, 3.801420374105815*^9}, {3.801420466189701*^9, 
   3.801420474298474*^9}, {3.801699847431911*^9, 3.8016998479740047`*^9}, {
   3.801699903219259*^9, 3.801699905271264*^9}, 3.801732063286902*^9},
 CellLabel->
  "In[119]:=",ExpressionUUID->"4a2d04d7-156b-44e7-b48e-c9877fae64a9"],

Cell["\<\
A solution is to trade off accuracy for smoothness, by resampling the \
function to be differentiated.\
\>", "Text",
 CellChangeTimes->{{3.801420416769247*^9, 3.801420428935956*^9}, {
  3.801420514794057*^9, 
  3.8014205254494553`*^9}},ExpressionUUID->"da6c4b6c-a9dc-4644-9d2c-\
fb9f4896b788"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "s", ",", "f0", ",", "f1", ",", "f1a", ",", "f1b", ",", "f2", ",", 
      "f3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f0", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "3"}], "}"}], "//", 
         "N"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f0", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"f0", "'"}], "[", "s", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"f1a", "=", 
      RowBox[{"FunctionInterpolation", "[", 
       RowBox[{
        RowBox[{"f1", "[", "s", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f1b", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"f1", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1", ",", 
            RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "4"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"s", ",", 
        RowBox[{
         RowBox[{"f1b", "'"}], "[", "s", "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "f2", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f0", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f0\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"f1", "[", "s", "]"}], ",", 
            RowBox[{"f1a", "[", "s", "]"}], ",", 
            RowBox[{"f1b", "[", "s", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f1,f1a,f1b\>\""}]}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f2", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", "\"\<f2\>\""}]}], "]"}]}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.8014191638828*^9, 3.801419231075392*^9}, {
   3.801419268075495*^9, 3.801419345377836*^9}, {3.801419386286841*^9, 
   3.801419428402166*^9}, {3.801420287650713*^9, 3.8014203303165483`*^9}, {
   3.801420361035799*^9, 3.801420374105815*^9}, {3.801420466189701*^9, 
   3.801420474298474*^9}, {3.801420537052336*^9, 3.801420609019732*^9}, {
   3.8016999439778967`*^9, 3.801699944559915*^9}, 3.801732067948831*^9},
 CellLabel->
  "In[120]:=",ExpressionUUID->"2235f77d-e643-4b86-8824-8802db06f30e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "FunctionInterpolationAlt[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["domain, opts",
  FontSlant->"Italic"],
 "]\n\t(options) Resample, Options[FunctionInterpolation]"
}], "Subsubsection",
 CellChangeTimes->{{3.797193418818022*^9, 3.797193433334816*^9}, 
   3.797193525807616*^9, 3.797258652239025*^9, {3.797434835390304*^9, 
   3.797434836246609*^9}, 3.797438854537672*^9, {3.7974389027163477`*^9, 
   3.797438927075959*^9}, {3.801700221188197*^9, 3.8017002265137777`*^9}, {
   3.801700256849401*^9, 3.801700258513552*^9}, 
   3.80170171677748*^9},ExpressionUUID->"3bf7649a-f0eb-4bd1-a307-\
85235bf2e7f2"],

Cell[TextData[{
 "FunctionInterpolationAlt[",
 StyleBox["expr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["domain",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] takes a scalar- or vector-valued expression ",
 StyleBox["expr",
  FontSlant->"Italic"],
 " and creates a single pure function containing InterpolatingFunctions of \
each of its components. The syntax is otherwise the same as that of \
FunctionInterpolation. "
}], "Text",
 CellChangeTimes->{{3.691189712004655*^9, 3.691189746969771*^9}, {
   3.691190391287794*^9, 3.691190391788557*^9}, {3.691190883151121*^9, 
   3.691190910387805*^9}, {3.691200392852474*^9, 3.691200452338945*^9}, 
   3.691200640239998*^9, {3.691233292647483*^9, 3.691233293199491*^9}, 
   3.691285986758998*^9, {3.801700221201475*^9, 3.8017002380733833`*^9}, 
   3.8017017167889986`*^9},ExpressionUUID->"5ec9d09c-6e1c-4ea4-a1b5-\
15ecea6e5974"],

Cell["\<\
Options:
\tResample \[Rule] True | False, whether to do a ListInterpolation from \
sampled values or use FunctionInterpolation.
\tOptions[FunctionInterpolation] are passed through.
\tAny other options are ignored.\
\>", "Text",
 CellChangeTimes->{{3.691285989278936*^9, 3.691285991978708*^9}, {
  3.799511320456461*^9, 3.799511328337283*^9}, {3.801700261969701*^9, 
  3.801700280370051*^9}, {3.8017003144907627`*^9, 
  3.8017003312656717`*^9}},ExpressionUUID->"777c8620-ec22-42b8-9170-\
b405ff283f8c"],

Cell["\<\
For especially wiggly functions or deep derivatives, you can override options \
provided to FunctionInterpolation.\
\>", "Text",
 CellChangeTimes->{{3.69120047460035*^9, 3.691200506272249*^9}, 
   3.801701452925799*^9},ExpressionUUID->"18a5f759-cf20-4449-9988-\
4cdc05b70f4d"],

Cell["\<\
Normally FunctionInterpolation adaptively attempts to reproduce all of the \
structure in a function, but repeated differentiation alternating with \
interpolation can amplify numerical artifacts, particularly \
high-spatial-frequency ripples. A mitigation strategy is to resample the \
function with a 3rd- or 4th-order polynomial fit, which has the effect of \
smoothing out high-spatial-frequency artifacts. Pass Resample \[Rule] True to \
force resampling. Use the InterpolationPoints option to specify the \
resampling interval.\
\>", "Text",
 CellChangeTimes->{{3.8017014584376597`*^9, 3.801701487318287*^9}, {
  3.801701535935573*^9, 3.801701554262665*^9}, {3.801701586488023*^9, 
  3.801701696232279*^9}, {3.801702763715865*^9, 3.801702793210772*^9}, {
  3.8017316038485117`*^9, 
  3.8017316070564756`*^9}},ExpressionUUID->"cc27a331-dd3d-4035-9b8d-\
803397f6f8dd"],

Cell[TextData[{
 "If all you want to do is resample a function ",
 StyleBox["f",
  FontSlant->"Italic"],
 ", do\n",
 StyleBox["f = FunctionInterpolationAlt[f[t], {t, t0, t1}, Resample \[Rule] \
True];", "Input"]
}], "Text",
 CellChangeTimes->{{3.801731650976131*^9, 3.80173171894493*^9}, {
  3.801731753258459*^9, 3.801731760752879*^9}, {3.8017318070658493`*^9, 
  3.801731830641835*^9}},ExpressionUUID->"b481572c-79bc-45a7-8fee-\
cf857084fceb"],

Cell["\<\
Another case where resampling is useful is if the analytic function is \
enormously complicated. FunctionInterpolation will do repeated bisections, \
which could take a really long time; but if you don\[CloseCurlyQuote]t need \
the highest level of accuracy, then you could set Resample \[Rule] True to \
use a finite number of samples.\
\>", "Text",
 CellChangeTimes->{{3.801829031945917*^9, 3.8018290692188373`*^9}, {
  3.8018291335951233`*^9, 
  3.801829183226714*^9}},ExpressionUUID->"86e2bf00-fc50-43f0-b388-\
92b451e05fd7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Resample", "::", "usage"}], 
   "=", "\"\<Resample is an option to FunctionInterpolationAlt that specifies \
whether to sample the function evenly and use just the sampled values, rather \
than using the default adaptive algorithm.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.801701740058826*^9, 3.801701768793329*^9}, {
  3.801701809274032*^9, 3.801701825737952*^9}, {3.801702057188476*^9, 
  3.801702069780093*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"a1f767a1-4e44-4e82-a3dd-76b9c1565ec5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "FunctionInterpolationAlt", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Resample", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     RowBox[{"InterpolationPoints", "\[Rule]", "Automatic"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8017003705092783`*^9, 3.801700419195467*^9}, {
   3.801700730903854*^9, 3.801700732975429*^9}, 3.801701716792661*^9, {
   3.801730041154867*^9, 3.801730042048501*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"b70b1ab9-fbd8-4dc4-bcf5-98e6454a8640"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FunctionInterpolationAlt", "::", "baddom"}], 
   "=", "\"\<`1` is a bad domain specification for \
FunctionInterpolationAlt.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.8017005702290983`*^9, 3.801700590541909*^9}, {
  3.801701716793571*^9, 3.801701716794231*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"a39335a3-0f6d-45e8-8db3-29cb6719b3ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolationAlt", "[", 
   RowBox[{"expr_", ",", "domain_List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "rs", ",", "fopts", ",", "ip", ",", "liopts", ",", "n", ",", "fns", ",", 
      "t", ",", "t0", ",", "t1", ",", "vals", ",", "flist"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rs", "=", 
      RowBox[{
       RowBox[{"Resample", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "FunctionInterpolationAlt", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"fopts", "=", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{"{", "opts", "}"}], ",", 
         RowBox[{"Options", "[", "FunctionInterpolation", "]"}]}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "domain", "]"}], "\[NotEqual]", "3"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"FunctionInterpolationAlt", "::", "baddom"}], ",", 
          "domain"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"rs", ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Resample", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ip", "=", 
         RowBox[{
          RowBox[{"InterpolationPoints", "/.", 
           RowBox[{"{", "opts", "}"}]}], "/.", 
          RowBox[{"Options", "[", "FunctionInterpolationAlt", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ip", "===", "Automatic"}], ",", 
          RowBox[{"ip", "=", 
           RowBox[{"InterpolationPoints", "/.", 
            RowBox[{"Options", "[", "FunctionInterpolation", "]"}]}]}]}], 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"liopts", "=", 
         RowBox[{"Sequence", "@@", 
          RowBox[{"FilterRules", "[", 
           RowBox[{
            RowBox[{"{", "opts", "}"}], ",", 
            RowBox[{"Options", "[", "ListInterpolation", "]"}]}], "]"}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "t0", ",", "t1"}], "}"}], "=", "domain"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vals", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"expr", "/.", 
            RowBox[{"{", 
             RowBox[{"t", "\[Rule]", 
              RowBox[{"t0", "+", 
               RowBox[{
                FractionBox["i", "ip"], 
                RowBox[{"(", 
                 RowBox[{"t1", "-", "t0"}], ")"}]}]}]}], "}"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "ip"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", "expr", "]"}], "===", "List"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"resample", ",", " ", 
            RowBox[{"vector", "-", 
             RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"vals", "=", 
            RowBox[{"Transpose", "[", "vals", "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"flist", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"ListInterpolation", "[", 
               RowBox[{"#", ",", 
                RowBox[{"{", 
                 RowBox[{"t0", ",", "t1"}], "}"}], ",", "liopts"}], "]"}], 
              "&"}], "/@", "vals"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Functionize", "[", 
            RowBox[{"t", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", "t", "]"}], "&"}], "/@", "flist"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"resample", ",", " ", 
            RowBox[{"scalar", "-", 
             RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"ListInterpolation", "[", 
           RowBox[{"vals", ",", 
            RowBox[{"{", 
             RowBox[{"t0", ",", "t1"}], "}"}], ",", "liopts"}], "]"}]}], 
         "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Use", " ", "FunctionInterpolation"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "expr", "]"}], "===", "List"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"interpolated", ",", " ", 
           RowBox[{"vector", "-", 
            RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"n", "=", 
           RowBox[{"Length", "[", "expr", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"fns", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"FunctionInterpolation", "[", 
              RowBox[{
               RowBox[{
               "expr", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
                ",", 
               StyleBox["domain",
                FontSlant->"Italic"], ",", 
               RowBox[{"Evaluate", "[", "fopts", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Functionize", "[", 
           RowBox[{"t", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", "t", "]"}], "&"}], "/@", "fns"}]}], "]"}]}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"interpolated", ",", " ", 
           RowBox[{"scalar", "-", 
            RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"FunctionInterpolation", "[", 
          RowBox[{"expr", ",", "domain", ",", 
           RowBox[{"Evaluate", "[", "fopts", "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6911898099342623`*^9, 3.691189847747042*^9}, {
   3.691189882012087*^9, 3.691189973883208*^9}, {3.691190031892939*^9, 
   3.69119006775156*^9}, 3.691190196266165*^9, {3.691190246533598*^9, 
   3.691190250926111*^9}, {3.691190281154125*^9, 3.691190362877582*^9}, {
   3.691190402034582*^9, 3.691190409077014*^9}, {3.691200395001746*^9, 
   3.691200403757991*^9}, {3.691200455218885*^9, 3.691200461694475*^9}, {
   3.691233993615209*^9, 3.69123399640602*^9}, {3.691285307766597*^9, 
   3.691285311043592*^9}, {3.691285409344902*^9, 3.691285425313081*^9}, {
   3.691285490304876*^9, 3.691285523272808*^9}, 3.691285925884991*^9, {
   3.797193518751738*^9, 3.797193521406141*^9}, {3.79743889439594*^9, 
   3.7974388947987537`*^9}, {3.797438942698519*^9, 3.797438943528582*^9}, {
   3.797439886826494*^9, 3.797439933394088*^9}, 3.798622844044956*^9, {
   3.799511454393513*^9, 3.799511458507218*^9}, 3.801700221208784*^9, {
   3.801700342900268*^9, 3.801700346017293*^9}, {3.801700452731663*^9, 
   3.801700511933172*^9}, {3.801700598621916*^9, 3.8017007124393196`*^9}, {
   3.801700756089416*^9, 3.8017007742900057`*^9}, {3.801700845778121*^9, 
   3.8017012264383*^9}, {3.801701716796844*^9, 3.801701734429878*^9}, {
   3.8017022992112637`*^9, 3.8017023218168373`*^9}, 3.801702362172355*^9, 
   3.801702392804591*^9, {3.801730035756578*^9, 3.801730076147251*^9}, {
   3.801730446489599*^9, 3.801730448247067*^9}, {3.803913388805562*^9, 
   3.803913395962268*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"31fd5b00-1b02-4030-af11-47b7c3ab2856"],

Cell["\<\
Example. Scalar-valued function: show original, not sampled, and sampled.\
\>", "Text",
 CellChangeTimes->{{3.801702084004071*^9, 3.801702111452245*^9}, {
  3.801702434889121*^9, 3.8017024384710627`*^9}, {3.801731011545428*^9, 
  3.801731012305173*^9}},ExpressionUUID->"b47472c0-fba8-4543-818f-\
167236816193"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "x1", ",", "f", ",", "f1", ",", "f2"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"x", ",", 
        RowBox[{"1", "+", 
         RowBox[{".5", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{".5", 
          SuperscriptBox["x", "3"]}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
        RowBox[{"Resample", "\[Rule]", "True"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f1", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"f2", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.801702112880196*^9, 3.801702266679832*^9}, 
   3.801702538420617*^9, {3.801731884997757*^9, 3.801731889450294*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"6726a56f-c50a-4cff-b29d-1f0951ec5c7e"],

Cell["\<\
Example: Vector-valued function: show original, not sampled, and sampled.\
\>", "Text",
 CellChangeTimes->{{3.801702442015769*^9, 3.801702454375692*^9}, {
  3.8017310151853743`*^9, 
  3.801731015761867*^9}},ExpressionUUID->"490350c9-8429-42ec-b8de-\
aadcb4e5e915"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "x1", ",", "f", ",", "f1", ",", "f2"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{"x", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], ",", 
          RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
        RowBox[{"Resample", "\[Rule]", "True"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"f1", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"f2", "[", "x", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x0", ",", "x1"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.801702112880196*^9, 3.801702266679832*^9}, {
   3.801702465411131*^9, 3.801702490082532*^9}, 3.801731896207431*^9},
 CellLabel->
  "In[126]:=",ExpressionUUID->"c02d7750-0bc8-447c-9036-4606746970ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FunctionInterpolationAlt", "::", "badip"}], 
   "=", "\"\<`1` is not a valid specification for InterpolationPoints.\>\""}],
   ";"}]], "Input",
 CellChangeTimes->{{3.801730278243676*^9, 3.801730304611213*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"0d872d72-b59f-4f00-abf0-8961fc4327bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionInterpolationAlt", "[", 
   RowBox[{
   "expr_", ",", "domain1_List", ",", "domain2_List", ",", "opts___"}], "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "rs", ",", "fopts", ",", "ip", ",", "ip1", ",", "ip2", ",", "liopts", ",",
       "n", ",", "fns", ",", "u", ",", "u0", ",", "u1", ",", "v", ",", "v0", ",",
       "v1", ",", "vals", ",", "flist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rs", "=", 
      RowBox[{
       RowBox[{"Resample", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "FunctionInterpolationAlt", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"fopts", "=", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{"{", "opts", "}"}], ",", 
         RowBox[{"Options", "[", "FunctionInterpolation", "]"}]}], "]"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "domain1", "]"}], "\[NotEqual]", "3"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"FunctionInterpolationAlt", "::", "baddom"}], ",", 
          "domain1"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "domain2", "]"}], "\[NotEqual]", "3"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"FunctionInterpolationAlt", "::", "baddom"}], ",", 
          "domain2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{"rs", ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Resample", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ip", "=", 
         RowBox[{
          RowBox[{"InterpolationPoints", "/.", 
           RowBox[{"{", "opts", "}"}]}], "/.", 
          RowBox[{"Options", "[", "FunctionInterpolationAlt", "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ip", "\[Equal]", "Automatic"}], ",", 
          RowBox[{"ip1", "=", 
           RowBox[{"ip2", "=", 
            RowBox[{"InterpolationPoints", "/.", 
             RowBox[{"Options", "[", "FunctionInterpolation", "]"}]}]}]}], ",",
           "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Head", "[", "ip", "]"}], "===", "List"}], ",", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "ip", "]"}], "\[NotEqual]", "2"}], ",", 
            RowBox[{
             RowBox[{"Message", "[", 
              RowBox[{
               RowBox[{"FunctionInterpolationAlt", "::", "badip"}], ",", 
               "ip"}], "]"}], ";", 
             RowBox[{"Abort", "[", "]"}]}], ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"ip1", ",", "ip2"}], "}"}], "=", "ip"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "True", ",", 
          RowBox[{"ip1", "=", 
           RowBox[{"ip2", "=", "ip"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{"liopts", "=", 
         RowBox[{"Sequence", "@@", 
          RowBox[{"FilterRules", "[", 
           RowBox[{
            RowBox[{"{", "opts", "}"}], ",", 
            RowBox[{"Options", "[", "ListInterpolation", "]"}]}], "]"}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], "=", "domain1"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"v", ",", "v0", ",", "v1"}], "}"}], "=", "domain2"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vals", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"expr", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"u", "\[Rule]", 
               RowBox[{"u0", "+", 
                RowBox[{
                 FractionBox["i", "ip1"], 
                 RowBox[{"(", 
                  RowBox[{"u1", "-", "u0"}], ")"}]}]}]}], ",", 
              RowBox[{"v", "\[Rule]", 
               RowBox[{"v0", "+", 
                RowBox[{
                 FractionBox["j", "ip2"], 
                 RowBox[{"(", 
                  RowBox[{"v1", "-", "v0"}], ")"}]}]}]}]}], "}"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", "ip1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0", ",", "ip2"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", "expr", "]"}], "===", "List"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"resample", ",", " ", 
            RowBox[{"vector", "-", 
             RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"vals", "=", 
            RowBox[{"Transpose", "[", 
             RowBox[{"vals", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"flist", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"ListInterpolation", "[", 
               RowBox[{"#", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"u0", ",", "u1"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"v0", ",", "v1"}], "}"}]}], "}"}], ",", "liopts"}],
                "]"}], "&"}], "/@", "vals"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"Functionize", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"u", ",", "v"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"u", ",", "v"}], "]"}], "&"}], "/@", "flist"}]}], 
            "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"resample", ",", " ", 
            RowBox[{"scalar", "-", 
             RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"ListInterpolation", "[", 
           RowBox[{"vals", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"u0", ",", "u1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"v0", ",", "v1"}], "}"}]}], "}"}], ",", "liopts"}], 
           "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Use", " ", "FunctionInterpolation"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "expr", "]"}], "===", "List"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"interpolated", ",", " ", 
           RowBox[{"vector", "-", 
            RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"n", "=", 
           RowBox[{"Length", "[", "expr", "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"fns", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"FunctionInterpolation", "[", 
              RowBox[{
               RowBox[{
               "expr", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
                ",", 
               StyleBox["domain1",
                FontSlant->"Italic"], 
               StyleBox[",",
                FontSlant->"Italic"], 
               StyleBox["domain2",
                FontSlant->"Italic"], ",", 
               RowBox[{"Evaluate", "[", "fopts", "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Functionize", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"u", ",", "v"}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"u", ",", "v"}], "]"}], "&"}], "/@", "fns"}]}], 
           "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{"interpolated", ",", " ", 
           RowBox[{"scalar", "-", 
            RowBox[{"valued", " ", "function"}]}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"FunctionInterpolation", "[", 
          RowBox[{"expr", ",", "domain1", ",", "domain2", ",", "opts"}], 
          "]"}]}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6911898099342623`*^9, 3.691189847747042*^9}, {
   3.691189882012087*^9, 3.691189973883208*^9}, {3.691190031892939*^9, 
   3.69119006775156*^9}, 3.691190196266165*^9, {3.691190246533598*^9, 
   3.691190250926111*^9}, {3.691190281154125*^9, 3.691190362877582*^9}, {
   3.691190402034582*^9, 3.691190409077014*^9}, {3.691200395001746*^9, 
   3.691200403757991*^9}, {3.691200455218885*^9, 3.691200461694475*^9}, {
   3.691233993615209*^9, 3.69123399640602*^9}, {3.691285307766597*^9, 
   3.691285311043592*^9}, {3.691285409344902*^9, 3.691285425313081*^9}, {
   3.691285490304876*^9, 3.691285523272808*^9}, 3.691285925884991*^9, {
   3.797193518751738*^9, 3.797193521406141*^9}, {3.79743889439594*^9, 
   3.7974388947987537`*^9}, {3.797438942698519*^9, 3.797438943528582*^9}, {
   3.797439886826494*^9, 3.797439933394088*^9}, 3.798622844044956*^9, {
   3.799511454393513*^9, 3.799511458507218*^9}, 3.801700221208784*^9, {
   3.801700342900268*^9, 3.801700346017293*^9}, {3.801700452731663*^9, 
   3.801700511933172*^9}, {3.801700598621916*^9, 3.8017007124393196`*^9}, {
   3.801700756089416*^9, 3.8017007742900057`*^9}, {3.801700845778121*^9, 
   3.8017012264383*^9}, {3.801701716796844*^9, 3.801701734429878*^9}, {
   3.8017022992112637`*^9, 3.8017023218168373`*^9}, 3.801702362172355*^9, 
   3.801702392804591*^9, {3.801729848594459*^9, 3.801729965554388*^9}, {
   3.801730116067512*^9, 3.80173027011128*^9}, {3.801730312775612*^9, 
   3.801730314637498*^9}, {3.801730359062316*^9, 3.801730401622641*^9}, {
   3.801730755835956*^9, 3.801730826554918*^9}, {3.801731124626657*^9, 
   3.8017311932142067`*^9}, {3.801731385634542*^9, 3.801731389641418*^9}, {
   3.801731462450929*^9, 3.801731478530799*^9}, {3.801731515644596*^9, 
   3.80173155675745*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"0faafa95-8592-401b-9b4f-7a9faac1f541"],

Cell["\<\
Example. Scalar-valued function: show original, not sampled, and sampled.\
\>", "Text",
 CellChangeTimes->{{3.801702084004071*^9, 3.801702111452245*^9}, {
  3.801702434889121*^9, 3.8017024384710627`*^9}, {3.801731005396798*^9, 
  3.801731005849382*^9}},ExpressionUUID->"cdfec703-5484-4215-a0c8-\
84e2ef66ddd3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "u", ",", "u0", ",", "u1", ",", "v", ",", "v0", ",", "v1", ",", "f", ",",
       "f1", ",", "f2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u0", ",", "u1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v0", ",", "v1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"u", ",", "v"}], "}"}], ",", 
        RowBox[{
         RowBox[{"u", 
          RowBox[{"(", 
           RowBox[{"1", "-", "u"}], ")"}]}], "-", 
         RowBox[{".5", "v", 
          RowBox[{"(", 
           RowBox[{"1", "-", "v"}], ")"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"u", ",", "v"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"u", ",", "v"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "v0", ",", "v1"}], "}"}], ",", 
        RowBox[{"Resample", "\[Rule]", "True"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"u", ",", "v"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"f1", "[", 
           RowBox[{"u", ",", "v"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"f2", "[", 
           RowBox[{"u", ",", "v"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.801702112880196*^9, 3.801702266679832*^9}, 
   3.801702538420617*^9, {3.8017308637029676`*^9, 3.801730997021185*^9}, {
   3.801731059542409*^9, 3.801731061611314*^9}, 3.801731205807502*^9, 
   3.801731901007151*^9},
 CellLabel->
  "In[129]:=",ExpressionUUID->"5ed5277d-a36e-4c6f-8f39-ae97e976d389"],

Cell["\<\
Example. Vector-valued function: show original, not sampled, and sampled.\
\>", "Text",
 CellChangeTimes->{{3.801702084004071*^9, 3.801702111452245*^9}, {
  3.801702434889121*^9, 3.8017024384710627`*^9}, {3.801731005396798*^9, 
  3.801731005849382*^9}, {3.801731242278857*^9, 
  3.801731242939897*^9}},ExpressionUUID->"abc3cf6b-7473-4219-9104-\
9ff2cf08e0be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "u", ",", "u0", ",", "u1", ",", "v", ",", "v0", ",", "v1", ",", "f", ",",
       "f1", ",", "f2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u0", ",", "u1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v0", ",", "v1"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"Functionize", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"u", ",", "v"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"u", 
           RowBox[{"(", 
            RowBox[{"1", "-", "u"}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"-", "v"}], 
           RowBox[{"(", 
            RowBox[{"1", "-", "v"}], ")"}]}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f1", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"u", ",", "v"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"f2", "=", 
      RowBox[{"FunctionInterpolationAlt", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"u", ",", "v"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v", ",", "v0", ",", "v1"}], "}"}], ",", 
        RowBox[{"Resample", "\[Rule]", "True"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"u", ",", "v"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"f1", "[", 
           RowBox[{"u", ",", "v"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"f2", "[", 
           RowBox[{"u", ",", "v"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "u0", ",", "u1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"v", ",", "v0", ",", "v1"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.801702112880196*^9, 3.801702266679832*^9}, 
   3.801702538420617*^9, {3.8017308637029676`*^9, 3.801730997021185*^9}, {
   3.801731059542409*^9, 3.801731061611314*^9}, 3.801731205807502*^9, {
   3.801731257534453*^9, 3.801731289085572*^9}, 3.801731904537702*^9},
 CellLabel->
  "In[130]:=",ExpressionUUID->"ea056ebe-71c0-4afc-b560-6d25854314fb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "InterpolatingFunctionCount[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.799507746959708*^9, 
  3.7995077586148777`*^9}},ExpressionUUID->"e32b94f3-53cc-4cde-a57b-\
7abc41cc8523"],

Cell[TextData[{
 "InterpolatingFunctionCount[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] returns the number of InterpolatingFunction objects within the \
expression. It\[CloseCurlyQuote]s a useful utility for determining if it\
\[CloseCurlyQuote]s time to reinterpolate an expression."
}], "Text",
 CellChangeTimes->{{3.7995077681131372`*^9, 
  3.799507807375112*^9}},ExpressionUUID->"886f5840-10b1-4757-872c-\
d1a5bb9bd1ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunctionCount", "[", "expr_", "]"}], ":=", 
  RowBox[{"Count", "[", 
   RowBox[{"expr", ",", 
    RowBox[{"_InterpolatingFunction", "|", 
     RowBox[{"_InterpolatingFunction", "[", "___", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.799507816075159*^9, 3.799507828122143*^9}, {
   3.799507876490806*^9, 3.799507879880509*^9}, 3.7995079362606153`*^9, {
   3.799508011990998*^9, 3.7995080221145487`*^9}, {3.799508058457402*^9, 
   3.7995080886292*^9}, {3.799508725952615*^9, 3.799508727702206*^9}, 
   3.799508857782712*^9, {3.799508915300737*^9, 3.799508916890112*^9}, {
   3.799508971828866*^9, 3.799508987314657*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"88f72cf5-60d1-4c8f-9f6f-5ad7604f46a7"],

Cell[TextData[{
 "Example. ",
 StyleBox["f",
  FontSlant->"Italic"],
 " is a simple InterpolatingFunction. ",
 StyleBox["g",
  FontSlant->"Italic"],
 " is more complex pure function with multiple copies of ",
 StyleBox["f",
  FontSlant->"Italic"],
 " embedded inside."
}], "Text",
 CellChangeTimes->{{3.799510392700047*^9, 3.799510393706793*^9}, {
  3.799510627532291*^9, 
  3.799510649356965*^9}},ExpressionUUID->"7f8ce771-cf9c-4a0f-84d4-\
249a3cf238bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "f", ",", "g"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"FunctionInterpolation", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SuperscriptBox["s", "2"]}], ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", 
      RowBox[{"InterpolatingFunctionCount", "[", "f", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"g", "=", 
      RowBox[{"Function", "@@", 
       RowBox[{"{", 
        RowBox[{"s", ",", 
         RowBox[{
          RowBox[{
           FractionBox["#", 
            SqrtBox[
             RowBox[{"#", ".", "#"}]]], "&"}], "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"f", "[", "s", "]"}]}], "}"}], "]"}]}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "g", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", 
      RowBox[{"InterpolatingFunctionCount", "[", "g", "]"}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.799510399268159*^9, 3.799510611727409*^9}, {
  3.799510662465045*^9, 3.799510664213196*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"30ac7424-2ed1-4e02-8a95-64cc47c29bfb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ContainsInterpolatingFunctionQ[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{
  3.799843346413559*^9},ExpressionUUID->"945b77b6-4b39-4388-abf2-\
7f4384b04ed2"],

Cell[TextData[{
 "ContainsInterpolatingFunctionQ[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "] returns True if the given expression contains any InterpolatingFunction \
subexpressions."
}], "Text",
 CellChangeTimes->{{3.799843349604754*^9, 
  3.7998433766997623`*^9}},ExpressionUUID->"e6a8f88b-e8a9-41ee-b497-\
e7c0818dc338"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContainsInterpolatingFunctionQ", "[", "expr_", "]"}], ":=", 
  RowBox[{
   RowBox[{"InterpolatingFunctionCount", "[", "expr", "]"}], ">", 
   "0"}]}]], "Input",
 CellChangeTimes->{{3.7998432960300713`*^9, 3.799843337523647*^9}, {
  3.799843386044282*^9, 3.799843396307981*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"1a2b4a7e-8c4a-4e83-9cf7-d096375f6bbb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ExtrapolatingInterpolatingFunction[",
 StyleBox["f",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.805918541798319*^9, 3.8059185435240183`*^9}, {
   3.806001416352918*^9, 3.80600141769695*^9}, 
   3.806354896024074*^9},ExpressionUUID->"9e2a9d5a-3f94-4995-9e65-\
1b5e0102ee9c"],

Cell[TextData[{
 "ExtrapolatingInterpolatingFunction[",
 StyleBox["f",
  FontSlant->"Italic"],
 "] takes an InterpolatingFunction defined for a finite domain and returns a \
pure function that linearly extrapolates it beyond the ends of the domain."
}], "Text",
 CellChangeTimes->{{3.805917884663209*^9, 3.805917936950723*^9}, {
   3.805918526395647*^9, 3.805918534058839*^9}, {3.8059189332945833`*^9, 
   3.805918934054662*^9}, 3.806001422979109*^9, {3.806354899548605*^9, 
   3.806354926985736*^9}},ExpressionUUID->"986d0522-c7ea-42f8-898d-\
c3f0fa107e7d"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["f",
  FontSlant->"Italic"],
 " \[LongDash] an InterpolatingFunction of a single variable."
}], "Text",
 CellChangeTimes->{{3.805919017194148*^9, 3.80591903594365*^9}, 
   3.806354934962277*^9},ExpressionUUID->"99181627-ba87-4b02-b8d3-\
96e19dc651e8"],

Cell["\<\
Returns: a pure function that extends the InterpolatingFunction beyond its \
endpoints using linear extrapolation.\
\>", "Text",
 CellChangeTimes->{{3.805919038399022*^9, 3.805919048023765*^9}, {
  3.8060625598552213`*^9, 3.806062570375746*^9}, {3.806354947939207*^9, 
  3.806354973971167*^9}},ExpressionUUID->"1231b4d3-da4a-4adf-9eed-\
c00f66c1a7cf"],

Cell["\<\
Of course, InterpolatingFunctions can be evaluated outside of their domain, \
but they issue a warning and include contributions from higher-order \
derivatives in the extrapolation. Sometimes you just want linear \
extrapolation (and no warning); this is the function for those cases.\
\>", "Text",
 CellChangeTimes->{{3.8063550424671593`*^9, 3.806355047051635*^9}, {
  3.8063551437573547`*^9, 
  3.806355249005513*^9}},ExpressionUUID->"8d76d6bc-c041-43ca-8cb3-\
63bd041da4c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "ExtrapolatingInterpolatingFunction", "[", "f_InterpolatingFunction", "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "x0", ",", "x1", ",", "f0", ",", "f1", ",", "fp0", ",", "fp1", ",", "fx",
       ",", "x", ",", "xs", ",", "fn", ",", "wh", ",", "pa", ",", "fr"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"fp0", "=", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "x0", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fp1", "=", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "x1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fn", "[", 
       RowBox[{"wh", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "<", "x0"}], " ", "&&", 
            RowBox[{"x0", "<", "x1"}]}], ")"}], "||", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", ">", "x0"}], "&&", 
            RowBox[{"x0", ">", "x1"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{"f", "[", "x0", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "-", "x0"}], ")"}], "fp0"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", ">", "x1"}], "&&", 
            RowBox[{"x0", "<", "x1"}]}], ")"}], "||", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "<", "x1"}], "&&", 
            RowBox[{"x0", ">", "x1"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{"f", "[", "x1", "]"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "-", "x1"}], ")"}], "fp1"}]}], ",", 
         "\[IndentingNewLine]", "True", ",", 
         RowBox[{"f", "[", "#", "]"}]}], "]"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fn", "\[Rule]", "Function"}], ",", 
        RowBox[{"wh", "\[Rule]", "Which"}]}], "}"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.805917538941918*^9, 3.805917646085727*^9}, {
   3.805917728781308*^9, 3.805917741134191*^9}, {3.806001618014553*^9, 
   3.806001766101075*^9}, 3.8060018139194317`*^9, 3.806001895088346*^9, {
   3.806055883761163*^9, 3.806055923056699*^9}, {3.806059919969655*^9, 
   3.80606005324753*^9}, {3.806060118426069*^9, 3.806060152144459*^9}, 
   3.80606025504961*^9, {3.806060305186137*^9, 3.80606031687463*^9}, {
   3.806060349434545*^9, 3.806060381009893*^9}, 3.806060427659389*^9, {
   3.806060527329881*^9, 3.80606063529865*^9}, {3.806060760574336*^9, 
   3.806060786835718*^9}, 3.806062239525057*^9, {3.806062270398191*^9, 
   3.806062461048341*^9}, 3.8060625078200607`*^9, {3.806062783204192*^9, 
   3.806062802444442*^9}, {3.806062854141647*^9, 3.806062942468105*^9}, {
   3.80606367308857*^9, 3.806063729194122*^9}, {3.806063778994138*^9, 
   3.806063847258869*^9}, {3.806063878973598*^9, 3.8060638871630774`*^9}, {
   3.806063975412424*^9, 3.806063991898687*^9}, 3.806064024117571*^9, {
   3.806064075710954*^9, 3.806064082547274*^9}, {3.80635526612116*^9, 
   3.806355467017848*^9}, 3.806355536171964*^9},
 CellLabel->
  "In[134]:=",ExpressionUUID->"db8a1d3d-ea42-4492-bfea-c9b2c565a0cd"],

Cell["\<\
Example. Superimpose the original function and our extrapolation.\
\>", "Text",
 CellChangeTimes->{{3.805918003382187*^9, 3.80591804111045*^9}, {
  3.806001934485141*^9, 3.806001948188779*^9}, {3.806002079517931*^9, 
  3.806002084813856*^9}, {3.8063554808556333`*^9, 
  3.80635549655926*^9}},ExpressionUUID->"4325a70c-bf03-41af-af50-\
c74605c6c514"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "g", ",", "x0", ",", "x1"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], "/", 
        "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"g", "=", 
      RowBox[{"ExtrapolatingInterpolatingFunction", "[", "f", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Cyan"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"x0", "-", "1"}], ",", 
           RowBox[{"x1", "+", "1"}]}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Dotted", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.8063550729499073`*^9, 3.806355113108823*^9}, {
  3.806355508266746*^9, 3.80635557660073*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"61ac6290-fe2c-476a-be4c-eac2accfdff7"],

Cell["Example: a decreasing function.", "Text",
 CellChangeTimes->{{3.806062726248334*^9, 
  3.806062733360546*^9}},ExpressionUUID->"0a03f2f1-898f-4cc9-b93f-\
92c790fa0869"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "g", ",", "x0", ",", "x1"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}]}], "/",
         "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"g", "=", 
      RowBox[{"ExtrapolatingInterpolatingFunction", "[", "f", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Cyan"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"x0", "-", "1"}], ",", 
           RowBox[{"x1", "+", "1"}]}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Dotted", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.8063550729499073`*^9, 3.806355113108823*^9}, {
  3.806355508266746*^9, 3.806355583552516*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"e8ea8707-cb6f-4e00-b2db-6b139e2de23e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "InterpolatingFunctionInverse[",
 StyleBox["f",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.805918541798319*^9, 
  3.8059185435240183`*^9}},ExpressionUUID->"5d4dc89d-5403-42a5-b313-\
b86e079b9681"],

Cell[TextData[{
 "InterpolatingFunctionInverse[",
 StyleBox["f",
  FontSlant->"Italic"],
 "] takes an InterpolatingFunction (that should ideally be monotonic) and \
returns a function that gives the inverse function value, which is computed \
using FindRoot and taking a linear interpolation as the first guess."
}], "Text",
 CellChangeTimes->{{3.805917884663209*^9, 3.805917936950723*^9}, {
  3.805918526395647*^9, 3.805918534058839*^9}, {3.8059189332945833`*^9, 
  3.805918934054662*^9}},ExpressionUUID->"ae48d06a-ed57-49c5-b8bb-\
fde127e3ba1f"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["f",
  FontSlant->"Italic"],
 " \[LongDash] an InterpolatingFunction of a single variable, whose inverse \
function is sought."
}], "Text",
 CellChangeTimes->{{3.805919017194148*^9, 
  3.80591903594365*^9}},ExpressionUUID->"59747304-ba0c-4c1d-9f18-\
9ae26be1f234"],

Cell["\<\
Returns: a pure function that inverts the InterpolatingFunction.\
\>", "Text",
 CellChangeTimes->{{3.805919038399022*^9, 
  3.805919048023765*^9}},ExpressionUUID->"53cd6373-840b-4898-9b59-\
8cd7af152d52"],

Cell["\<\
Note that Mathematica has a built-in function, InverseFunction, that does \
this for symbolic expressions, but it doesn\[CloseCurlyQuote]t give the \
desired behavior when applied to an InterpolatingFunction.\
\>", "Text",
 CellChangeTimes->{{3.8059190497516*^9, 
  3.805919099511155*^9}},ExpressionUUID->"361f3cff-1074-4d62-81b6-\
2578d721ed41"],

Cell["\<\
Note that in order to get some subexpressions to evaluate but leave others \
unevaluated, we use symbolic forms for some functions that have HoldAll \
attributes\
\>", "Text",
 CellChangeTimes->{{3.8060614627354803`*^9, 3.806061541800303*^9}, {
  3.806061586448535*^9, 
  3.806061593135591*^9}},ExpressionUUID->"ad241531-d490-4ee2-948f-\
f5f10837f19b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "InterpolatingFunctionInverse", "[", "f_InterpolatingFunction", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "x0", ",", "x1", ",", "f0", ",", "f1", ",", "xs", ",", "fn", ",", "pa", ",",
       "fr"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f0", ",", "f1"}], "}"}], "=", 
      RowBox[{"f", "/@", 
       RowBox[{"{", 
        RowBox[{"x0", ",", "x1"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fn", "[", 
       RowBox[{"pa", "[", 
        RowBox[{
         RowBox[{"fr", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "xs", "]"}], "\[Equal]", "#"}], ",", 
           RowBox[{"{", 
            RowBox[{"xs", ",", 
             RowBox[{"x0", "+", 
              RowBox[{
               FractionBox[
                RowBox[{"#", "-", "f0"}], 
                RowBox[{"f1", "-", "f0"}]], 
               RowBox[{"(", 
                RowBox[{"x1", "-", "x0"}], ")"}]}]}]}], "}"}]}], "]"}], ",", 
         "1", ",", "2"}], "]"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fn", "\[Rule]", "Function"}], ",", 
        RowBox[{"pa", "\[Rule]", "Part"}], ",", 
        RowBox[{"fr", "\[Rule]", "FindRoot"}]}], "}"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.805917538941918*^9, 3.805917646085727*^9}, {
   3.805917728781308*^9, 3.805917741134191*^9}, {3.806060870919205*^9, 
   3.806060872662434*^9}, {3.806060913405471*^9, 3.806060953653767*^9}, {
   3.8060610711578207`*^9, 3.806061141311594*^9}, 3.8060611971216393`*^9, {
   3.806061229023838*^9, 3.806061246167026*^9}, {3.80606137440219*^9, 
   3.80606140559997*^9}, {3.8060614503303227`*^9, 3.8060614507596207`*^9}, {
   3.806061568672763*^9, 3.8060615731212187`*^9}, {3.806061691925324*^9, 
   3.806061720266116*^9}, {3.806061779205998*^9, 3.8060618416148033`*^9}, {
   3.8060618761592007`*^9, 3.806061892955741*^9}, {3.806061927261191*^9, 
   3.806061936717507*^9}, {3.806061985822288*^9, 3.806061986187992*^9}, {
   3.806062528630452*^9, 3.806062537048907*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"c576f175-7ca0-49a3-834e-709f3629e6df"],

Cell["\<\
Example. Plot both, superimposing the original function and the x-y swap of \
the inverse function; the two curves should perfectly overlap.\
\>", "Text",
 CellChangeTimes->{{3.805918003382187*^9, 3.80591804111045*^9}, {
  3.806062751280685*^9, 
  3.806062754648016*^9}},ExpressionUUID->"2d731dd1-8abc-4491-97ce-\
52b101a4389a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "f", ",", "g", ",", "x0", ",", "x1", ",", "f0", ",", "f1", ",", "fs"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"g", "=", 
      RowBox[{"InterpolatingFunctionInverse", "[", "f", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "g", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "[", "4", "]"}], ",", 
        RowBox[{"f", "[", 
         RowBox[{"g", "[", "4", "]"}], "]"}], ",", 
        RowBox[{"g", "[", 
         RowBox[{"f", "[", "4", "]"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Cyan"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"g", "[", "y", "]"}], ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"f", "[", "x0", "]"}], ",", 
           RowBox[{"f", "[", "x1", "]"}]}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "Dotted"}], "}"}]}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.805916386477362*^9, 3.805916684706113*^9}, 
   3.8059167166502657`*^9, {3.805917163187932*^9, 3.8059171911306973`*^9}, {
   3.8059172542231817`*^9, 3.805917505909136*^9}, {3.805917837655449*^9, 
   3.805917858806856*^9}, {3.805917965833248*^9, 3.805917997696412*^9}, {
   3.805918300127009*^9, 3.805918325947701*^9}, {3.805918978552947*^9, 
   3.8059189806709747`*^9}, 3.8060608493806667`*^9, {3.806060883038033*^9, 
   3.80606089130083*^9}, {3.806061052665503*^9, 3.806061059014239*^9}, {
   3.806061437680807*^9, 3.806061439802557*^9}, {3.806061669987421*^9, 
   3.806061673113796*^9}, 3.806061769740139*^9, {3.806062591891367*^9, 
   3.806062627088729*^9}, {3.80606276463548*^9, 3.806062771107155*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"3474c733-8755-4d7d-8505-9beb6febfff9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ExtrapolatingInterpolatingFunctionInverse[",
 StyleBox["f",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.805918541798319*^9, 3.8059185435240183`*^9}, {
  3.806001416352918*^9, 
  3.80600141769695*^9}},ExpressionUUID->"b9696a6f-aa1e-48cb-b486-\
2cd588af90bd"],

Cell[TextData[{
 "ExtrapolatingInterpolatingFunctionInverse[",
 StyleBox["f",
  FontSlant->"Italic"],
 "] takes an InterpolatingFunction (that should ideally be monotonic) and \
returns a function that gives the inverse function value, which is computed \
using FindRoot and taking a linear interpolation as the first guess."
}], "Text",
 CellChangeTimes->{{3.805917884663209*^9, 3.805917936950723*^9}, {
   3.805918526395647*^9, 3.805918534058839*^9}, {3.8059189332945833`*^9, 
   3.805918934054662*^9}, 
   3.806001422979109*^9},ExpressionUUID->"c799966b-f191-4d60-af27-\
92658ad28ac6"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["f",
  FontSlant->"Italic"],
 " \[LongDash] an InterpolatingFunction of a single variable, whose inverse \
function is sought."
}], "Text",
 CellChangeTimes->{{3.805919017194148*^9, 
  3.80591903594365*^9}},ExpressionUUID->"09bf1250-8ee0-46dc-89ef-\
b1b297750cd0"],

Cell["\<\
Returns: a pure function that inverts the InterpolatingFunction and then \
linearly extrapolates beyond its endpoints.\
\>", "Text",
 CellChangeTimes->{{3.805919038399022*^9, 3.805919048023765*^9}, {
  3.8060625598552213`*^9, 
  3.806062570375746*^9}},ExpressionUUID->"434a2ba4-0096-4312-a1bd-\
027d481f669f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "ExtrapolatingInterpolatingFunctionInverse", "[", "f_InterpolatingFunction",
    "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "x0", ",", "x1", ",", "f0", ",", "f1", ",", "fp0", ",", "fp1", ",", "fx",
       ",", "x", ",", "xs", ",", "fn", ",", "wh", ",", "pa", ",", "fr"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f0", ",", "f1"}], "}"}], "=", 
      RowBox[{"f", "/@", 
       RowBox[{"{", 
        RowBox[{"x0", ",", "x1"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fp0", "=", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "x0", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fp1", "=", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "x1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fn", "[", 
       RowBox[{"wh", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f0", "<", "f1"}], "&&", 
            RowBox[{"#", "<", "f0"}]}], ")"}], "||", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f0", ">", "f1"}], "&&", 
            RowBox[{"#", ">", "f0"}]}], ")"}]}], ",", 
         RowBox[{"x0", "-", 
          FractionBox[
           RowBox[{"f0", "-", "#"}], "fp0"]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f0", "<", "f1"}], "&&", 
            RowBox[{"#", ">", "f1"}]}], ")"}], "||", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"f0", ">", "f1"}], "&&", 
            RowBox[{"#", "<", "f1"}]}], ")"}]}], ",", 
         RowBox[{"x1", "+", 
          FractionBox[
           RowBox[{"#", "-", "f1"}], "fp1"]}], ",", "\[IndentingNewLine]", 
         "True", ",", 
         RowBox[{"pa", "[", 
          RowBox[{
           RowBox[{"fr", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"f", "[", "xs", "]"}], "\[Equal]", "#"}], ",", 
             RowBox[{"{", 
              RowBox[{"xs", ",", 
               RowBox[{"x0", "+", 
                RowBox[{
                 FractionBox[
                  RowBox[{"#", "-", "f0"}], 
                  RowBox[{"f1", "-", "f0"}]], 
                 RowBox[{"(", 
                  RowBox[{"x1", "-", "x0"}], ")"}]}]}]}], "}"}]}], "]"}], ",",
            "1", ",", "2"}], "]"}]}], "]"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"fn", "\[Rule]", "Function"}], ",", 
        RowBox[{"wh", "\[Rule]", "Which"}], ",", 
        RowBox[{"pa", "\[Rule]", "Part"}], ",", 
        RowBox[{"fr", "\[Rule]", "FindRoot"}]}], "}"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.805917538941918*^9, 3.805917646085727*^9}, {
   3.805917728781308*^9, 3.805917741134191*^9}, {3.806001618014553*^9, 
   3.806001766101075*^9}, 3.8060018139194317`*^9, 3.806001895088346*^9, {
   3.806055883761163*^9, 3.806055923056699*^9}, {3.806059919969655*^9, 
   3.80606005324753*^9}, {3.806060118426069*^9, 3.806060152144459*^9}, 
   3.80606025504961*^9, {3.806060305186137*^9, 3.80606031687463*^9}, {
   3.806060349434545*^9, 3.806060381009893*^9}, 3.806060427659389*^9, {
   3.806060527329881*^9, 3.80606063529865*^9}, {3.806060760574336*^9, 
   3.806060786835718*^9}, 3.806062239525057*^9, {3.806062270398191*^9, 
   3.806062461048341*^9}, 3.8060625078200607`*^9, {3.806062783204192*^9, 
   3.806062802444442*^9}, {3.806062854141647*^9, 3.806062942468105*^9}, {
   3.80606367308857*^9, 3.806063729194122*^9}, {3.806063778994138*^9, 
   3.806063847258869*^9}, {3.806063878973598*^9, 3.8060638871630774`*^9}, {
   3.806063975412424*^9, 3.806063991898687*^9}, 3.806064024117571*^9, {
   3.806064075710954*^9, 3.806064082547274*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"3227c5cc-a622-4405-930d-cbe8254c124a"],

Cell["\<\
Example. Superimpose the original function and the x-y swap of the inverse \
function; the two curves should perfectly overlap, except \
we\[CloseCurlyQuote]ll plot our extrapolating function over a wider range to \
show the linear extrapolation.\
\>", "Text",
 CellChangeTimes->{{3.805918003382187*^9, 3.80591804111045*^9}, {
  3.806001934485141*^9, 3.806001948188779*^9}, {3.806002079517931*^9, 
  3.806002084813856*^9}},ExpressionUUID->"9731ba38-c919-4428-83d9-\
4d5168f46a6b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "f", ",", "g", ",", "x0", ",", "x1", ",", "f0", ",", "f1", ",", "fs"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"g", "=", 
      RowBox[{"ExtrapolatingInterpolatingFunctionInverse", "[", "f", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "g", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "[", "4", "]"}], ",", 
        RowBox[{"f", "[", 
         RowBox[{"g", "[", "4", "]"}], "]"}], ",", 
        RowBox[{"g", "[", 
         RowBox[{"f", "[", "4", "]"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "[", "0", "]"}], ",", 
        RowBox[{"g", "[", "1", "]"}], ",", 
        RowBox[{"g", "[", "8", "]"}], ",", 
        RowBox[{"g", "[", "9", "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Cyan"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"g", "[", "y", "]"}], ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{
            RowBox[{"f", "[", "x0", "]"}], "-", "1"}], ",", 
           RowBox[{
            RowBox[{"f", "[", "x1", "]"}], "+", "1"}]}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Dotted", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.805916386477362*^9, 3.805916684706113*^9}, 
   3.8059167166502657`*^9, {3.805917163187932*^9, 3.8059171911306973`*^9}, {
   3.8059172542231817`*^9, 3.805917505909136*^9}, {3.805917837655449*^9, 
   3.805917858806856*^9}, {3.805917965833248*^9, 3.805917997696412*^9}, {
   3.805918300127009*^9, 3.805918325947701*^9}, {3.805918978552947*^9, 
   3.8059189806709747`*^9}, 3.806001619456945*^9, 3.806001711901842*^9, {
   3.806001775205639*^9, 3.806001785395685*^9}, {3.806001846055941*^9, 
   3.806001913428713*^9}, {3.806001952912599*^9, 3.806002052998872*^9}, {
   3.806002133656493*^9, 3.806002135518094*^9}, {3.806055810843466*^9, 
   3.806055819007749*^9}, {3.806060389258585*^9, 3.806060391809854*^9}, 
   3.806062513901266*^9, {3.806062635324252*^9, 3.806062635769117*^9}, {
   3.806064112830779*^9, 3.806064130083952*^9}, 3.8060642797787743`*^9},
 CellLabel->
  "In[140]:=",ExpressionUUID->"50fce09f-1393-4498-bce9-f533fa457fdb"],

Cell["Example: a decreasing function.", "Text",
 CellChangeTimes->{{3.806062726248334*^9, 
  3.806062733360546*^9}},ExpressionUUID->"8850ec0d-9db5-4d65-b4dc-\
6e3e0ef1f2b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "f", ",", "g", ",", "x0", ",", "x1", ",", "f0", ",", "f1", ",", "fs"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "=", 
      RowBox[{"ListInterpolation", "[", 
       RowBox[{"{", 
        RowBox[{"8", ",", "5", ",", "3", ",", "2", ",", "1"}], "}"}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"g", "=", 
      RowBox[{"ExtrapolatingInterpolatingFunctionInverse", "[", "f", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "g", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "[", "4", "]"}], ",", 
        RowBox[{"f", "[", 
         RowBox[{"g", "[", "4", "]"}], "]"}], ",", 
        RowBox[{"g", "[", 
         RowBox[{"f", "[", "4", "]"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "[", "0", "]"}], ",", 
        RowBox[{"g", "[", "1", "]"}], ",", 
        RowBox[{"g", "[", "8", "]"}], ",", 
        RowBox[{"g", "[", "9", "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"f", "\[LeftDoubleBracket]", 
       RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Cyan"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"g", "[", "y", "]"}], ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{
            RowBox[{"f", "[", "x0", "]"}], "+", "1"}], ",", 
           RowBox[{
            RowBox[{"f", "[", "x1", "]"}], "-", "1"}]}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Dotted", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.805916386477362*^9, 3.805916684706113*^9}, 
   3.8059167166502657`*^9, {3.805917163187932*^9, 3.8059171911306973`*^9}, {
   3.8059172542231817`*^9, 3.805917505909136*^9}, {3.805917837655449*^9, 
   3.805917858806856*^9}, {3.805917965833248*^9, 3.805917997696412*^9}, {
   3.805918300127009*^9, 3.805918325947701*^9}, {3.805918978552947*^9, 
   3.8059189806709747`*^9}, 3.806001619456945*^9, 3.806001711901842*^9, {
   3.806001775205639*^9, 3.806001785395685*^9}, {3.806001846055941*^9, 
   3.806001913428713*^9}, {3.806001952912599*^9, 3.806002052998872*^9}, {
   3.806002133656493*^9, 3.806002135518094*^9}, {3.806055810843466*^9, 
   3.806055819007749*^9}, {3.806060389258585*^9, 3.806060391809854*^9}, 
   3.806062513901266*^9, {3.806062635324252*^9, 3.806062635769117*^9}, {
   3.8060627159557867`*^9, 3.806062717961629*^9}, {3.80606415937678*^9, 
   3.806064187292955*^9}, {3.806064271616069*^9, 3.806064273420328*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"e0090240-236e-4db1-b05a-50a81a39d18c"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function plotting", "Subsection",
 CellChangeTimes->{{3.801398609429817*^9, 
  3.8013986118821497`*^9}},ExpressionUUID->"99b8b5cc-a4bd-40b5-a848-\
d41bc766cb3b"],

Cell[CellGroupData[{

Cell[TextData[{
 "FunctionPlot[",
 StyleBox["f",
  FontSlant->"Italic"],
 ", {",
 StyleBox["u0",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u1",
  FontSlant->"Italic"],
 "}, opts]\n\t(options) Options[Plot]"
}], "Subsubsection",
 CellChangeTimes->{{3.801398008490963*^9, 3.801398038759878*^9}, {
  3.8013980742733107`*^9, 
  3.801398083938363*^9}},ExpressionUUID->"bb56161c-b8e3-4570-acc7-\
a677d4f0d05b"],

Cell[TextData[{
 "FunctionPlot[",
 StyleBox["f",
  FontSlant->"Italic"],
 ", {",
 StyleBox["u0",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u1",
  FontSlant->"Italic"],
 "}, opts] plots pure functions, which can be either scalar or \
vector-valued."
}], "Text",
 CellChangeTimes->{{3.801398026225542*^9, 3.8013980672648773`*^9}, 
   3.8013986226143*^9},ExpressionUUID->"2740dada-3843-448e-8e4d-a74f07793673"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["f",
  FontSlant->"Italic"],
 " \[LongDash] a pure function of one variable; could be either scalar-valued \
or vector-valued.\n\t{",
 StyleBox["u0",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u1",
  FontSlant->"Italic"],
 "} \[LongDash] the plot range."
}], "Text",
 CellChangeTimes->{{3.801733205703195*^9, 
  3.80173324387189*^9}},ExpressionUUID->"a5553547-c139-449f-8278-\
195d2402a103"],

Cell["\<\
For vector-valued functions, all the components are plotted and overlaid.\
\>", "Text",
 CellChangeTimes->{{3.801733250559676*^9, 
  3.8017332713763323`*^9}},ExpressionUUID->"e816a08c-3823-4928-9905-\
04669adae575"],

Cell["\<\
This is basically just a handy utility for debugging and troubleshooting \
tools that work with pure functions.\
\>", "Text",
 CellChangeTimes->{{3.801733276227651*^9, 
  3.8017332990087147`*^9}},ExpressionUUID->"b0949939-c2b7-4a2e-b38a-\
0e51a2d91636"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionPlot", "[", 
   RowBox[{
    RowBox[{"f_Function", "|", "f_InterpolatingFunction"}], ",", 
    RowBox[{"{", 
     RowBox[{"u0_", ",", "u1_"}], "}"}], ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f0", ",", "n", ",", "s", ",", "flist"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f0", "=", 
      RowBox[{"f", "[", "u0", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "f0", "]"}], "===", "List"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"n", "=", 
         RowBox[{"Length", "[", "f0", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"flist", "=", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "s", "]"}], "\[LeftDoubleBracket]", "#", 
            "\[RightDoubleBracket]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "n", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{"flist", ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "u0", ",", "u1"}], "}"}], ",", "opts"}], "]"}]}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"f", "[", "s", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "u0", ",", "u1"}], "}"}], ",", "opts"}], "]"}]}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.801398087807864*^9, 3.801398228707284*^9}, {
  3.801398332469062*^9, 3.801398436988635*^9}, {3.801398569527974*^9, 
  3.8013985698860607`*^9}, {3.801398691183011*^9, 3.801398707686874*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"8dbd14ba-ed27-45f9-83fe-50f7fbb69020"],

Cell["Examples of both scalar- and vector-valued functions.", "Text",
 CellChangeTimes->{{3.8013984439529448`*^9, 3.80139844586854*^9}, {
  3.80139863922809*^9, 
  3.8013986646853848`*^9}},ExpressionUUID->"ff886fb1-3697-4368-b441-\
fa94fe27be42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"GraphicsRow", "[", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FunctionPlot", "[", 
        RowBox[{
         RowBox[{
          SuperscriptBox["#", "2"], "&"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{
         "PlotLabel", 
          "\[Rule]", "\"\<\!\(\*SuperscriptBox[\(x\), \(2\)]\)\>\""}]}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FunctionPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "#", "]"}], ",", 
            RowBox[{"Sin", "[", "#", "]"}], ",", 
            RowBox[{"#", "/", "2"}]}], "}"}], "&"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", "\"\<c\>\""}]}], "]"}]}], "}"}], 
     "]"}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.801398447142344*^9, 3.801398553061721*^9}, {
  3.801398673150025*^9, 3.801398673277896*^9}, {3.801398764082345*^9, 
  3.801398765821809*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"5ab71837-146b-40be-8845-cae466b31422"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Strict arguments", "Subsection",
 CellChangeTimes->{{3.7994149394178333`*^9, 
  3.79941494334503*^9}},ExpressionUUID->"d3bedff9-f98e-42db-a5c0-\
4a86af2b9539"],

Cell[CellGroupData[{

Cell[TextData[{
 "StrictArguments[",
 StyleBox["name",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.799414945257306*^9, 
  3.7994149935936313`*^9}},ExpressionUUID->"3749a06c-c64f-4a10-addb-\
aa90c62e26f5"],

Cell[TextData[{
 "StrictArguments[",
 StyleBox["name",
  FontSlant->"Italic"],
 "] sets up a default definition for ",
 StyleBox["name",
  FontSlant->"Italic"],
 " that returns an error and aborts if the arguments to ",
 StyleBox["name",
  FontSlant->"Italic"],
 "[",
 StyleBox["args",
  FontSlant->"Italic"],
 "] do not match any other definitions."
}], "Text",
 CellChangeTimes->{{3.799414958777128*^9, 
  3.799415053690029*^9}},ExpressionUUID->"38ac7929-b39a-4bc1-85ff-\
04156da6d5fa"],

Cell["\<\
This is useful for functions that require many precisely structured \
arguments, when we want them to fail rather than propagate unevaluated.\
\>", "Text",
 CellChangeTimes->{{3.79941506673013*^9, 
  3.799415114130561*^9}},ExpressionUUID->"6172a3e9-9961-42a6-9263-\
f38cd7d650e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StrictArguments", "[", "name_Symbol", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"name", "::", "badargs"}], 
       "=", "\"\<`1` does not fit any defined pattern for arguments.\>\""}], ";",
       "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"name", "[", "args___", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"name", "::", "badargs"}], ",", 
            RowBox[{"{", "args", "}"}]}], "]"}], ";", 
          RowBox[{"Abort", "[", "]"}]}]}], "]"}]}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.799414970088028*^9, 3.799415001017728*^9}, {
  3.7994151434594793`*^9, 3.799415180492138*^9}, {3.799415461080844*^9, 
  3.799415461429451*^9}, {3.799415522544264*^9, 3.7994155264453506`*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"113e816e-3927-4fad-9942-2d4370129c39"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Any-D geometry", "Section",
 CellChangeTimes->{{3.7083986670217*^9, 
  3.708398670152666*^9}},ExpressionUUID->"d2003200-5c2c-4e34-a3b0-\
52af5984aae7"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.708400355842918*^9, 
  3.708400357156689*^9}},ExpressionUUID->"db344254-60fb-48f7-a6c5-\
c3b3835fb77a"],

Cell["\<\
These functions work for vectors in any dimension, though the most common \
usage will be 2D and 3D.\
\>", "Text",
 CellChangeTimes->{{3.708400358787162*^9, 3.708400382619314*^9}, {
  3.708400817041411*^9, 
  3.70840082094611*^9}},ExpressionUUID->"ea81af20-191a-4dcf-9232-\
b3e88f6470f3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Magnitude and normalization", "Subsection",
 CellChangeTimes->{{3.45752939963939*^9, 3.45752940055091*^9}, {
  3.691511522842156*^9, 3.691511524167952*^9}, {3.708400410058519*^9, 
  3.708400414124058*^9}},ExpressionUUID->"eb2bddb7-3ae9-4ed0-8d20-\
1f22f1218421"],

Cell[CellGroupData[{

Cell[TextData[{
 "Mag[",
 StyleBox["v",
  FontSlant->"Italic"],
 "]\nMag2[",
 StyleBox["v",
  FontSlant->"Italic"],
 "]\nNormalize[",
 StyleBox["v",
  FontSlant->"Italic"],
 "]\nNormalizeReal[",
 StyleBox["v",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.692987441431423*^9, 
  3.692987451575542*^9}},ExpressionUUID->"512eec72-7f13-4a0d-9184-\
a4e6fa7b603e"],

Cell[TextData[{
 "Mag2[",
 StyleBox["v",
  FontSlant->"Italic"],
 "] gives the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["magnitude", "2"], TraditionalForm]],ExpressionUUID->
  "b16228c3-8a1f-4fc9-b767-4c57563648af"],
 " of a real-valued vector ",
 StyleBox["v",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.692987608995804*^9, 
  3.692987626352941*^9}},ExpressionUUID->"6524f872-caaa-4ef4-a48d-\
8e4a6ebf1be7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mag2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", ".", "#"}], ")"}], "&"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.780786746327675*^9, 3.780786751419036*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"0ddecea9-7939-41ea-81c9-a362ecca94b4"],

Cell[TextData[{
 "Note: as of Tessellatica 12.1d3, we replaced ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Plus", "@@", 
       SuperscriptBox["#", "2"]}], ")"}], "&"}]}], TraditionalForm]],
  ExpressionUUID->"ab8d87e8-47dd-4363-b48d-89aef6bcdbaf"],
 ") with the above, which more properly handles symbolic or \
delayed-evaluation functions."
}], "Text",
 CellChangeTimes->{{3.780786759002983*^9, 3.780786850412413*^9}, {
  3.780786905254807*^9, 3.78078690895942*^9}, {3.780787363241332*^9, 
  3.780787364152087*^9}},ExpressionUUID->"4292f750-4c66-465d-8052-\
730f941f7ec9"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.7807868676374288`*^9, 
  3.780786870277072*^9}},ExpressionUUID->"e9f16fb1-f24a-463f-a8c8-\
fa63fcd6cb44"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f1", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          SuperscriptBox["#", "2"]}], ")"}], "&"}]}], ",", 
      RowBox[{"f2", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#", ".", "#"}], ")"}], "&"}]}], ",", "if"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "They", " ", "give", " ", "the", " ", "same", " ", "result", " ", "for", 
      " ", "a", " ", "real", " ", "vector"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f1", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], ",", 
        RowBox[{"f2", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "And", " ", "the", " ", "give", " ", "the", " ", "same", " ", "result", 
       " ", "for", " ", "an", " ", "evaluated", " ", "interpolating", " ", 
       RowBox[{"function", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"if", "=", 
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"{", 
             RowBox[{"4", ",", "2"}], "}"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f1", "[", 
         RowBox[{"if", "[", "1", "]"}], "]"}], ",", 
        RowBox[{"f2", "[", 
         RowBox[{"if", "[", "1", "]"}], "]"}]}], "}"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "But", " ", "they", " ", "differ", " ", "if", " ", "we", " ", "have", " ",
        "a", " ", "parameter", " ", "that", " ", "delays", " ", "evaluation", 
       " ", "of", " ", "the", " ", "interpolation"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f1", "[", 
          RowBox[{"if", "[", "x", "]"}], "]"}], ",", 
         RowBox[{"f2", "[", 
          RowBox[{"if", "[", "x", "]"}], "]"}]}], "}"}], "/.", 
       RowBox[{"x", "\[Rule]", "1"}]}], "]"}], ";"}]}], "\[IndentingNewLine]",
    "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.780786871860231*^9, 3.780787089366184*^9}, {
  3.780787155050406*^9, 3.78078725360781*^9}, {3.780787295994179*^9, 
  3.780787355759783*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"d8547bae-3332-4017-a595-ee8c0000fba7"],

Cell[TextData[{
 "Mag[",
 StyleBox["v",
  FontSlant->"Italic"],
 "] gives the magnitude of a real-valued vector ",
 StyleBox["v",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.692987615371912*^9, 
  3.692987632030433*^9}},ExpressionUUID->"cadcf060-c1d2-4b9d-999d-\
a03ec471277e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Mag", "=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"#", ".", "#"}], "]"}], "&"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.780787378002075*^9, 3.780787389358932*^9}},
 CellLabel->
  "In[147]:=",ExpressionUUID->"269d774c-df87-432e-8cd4-95b9acb71b4e"],

Cell[TextData[{
 "Normalize[",
 StyleBox["v",
  FontSlant->"Italic"],
 "] normalizes the vector ",
 StyleBox["v",
  FontSlant->"Italic"],
 ". This is now built-in to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 7."
}], "Text",
 CellChangeTimes->{{3.457796370668239*^9, 
  3.4577963853232317`*^9}},ExpressionUUID->"4904b639-e943-4093-ad9e-\
e2fc361b6e7a"],

Cell["\<\
However, I noticed in Mathematica 11 that the built-in function does not \
assume real values, which can unnecessarily complicate expressions that are \
known to be real. So we introduce NormalizeReal, which gives simpler \
expressions for real-valued arguments.\
\>", "Text",
 CellChangeTimes->{{3.69298735899013*^9, 
  3.692987459739666*^9}},ExpressionUUID->"4c559e2b-d699-4c41-8031-\
20b0b80e3f00"],

Cell[TextData[{
 "NormalizeReal[",
 StyleBox["v",
  FontSlant->"Italic"],
 "] normalizes a vector under the assumption that all of its components are \
real."
}], "Text",
 CellChangeTimes->{{3.6929874632912283`*^9, 
  3.692987496444738*^9}},ExpressionUUID->"e6f1d11d-85fa-4b87-9cd1-\
2a422778d7b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalizeReal", "=", 
   RowBox[{
    RowBox[{"#", "/", 
     RowBox[{"Mag", "[", "#", "]"}]}], "&"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.692987501751926*^9, 3.692987517242817*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"4922d42c-af1c-423b-8aaa-617eed0998b1"],

Cell["Example, compare this with built-in version.", "Text",
 CellChangeTimes->{{3.692987521868298*^9, 
  3.692987537252255*^9}},ExpressionUUID->"2dcf39f4-7d87-4d87-b3d3-\
88bbc4b5d63d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "v", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Normalize[v] = \>\"", ",", 
       RowBox[{"Normalize", "[", "v", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<NormalizeReal[v] = \>\"", ",", 
       RowBox[{"NormalizeReal", "[", "v", "]"}]}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.69298753852139*^9, 3.692987581519576*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"15b1e290-a00f-49e4-94f0-252a458b822b"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Reflection", "Subsection",
 CellChangeTimes->{{3.708400421853665*^9, 
  3.708400427101992*^9}},ExpressionUUID->"caca2c7d-ae1b-486b-9017-\
d79a8c218993"],

Cell[CellGroupData[{

Cell[TextData[{
 "Reflect[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "]\nReflectu[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "]\nReflect[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "]\nReflectu[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.690651440917293*^9, 3.690651455000332*^9}, {
  3.690651867519218*^9, 
  3.690651873790906*^9}},ExpressionUUID->"7f164ce6-f368-401d-9b01-\
7df579b7b6e1"],

Cell[TextData[{
 "Reflect[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "] reflects a point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " in the hyperplane defined by the unnormalized vector ",
 StyleBox["u",
  FontSlant->"Italic"],
 " through the origin."
}], "Text",
 CellChangeTimes->{{3.690651461278023*^9, 3.690651480038528*^9}, {
  3.690651613706141*^9, 3.6906516161460657`*^9}, {3.690651927759676*^9, 
  3.690651929647661*^9}},ExpressionUUID->"c5736046-2b69-4cd6-9638-\
570c86b380dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reflect", "[", 
   RowBox[{"p_List", ",", "u_List"}], "]"}], ":=", 
  RowBox[{"p", "-", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"p", ".", "u"}], ")"}], 
    RowBox[{"u", "/", 
     RowBox[{"(", 
      RowBox[{"u", ".", "u"}], ")"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.690651517927093*^9, 3.6906515351710997`*^9}, 
   3.690651810124446*^9},
 CellLabel->
  "In[150]:=",ExpressionUUID->"2cb0f210-7735-4a35-88ad-fb3730e69d4e"],

Cell["Example", "Text",
 CellChangeTimes->{{3.690651629804801*^9, 
  3.690651630474066*^9}},ExpressionUUID->"a3dd6af7-acf8-4b14-a7bf-\
01d0e2b113fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "u", ",", "pp", ",", "R"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pp", "=", 
      RowBox[{"Reflect", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"R", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R", ".", "u"}], ",", 
              RowBox[{"-", 
               RowBox[{"R", ".", "u"}]}]}], "}"}], "]"}], ",", "Black"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Red"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "pp", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Green"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.690651633548016*^9, 3.690651700409941*^9}, {
   3.690652061490505*^9, 3.6906520879550667`*^9}, {3.690652125184003*^9, 
   3.69065218904673*^9}, 3.690652494565968*^9},
 CellLabel->
  "In[151]:=",ExpressionUUID->"021918a7-c8d8-40ae-b07b-1b56cb7a8221"],

Cell[TextData[{
 "Reflectu[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "] reflects a point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " in the hyperplane defined by the normalized vector ",
 StyleBox["u",
  FontSlant->"Italic"],
 " through the origin. If you know that u is normalized, you can save some \
algebra by using this."
}], "Text",
 CellChangeTimes->{{3.690651461278023*^9, 3.690651495707066*^9}, {
  3.690651550336828*^9, 3.6906515659584208`*^9}, {3.690651622017379*^9, 
  3.690651624371141*^9}, {3.690651917128772*^9, 
  3.690651918790215*^9}},ExpressionUUID->"d49b11ca-2ad5-424f-a6e2-\
f8d8a10a37e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reflectu", "[", 
   RowBox[{"p_List", ",", "u_List"}], "]"}], ":=", 
  RowBox[{"p", "-", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"p", ".", "u"}], ")"}], "u"}]}]}]], "Input",
 CellChangeTimes->{{3.690651517927093*^9, 3.690651547433495*^9}, 
   3.6906518116392193`*^9},
 CellLabel->
  "In[152]:=",ExpressionUUID->"e48f30af-ed4d-4551-9186-cb2b21042842"],

Cell["Example", "Text",
 CellChangeTimes->{{3.690651629804801*^9, 
  3.690651630474066*^9}},ExpressionUUID->"8464a62b-feca-4ff7-9816-\
59a4fabe8c0c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "u", ",", "pp", ",", "R"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"NormalizeReal", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pp", "=", 
      RowBox[{"Reflectu", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"R", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"R", ".", "u"}], ",", 
              RowBox[{"-", 
               RowBox[{"R", ".", "u"}]}]}], "}"}], "]"}], ",", "Black"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Red"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "pp", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Green"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.690651633548016*^9, 3.690651700409941*^9}, {
   3.690652061490505*^9, 3.6906520879550667`*^9}, {3.690652125184003*^9, 
   3.69065218904673*^9}, {3.690652227206971*^9, 3.690652236845537*^9}, 
   3.690652489225574*^9, 3.701092740868682*^9},
 CellLabel->
  "In[153]:=",ExpressionUUID->"b49ea82a-f498-4efb-9336-ba7bc49eeb8e"],

Cell[TextData[{
 "Reflect[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "] reflects a point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " in the hyperplane defined by the unnormalized vector ",
 StyleBox["u",
  FontSlant->"Italic"],
 " through point ",
 StyleBox["q.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.690651461278023*^9, 3.690651480038528*^9}, {
  3.690651613706141*^9, 3.6906516161460657`*^9}, {3.690651892600111*^9, 
  3.690651907669823*^9}},ExpressionUUID->"68f2a23e-538f-4091-95b9-\
c24b18d2a481"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reflect", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "u_List"}], "]"}], ":=", 
  RowBox[{"p", "-", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "q"}], ")"}], ".", "u"}], ")"}], 
    RowBox[{"u", "/", 
     RowBox[{"(", 
      RowBox[{"u", ".", "u"}], ")"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.690651517927093*^9, 3.6906515351710997`*^9}, 
   3.690651810124446*^9, {3.690651966130169*^9, 3.690651967198979*^9}, {
   3.690652028849454*^9, 3.690652031977228*^9}, {3.69065233122687*^9, 
   3.690652332832108*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"5faf2e91-9e73-408e-a762-426d13b1f087"],

Cell["Example", "Text",
 CellChangeTimes->{{3.690651629804801*^9, 
  3.690651630474066*^9}},ExpressionUUID->"7e187eb9-c859-4060-b499-\
4222aedd800c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "u", ",", "pp", ",", "R"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"1", "/", "4"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pp", "=", 
      RowBox[{"Reflect", "[", 
       RowBox[{"p", ",", "q", ",", "u"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"R", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"q", "+", 
               RowBox[{"R", ".", "u"}]}], ",", 
              RowBox[{"q", "-", 
               RowBox[{"R", ".", "u"}]}]}], "}"}], "]"}], ",", "Black"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "q", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Gray"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Red"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "pp", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Green"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.690651633548016*^9, 3.690651700409941*^9}, {
   3.690652061490505*^9, 3.6906520879550667`*^9}, {3.690652125184003*^9, 
   3.69065218904673*^9}, {3.690652227206971*^9, 3.690652305732864*^9}, {
   3.690652418413363*^9, 3.69065241864997*^9}, 3.690652483096142*^9},
 CellLabel->
  "In[155]:=",ExpressionUUID->"617420f9-0945-4ab0-bc38-3800181866a8"],

Cell[TextData[{
 "Reflectu[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["u",
  FontSlant->"Italic"],
 "] reflects a point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " in the hyperplane defined by the normalized vector ",
 StyleBox["u",
  FontSlant->"Italic"],
 " through point ",
 StyleBox["q",
  FontSlant->"Italic"],
 ". If you know that u is normalized, you can save some algebra by using this."
}], "Text",
 CellChangeTimes->{{3.690651461278023*^9, 3.690651495707066*^9}, {
  3.690651550336828*^9, 3.6906515659584208`*^9}, {3.690651622017379*^9, 
  3.690651624371141*^9}, {3.69065195218355*^9, 3.690651958354342*^9}, {
  3.922811463041194*^9, 
  3.92281146344704*^9}},ExpressionUUID->"ac583074-8b34-415d-8fc5-\
6d8679ac2efe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reflectu", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "u_List"}], "]"}], ":=", 
  RowBox[{"p", "-", 
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "q"}], ")"}], ".", "u"}], ")"}], "u"}]}]}]], "Input",\

 CellChangeTimes->{{3.690651517927093*^9, 3.690651547433495*^9}, 
   3.6906518116392193`*^9, {3.690651974478408*^9, 3.690651982608624*^9}, {
   3.690652037594139*^9, 3.690652040241428*^9}},
 CellLabel->
  "In[156]:=",ExpressionUUID->"b1f3cee6-dd48-4b2c-93cb-9383d0b0b288"],

Cell["Example", "Text",
 CellChangeTimes->{{3.690651629804801*^9, 
  3.690651630474066*^9}},ExpressionUUID->"a44647b6-f3de-4692-b158-\
587af27b163e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "u", ",", "pp", ",", "R"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"1", "/", "4"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u", "=", 
      RowBox[{"NormalizeReal", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pp", "=", 
      RowBox[{"Reflectu", "[", 
       RowBox[{"p", ",", "q", ",", "u"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"R", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"q", "+", 
               RowBox[{"R", ".", "u"}]}], ",", 
              RowBox[{"q", "-", 
               RowBox[{"R", ".", "u"}]}]}], "}"}], "]"}], ",", "Black"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "q", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Gray"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Red"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "pp", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}], ",", "Green"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.690651633548016*^9, 3.690651700409941*^9}, {
   3.690652061490505*^9, 3.6906520879550667`*^9}, {3.690652125184003*^9, 
   3.69065218904673*^9}, {3.690652227206971*^9, 3.690652305732864*^9}, {
   3.690652418413363*^9, 3.69065247494857*^9}, 3.701092742985042*^9},
 CellLabel->
  "In[157]:=",ExpressionUUID->"1b8abbb8-367b-4dbe-9602-12754e3a4307"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Intersections", "Subsection",
 CellChangeTimes->{{3.7260896814584503`*^9, 
  3.726089682952845*^9}},ExpressionUUID->"f19fbdb0-c263-4b10-9e80-\
f98636d08f9e"],

Cell[CellGroupData[{

Cell[TextData[{
 "LinePlaneInt[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["qn",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.726090456947465*^9, 
  3.726090460153887*^9}},ExpressionUUID->"d95edc79-5d35-4c5a-9ea6-\
49e2e67faa1d"],

Cell[TextData[{
 "LinePlaneInt[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["qn",
  FontSlant->"Italic"],
 "}] finds the intersection of the line through ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p2",
  FontSlant->"Italic"],
 " with the plane containing ",
 StyleBox["q",
  FontSlant->"Italic"],
 " and normal vector ",
 StyleBox["qn",
  FontSlant->"Italic"],
 " (which does not need to be normalized)."
}], "Text",
 CellChangeTimes->{{3.726089731354478*^9, 3.726089767585807*^9}, 
   3.726090461872739*^9, {3.936014712055965*^9, 
   3.936014728101748*^9}},ExpressionUUID->"2e71e4ac-c9f1-4a3e-bc13-\
cd5550c06ade"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinePlaneInt", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_List", ",", " ", "p2_List"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q_List", ",", "qn_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", "=", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"q", "-", "p1"}], ")"}], ".", "qn"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p2", "-", "p1"}], ")"}], ".", "qn"}]]}], "}"}], ",", 
    RowBox[{"p1", "+", 
     RowBox[{"t", 
      RowBox[{"(", 
       RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.726089688211178*^9, 3.726089725707534*^9}, {
  3.726089787241774*^9, 3.726089794162667*^9}, {3.726089914228869*^9, 
  3.726089940884073*^9}, {3.726090250838695*^9, 3.726090271102858*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"817dd3ae-c565-4b0f-b5cb-b874c0e4c608"],

Cell["Example", "Text",
 CellChangeTimes->{{3.726089944946788*^9, 
  3.726089945660687*^9}},ExpressionUUID->"ac6f0263-007b-4c98-bece-\
35dcd634b8d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2", ",", "q", ",", "qn", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".2", ",", ".3"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"q", "=", 
      RowBox[{"{", 
       RowBox[{".5", ",", "0", ",", "0"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"qn", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"LinePlaneInt", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", "qn"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "p1", "]"}], ",", 
             RowBox[{"Point", "[", "p2", "]"}]}], "}"}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".01", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "q", "]"}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Polygon", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"q", "+", 
               RowBox[{".3", "#"}]}], "&"}], "/@", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{"-", "1"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", 
                 RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}], ",", 
           RowBox[{"Opacity", "[", ".25", "]"}], ",", 
           RowBox[{"EdgeForm", "[", "]"}], ",", "Green"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.7260899682507*^9, 3.726090181695464*^9}, {
  3.726090241799693*^9, 3.726090245767318*^9}, {3.726090281623105*^9, 
  3.726090446177143*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"ba2fb293-2408-4dbe-aefd-951af5a8cf4a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Medials", "Subsection",
 CellChangeTimes->{{3.708400433679322*^9, 
  3.708400442975317*^9}},ExpressionUUID->"59627916-2f2d-436b-bcfb-\
66b405820513"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.4577036990590477`*^9, 
  3.457703699489459*^9}},ExpressionUUID->"14bf2ab8-46da-4126-b9ed-\
6fa85b38e9d7"],

Cell["\<\
The *MedialInfo functions compute points of closest approach between \
combinations of points, lines, and line segments. They give both points \
equidistant between two objects and information about the closest points on \
the two objects themselves. You can use these to get distances between \
combinations of objects, although in some cases the *Distance functions in \
the next section will be more efficient.\
\>", "Text",
 CellChangeTimes->{{3.676475262985497*^9, 3.676475370415791*^9}, {
  3.676475466921236*^9, 3.676475507111916*^9}, {3.67647638076895*^9, 
  3.676476382063709*^9}},ExpressionUUID->"5129c641-471a-429d-a36c-\
b31bac1ac8e4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "PointPointMedialInfo[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 "]\nPointLineMedialInfo[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]\nPointSegmentMedialInfo[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]\nLineLineMedialInfo[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]\nLineSegmentMedialInfo[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]\nSegmentSegmentMedialInfo[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.676406055534975*^9, 3.6764060759479513`*^9}, {
  3.676406109738408*^9, 3.676406181917145*^9}, {3.676406275767284*^9, 
  3.676406282494722*^9}, {3.676407888906786*^9, 3.676407900097379*^9}, {
  3.676416364239455*^9, 3.676416368994385*^9}, {3.7067212726547832`*^9, 
  3.706721277193891*^9}},ExpressionUUID->"1a243e66-984d-4fa8-bb3a-\
aa25d1ace6b5"],

Cell[TextData[{
 "PointPointMedialInfo[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 "] constructs the medial point between two points ",
 StyleBox["p",
  FontSlant->"Italic"],
 " and ",
 StyleBox["q",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.676406258786076*^9, 3.676406330155931*^9}, 
   3.6764063802193108`*^9, {3.706722366780443*^9, 
   3.706722388608838*^9}},ExpressionUUID->"a7847a81-652f-4d7a-8260-\
7c82d147e00f"],

Cell[TextData[{
 "Returns a list {",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 "} where ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the closest point equidistant between ",
 StyleBox["p",
  FontSlant->"Italic"],
 " and ",
 StyleBox["q",
  FontSlant->"Italic"],
 " and ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the distance to either."
}], "Text",
 CellChangeTimes->{{3.706722369996299*^9, 
  3.70672237373748*^9}},ExpressionUUID->"c7f418f6-54ae-4aad-9519-\
1f1942d2b360"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PointPointMedialInfo", "[", 
   RowBox[{"p_List", ",", "q_List"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}], "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", 
      RowBox[{"Mag", "[", 
       RowBox[{"r", "-", "p"}], "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.676406195314093*^9, 3.67640624125892*^9}, {
  3.6764063426911097`*^9, 3.67640638142941*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"5bc554a9-47fd-4f10-9d9e-f646b70c4cf8"],

Cell["Example", "Text",
 CellChangeTimes->{{3.676406429336599*^9, 
  3.676406430021316*^9}},ExpressionUUID->"8d9970c7-1ccb-4622-b1e1-\
be0326639667"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PointPointMedialInfo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.6764064470117807`*^9, 3.676406470741218*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"d6060299-085f-4044-89d8-905db7186126"],

Cell[TextData[{
 "PointLineMedialInfo[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]  constructs the medial point between a point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " and the line passing through points {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}."
}], "Text",
 CellChangeTimes->{{3.6764064765474873`*^9, 3.676406550493884*^9}, {
  3.706720401697122*^9, 3.706720442639451*^9}, {3.706722412600486*^9, 
  3.706722461379725*^9}},ExpressionUUID->"9ef531a8-25a3-41b3-9d2a-\
170bf2e4d567"],

Cell[TextData[{
 "Returns a list {",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "} where ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the closest point equidistant between ",
 StyleBox["p",
  FontSlant->"Italic"],
 " and the line through {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the distance to either, and ",
 StyleBox["tq",
  FontSlant->"Italic"],
 " parameterizes the position of the point of closest approach to ",
 StyleBox["r",
  FontSlant->"Italic"],
 " along the line segment between ",
 StyleBox["q1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["q2.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.706722414897366*^9, 3.706722417561328*^9}, {
  3.706722479486435*^9, 3.706722480434334*^9}, {3.706722535326561*^9, 
  3.706722601261751*^9}},ExpressionUUID->"a9a0c0aa-3b83-46cb-b06f-\
0dcde3f98afe"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PointLineMedialInfo", "::", "badline"}], 
   "=", "\"\<Points `1` and `2` must be distinct.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.676406887739288*^9, 3.67640690066523*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"f3e23820-c17e-429a-b9b9-ef0144e20371"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PointLineMedialInfo", "[", 
   RowBox[{"p_List", ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pq", ",", "dq", ",", "tq", ",", "rq", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", 
         RowBox[{"Mag", "[", "dq", "]"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"PointLineMedialInfo", "::", "badline"}], ",", "q1", ",", 
          "q2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"pq", "=", 
      RowBox[{"p", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tq", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"pq", ".", "dq"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"dq", ".", "dq"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rq", "=", 
      RowBox[{"q1", "+", 
       RowBox[{"tq", " ", "dq"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "pt", " ", "of", " ", "closest", " ", "approach", " ", "on", " ", 
       "line"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "rq"}], ")"}], "/", "2"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{"Mag", "[", 
        RowBox[{"r", "-", "p"}], "]"}], ",", "tq"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.676406576753314*^9, 3.676406593228881*^9}, {
  3.676406911080279*^9, 3.676407038216648*^9}, {3.676407108332738*^9, 
  3.676407197085422*^9}, {3.67640763058255*^9, 3.676407666906702*^9}, {
  3.6764149024260798`*^9, 3.676414903650339*^9}, {3.676419036827538*^9, 
  3.676419050830437*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"8a015abd-164c-4d00-8d8e-83dfc6cf6599"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.676407200885289*^9, 
  3.676407201821302*^9}},ExpressionUUID->"3e1f8ea1-c467-4105-9e61-\
8f0c75cbd632"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tq"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tq"}], "}"}], "=", 
      RowBox[{"PointLineMedialInfo", "[", 
       RowBox[{"p", ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "q1"}], "-", "q2"}], ",", 
              RowBox[{
               RowBox[{"2", "q2"}], "-", "q1"}]}], "}"}], "]"}], ",", "Red"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "q1", "]"}], ",", 
             RowBox[{"Point", "[", "q2", "]"}]}], "}"}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", 
           RowBox[{"Darker", "[", "Blue", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}], "//", "Print"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", "tq"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.676407206560045*^9, 3.676407384100723*^9}, {
   3.6764075047810917`*^9, 3.67640750829067*^9}, 3.706720393634663*^9, {
   3.706723993530328*^9, 3.70672400421032*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"7458b92e-6d9f-427f-8adc-37c23ece1d99"],

Cell[TextData[{
 "PointSegmentMedialInfo[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] constructs the medial point between a point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " and the line segment between points {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}."
}], "Text",
 CellChangeTimes->{{3.6764064765474873`*^9, 3.676406550493884*^9}, {
   3.676407446975245*^9, 3.676407468907887*^9}, 3.706722657169466*^9, {
   3.706722694380144*^9, 
   3.706722711818533*^9}},ExpressionUUID->"7f656d6f-4ff2-420f-b262-\
9ec9ddc64ab5"],

Cell[TextData[{
 "Returns a list {",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "} where ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the closest point equidistant between ",
 StyleBox["p",
  FontSlant->"Italic"],
 " and the line segment between {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the distance, and ",
 StyleBox["tq",
  FontSlant->"Italic"],
 " parameterizes the point along the line of closest approach to ",
 StyleBox["r",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.706722661122917*^9, 
  3.7067226664348717`*^9}},ExpressionUUID->"2312481a-c590-440e-8528-\
5a0274706c6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PointSegmentMedialInfo", "::", "badline"}], 
   "=", "\"\<Points `1` and `2` must be distinct.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.676406887739288*^9, 3.67640690066523*^9}, 
   3.676407515567987*^9},
 CellLabel->
  "In[165]:=",ExpressionUUID->"70996134-649e-45b3-b5f9-6730dda60a45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PointSegmentMedialInfo", "[", 
   RowBox[{"p_List", ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pq", ",", "dq", ",", "tq", ",", "rq", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", 
         RowBox[{"Mag", "[", "dq", "]"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"PointSegmentMedialInfo", "::", "badline"}], ",", "q1", ",",
           "q2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"pq", "=", 
      RowBox[{"p", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tq", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"pq", ".", "dq"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"dq", ".", "dq"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rq", "=", 
      RowBox[{"Which", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tq", "<", "0"}], ",", "q1", ",", "\[IndentingNewLine]", 
        RowBox[{"tq", ">", "1"}], ",", "q2", ",", "\[IndentingNewLine]", 
        "True", ",", 
        RowBox[{"q1", "+", 
         RowBox[{"tq", " ", "dq"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "rq"}], ")"}], "/", "2"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", 
       RowBox[{"Mag", "[", 
        RowBox[{"r", "-", "p"}], "]"}], ",", "tq"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.676406576753314*^9, 3.676406593228881*^9}, {
  3.676406911080279*^9, 3.676407038216648*^9}, {3.676407108332738*^9, 
  3.676407197085422*^9}, {3.676407516969294*^9, 3.676407609910515*^9}, {
  3.676407673491082*^9, 3.676407757293705*^9}, {3.676414915220142*^9, 
  3.676414922344309*^9}, {3.6764190620842943`*^9, 3.676419066760894*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"ba12c439-f305-41bd-8bd4-5331555083d0"],

Cell["Example. Point within the line segment.", "Text",
 CellChangeTimes->{{3.676407200885289*^9, 3.676407201821302*^9}, {
  3.676407767521365*^9, 
  3.676407771529195*^9}},ExpressionUUID->"20b80705-f2dd-4a3a-bf92-\
c421f79498dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tq"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tq"}], "}"}], "=", 
      RowBox[{"PointSegmentMedialInfo", "[", 
       RowBox[{"p", ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "q1", "]"}], ",", 
             RowBox[{"Point", "[", "q2", "]"}]}], "}"}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", 
           RowBox[{"Darker", "[", "Blue", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}], "//", "Print"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", "tq"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.676407206560045*^9, 3.676407384100723*^9}, 
   3.676407519722129*^9, {3.676407825138825*^9, 3.676407828958424*^9}, 
   3.706722778337816*^9},
 CellLabel->
  "In[167]:=",ExpressionUUID->"1b195c1d-ec52-401d-8859-d1fca9f9aba9"],

Cell["Example. Point is off to the right.", "Text",
 CellChangeTimes->{{3.676407200885289*^9, 3.676407201821302*^9}, {
  3.676407767521365*^9, 
  3.676407784208089*^9}},ExpressionUUID->"d4fe70e4-03ae-4195-8107-\
2fc90b28832e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tq"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tq"}], "}"}], "=", 
      RowBox[{"PointSegmentMedialInfo", "[", 
       RowBox[{"p", ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", "q1", "]"}], ",", 
             RowBox[{"Point", "[", "q2", "]"}]}], "}"}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", 
           RowBox[{"Darker", "[", "Blue", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}], "//", "Print"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", "tq"}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.676407206560045*^9, 3.676407384100723*^9}, 
   3.676407519722129*^9, {3.6764077906434097`*^9, 3.6764078217271433`*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"55cfc67e-e92e-4c3e-801a-b3702e4de25a"],

Cell[TextData[{
 "LineLineMedialInfo[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] constructs the medial point between two lines."
}], "Text",
 CellChangeTimes->{{3.67640801439561*^9, 3.6764080520793047`*^9}, {
  3.676408122987747*^9, 3.676408172391872*^9}, {3.706722808603724*^9, 
  3.706722836930548*^9}},ExpressionUUID->"89d84fd9-5060-42ed-8b44-\
b348370cdf99"],

Cell[TextData[{
 "Returns a list {",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 ", {",
 StyleBox["tp",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "}} where ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the closest point equidistant between a line through {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} and a line through {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}. In 2D, this will be the intersection of the two lines. In 3D and higher, \
it will be a point of closest approach. ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the point, ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the distance to either line, and {",
 StyleBox["tp",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "} are parameterizations of the points of closest approach on both lines."
}], "Text",
 CellChangeTimes->{{3.706722811951858*^9, 
  3.7067228156474533`*^9}},ExpressionUUID->"bc359463-2e99-4c79-aaf6-\
db23c93a8369"],

Cell["\<\
If the lines are parallel, there is no unique solution. For definiteness, we \
simply pick a solution between the midpoints of the two line segments.\
\>", "Text",
 CellChangeTimes->{{3.676415897065736*^9, 
  3.676415948076418*^9}},ExpressionUUID->"965c4966-bd3d-4a9c-bab8-\
e4cf8a434bc9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LineLineMedialInfo", "::", "badline"}], 
   "=", "\"\<Points `1` and `2` must be distinct.\>\""}], ";"}]], "Input",
 CellChangeTimes->{3.676414936047442*^9},
 CellLabel->
  "In[169]:=",ExpressionUUID->"59782803-c5be-4f71-bbde-dcaeeb44ec7a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineLineMedialInfo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_List", ",", "p2_List"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "dq", ",", "dp", ",", "dqp", ",", "dpdp", ",", "dpdq", ",", "dqdq", ",", 
      "det", ",", "dpdqp", ",", "dqdqp", ",", "tp", ",", "tq", ",", "rp", ",",
       "rq", ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dp", "=", 
      RowBox[{"p2", "-", "p1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", 
         RowBox[{"Mag", "[", "dp", "]"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"LineLineMedialInfo", "::", "badline"}], ",", "p1", ",", 
          "p2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"dq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", 
         RowBox[{"Mag", "[", "dq", "]"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"LineLineMedialInfo", "::", "badline"}], ",", "q1", ",", 
          "q2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"dpdp", "=", 
      RowBox[{"dp", ".", "dp"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dpdq", "=", 
      RowBox[{"dp", ".", "dq"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dqdq", "=", 
      RowBox[{"dq", ".", "dq"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"det", "=", 
      RowBox[{
       SuperscriptBox["dpdq", "2"], "-", 
       RowBox[{"dpdp", " ", "dqdq"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", "det", "]"}], "\[NotEqual]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"lines", " ", "are", " ", "non"}], "-", "parallel"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dqp", "=", 
         RowBox[{"q1", "-", "p1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dpdqp", "=", 
         RowBox[{"dp", ".", "dqp"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dqdqp", "=", 
         RowBox[{"dq", ".", "dqp"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tp", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"dpdq", " ", "dqdqp"}], "-", 
            RowBox[{"dpdqp", " ", "dqdq"}]}], ")"}], "/", "det"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tq", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"dpdp", " ", "dqdqp"}], "-", 
            RowBox[{"dpdq", " ", "dpdqp"}]}], ")"}], "/", "det"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rp", "=", 
         RowBox[{"p1", "+", 
          RowBox[{"tp", 
           RowBox[{"(", 
            RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rq", "=", 
         RowBox[{"q1", "+", 
          RowBox[{"tq", 
           RowBox[{"(", 
            RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rp", "+", "rq"}], ")"}], "/", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"r", ",", 
          RowBox[{"Mag", "[", 
           RowBox[{"r", "-", "rp"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"lines", " ", "are", " ", "parallel"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"r", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"q1", "+", "q2"}], ")"}], "+", 
            RowBox[{"(", 
             RowBox[{"p1", "+", "p2"}], ")"}]}], ")"}], "/", "4"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tp", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", "-", "p1"}], ")"}], ".", "dp"}], "/", "dpdp"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"tq", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", "-", "q1"}], ")"}], ".", "dq"}], "/", "dqdq"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"rp", "=", 
         RowBox[{"p1", "+", 
          RowBox[{"tp", 
           RowBox[{"(", 
            RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rq", "=", 
         RowBox[{"q1", "+", 
          RowBox[{"tq", 
           RowBox[{"(", 
            RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"r", ",", 
          RowBox[{"Mag", "[", 
           RowBox[{"r", "-", "rp"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.676413351101513*^9, 3.676413372491542*^9}, {
   3.6764137367483597`*^9, 3.676413742503035*^9}, 3.6764137965368023`*^9, {
   3.676413917590886*^9, 3.676413934247726*^9}, {3.676414102699527*^9, 
   3.676414114313807*^9}, {3.676414358779552*^9, 3.6764144622210293`*^9}, {
   3.6764144982262173`*^9, 3.676414739013921*^9}, {3.676414853148744*^9, 
   3.67641488938238*^9}, {3.676414942573451*^9, 3.676414982657027*^9}, {
   3.676415538667207*^9, 3.676415674179595*^9}, {3.676415955938489*^9, 
   3.676416154102809*^9}, {3.676419075587058*^9, 3.676419087831467*^9}, {
   3.676459599547488*^9, 3.676459613996375*^9}, {3.676459646919508*^9, 
   3.676459655892602*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"9264cb46-9f6c-48eb-bccb-d396b5bcd046"],

Cell["Example, 2D.", "Text",
 CellChangeTimes->{{3.676414987544997*^9, 
  3.676415001360456*^9}},ExpressionUUID->"cedf4304-5706-4412-b001-\
fa59e549a44e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tpair", 
      ",", "tp", ",", "tq"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"LineLineMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], "]"}], "//",
       "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", 
       RowBox[{"{", 
        RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.67641499032905*^9, 3.676415226816463*^9}, {
   3.676415266227132*^9, 3.676415282836175*^9}, 3.676415687927701*^9, 
   3.676417239347293*^9},
 CellLabel->
  "In[171]:=",ExpressionUUID->"86f6d8f3-6733-466e-b1d4-17bd4fa54a4d"],

Cell["Example, 3D.", "Text",
 CellChangeTimes->{{3.676414987544997*^9, 3.676415001360456*^9}, {
  3.6764157159083023`*^9, 
  3.676415716299439*^9}},ExpressionUUID->"08733a73-4446-4fe4-966d-\
7ce30301528e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tpair", 
      ",", "tp", ",", "tq", ",", "rp", ",", "rq"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"LineLineMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"rp", "=", 
      RowBox[{"p1", "+", 
       RowBox[{"tp", 
        RowBox[{"(", 
         RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rq", "=", 
      RowBox[{"q1", "+", 
       RowBox[{"tq", 
        RowBox[{"(", 
         RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}], "]"}], ",", "Cyan"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Cyan", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], "]"}], "//",
       "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", 
       RowBox[{"{", 
        RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.67641499032905*^9, 3.676415226816463*^9}, {
   3.676415266227132*^9, 3.676415282836175*^9}, 3.676415687927701*^9, {
   3.676415721684657*^9, 3.676415814868828*^9}, 3.676417234978813*^9},
 CellLabel->
  "In[172]:=",ExpressionUUID->"44df6353-075c-4071-83cd-53d71e043751"],

Cell["Example, 2D, parallel lines.", "Text",
 CellChangeTimes->{{3.676414987544997*^9, 3.676415001360456*^9}, {
  3.67641618736727*^9, 
  3.676416191772971*^9}},ExpressionUUID->"83bf64b3-dbdc-4778-b41a-\
66a4b4cfcfc7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tpair", 
      ",", "tp", ",", "tq"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"LineLineMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], "]"}], "//",
       "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", 
       RowBox[{"{", 
        RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.67641499032905*^9, 3.676415226816463*^9}, {
   3.676415266227132*^9, 3.676415282836175*^9}, 3.676415687927701*^9, {
   3.676416195655208*^9, 3.676416230325449*^9}, {3.676417228822396*^9, 
   3.676417230654462*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"fe52fe87-4995-4feb-9e9d-748ed555ea73"],

Cell[TextData[{
 "LineSegmentMedialInfo[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] computes the medial point between a line and a line segment."
}], "Text",
 CellChangeTimes->{{3.67640801439561*^9, 3.6764080520793047`*^9}, {
  3.676408122987747*^9, 3.676408172391872*^9}, {3.6764162713952007`*^9, 
  3.676416344267931*^9}, {3.7067222717063446`*^9, 3.7067222834186687`*^9}, {
  3.7067229264888277`*^9, 
  3.706722942522916*^9}},ExpressionUUID->"db15534b-872c-44ab-89cc-\
c733d640e75c"],

Cell[TextData[{
 "Returns a list {",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 ", {",
 StyleBox["tp",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "}} where ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the closest point equidistant between a line passing through points {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} and a line segment between {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}. ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the point, ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the distance to either line, and {",
 StyleBox["tp",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "} are parameterizations of the points of closest approach on both \
segments."
}], "Text",
 CellChangeTimes->{{3.706722930226638*^9, 
  3.706722960639955*^9}},ExpressionUUID->"cc8b9338-99f8-4eea-8dcc-\
bbd1bc50ea72"],

Cell[TextData[{
 "For simplicity, we compute all possible combinations of points and lines \
and then pick the smallest distance that has valid ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.676415897065736*^9, 3.676415948076418*^9}, {
   3.676418278795492*^9, 3.676418321206855*^9}, {3.676457254609872*^9, 
   3.676457255561753*^9}, 
   3.706722970293169*^9},ExpressionUUID->"b4a45693-f2d0-48ac-8148-\
7ab811694f3c"],

Cell["\<\
Note that as with LineLineMedialInfo, if the segments are parallel, the \
solution is not unique.\
\>", "Text",
 CellChangeTimes->{{3.67645742926669*^9, 3.676457484858983*^9}, {
  3.676457523480654*^9, 
  3.676457523881397*^9}},ExpressionUUID->"2a0b7546-9a9f-4066-bfd5-\
a620a2da6b42"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LineSegmentMedialInfo", "::", "badline"}], 
   "=", "\"\<Points `1` and `2` must be distinct.\>\""}], ";"}]], "Input",
 CellChangeTimes->{3.676414936047442*^9, 3.676416352555525*^9, 
  3.706722983482385*^9},
 CellLabel->
  "In[174]:=",ExpressionUUID->"988fe7c9-e827-488c-b869-0a65739330ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineSegmentMedialInfo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_List", ",", "p2_List"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "dq", ",", "dp", ",", "dqp", ",", "dpdp", ",", "dpdq", ",", "dqdq", ",", 
      "det", ",", "tpq1", ",", "tpq2", ",", "dpdqp", ",", "dqdqp", ",", "tp", 
      ",", "tq", ",", "rp", ",", "rq", ",", "r", ",", "clist"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dp", "=", 
      RowBox[{"p2", "-", "p1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", "dp", "]"}], "\[Equal]", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "dp", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"LineSegmentMedialInfo", "::", "badline"}], ",", "p1", ",", 
          "p2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"dq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", "dq", "]"}], "\[Equal]", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "dq", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"LineSegmentMedialInfo", "::", "badline"}], ",", "q1", ",", 
          "q2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"dpdp", "=", 
      RowBox[{"dp", ".", "dp"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dpdq", "=", 
      RowBox[{"dp", ".", "dq"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dqdq", "=", 
      RowBox[{"dq", ".", "dq"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"det", "=", 
      RowBox[{
       SuperscriptBox["dpdq", "2"], "-", 
       RowBox[{"dpdp", " ", "dqdq"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", "det", "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"lines", " ", "are", " ", "parallel"}], ",", " ", 
         RowBox[{
         "return", " ", "soln", " ", "for", " ", "midpoints", " ", "of", " ", 
          "the", " ", "segment"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tq", "=", 
         RowBox[{"1", "/", "2"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"rq", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q1", "+", "q2"}], ")"}], "/", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tp", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"rq", "-", "p1"}], ")"}], ".", "dp"}], "/", "dpdp"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"rp", "=", 
         RowBox[{"p1", "+", 
          RowBox[{"tp", 
           RowBox[{"(", 
            RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rp", "+", "rq"}], ")"}], "/", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"r", ",", 
           RowBox[{"Mag", "[", 
            RowBox[{"r", "-", "rp"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"lines", " ", "are", " ", "not", " ", "parallel"}], ",", " ", 
         RowBox[{
          RowBox[{"construct", " ", "line"}], "-", 
          RowBox[{"line", " ", "solution"}]}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dqp", "=", 
         RowBox[{"q1", "-", "p1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dpdqp", "=", 
         RowBox[{"dp", ".", "dqp"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dqdqp", "=", 
         RowBox[{"dq", ".", "dqp"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tp", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"dpdq", " ", "dqdqp"}], "-", 
            RowBox[{"dpdqp", " ", "dqdq"}]}], ")"}], "/", "det"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tq", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"dpdp", " ", "dqdqp"}], "-", 
            RowBox[{"dpdq", " ", "dpdqp"}]}], ")"}], "/", "det"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rp", "=", 
         RowBox[{"p1", "+", 
          RowBox[{"tp", 
           RowBox[{"(", 
            RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rq", "=", 
         RowBox[{"q1", "+", 
          RowBox[{"tq", 
           RowBox[{"(", 
            RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rp", "+", "rq"}], ")"}], "/", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"clist", "=", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"r", ",", 
            RowBox[{"Mag", "[", 
             RowBox[{"r", "-", "rp"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}], "}"}]}]}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"JoinTo", "[", 
      RowBox[{"clist", ",", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "#", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",",
                "0"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointLineMedialInfo", "[", 
           RowBox[{"q1", ",", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "#", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",",
                "1"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointLineMedialInfo", "[", 
           RowBox[{"q2", ",", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}]}]}], "}"}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"clist", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"clist", ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"#", "\[LeftDoubleBracket]", 
            RowBox[{"3", ",", "2"}], "\[RightDoubleBracket]"}], "\[GreaterEqual]",
            "0"}], "&&", 
          RowBox[{
           RowBox[{"#", "\[LeftDoubleBracket]", 
            RowBox[{"3", ",", "2"}], "\[RightDoubleBracket]"}], "\[LessEqual]",
            "1"}]}], "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"clist", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"clist", ",", 
        RowBox[{
         RowBox[{
          RowBox[{
          "#1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "<", 
          RowBox[{
          "#2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
         "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "clist", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.676413351101513*^9, 3.676413372491542*^9}, {
   3.6764137367483597`*^9, 3.676413742503035*^9}, 3.6764137965368023`*^9, {
   3.676413917590886*^9, 3.676413934247726*^9}, {3.676414102699527*^9, 
   3.676414114313807*^9}, {3.676414358779552*^9, 3.6764144622210293`*^9}, {
   3.6764144982262173`*^9, 3.676414739013921*^9}, {3.676414853148744*^9, 
   3.67641488938238*^9}, {3.676414942573451*^9, 3.676414982657027*^9}, {
   3.676415538667207*^9, 3.676415674179595*^9}, {3.676415955938489*^9, 
   3.676416154102809*^9}, {3.676416353577881*^9, 3.676416356710905*^9}, {
   3.676416866782531*^9, 3.676416866924993*^9}, {3.676416917036166*^9, 
   3.676417045122828*^9}, {3.676417110958568*^9, 3.676417212766439*^9}, {
   3.676417247079025*^9, 3.676417343491501*^9}, {3.676417386230194*^9, 
   3.676417522678145*^9}, {3.676417568610133*^9, 3.676417853702039*^9}, {
   3.676417994305448*^9, 3.676418023134504*^9}, {3.676418331659846*^9, 
   3.676418389752802*^9}, {3.676418427741071*^9, 3.676418647955489*^9}, {
   3.676418681635855*^9, 3.676418764767803*^9}, {3.676418796257654*^9, 
   3.676418891428274*^9}, {3.676418930528074*^9, 3.676418987136548*^9}, {
   3.676419109748531*^9, 3.676419112162698*^9}, {3.676419178478318*^9, 
   3.67641919005395*^9}, {3.676419223498363*^9, 3.676419241916177*^9}, {
   3.676419307586755*^9, 3.676419309397852*^9}, {3.676419371695998*^9, 
   3.676419376013849*^9}, {3.676419426438626*^9, 3.676419428463004*^9}, {
   3.676457045461961*^9, 3.676457240308022*^9}, {3.676457548539756*^9, 
   3.676457548811901*^9}, {3.676457582609511*^9, 3.676457707131931*^9}, {
   3.676457757535515*^9, 3.676457774454932*^9}, {3.676457873580924*^9, 
   3.6764578760666847`*^9}, {3.676457936352128*^9, 3.676458028657406*^9}, {
   3.676458074683726*^9, 3.676458123711654*^9}, {3.676458685760338*^9, 
   3.676458779416954*^9}, {3.676458816205248*^9, 3.676458837525203*^9}, {
   3.676458878202649*^9, 3.676458881809461*^9}, {3.676458938548883*^9, 
   3.676459160211401*^9}, {3.676459201703311*^9, 3.676459228401264*^9}, {
   3.676459260264165*^9, 3.676459323311566*^9}, {3.676459421494244*^9, 
   3.6764595519184017`*^9}, {3.706722985134939*^9, 3.706722988611888*^9}, {
   3.706723058044986*^9, 3.706723080964148*^9}, {3.706723111054961*^9, 
   3.706723238817156*^9}, {3.7067233096981907`*^9, 3.706723345339908*^9}, {
   3.7067233869014606`*^9, 3.706723407731675*^9}, {3.706723509577467*^9, 
   3.706723516340191*^9}, 3.706723823523925*^9},
 CellLabel->
  "In[175]:=",ExpressionUUID->"8e82c818-d0c9-42b9-871e-5585614200e6"],

Cell["Example, 2D, parallel lines.", "Text",
 CellChangeTimes->{{3.676414987544997*^9, 3.676415001360456*^9}, {
  3.67645731202383*^9, 3.676457314302273*^9}, {3.676459983292121*^9, 
  3.676459986963972*^9}, {3.706723451183068*^9, 
  3.706723452843065*^9}},ExpressionUUID->"aa9bdf75-c09b-4307-932e-\
9feb36416fe6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tpair", 
      ",", "tp", ",", "tq", ",", "rp", ",", "rq"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{".8", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"LineSegmentMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"rp", "=", 
      RowBox[{"p1", "+", 
       RowBox[{"tp", 
        RowBox[{"(", 
         RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rq", "=", 
      RowBox[{"q1", "+", 
       RowBox[{"tq", 
        RowBox[{"(", 
         RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "p1"}], "-", "p2"}], ",", 
              RowBox[{
               RowBox[{"2", "p2"}], "-", "p1"}]}], "}"}], "]"}], ",", "Red"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}], "]"}], ",", "Cyan"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Cyan", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], "]"}], "//",
       "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", 
       RowBox[{"{", 
        RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.67641499032905*^9, 3.676415226816463*^9}, {
   3.676415266227132*^9, 3.676415282836175*^9}, 3.676415687927701*^9, 
   3.6764168755776033`*^9, {3.676419149557317*^9, 3.676419165724881*^9}, {
   3.676419321520333*^9, 3.676419343565813*^9}, {3.676419394096096*^9, 
   3.676419400912242*^9}, {3.676457322208644*^9, 3.676457331134938*^9}, {
   3.676457370237444*^9, 3.676457411523007*^9}, {3.676458052073968*^9, 
   3.676458052467147*^9}, {3.676459566108409*^9, 3.676459566586415*^9}, {
   3.676459708905274*^9, 3.67645971065479*^9}, 3.676459979828382*^9, {
   3.676460106008816*^9, 3.676460108518302*^9}, 3.7067234691998177`*^9, {
   3.706723537079912*^9, 3.706723549988066*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"450c8159-e7cc-4f16-85b5-6e374dc7af01"],

Cell["\<\
Example. A bunch of random sets of 2D points. (Change SeedRandom[] to \
generate new sets.)\
\>", "Text",
 CellChangeTimes->{{3.676416469867331*^9, 3.676416504065241*^9}, {
  3.676416807529809*^9, 3.676416808022611*^9}, {3.676459690807356*^9, 
  3.676459700501903*^9}},ExpressionUUID->"4bf1fd74-9c21-4062-afb5-\
9109411d0618"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "glist", ",", "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", 
      ",", "tpair", ",", "tp", ",", "tq", ",", "rp", ",", "rq"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"glist", "=", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p1", ",", "p2"}], "}"}], "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"q1", ",", "q2"}], "}"}], "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
          RowBox[{"LineSegmentMedialInfo", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rp", "=", 
          RowBox[{"p1", "+", 
           RowBox[{"tp", 
            RowBox[{"(", 
             RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rq", "=", 
          RowBox[{"q1", "+", 
           RowBox[{"tq", 
            RowBox[{"(", 
             RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"2", "p1"}], "-", "p2"}], ",", 
                  RowBox[{
                   RowBox[{"2", "p2"}], "-", "p1"}]}], "}"}], "]"}], ",", 
               "Red"}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"rp", ",", "rq"}], "}"}], "]"}], ",", "Cyan"}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "/@", 
                RowBox[{"{", 
                 RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
               RowBox[{"Darker", "[", "Red", "]"}], ",", 
               RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "/@", 
                RowBox[{"{", 
                 RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
               RowBox[{"Darker", "[", "Green", "]"}], ",", 
               RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "/@", 
                RowBox[{"{", 
                 RowBox[{"rp", ",", "rq"}], "}"}]}], ",", 
               RowBox[{"Darker", "[", "Cyan", "]"}], ",", 
               RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
               RowBox[{"PointSize", "[", ".04", "]"}]}], "]"}]}], "}"}], ",", 
           
           RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", "12", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{"Partition", "[", 
       RowBox[{"glist", ",", "4"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.676416481969658*^9, 3.676416484507917*^9}, {
   3.676416518499123*^9, 3.676416720281666*^9}, {3.676416751087983*^9, 
   3.676416773508773*^9}, 3.676416877926505*^9, {3.676457293060301*^9, 
   3.676457293263808*^9}, {3.6764596772763243`*^9, 3.676459706078762*^9}, {
   3.706721073554389*^9, 3.706721111294298*^9}, {3.706723570899638*^9, 
   3.706723584866929*^9}, {3.706723859098521*^9, 3.7067238616371*^9}, {
   3.706723952356703*^9, 3.706723952776295*^9}},
 CellLabel->
  "In[177]:=",ExpressionUUID->"94cd7c2e-c1c5-4f42-8561-51702ddad654"],

Cell[TextData[{
 "SegmentSegmentMedialInfo[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] constructs the medial point between two line segments."
}], "Text",
 CellChangeTimes->{{3.67640801439561*^9, 3.6764080520793047`*^9}, {
  3.676408122987747*^9, 3.676408172391872*^9}, {3.6764162713952007`*^9, 
  3.676416344267931*^9}, {3.706722859078662*^9, 
  3.7067228797032957`*^9}},ExpressionUUID->"67d10412-4967-4bca-9b72-\
9eefde891c09"],

Cell[TextData[{
 "Returns a list {",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 ", {",
 StyleBox["tp",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "}} where ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the closest point equidistant between a line segment between {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} and a line segment between {q1, q2}. ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the point, ",
 StyleBox["d",
  FontSlant->"Italic"],
 " is the distance to either line, and {",
 StyleBox["tp",
  FontSlant->"Italic"],
 ", ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "} are parameterizations of the points of closest approach on both \
segments."
}], "Text",
 CellChangeTimes->{{3.706722863482181*^9, 
  3.706722895476959*^9}},ExpressionUUID->"c282f16c-685e-48e9-9019-\
931db7f5738b"],

Cell[TextData[{
 "For simplicity, we compute all possible combinations of points and lines \
and then pick the smallest distance that has valid ",
 StyleBox["tp",
  FontSlant->"Italic"],
 " and ",
 StyleBox["tq",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.676415897065736*^9, 3.676415948076418*^9}, {
  3.676418278795492*^9, 3.676418321206855*^9}, {3.676457254609872*^9, 
  3.676457255561753*^9}},ExpressionUUID->"207b09e5-8efd-46f0-8b7d-\
6df586308df3"],

Cell["\<\
Note that as with LineLineMedialInfo, if the segments are parallel, the \
solution is not unique.\
\>", "Text",
 CellChangeTimes->{{3.67645742926669*^9, 3.676457484858983*^9}, {
  3.676457523480654*^9, 
  3.676457523881397*^9}},ExpressionUUID->"ff3d6ff2-57c7-47c0-ab57-\
268a365fc022"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SegmentSegmentMedialInfo", "::", "badline"}], 
   "=", "\"\<Points `1` and `2` must be distinct.\>\""}], ";"}]], "Input",
 CellChangeTimes->{3.676414936047442*^9, 3.676416352555525*^9},
 CellLabel->
  "In[178]:=",ExpressionUUID->"f932dcaa-651c-4362-a138-caff1af9bff5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SegmentSegmentMedialInfo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_List", ",", "p2_List"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "dq", ",", "dp", ",", "dqp", ",", "dpdp", ",", "dpdq", ",", "dqdq", ",", 
      "det", ",", "tpq1", ",", "tpq2", ",", "dpdqp", ",", "dqdqp", ",", "tp", 
      ",", "tq", ",", "rp", ",", "rq", ",", "r", ",", "clist"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dp", "=", 
      RowBox[{"p2", "-", "p1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", "dp", "]"}], "\[Equal]", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "dp", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"SegmentSegmentMedialInfo", "::", "badline"}], ",", "p1", ",",
           "p2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"dq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", "dq", "]"}], "\[Equal]", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"Length", "[", "dq", "]"}], "}"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"SegmentSegmentMedialInfo", "::", "badline"}], ",", "q1", ",",
           "q2"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"dpdp", "=", 
      RowBox[{"dp", ".", "dp"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dpdq", "=", 
      RowBox[{"dp", ".", "dq"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dqdq", "=", 
      RowBox[{"dq", ".", "dq"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"det", "=", 
      RowBox[{
       SuperscriptBox["dpdq", "2"], "-", 
       RowBox[{"dpdp", " ", "dqdq"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Chop", "[", "det", "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"lines", " ", "are", " ", "parallel"}], ",", " ", 
         RowBox[{"construct", " ", "overlap", " ", "interval"}]}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"tpq1", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q1", "-", "p1"}], ")"}], ".", "dp"}], "/", "dpdp"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"tpq2", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q2", "-", "p1"}], ")"}], ".", "dp"}], "/", "dpdp"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"tpq1", ",", "tpq2"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"tpq1", ",", "tpq2"}], "]"}], ",", 
           RowBox[{"Max", "[", 
            RowBox[{"tpq1", ",", "tpq2"}], "]"}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"tpq1", "\[LessEqual]", "1"}], "&&", 
           RowBox[{"tpq2", "\[GreaterEqual]", "0"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"there", "'"}], "s", " ", "overlap"}], ",", " ", 
            RowBox[{
            "return", " ", "soln", " ", "for", " ", "midpoints", " ", "of", " ",
              "the", " ", "overlap"}]}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"tpq1", "=", 
            RowBox[{"Max", "[", 
             RowBox[{"tpq1", ",", "0"}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"tpq2", "=", 
            RowBox[{"Min", "[", 
             RowBox[{"tpq2", ",", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
           
           RowBox[{"tp", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"tpq1", "+", "tpq2"}], ")"}], "/", "2"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"rp", "=", 
            RowBox[{"p1", "+", 
             RowBox[{"tp", 
              RowBox[{"(", 
               RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"tq", "=", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"rp", "-", "q1"}], ")"}], ".", "dq"}], "/", "dqdq"}]}],
            ";", "\[IndentingNewLine]", 
           RowBox[{"rq", "=", 
            RowBox[{"q1", "+", 
             RowBox[{"tq", 
              RowBox[{"(", 
               RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"r", "=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"rp", "+", "rq"}], ")"}], "/", "2"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Return", "[", 
            RowBox[{"{", 
             RowBox[{"r", ",", 
              RowBox[{"Mag", "[", 
               RowBox[{"r", "-", "rp"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"clist", "=", 
           RowBox[{"{", "}"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"lines", " ", "are", " ", "not", " ", "parallel"}], ",", " ", 
         RowBox[{
          RowBox[{"construct", " ", "line"}], "-", 
          RowBox[{"line", " ", "solution"}]}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"dqp", "=", 
         RowBox[{"q1", "-", "p1"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dpdqp", "=", 
         RowBox[{"dp", ".", "dqp"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dqdqp", "=", 
         RowBox[{"dq", ".", "dqp"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"tp", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"dpdq", " ", "dqdqp"}], "-", 
            RowBox[{"dpdqp", " ", "dqdq"}]}], ")"}], "/", "det"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"tq", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"dpdp", " ", "dqdqp"}], "-", 
            RowBox[{"dpdq", " ", "dpdqp"}]}], ")"}], "/", "det"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rp", "=", 
         RowBox[{"p1", "+", 
          RowBox[{"tp", 
           RowBox[{"(", 
            RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rq", "=", 
         RowBox[{"q1", "+", 
          RowBox[{"tq", 
           RowBox[{"(", 
            RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rp", "+", "rq"}], ")"}], "/", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"clist", "=", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"r", ",", 
            RowBox[{"Mag", "[", 
             RowBox[{"r", "-", "rp"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}], "}"}]}]}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"JoinTo", "[", 
      RowBox[{"clist", ",", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointPointMedialInfo", "[", 
           RowBox[{"p1", ",", "q1"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointPointMedialInfo", "[", 
           RowBox[{"p1", ",", "q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointPointMedialInfo", "[", 
           RowBox[{"p2", ",", "q1"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointPointMedialInfo", "[", 
           RowBox[{"p2", ",", "q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{
               "#", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
              "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointLineMedialInfo", "[", 
           RowBox[{"p1", ",", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{
               "#", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
              "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointLineMedialInfo", "[", 
           RowBox[{"p2", ",", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "#", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",",
                "0"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointLineMedialInfo", "[", 
           RowBox[{"q1", ",", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
             "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
             RowBox[{
             "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
               "#", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",",
                "1"}], "}"}]}], "}"}], "&"}], "@", 
          RowBox[{"PointLineMedialInfo", "[", 
           RowBox[{"q2", ",", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}]}]}], "}"}]}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"clist", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"clist", ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"#", "\[LeftDoubleBracket]", 
            RowBox[{"3", ",", "1"}], "\[RightDoubleBracket]"}], "\[GreaterEqual]",
            "0"}], "&&", 
          RowBox[{
           RowBox[{"#", "\[LeftDoubleBracket]", 
            RowBox[{"3", ",", "1"}], "\[RightDoubleBracket]"}], "\[LessEqual]",
            "1"}], "&&", 
          RowBox[{
           RowBox[{"#", "\[LeftDoubleBracket]", 
            RowBox[{"3", ",", "2"}], "\[RightDoubleBracket]"}], "\[GreaterEqual]",
            "0"}], "&&", 
          RowBox[{
           RowBox[{"#", "\[LeftDoubleBracket]", 
            RowBox[{"3", ",", "2"}], "\[RightDoubleBracket]"}], "\[LessEqual]",
            "1"}]}], "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"clist", "=", 
      RowBox[{"Sort", "[", 
       RowBox[{"clist", ",", 
        RowBox[{
         RowBox[{
          RowBox[{
          "#1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "<", 
          RowBox[{
          "#2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
         "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "clist", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.676413351101513*^9, 3.676413372491542*^9}, {
   3.6764137367483597`*^9, 3.676413742503035*^9}, 3.6764137965368023`*^9, {
   3.676413917590886*^9, 3.676413934247726*^9}, {3.676414102699527*^9, 
   3.676414114313807*^9}, {3.676414358779552*^9, 3.6764144622210293`*^9}, {
   3.6764144982262173`*^9, 3.676414739013921*^9}, {3.676414853148744*^9, 
   3.67641488938238*^9}, {3.676414942573451*^9, 3.676414982657027*^9}, {
   3.676415538667207*^9, 3.676415674179595*^9}, {3.676415955938489*^9, 
   3.676416154102809*^9}, {3.676416353577881*^9, 3.676416356710905*^9}, {
   3.676416866782531*^9, 3.676416866924993*^9}, {3.676416917036166*^9, 
   3.676417045122828*^9}, {3.676417110958568*^9, 3.676417212766439*^9}, {
   3.676417247079025*^9, 3.676417343491501*^9}, {3.676417386230194*^9, 
   3.676417522678145*^9}, {3.676417568610133*^9, 3.676417853702039*^9}, {
   3.676417994305448*^9, 3.676418023134504*^9}, {3.676418331659846*^9, 
   3.676418389752802*^9}, {3.676418427741071*^9, 3.676418647955489*^9}, {
   3.676418681635855*^9, 3.676418764767803*^9}, {3.676418796257654*^9, 
   3.676418891428274*^9}, {3.676418930528074*^9, 3.676418987136548*^9}, {
   3.676419109748531*^9, 3.676419112162698*^9}, {3.676419178478318*^9, 
   3.67641919005395*^9}, {3.676419223498363*^9, 3.676419241916177*^9}, {
   3.676419307586755*^9, 3.676419309397852*^9}, {3.676419371695998*^9, 
   3.676419376013849*^9}, {3.676419426438626*^9, 3.676419428463004*^9}, {
   3.676457045461961*^9, 3.676457240308022*^9}, {3.676457548539756*^9, 
   3.676457548811901*^9}, {3.676457582609511*^9, 3.676457707131931*^9}, {
   3.676457757535515*^9, 3.676457774454932*^9}, {3.676457873580924*^9, 
   3.6764578760666847`*^9}, {3.676457936352128*^9, 3.676458028657406*^9}, {
   3.676458074683726*^9, 3.676458123711654*^9}, {3.676458685760338*^9, 
   3.676458779416954*^9}, {3.676458816205248*^9, 3.676458837525203*^9}, {
   3.676458878202649*^9, 3.676458881809461*^9}, {3.676458938548883*^9, 
   3.676459160211401*^9}, {3.676459201703311*^9, 3.676459228401264*^9}, {
   3.676459260264165*^9, 3.676459323311566*^9}, {3.676459421494244*^9, 
   3.6764595519184017`*^9}},
 CellLabel->
  "In[179]:=",ExpressionUUID->"8f25f29e-f9b0-4854-8694-8995543b3065"],

Cell["Example, 2D, parallel lines, overlapping.", "Text",
 CellChangeTimes->{{3.676414987544997*^9, 3.676415001360456*^9}, {
  3.67645731202383*^9, 3.676457314302273*^9}, {3.676459983292121*^9, 
  3.676459986963972*^9}},ExpressionUUID->"9396569d-de43-44ed-8d69-\
b3a9e5985d0c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tpair", 
      ",", "tp", ",", "tq", ",", "rp", ",", "rq"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{".8", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"SegmentSegmentMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"rp", "=", 
      RowBox[{"p1", "+", 
       RowBox[{"tp", 
        RowBox[{"(", 
         RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rq", "=", 
      RowBox[{"q1", "+", 
       RowBox[{"tq", 
        RowBox[{"(", 
         RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}], "]"}], ",", "Cyan"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Cyan", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], "]"}], "//",
       "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", 
       RowBox[{"{", 
        RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.67641499032905*^9, 3.676415226816463*^9}, {
   3.676415266227132*^9, 3.676415282836175*^9}, 3.676415687927701*^9, 
   3.6764168755776033`*^9, {3.676419149557317*^9, 3.676419165724881*^9}, {
   3.676419321520333*^9, 3.676419343565813*^9}, {3.676419394096096*^9, 
   3.676419400912242*^9}, {3.676457322208644*^9, 3.676457331134938*^9}, {
   3.676457370237444*^9, 3.676457411523007*^9}, {3.676458052073968*^9, 
   3.676458052467147*^9}, {3.676459566108409*^9, 3.676459566586415*^9}, {
   3.676459708905274*^9, 3.67645971065479*^9}, 3.676459979828382*^9, {
   3.676460106008816*^9, 3.676460108518302*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"162a2df0-160d-41ea-ac42-d620b70c7513"],

Cell["Example, 2D, parallel lines, nonoverlapping.", "Text",
 CellChangeTimes->{{3.676414987544997*^9, 3.676415001360456*^9}, {
  3.67645731202383*^9, 3.676457314302273*^9}, {3.676459983292121*^9, 
  3.676459996691633*^9}},ExpressionUUID->"ebc84539-55bc-4f15-b53c-\
36b99be68e60"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", ",", "tpair", 
      ",", "tp", ",", "tq", ",", "rp", ",", "rq"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1.5", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.5", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"SegmentSegmentMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"rp", "=", 
      RowBox[{"p1", "+", 
       RowBox[{"tp", 
        RowBox[{"(", 
         RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rq", "=", 
      RowBox[{"q1", "+", 
       RowBox[{"tq", 
        RowBox[{"(", 
         RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}], "]"}], ",", "Cyan"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", 
            RowBox[{"{", 
             RowBox[{"rp", ",", "rq"}], "}"}]}], ",", 
           RowBox[{"Darker", "[", "Cyan", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], "]"}], "//",
       "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"r", ",", "d", ",", 
       RowBox[{"{", 
        RowBox[{"tp", ",", "tq"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.67641499032905*^9, 3.676415226816463*^9}, {
   3.676415266227132*^9, 3.676415282836175*^9}, 3.676415687927701*^9, 
   3.6764168755776033`*^9, {3.676419149557317*^9, 3.676419165724881*^9}, {
   3.676419321520333*^9, 3.676419343565813*^9}, {3.676419394096096*^9, 
   3.676419400912242*^9}, {3.676457322208644*^9, 3.676457331134938*^9}, {
   3.676457370237444*^9, 3.676457411523007*^9}, {3.676458052073968*^9, 
   3.676458052467147*^9}, {3.676459566108409*^9, 3.676459566586415*^9}, {
   3.676459708905274*^9, 3.67645971065479*^9}, {3.676459979828382*^9, 
   3.67646000851807*^9}, {3.676460112112746*^9, 3.676460113844805*^9}},
 CellLabel->
  "In[181]:=",ExpressionUUID->"2a279c74-f0da-4401-bb40-d428845a2a06"],

Cell["\<\
Example. A bunch of random sets of 2D points. (Change SeedRandom[] to \
generate new sets.)\
\>", "Text",
 CellChangeTimes->{{3.676416469867331*^9, 3.676416504065241*^9}, {
  3.676416807529809*^9, 3.676416808022611*^9}, {3.676459690807356*^9, 
  3.676459700501903*^9}},ExpressionUUID->"9e9ab9fc-e92a-4a7a-ae71-\
23dff725b523"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "glist", ",", "p1", ",", "p2", ",", "q1", ",", "q2", ",", "r", ",", "d", 
      ",", "tpair", ",", "tp", ",", "tq", ",", "rp", ",", "rq"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"glist", "=", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p1", ",", "p2"}], "}"}], "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"q1", ",", "q2"}], "}"}], "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Random", "[", "]"}], ",", 
              RowBox[{"Random", "[", "]"}]}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
          RowBox[{"SegmentSegmentMedialInfo", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"tp", ",", "tq"}], "}"}], "=", "tpair"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rp", "=", 
          RowBox[{"p1", "+", 
           RowBox[{"tp", 
            RowBox[{"(", 
             RowBox[{"p2", "-", "p1"}], ")"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"rq", "=", 
          RowBox[{"q1", "+", 
           RowBox[{"tq", 
            RowBox[{"(", 
             RowBox[{"q2", "-", "q1"}], ")"}]}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}],
              ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"rp", ",", "rq"}], "}"}], "]"}], ",", "Cyan"}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "/@", 
                RowBox[{"{", 
                 RowBox[{"p1", ",", "p2"}], "}"}]}], ",", 
               RowBox[{"Darker", "[", "Red", "]"}], ",", 
               RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "/@", 
                RowBox[{"{", 
                 RowBox[{"q1", ",", "q2"}], "}"}]}], ",", 
               RowBox[{"Darker", "[", "Green", "]"}], ",", 
               RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "/@", 
                RowBox[{"{", 
                 RowBox[{"rp", ",", "rq"}], "}"}]}], ",", 
               RowBox[{"Darker", "[", "Cyan", "]"}], ",", 
               RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "[", "r", "]"}], ",", "Blue", ",", 
               RowBox[{"PointSize", "[", ".04", "]"}]}], "]"}]}], "}"}], ",", 
           
           RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", "12", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{"Partition", "[", 
       RowBox[{"glist", ",", "4"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.676416481969658*^9, 3.676416484507917*^9}, {
   3.676416518499123*^9, 3.676416720281666*^9}, {3.676416751087983*^9, 
   3.676416773508773*^9}, 3.676416877926505*^9, {3.676457293060301*^9, 
   3.676457293263808*^9}, {3.6764596772763243`*^9, 3.676459706078762*^9}, {
   3.706721073554389*^9, 3.706721111294298*^9}, {3.7067239288382483`*^9, 
   3.706723942225651*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"4fdd1a73-e723-4c5c-b1d4-991a6cff6816"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Distances", "Subsection",
 CellChangeTimes->{{3.7084004482768397`*^9, 
  3.708400449260713*^9}},ExpressionUUID->"c0768552-aca8-42d1-8e99-\
cdfa4c96cadd"],

Cell[CellGroupData[{

Cell[TextData[{
 "PointLineDistance[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]\nPointSegmentDistance[",
 StyleBox["p, ",
  FontSlant->"Italic"],
 "{",
 StyleBox["q1, q2",
  FontSlant->"Italic"],
 "}]\nPointTriangleDistance[",
 StyleBox["p, ",
  FontSlant->"Italic"],
 "{",
 StyleBox["q1, q2, q3",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.650065817658555*^9, 3.650065829825837*^9}, {
   3.650065902005149*^9, 3.650065902516796*^9}, 3.6764748106205273`*^9, {
   3.676475114912788*^9, 3.676475115528574*^9}, {3.7345536331760387`*^9, 
   3.7345536446593533`*^9}},ExpressionUUID->"7ca619e3-7111-4a5c-9dd8-\
10b5f2104042"],

Cell[TextData[{
 "PointLineDistance[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] returns the shortest distance from the point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " to the line passing through {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}."
}], "Text",
 CellChangeTimes->{{3.650065908028333*^9, 3.650065938386759*^9}, {
  3.676474810673546*^9, 3.6764748388048162`*^9}, {3.676474900212681*^9, 
  3.676474902460999*^9}},ExpressionUUID->"adc9b6a2-25cd-4ec1-8cb7-\
710d3ed25c4e"],

Cell["Used in rotational pots and in PtOnLineQ.", "Text",
 CellChangeTimes->{{3.676474706491631*^9, 3.6764747114087*^9}, {
  3.706715252645707*^9, 
  3.706715261692718*^9}},ExpressionUUID->"cdfa5586-04cb-4e09-8b3f-\
70c5df2536cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PointLineDistance", "[", 
   RowBox[{"p_", ",", 
    RowBox[{"{", 
     RowBox[{"q1_", ",", "q2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dq", ",", "tq"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tq", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "q1"}], ")"}], ".", "dq"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"dq", ".", "dq"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Mag", "[", 
      RowBox[{"p", "-", 
       RowBox[{"(", 
        RowBox[{"q1", "+", 
         RowBox[{"tq", " ", "dq"}]}], ")"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.523811195670919*^9, 3.523811235098943*^9}, 
   3.5238114323077602`*^9, 3.6500662042882223`*^9, {3.650066317457516*^9, 
   3.650066324540854*^9}, {3.650066360330264*^9, 3.650066364840724*^9}, 
   3.676474810696267*^9, {3.676474848461583*^9, 3.6764748676747503`*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"0d82af77-9fc4-4978-a337-14f1a0dcae4c"],

Cell["Example", "Text",
 CellChangeTimes->{{3.650066370703071*^9, 
  3.6500663713986397`*^9}},ExpressionUUID->"6e04fb41-a6d8-43cd-bc8d-\
1d97b87143a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q1", ",", "q2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0.5", ",", ".5"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"q1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".5", ",", "1"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", "p", "]"}], ",", "Red", ",", 
            RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], 
           "]"}]}], "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "True"}]}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"PointLineDistance", "[", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.650066375668965*^9, 3.650066554229354*^9}, {
   3.650066712294622*^9, 3.6500667396594343`*^9}, 3.676474810723462*^9},
 CellLabel->
  "In[184]:=",ExpressionUUID->"079475e5-9a64-406b-af22-7ca43f5c9db9"],

Cell[TextData[{
 "PointSegmentDistance[",
 StyleBox["p, ",
  FontSlant->"Italic"],
 "{",
 StyleBox["q1, q2",
  FontSlant->"Italic"],
 "}] returns the closest distance between the point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " and the line segment from ",
 StyleBox["q1",
  FontSlant->"Italic"],
 " to ",
 StyleBox["q2.",
  FontSlant->"Italic"],
 " We check the perpendicular distance and the distance from the endpoints."
}], "Text",
 CellChangeTimes->{{3.523811146462167*^9, 3.523811148124521*^9}, 
   3.523811432287949*^9, 3.650066251059156*^9, {3.650066591434909*^9, 
   3.650066593298012*^9}, 
   3.6764750362749577`*^9},ExpressionUUID->"63b3e8ab-f094-4dbe-960c-\
51d7a334baee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PointSegmentDistance", "[", 
   RowBox[{"p1_", ",", 
    RowBox[{"{", 
     RowBox[{"q1_", ",", "q2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dq", ",", "tq"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tq", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p1", "-", "q1"}], ")"}], ".", "dq"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"dq", ".", "dq"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Min", "[", 
      RowBox[{
       RowBox[{"Mag", "[", 
        RowBox[{"p1", "-", "q1"}], "]"}], ",", 
       RowBox[{"Mag", "[", 
        RowBox[{"p1", "-", "q2"}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"tq", ">", "0"}], "&&", 
          RowBox[{"tq", "<", "1"}]}], ",", 
         RowBox[{"Mag", "[", 
          RowBox[{"p1", "-", 
           RowBox[{"(", 
            RowBox[{"q1", "+", 
             RowBox[{"tq", " ", "dq"}]}], ")"}]}], "]"}], ",", 
         "\[Infinity]"}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.523811195670919*^9, 3.523811235098943*^9}, 
   3.5238114323077602`*^9, {3.65006658280785*^9, 3.650066601026156*^9}, {
   3.676474970234578*^9, 3.676475036293418*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"24ffb97a-b85a-4770-93ec-87947d84648f"],

Cell[TextData[{
 "PointTriangleDistance[ ",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q3",
  FontSlant->"Italic"],
 "}] returns the closest distance between the point p and the triangle {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q3",
  FontSlant->"Italic"],
 "}. We check the perpendicular distance to the (hyper)plane containing the \
three points, as well as distances to segments and endpoints."
}], "Text",
 CellChangeTimes->{{3.734552711884841*^9, 3.734552716100196*^9}, {
  3.73455279506139*^9, 3.734552824883873*^9}, {3.734553149947953*^9, 
  3.7345531849245977`*^9}, {3.734553687205434*^9, 
  3.734553690757855*^9}},ExpressionUUID->"2e8a985c-caf9-46bc-9d57-\
35e8c1262477"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PointTriangleDistance", "[", 
   RowBox[{"p_", ",", 
    RowBox[{"{", 
     RowBox[{"q1_", ",", "q2_", ",", "q3_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dist2", ",", "x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"dist2", "=", 
      RowBox[{"Mag2", "[", 
       RowBox[{"p", "-", 
        RowBox[{"(", 
         RowBox[{"q1", "+", 
          RowBox[{"x", 
           RowBox[{"(", 
            RowBox[{"q2", "-", "q1"}], ")"}]}], "+", 
          RowBox[{"y", 
           RowBox[{"(", 
            RowBox[{"q3", "-", "q1"}], ")"}]}]}], ")"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "/.", 
       RowBox[{
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"dist2", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"dist2", ",", "y"}], "]"}], "\[Equal]", "0"}]}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[LeftDoubleBracket]", 
        "1", "\[RightDoubleBracket]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Min", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
          RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
          RowBox[{
           RowBox[{"x", "+", "y"}], "\[LessEqual]", "1"}]}], ",", 
         SqrtBox["dist2"], ",", "\[Infinity]"}], "]"}], ",", 
       RowBox[{"PointSegmentDistance", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}], ",", 
       RowBox[{"PointSegmentDistance", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"q1", ",", "q3"}], "}"}]}], "]"}], ",", 
       RowBox[{"PointSegmentDistance", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"q2", ",", "q3"}], "}"}]}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.734553193359571*^9, 3.734553209747005*^9}, {
  3.7345533490440807`*^9, 3.73455347743755*^9}, {3.734553513856142*^9, 
  3.734553626325626*^9}, {3.734553749431962*^9, 3.734553784182215*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"ad72cf4e-4216-4768-889f-caac0d0fc158"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.7345532130371947`*^9, 
  3.734553213956531*^9}},ExpressionUUID->"a21d41c3-9841-4091-b56d-\
5efa9741952e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q1", ",", "q2", ",", "q3", ",", "dist"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "=", 
        RowBox[{"{", 
         RowBox[{"r", ",", ".5", ",", ".4"}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2", ",", "q3"}], "}"}], "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"dist", "=", 
        RowBox[{"PointTriangleDistance", "[", 
         RowBox[{"p", ",", 
          RowBox[{"{", 
           RowBox[{"q1", ",", "q2", ",", "q3"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"Polygon", "[", 
              RowBox[{"{", 
               RowBox[{"q1", ",", "q2", ",", "q3"}], "}"}], "]"}], ",", 
             "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"Point", "/@", 
              RowBox[{"{", 
               RowBox[{"q1", ",", "q2", ",", "q3"}], "}"}]}], ",", "Black", ",", 
             RowBox[{"PointSize", "[", ".01", "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"Point", "[", "p", "]"}], ",", "Red", ",", 
             RowBox[{"PointSize", "[", ".01", "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", "}"}]}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", "1"}], "}"}], ",", "All", ",", 
            "All"}], "}"}]}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"\"\<d = \>\"", "<>", 
           RowBox[{"ToString", "[", "dist", "]"}]}]}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"r", ",", ".4"}], "}"}], ",", 
        RowBox[{"-", ".5"}], ",", "1"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.734553215384907*^9, 3.7345533354447517`*^9}, {
  3.734553479965117*^9, 3.734553492709301*^9}, {3.7345537090491943`*^9, 
  3.734553718258573*^9}, {3.734553808320005*^9, 3.734554025900146*^9}},
 CellLabel->
  "In[187]:=",ExpressionUUID->"888dba5d-5220-4147-a8e1-2a8745872605"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "LineLineDistance[",
 StyleBox["{p1, p2}, {q1, q2}",
  FontSlant->"Italic"],
 "]\nSegmentSegmentDistance[",
 StyleBox["{p1, p2}, {q1, q2}",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.676474943845235*^9, 3.6764749456990433`*^9}, 
   3.676475810838809*^9, {3.6764761316576967`*^9, 3.67647613930299*^9}, {
   3.676476347007673*^9, 
   3.676476352673267*^9}},ExpressionUUID->"8ce166f3-1e7d-473b-83f4-\
0c6375662e43"],

Cell[TextData[{
 "LineLineDistance[",
 StyleBox["{p1, p2}, {q1, q2}",
  FontSlant->"Italic"],
 "] returns the closest distance between any points on the line through {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} and the line through {",
 StyleBox["q1,",
  FontSlant->"Italic"],
 " ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}",
 StyleBox[".",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.523811284362961*^9, 3.523811287330394*^9}, 
   3.523811413094408*^9, 3.650066254908202*^9, 3.676475810888836*^9, {
   3.676476187461822*^9, 
   3.676476248640048*^9}},ExpressionUUID->"ce3a7005-f096-4d14-b3c2-\
47ccf6c1a7fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineLineDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_", ",", "p2_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_", ",", "q2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"LineLineMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"2", "d"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.523811170074839*^9, 3.523811187718014*^9}, {
   3.523811413116151*^9, 3.5238114335241957`*^9}, {3.650066628377437*^9, 
   3.650066691489098*^9}, {3.676475036310405*^9, 3.676475036355715*^9}, 
   3.67647581091022*^9, {3.676475840969481*^9, 3.676475964517736*^9}, {
   3.676476254280607*^9, 3.676476270208001*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"36e5f47a-e6ba-4b73-b9ff-7fe9bb82c2bb"],

Cell["\<\
Example. (Note, point of closest approach is at the extension of the lower \
segment.)\
\>", "Text",
 CellChangeTimes->{{3.650066749160203*^9, 3.65006674993578*^9}, {
  3.676476280721055*^9, 3.676476281349887*^9}, {3.676476311780918*^9, 
  3.676476331858801*^9}},ExpressionUUID->"48b66f06-e2de-4fe4-adc4-\
510d8789861b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q1", "=", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", 
        RowBox[{"-", ".5"}], ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"q2", "=", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", ".5", ",", "1"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{"q1", ",", "q2"}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "True"}]}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"LineLineDistance", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p1", ",", "p2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.5239779811020412`*^9, 3.523978136431347*^9}, {
   3.6500667542488003`*^9, 3.650066754675585*^9}, 3.6764758109643087`*^9, 
   3.676476287420145*^9},
 CellLabel->
  "In[189]:=",ExpressionUUID->"3059baf5-8545-41ca-9df8-5e3569f6e0cb"],

Cell[TextData[{
 "SegmentSegmentDistance",
 "[",
 StyleBox["{p1, p2}, {q1, q2}",
  FontSlant->"Italic"],
 "] returns the closest distance between any points on the two lines segments \
from ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " to ",
 StyleBox["p2",
  FontSlant->"Italic"],
 " and from ",
 StyleBox["q1",
  FontSlant->"Italic"],
 " to ",
 StyleBox["q2.",
  FontSlant->"Italic"],
 " We check both the perpendicular distance and the distance from the \
endpoints, all combinations."
}], "Text",
 CellChangeTimes->{{3.523811284362961*^9, 3.523811287330394*^9}, 
   3.523811413094408*^9, 3.650066254908202*^9, 
   3.676475810888836*^9},ExpressionUUID->"83823026-54b3-4423-96a5-\
5090f410bb61"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SegmentSegmentDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_", ",", "p2_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_", ",", "q2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "d", ",", "tpair"}], "}"}], "=", 
      RowBox[{"LineLineMedialInfo", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Min", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "tpair", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "\[GreaterEqual]",
            "0"}], "&&", 
          RowBox[{
           RowBox[{
           "tpair", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "\[LessEqual]",
            "1"}], "&&", 
          RowBox[{
           RowBox[{
           "tpair", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "\[GreaterEqual]",
            "0"}], "&&", 
          RowBox[{
           RowBox[{
           "tpair", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "\[LessEqual]",
            "1"}]}], ",", 
         RowBox[{"2", "d"}], ",", "\[Infinity]"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PointSegmentDistance", "[", 
        RowBox[{"p1", ",", 
         RowBox[{"{", 
          RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PointSegmentDistance", "[", 
        RowBox[{"p2", ",", 
         RowBox[{"{", 
          RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PointSegmentDistance", "[", 
        RowBox[{"q1", ",", 
         RowBox[{"{", 
          RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PointSegmentDistance", "[", 
        RowBox[{"q2", ",", 
         RowBox[{"{", 
          RowBox[{"p1", ",", "p2"}], "}"}]}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.523811170074839*^9, 3.523811187718014*^9}, {
   3.523811413116151*^9, 3.5238114335241957`*^9}, {3.650066628377437*^9, 
   3.650066691489098*^9}, {3.676475036310405*^9, 3.676475036355715*^9}, 
   3.67647581091022*^9, {3.676475840969481*^9, 3.676475964517736*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"951a6d74-f229-4934-9b5d-94d1cb2251f2"],

Cell["Examples", "Text",
 CellChangeTimes->{{3.523977927972787*^9, 
  3.52397793140029*^9}},ExpressionUUID->"3954c040-348b-488e-86a7-\
021629ea3816"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q1", "=", 
      RowBox[{"{", 
       RowBox[{".5", ",", 
        RowBox[{"-", ".5"}], ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"q2", "=", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5", ",", "1"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{"q1", ",", "q2"}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "True"}]}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SegmentSegmentDistance", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p1", ",", "p2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.5239779811020412`*^9, 3.523978100767372*^9}, {
   3.523978144851656*^9, 3.523978148719086*^9}, {3.650066701076074*^9, 
   3.650066701518765*^9}, 3.676475810937419*^9},
 CellLabel->
  "In[191]:=",ExpressionUUID->"b139e335-dc36-484c-a8e8-d74b62f06dea"],

Cell["Another.", "Text",
 CellChangeTimes->{{3.650066749160203*^9, 
  3.65006674993578*^9}},ExpressionUUID->"5c291c35-3add-4274-9ada-\
a65685960a77"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q1", "=", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", 
        RowBox[{"-", ".5"}], ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"q2", "=", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", ".5", ",", "1"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{"q1", ",", "q2"}], "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "True"}]}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SegmentSegmentDistance", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p1", ",", "p2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.5239779811020412`*^9, 3.523978136431347*^9}, {
   3.6500667542488003`*^9, 3.650066754675585*^9}, 3.6764758109643087`*^9},
 CellLabel->
  "In[192]:=",ExpressionUUID->"e23b26bb-46f6-41c0-9502-5d2a12ac95ac"]
}, Closed]],

Cell["Coincidence", "Subsubsection",
 CellChangeTimes->{{3.7084004533565683`*^9, 
  3.708400455735162*^9}},ExpressionUUID->"2f5bf65b-e4ef-429c-a71a-\
7a21f6ba7046"],

Cell[CellGroupData[{

Cell[TextData[{
 "PtOnPtQ[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) PtOnPtTolerance\nPtOnLineQ[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) PtOnLineTolerance"
}], "Subsubsection",
 CellChangeTimes->{{3.70671475190221*^9, 3.7067147737345347`*^9}, 
   3.706714828002919*^9, {3.706714970763448*^9, 3.706714976520046*^9}, {
   3.7067150160132723`*^9, 3.706715016718647*^9}, {3.706715203632344*^9, 
   3.706715204996606*^9}},ExpressionUUID->"9510a1a3-a139-4193-963e-\
2ada1968b025"],

Cell[TextData[{
 "PtOnPtQ[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] returns True if the two points lie within a specified tolerance of each \
other."
}], "Text",
 CellChangeTimes->{{3.455895216389133*^9, 3.455895261668165*^9}, 
   3.594653989413974*^9, {3.70671470333142*^9, 3.706714705317891*^9}, {
   3.7067148437552853`*^9, 3.706714847817505*^9}, {3.706714894828562*^9, 
   3.706714899999475*^9}, {3.706715021103443*^9, 3.706715021782337*^9}, {
   3.706715614986587*^9, 
   3.70671561540871*^9}},ExpressionUUID->"420ce295-4303-470e-b4b7-\
4a47dc44c63b"],

Cell[TextData[{
 "Options:\n\tPtOnPtTolerance \[Rule] ",
 StyleBox["tol",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["tol",
  FontSlant->"Italic"],
 " is the separation distance below which the two points are considered the \
same."
}], "Text",
 CellChangeTimes->{{3.706714906168742*^9, 3.706714913582951*^9}, 
   3.706714981280258*^9},ExpressionUUID->"de823580-04df-4acc-bc57-\
15783ba515f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PtOnPtTolerance", "::", "usage"}], 
   "=", "\"\<PtOnPtTolerance is an option to PtOnPtQ that specifies how close \
two points can be to be considered the same point.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.594654261929364*^9, 3.594654291437753*^9}, 
   3.70671491904994*^9, {3.7067153862936373`*^9, 3.706715387814239*^9}},
 CellLabel->
  "In[193]:=",ExpressionUUID->"57c87147-9a69-45a2-9808-fa1201c78bbf"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "PtOnPtQ", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"PtOnPtTolerance", "\[Rule]", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.455895163155131*^9, 3.455895188406962*^9}, 
   3.594653990363317*^9, 3.706714923747237*^9, 3.706714985537903*^9},
 CellLabel->
  "In[194]:=",ExpressionUUID->"3da481da-32da-4e5d-b914-9846ef5113dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PtOnPtQ", "[", 
   RowBox[{"p__List", ",", "q__List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "tol", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"tol", "=", 
      RowBox[{
       RowBox[{"PtOnPtTolerance", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "PtOnPtQ", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Plus", "@@", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"p", "-", "q"}], ")"}], "2"]}], "\[LessEqual]", 
      SuperscriptBox["tol", "2"]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.455895138080786*^9, 3.455895158861995*^9}, {
   3.455895267092721*^9, 3.455895343112156*^9}, 3.594653991194743*^9, {
   3.706714928381206*^9, 3.7067149402261996`*^9}, {3.706714987601457*^9, 
   3.706714996044075*^9}, {3.706715417255285*^9, 3.706715421569096*^9}},
 CellLabel->
  "In[195]:=",ExpressionUUID->"1f8fd548-94f3-488a-bf1e-0195fabcbbc7"],

Cell["Example", "Text",
 CellChangeTimes->{{3.7067172261129837`*^9, 
  3.706717228193909*^9}},ExpressionUUID->"580f80f0-a9f0-47dd-9b4f-\
a14869da5cb6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "report", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"report", "[", 
       RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
      RowBox[{"Print", "[", 
       RowBox[{"{", 
        RowBox[{"p", ",", "q", ",", 
         RowBox[{"PtOnPtQ", "[", 
          RowBox[{"p", ",", "q"}], "]"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"report", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.000001", ",", "0"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"report", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0000011", ",", "0"}], "}"}]}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.706717229593638*^9, 3.706717335720745*^9}},
 CellLabel->
  "In[196]:=",ExpressionUUID->"6c955579-1ae6-4dae-9d06-1da29d6a6c71"],

Cell[TextData[{
 "PtOnLineQ[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] returns True if a point lies within a specified tolerance of a line."
}], "Text",
 CellChangeTimes->{{3.706715059553174*^9, 
  3.706715097769676*^9}},ExpressionUUID->"bdeb44cb-0b38-4498-92af-\
3c621ff59361"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["p",
  FontSlant->"Italic"],
 " \[LongDash] the point\n\t",
 StyleBox["q",
  FontSlant->"Italic"],
 " \[LongDash] a point on the line\n\t",
 StyleBox["r",
  FontSlant->"Italic"],
 " \[LongDash] a vector in the direction of the line."
}], "Text",
 CellChangeTimes->{{3.706715351532359*^9, 
  3.7067153699630957`*^9}},ExpressionUUID->"491a24bd-bf53-4060-bf40-\
01dd122fefe4"],

Cell[TextData[{
 "Options:\n\tPtOnLineTolerance \[Rule] ",
 StyleBox["tol",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["tol",
  FontSlant->"Italic"],
 " is the allowable separation distance between the point and line."
}], "Text",
 CellChangeTimes->{{3.706714906168742*^9, 3.706714913582951*^9}, 
   3.706714981280258*^9, {3.7067173565023756`*^9, 
   3.706717370743932*^9}},ExpressionUUID->"f1cf7af0-9ed0-4395-9ca0-\
3e7114d43c92"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PtOnLineTolerance", "::", "usage"}], 
   "=", "\"\<PtOnLineTolerance is an option to PtOnLineQ that specifies how \
close a point can be to a line to be considered on the line.\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.594654261929364*^9, 3.594654291437753*^9}, 
   3.70671491904994*^9, {3.7067153862936373`*^9, 3.706715387814239*^9}, {
   3.706715512760961*^9, 3.706715535403096*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"d271ff48-a108-4ab1-a565-84724faba194"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "PtOnLineQ", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"PtOnLineTolerance", "\[Rule]", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.706715466953574*^9, 3.706715487823256*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"3f200c29-0a44-49ad-8d5b-77c800cccd23"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PtOnLineQ", "[", 
   RowBox[{"p_List", ",", 
    RowBox[{"{", 
     RowBox[{"q_List", ",", "r_List"}], "}"}], ",", "opts___"}], "]"}], ":=", 
  
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "tol", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"tol", "=", 
      RowBox[{
       RowBox[{"PtOnLineTolerance", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "PtOnLineQ", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"PointLineDistance", "[", 
       RowBox[{"p", ",", 
        RowBox[{"{", 
         RowBox[{"q", ",", 
          RowBox[{"q", "+", "r"}]}], "}"}]}], "]"}], "\[LessEqual]", 
      "tol"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.706715341884752*^9, 3.706715346211063*^9}, {
  3.706715406548974*^9, 3.706715464813215*^9}, {3.706715495745906*^9, 
  3.706715501767511*^9}, {3.706715541707981*^9, 3.706715579963139*^9}},
 CellLabel->
  "In[199]:=",ExpressionUUID->"cdf28f23-2aba-42e8-8b4d-ae86c7d52822"],

Cell["Example", "Text",
 CellChangeTimes->{{3.7067172261129837`*^9, 
  3.706717228193909*^9}},ExpressionUUID->"bd078cb7-c08b-488f-be56-\
d1b53dd3807c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "report", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"report", "[", 
       RowBox[{"p_", ",", 
        RowBox[{"{", 
         RowBox[{"q_", ",", "r_"}], "}"}]}], "]"}], ":=", 
      RowBox[{"Print", "[", 
       RowBox[{"{", 
        RowBox[{"p", ",", "q", ",", 
         RowBox[{"PtOnLineQ", "[", 
          RowBox[{"p", ",", 
           RowBox[{"{", 
            RowBox[{"q", ",", "r"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"report", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.000001", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"report", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.0000011", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.706717229593638*^9, 3.706717335720745*^9}, {
  3.706717388267878*^9, 3.706717398612629*^9}, {3.706719088861892*^9, 
  3.706719155704013*^9}},
 CellLabel->
  "In[200]:=",ExpressionUUID->"40b1e936-8e55-457c-8473-ea0dd4455e6e"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Angles", "Subsection",
 CellChangeTimes->{{3.731921117886741*^9, 
  3.731921118662896*^9}},ExpressionUUID->"22dd72ba-0f17-4412-a2eb-\
c0d7635d9057"],

Cell[CellGroupData[{

Cell[TextData[{
 "ShortestAngle[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.483703494288868*^9, 3.483703500624413*^9}, {
   3.496237066529303*^9, 3.496237072826506*^9}, 3.591978848529223*^9, 
   3.628786344413597*^9, {3.731921124388052*^9, 
   3.731921124630976*^9}},ExpressionUUID->"20ad298a-e5fb-450a-bf9d-\
e28c14d012f6"],

Cell[TextData[{
 "ShortestAngle[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "] returns the angle between ",
 StyleBox["a",
  FontSlant->"Italic"],
 " and ",
 StyleBox["b",
  FontSlant->"Italic"],
 " via the shortest route. Result lies in the range of built-in function \
ArcCos, ie.,  [0,\[Pi]]. Neither vector should be zero-length."
}], "Text",
 CellChangeTimes->{{3.483703502848235*^9, 3.483703519742947*^9}, {
   3.483704440057274*^9, 3.483704442990102*^9}, {3.483705138036894*^9, 
   3.483705183928196*^9}, {3.496237066546876*^9, 3.496237072858491*^9}, 
   3.496237120583181*^9, {3.496237355408513*^9, 3.496237382111553*^9}, 
   3.591978848628744*^9, 3.62878634449605*^9, {3.731921126176671*^9, 
   3.7319211264018993`*^9}},ExpressionUUID->"a353f935-b7b0-4ecb-b297-\
2e7d22b82414"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ShortestAngle", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"ArcCos", "[", 
   FractionBox[
    RowBox[{"a", ".", "b"}], 
    RowBox[{
     RowBox[{"Mag", "[", "a", "]"}], 
     RowBox[{"Mag", "[", "b", "]"}]}]], "]"}]}]], "Input",
 CellChangeTimes->{{3.483704454339412*^9, 3.483704608566489*^9}, {
   3.483705018280308*^9, 3.483705123031788*^9}, 3.483705191308157*^9, {
   3.4962370666006*^9, 3.496237072929892*^9}, {3.496237191146319*^9, 
   3.4962372112622766`*^9}, {3.496237296433427*^9, 3.496237309587647*^9}, 
   3.591978848654351*^9, 3.628786344519286*^9, {3.731921134413327*^9, 
   3.731921134711407*^9}},
 CellLabel->
  "In[201]:=",ExpressionUUID->"ae067acf-73ac-426d-8465-d6ba37a627bf"],

Cell["Example", "Text",
 CellChangeTimes->{{3.483705194191435*^9, 
  3.483705194807159*^9}},ExpressionUUID->"6a034249-77f7-4bcd-a067-\
0853306bb291"],

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "p", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ShortestAngle", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ShortestAngle", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ShortestAngle", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ShortestAngle", "[", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", ".1", ",", ".1"}], "}"}]}], "]"}]}], "}"}], "//", 
     "ShowExample"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.483705196245737*^9, 3.483705285283189*^9}, {
  3.496237066702495*^9, 3.496237090769497*^9}, {3.496237396708674*^9, 
  3.496237411352479*^9}, {3.591978848663704*^9, 3.591978848711415*^9}, {
  3.628786344531215*^9, 3.628786344576857*^9}, {3.731921140336618*^9, 
  3.731921143454486*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"b9a54fbf-b276-4569-903b-4c0fdc628389"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Triangulation", "Subsection",
 CellChangeTimes->{{3.708348353092257*^9, 
  3.708348357011585*^9}},ExpressionUUID->"8387ee2d-a708-4303-9780-\
9aceb44e02d4"],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangulatePolygon[",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["face",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{
  3.708393402163159*^9, 3.70839841135*^9, {3.708599275807559*^9, 
   3.708599285800481*^9}},ExpressionUUID->"e1526f90-a1cc-4652-8cf2-\
818602312755"],

Cell[TextData[{
 "TriangulatePolygon[",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["face",
  FontSlant->"Italic"],
 "] takes a list of 2D or 3D points and a \[OpenCurlyDoubleQuote]nice\
\[CloseCurlyDoubleQuote] polygon defined on those points and produces a \
triangulation of the polygon."
}], "Text",
 CellChangeTimes->{{3.708348774986329*^9, 3.70834884976455*^9}, {
   3.708361708575115*^9, 3.70836172551789*^9}, {3.708361998301497*^9, 
   3.7083620049069858`*^9}, {3.708393428925648*^9, 3.708393434912051*^9}, {
   3.7083938419966407`*^9, 3.708393842568277*^9}, 3.708398411399548*^9, {
   3.708599275854775*^9, 
   3.708599285847231*^9}},ExpressionUUID->"8ae8dc48-bbf9-4988-b7a1-\
6af680e8381c"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["verts",
  FontSlant->"Italic"],
 " \[LongDash] the vertices of the polygon\n\t",
 StyleBox["face",
  FontSlant->"Italic"],
 " \[LongDash] a list of indices into verts that defines the polygon."
}], "Text",
 CellChangeTimes->{{3.708361737147257*^9, 3.708361768942737*^9}, {
  3.708599275902316*^9, 
  3.708599285896358*^9}},ExpressionUUID->"d4664996-f5ff-4267-a3bb-\
1f4e4993eb67"],

Cell[TextData[{
 "Returns: a list {",
 StyleBox["edges",
  FontSlant->"Italic"],
 ", ",
 StyleBox["faces",
  FontSlant->"Italic"],
 "} where \n\t",
 StyleBox["edges",
  FontSlant->"Italic"],
 " are the newly added edges\n\t",
 StyleBox["faces",
  FontSlant->"Italic"],
 " is a list of all triangles\nboth given as indices into verts."
}], "Text",
 CellChangeTimes->{{3.708361773883309*^9, 3.708361821262312*^9}, {
   3.7083933510323896`*^9, 3.708393369742218*^9}, {3.70839385902199*^9, 
   3.708393895507002*^9}, 
   3.708599275991943*^9},ExpressionUUID->"a74b6f6d-ad5d-43a3-ae79-\
6a2bf2820ab2"],

Cell["\<\
We use a greedy algorithm: we always cut off the sharpest remaining corner of \
the polygon. This works for both 2D and 3D polygons.\
\>", "Text",
 CellChangeTimes->{{3.708362135652536*^9, 3.708362160347647*^9}, {
  3.708363166945537*^9, 
  3.708363186442292*^9}},ExpressionUUID->"8355410a-0104-4a71-994d-\
eb0de184589a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TriangulatePolygon", "::", "badpoly"}], 
   "=", "\"\<Polygon `1` has fewer than 3 vertices.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.708362268854452*^9, 3.708362281763666*^9}, 
   3.708398411420708*^9},
 CellLabel->
  "In[203]:=",ExpressionUUID->"7abe259e-82ea-4b99-889e-b4ce0d74bebd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangulatePolygon", "[", 
   RowBox[{"verts_List", ",", " ", "face_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "n", ",", "edges", ",", "faces", ",", "wpoly", ",", "wi", ",", "acos", ",",
       "work", ",", "idrop"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"Length", "[", "face", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", "<", "3"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"TriangulatePolygon", "::", "badpoly"}], ",", "face"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", "\[Equal]", "3"}], ",", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "face", "}"}]}], "}"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"faces", "=", 
      RowBox[{"edges", "=", 
       RowBox[{"{", "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"wpoly", "=", "face"}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"working", " ", "polygon"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "modulo", " ", "indexing", " ", "into", " ", "working", " ", 
       "polygon"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"wi", "[", "i_", "]"}], ":=", 
      RowBox[{"Mod", "[", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "wpoly", "]"}], ",", "1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "angle", " ", "cosine", " ", "of", " ", "ith", " ", "vertex", " ", "of",
        " ", "working", " ", "polygon"}], " ", "*)"}], "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"acos", "[", "i_", "]"}], ":=", 
      RowBox[{
       RowBox[{"NormalizeReal", "[", 
        RowBox[{
         RowBox[{"verts", "\[LeftDoubleBracket]", 
          RowBox[{"wpoly", "\[LeftDoubleBracket]", 
           RowBox[{"wi", "[", 
            RowBox[{"i", "+", "1"}], "]"}], "\[RightDoubleBracket]"}], 
          "\[RightDoubleBracket]"}], "-", 
         RowBox[{"verts", "\[LeftDoubleBracket]", 
          RowBox[{
          "wpoly", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
          "\[RightDoubleBracket]"}]}], "]"}], ".", 
       RowBox[{"NormalizeReal", "[", 
        RowBox[{
         RowBox[{"verts", "\[LeftDoubleBracket]", 
          RowBox[{
          "wpoly", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
          "\[RightDoubleBracket]"}], "-", 
         RowBox[{"verts", "\[LeftDoubleBracket]", 
          RowBox[{"wpoly", "\[LeftDoubleBracket]", 
           RowBox[{"wi", "[", 
            RowBox[{"i", "-", "1"}], "]"}], "\[RightDoubleBracket]"}], 
          "\[RightDoubleBracket]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"(*", " ", 
      RowBox[{
      "table", " ", "matching", " ", "working", " ", "face", " ", "index", " ",
        "with", " ", "its", " ", "corner", " ", "angle"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"work", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{
          "face", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], ",", 
          RowBox[{"acos", "[", "i", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"idrop", "=", 
         RowBox[{
          RowBox[{"Sort", "[", 
           RowBox[{"work", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"#1", "\[LeftDoubleBracket]", 
               RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], "<", 
              RowBox[{"#2", "\[LeftDoubleBracket]", 
               RowBox[{"-", "1"}], "\[RightDoubleBracket]"}]}], "&"}]}], 
           "]"}], "\[LeftDoubleBracket]", 
          RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"edges", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"wpoly", "\[LeftDoubleBracket]", 
             RowBox[{"wi", "[", 
              RowBox[{"idrop", "-", "1"}], "]"}], "\[RightDoubleBracket]"}], ",", 
            RowBox[{"wpoly", "\[LeftDoubleBracket]", 
             RowBox[{"wi", "[", 
              RowBox[{"idrop", "+", "1"}], "]"}], "\[RightDoubleBracket]"}]}],
            "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"faces", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"wpoly", "\[LeftDoubleBracket]", 
             RowBox[{"wi", "[", 
              RowBox[{"idrop", "-", "1"}], "]"}], "\[RightDoubleBracket]"}], ",", 
            RowBox[{
            "wpoly", "\[LeftDoubleBracket]", "idrop", 
             "\[RightDoubleBracket]"}], ",", 
            RowBox[{"wpoly", "\[LeftDoubleBracket]", 
             RowBox[{"wi", "[", 
              RowBox[{"idrop", "+", "1"}], "]"}], "\[RightDoubleBracket]"}]}],
            "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"wpoly", "=", 
         RowBox[{"Drop", "[", 
          RowBox[{"wpoly", ",", 
           RowBox[{"{", "idrop", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"work", "=", 
         RowBox[{"Drop", "[", 
          RowBox[{"work", ",", 
           RowBox[{"{", "idrop", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"work", "\[LeftDoubleBracket]", 
            RowBox[{"i", ",", "1"}], "\[RightDoubleBracket]"}], "=", "i"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "work", "]"}]}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", "=", 
            RowBox[{"wi", "[", 
             RowBox[{"idrop", "-", "1"}], "]"}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"work", "\[LeftDoubleBracket]", 
            RowBox[{"i", ",", 
             RowBox[{"-", "1"}]}], "\[RightDoubleBracket]"}], "=", 
           RowBox[{"acos", "[", "i", "]"}]}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", "=", 
            RowBox[{"wi", "[", "idrop", "]"}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"work", "\[LeftDoubleBracket]", 
            RowBox[{"i", ",", 
             RowBox[{"-", "1"}]}], "\[RightDoubleBracket]"}], "=", 
           RowBox[{"acos", "[", "i", "]"}]}]}], "]"}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"n", "-", "3"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"faces", ",", "wpoly"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"edges", ",", "faces"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.70834856289865*^9, 3.70834859322001*^9}, 
   3.708348763152238*^9, 3.708361733616488*^9, {3.7083621648485823`*^9, 
   3.708362331523113*^9}, {3.7083623980506897`*^9, 3.708362435976386*^9}, {
   3.708362486326182*^9, 3.708363123300564*^9}, {3.708363208141361*^9, 
   3.708363223186257*^9}, {3.708363396136546*^9, 3.708363418151813*^9}, {
   3.708363457750341*^9, 3.708363496868574*^9}, {3.708363527762455*^9, 
   3.708363580796251*^9}, {3.708363619364928*^9, 3.708363923052734*^9}, {
   3.708363956940514*^9, 3.708363977790237*^9}, {3.708364027534061*^9, 
   3.70836405984983*^9}, {3.70836410720124*^9, 3.708364192505002*^9}, {
   3.708364375687353*^9, 3.708364429608986*^9}, {3.708364481673118*^9, 
   3.708364509787885*^9}, {3.708364578803184*^9, 3.708364581369047*^9}, {
   3.708364628628248*^9, 3.70836463216067*^9}, {3.708364668976601*^9, 
   3.708364671906135*^9}, {3.708393177468892*^9, 3.708393341314251*^9}, {
   3.708393377996512*^9, 3.708393381939849*^9}, {3.708393563101615*^9, 
   3.708393566384047*^9}, {3.708398411443645*^9, 3.708398411465304*^9}, {
   3.708599275609204*^9, 3.708599301304662*^9}},
 CellLabel->
  "In[204]:=",ExpressionUUID->"02091989-a106-4c2c-889c-449e263efd01"],

Cell["Example: 2D.", "Text",
 CellChangeTimes->{{3.708363137366496*^9, 3.708363139689914*^9}, {
   3.708393772194098*^9, 3.708393774261231*^9}, 
   3.708398528167449*^9},ExpressionUUID->"a0818092-acc0-4ae7-9c46-\
fd471c952aab"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"verts", ",", "mr", ",", "face", ",", "edges", ",", "faces"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", ".1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.2", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"face", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"edges", ",", "faces"}], "}"}], "=", 
      RowBox[{"TriangulatePolygon", "[", 
       RowBox[{"verts", ",", "face"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<new edges = \>\"", ",", "edges"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<new faces = \>\"", ",", "faces"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Polygon", "[", "face", "]"}]}], "]"}], ",", 
             "LightGray"}], "]"}], ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{"i", ",", 
               RowBox[{
               "verts", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "verts", "]"}]}], "}"}]}], "]"}]}], 
          "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Polygon", "/@", "faces"}]}], "]"}], ",", 
             "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Line", "/@", "edges"}]}], "]"}], ",", "Red"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{"i", ",", 
               RowBox[{
               "verts", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "verts", "]"}]}], "}"}]}], "]"}]}], 
          "}"}], "]"}]}], "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.708348756145363*^9, 3.708348767932206*^9}, {
   3.708355266341501*^9, 3.708355357863364*^9}, {3.70835539202326*^9, 
   3.708355418689129*^9}, {3.708361371188949*^9, 3.708361494690921*^9}, {
   3.7083631436250257`*^9, 3.708363162875545*^9}, {3.708363249993469*^9, 
   3.708363312057165*^9}, {3.708363342648616*^9, 3.708363368379233*^9}, {
   3.708363507835428*^9, 3.708363508079567*^9}, {3.70836423294149*^9, 
   3.708364327307126*^9}, {3.708364716154961*^9, 3.708364724502797*^9}, {
   3.708364811727537*^9, 3.708364826275444*^9}, {3.708393164017096*^9, 
   3.708393165776238*^9}, {3.708393503441965*^9, 3.70839352574881*^9}, {
   3.708393590591126*^9, 3.708393744003847*^9}, 3.708398411482404*^9, {
   3.708398507376479*^9, 3.708398522923065*^9}, {3.70839943785648*^9, 
   3.70839944016698*^9}, 3.70839986384701*^9, {3.708599275653306*^9, 
   3.708599285741743*^9}},
 CellLabel->
  "In[205]:=",ExpressionUUID->"37ce9b48-f5bd-481d-b945-e17f08085a71"],

Cell["Example: 3D.", "Text",
 CellChangeTimes->{{3.708363137366496*^9, 3.708363139689914*^9}, {
   3.708393772194098*^9, 3.708393812026971*^9}, 
   3.708398541875492*^9},ExpressionUUID->"292e3657-617a-4632-be24-\
a861d90ff542"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"verts", ",", "mr", ",", "face", ",", "edges", ",", "faces"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", ".1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.2", ",", "1.5", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"face", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"edges", ",", "faces"}], "}"}], "=", 
      RowBox[{"TriangulatePolygon", "[", 
       RowBox[{"verts", ",", "face"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<new edges = \>\"", ",", "edges"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<new faces = \>\"", ",", "faces"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Polygon", "[", "face", "]"}]}], "]"}], ",", 
             "LightGray"}], "]"}], ",", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{"i", ",", 
               RowBox[{
               "verts", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "verts", "]"}]}], "}"}]}], "]"}]}], 
          "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Polygon", "/@", "faces"}]}], "]"}], ",", 
             "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Line", "/@", "edges"}]}], "]"}], ",", "Red"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{"i", ",", 
               RowBox[{
               "verts", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "verts", "]"}]}], "}"}]}], "]"}]}], 
          "}"}], "]"}]}], "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.708348756145363*^9, 3.708348767932206*^9}, {
   3.708355266341501*^9, 3.708355357863364*^9}, {3.70835539202326*^9, 
   3.708355418689129*^9}, {3.708361371188949*^9, 3.708361494690921*^9}, {
   3.7083631436250257`*^9, 3.708363162875545*^9}, {3.708363249993469*^9, 
   3.708363312057165*^9}, {3.708363342648616*^9, 3.708363368379233*^9}, {
   3.708363507835428*^9, 3.708363508079567*^9}, {3.70836423294149*^9, 
   3.708364327307126*^9}, {3.708364716154961*^9, 3.708364724502797*^9}, {
   3.708364811727537*^9, 3.708364826275444*^9}, {3.708393164017096*^9, 
   3.708393165776238*^9}, {3.708393503441965*^9, 3.70839352574881*^9}, {
   3.708393590591126*^9, 3.708393744003847*^9}, {3.708393787406952*^9, 
   3.7083937953912*^9}, 3.708398411504988*^9, {3.708399418280916*^9, 
   3.708399429691652*^9}, 3.70839985770277*^9, {3.708599275697847*^9, 
   3.708599285764289*^9}},
 CellLabel->
  "In[206]:=",ExpressionUUID->"2bd957db-1031-4d28-b095-269e7293fcc6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangulatePolygons[",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["faces",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.708398359390275*^9, 3.7083983873680696`*^9}, {
   3.708590976610017*^9, 3.7085909771850033`*^9}, 3.7085993781331*^9, {
   3.708601999539541*^9, 
   3.708602000061534*^9}},ExpressionUUID->"f8a42810-5155-40d9-a35d-\
6e0775e95a1c"],

Cell[TextData[{
 "TriangulatePolygons[",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["faces",
  FontSlant->"Italic"],
 "] triangulates all polygons in a list of polygonal faces."
}], "Text",
 CellChangeTimes->{{3.708398773387298*^9, 3.708398802253656*^9}, 
   3.708590980949516*^9, 3.708599378197525*^9, {3.708602002981875*^9, 
   3.708602003421485*^9}},ExpressionUUID->"68f7b0b7-3944-4a0a-aede-\
7ed717cb07f5"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["verts",
  FontSlant->"Italic"],
 " \[LongDash] a list of all vertices.\n\t",
 StyleBox["faces",
  FontSlant->"Italic"],
 " \[LongDash] a list of all faces to be triangulated."
}], "Text",
 CellChangeTimes->{{3.708398805169705*^9, 3.7083988471611843`*^9}, 
   3.708590982254633*^9, 
   3.708602006970419*^9},ExpressionUUID->"34740f2d-f387-4d12-a442-\
ec6a5a683967"],

Cell[TextData[{
 "Returns: a list {",
 StyleBox["nedges",
  FontSlant->"Italic"],
 ", ",
 StyleBox["nfaces",
  FontSlant->"Italic"],
 "} where\n\t",
 StyleBox["nedges",
  FontSlant->"Italic"],
 " is a list of the newly added edges\n\t",
 StyleBox["nfaces",
  FontSlant->"Italic"],
 " is a list of all triangular faces."
}], "Text",
 CellChangeTimes->{{3.708398849494349*^9, 3.7083989066978292`*^9}, {
  3.708602011426627*^9, 
  3.708602014998817*^9}},ExpressionUUID->"bc9191c7-eafa-472e-850c-\
3dd8cfdbdb69"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangulatePolygons", "[", 
   RowBox[{"verts_List", ",", "faces_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nedges", ",", "nfaces"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"nedges", ",", "nfaces"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"JoinTo", "[", 
          RowBox[{"nedges", ",", 
           RowBox[{
           "#", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
          "]"}], ";", 
         RowBox[{"JoinTo", "[", 
          RowBox[{"nfaces", ",", 
           RowBox[{
           "#", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
          "]"}]}], ")"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"TriangulatePolygon", "[", 
          RowBox[{
           StyleBox["verts",
            FontSlant->"Italic"], ",", "#"}], "]"}], "&"}], "/@", "faces"}], 
       ")"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"nedges", ",", 
         RowBox[{"SameTest", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"#1", "\[Equal]", "#2"}], "||", 
             RowBox[{"#1", "\[Equal]", 
              RowBox[{"Reverse", "[", "#2", "]"}]}]}], "&"}], ")"}]}]}], 
        "]"}], ",", "nfaces"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.708398425250193*^9, 3.708398467907909*^9}, {
   3.708398924515944*^9, 3.708399211878178*^9}, {3.708399462637038*^9, 
   3.708399480263637*^9}, {3.708399521668884*^9, 3.708399532393227*^9}, 
   3.708399686624118*^9, {3.708399752626367*^9, 3.708399757057613*^9}, {
   3.708590989830708*^9, 3.708591005795041*^9}, 3.708599378220641*^9, {
   3.708602026435761*^9, 3.7086020321258*^9}, {3.731515105647159*^9, 
   3.73151512672754*^9}},
 CellLabel->
  "In[207]:=",ExpressionUUID->"a2375e8d-d6bb-4a82-966d-66d50ee49373"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.708398470304282*^9, 3.708398471054017*^9}, {
   3.708399727794736*^9, 3.708399746756274*^9}, 
   3.7083998118464627`*^9},ExpressionUUID->"675c9004-785d-4333-b51c-\
0ec09e8b166c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "verts", ",", "edges", ",", "faces", ",", "nedges", ",", "nfaces"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.2", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"edges", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "3"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"faces", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "7", ",", "3", ",", "2"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"nedges", ",", "nfaces"}], "}"}], "=", 
      RowBox[{"TriangulatePolygons", "[", 
       RowBox[{"verts", ",", "faces"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<new edges = \>\"", ",", "nedges"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<new faces = \>\"", ",", "nfaces"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Polygon", "/@", "faces"}]}], "]"}], ",", 
             "LightGray"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Line", "/@", "edges"}]}], "]"}], ",", "Red"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{"i", ",", 
               RowBox[{
               "verts", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "verts", "]"}]}], "}"}]}], "]"}]}], 
          "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Polygon", "/@", "nfaces"}]}], "]"}], ",", 
             "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Line", "/@", "edges"}]}], "]"}], ",", "Red"}], "]"}], 
           ",", "\[IndentingNewLine]", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"GraphicsComplex", "[", 
              RowBox[{"verts", ",", 
               RowBox[{"Line", "/@", "nedges"}]}], "]"}], ",", "Green"}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{"i", ",", 
               RowBox[{
               "verts", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"Length", "[", "verts", "]"}]}], "}"}]}], "]"}]}], 
          "}"}], "]"}]}], "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.708348756145363*^9, 3.708348767932206*^9}, {
   3.708355266341501*^9, 3.708355357863364*^9}, {3.70835539202326*^9, 
   3.708355418689129*^9}, {3.708361371188949*^9, 3.708361494690921*^9}, {
   3.7083631436250257`*^9, 3.708363162875545*^9}, {3.708363249993469*^9, 
   3.708363312057165*^9}, {3.708363342648616*^9, 3.708363368379233*^9}, {
   3.708363507835428*^9, 3.708363508079567*^9}, {3.70836423294149*^9, 
   3.708364327307126*^9}, {3.708364716154961*^9, 3.708364724502797*^9}, {
   3.708364811727537*^9, 3.708364826275444*^9}, {3.708393164017096*^9, 
   3.708393165776238*^9}, {3.708393503441965*^9, 3.70839352574881*^9}, {
   3.708393590591126*^9, 3.708393744003847*^9}, 3.708398411482404*^9, {
   3.708398507376479*^9, 3.708398522923065*^9}, {3.708399231314256*^9, 
   3.708399255863941*^9}, {3.708399295439274*^9, 3.708399387602161*^9}, {
   3.708399567678236*^9, 3.708399593464061*^9}, {3.708399678487959*^9, 
   3.708399682137273*^9}, {3.708399775231106*^9, 3.708399840546509*^9}, 
   3.708599378249707*^9, {3.708602073233095*^9, 3.708602128615753*^9}},
 CellLabel->
  "In[208]:=",ExpressionUUID->"1a78b3e8-933d-42c8-872a-bb110ce9be11"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangulateGC[",
 StyleBox["gc",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.708602218616752*^9, 
  3.708602223766712*^9}},ExpressionUUID->"72c9e604-1485-4be1-b7cb-\
0a3f950e39e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangulateGC", "[", "gc_GraphicsComplex", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "verts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"gc", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"gc", "/.", 
      RowBox[{
       RowBox[{"Polygon", "[", "pl_", "]"}], "\[RuleDelayed]", 
       RowBox[{"Polygon", "/@", 
        RowBox[{
         RowBox[{"TriangulatePolygon", "[", 
          RowBox[{"verts", ",", "pl"}], "]"}], "\[LeftDoubleBracket]", "2", 
         "\[RightDoubleBracket]"}]}]}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7086022286354*^9, 3.708602341710484*^9}},
 CellLabel->
  "In[209]:=",ExpressionUUID->"8a72fa42-ddd3-480b-a52f-625ec8e0874a"],

Cell["Example", "Text",
 CellChangeTimes->{{3.708602347356814*^9, 
  3.708602348226057*^9}},ExpressionUUID->"2d8b0cee-42f7-4dc3-8149-\
188fe254bee8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "gc", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"gc", "=", 
      RowBox[{"GraphicsComplex", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TriangulateGC", "[", "gc", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.708602361609173*^9, 3.708602415440477*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"f83c5344-8d25-4637-9cdd-50e3b3f1c31a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangulateGCs[",
 StyleBox["expr",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.708599136235019*^9, 
  3.7085991431322336`*^9}},ExpressionUUID->"5a5fdba6-0417-4de7-b00b-\
ca3f149548b1"],

Cell["\<\
TriangulateGCs[expr] takes an expression and replaces any Polygon objects \
with 4 or more vertices with a list of Polygons with exactly 3 vertices, \
leaving any other elements unchanged.\
\>", "Text",
 CellChangeTimes->{{3.708599148225315*^9, 
  3.708599201488991*^9}},ExpressionUUID->"0a8d4e67-78ab-488b-b0de-\
0796355a1ae5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangulateGCs", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{"gc_GraphicsComplex", "\[RuleDelayed]", 
    RowBox[{"TriangulateGC", "[", "gc", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7086021716227*^9, 3.708602203985577*^9}, {
  3.70860243085857*^9, 3.708602450624359*^9}},
 CellLabel->
  "In[211]:=",ExpressionUUID->"2d686da3-b3f8-4868-adc9-ae894aa0d011"],

Cell["Example", "Text",
 CellChangeTimes->{{3.708602347356814*^9, 
  3.708602348226057*^9}},ExpressionUUID->"e1cc9f8b-645b-4b93-9cd8-\
310a14cf59be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "expr", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"expr", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GraphicsComplex", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
         "]"}], ",", 
        RowBox[{"GraphicsComplex", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}], 
         "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"TriangulateGCs", "[", "expr", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.708602361609173*^9, 3.708602415440477*^9}, {
  3.708602474783844*^9, 3.708602508553864*^9}},
 CellLabel->
  "In[212]:=",ExpressionUUID->"be3220f3-d287-48ba-8eae-98a793b46efa"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2D geometry", "Section",
 CellChangeTimes->{{3.595972910349372*^9, 3.595972913251588*^9}, {
  3.595974517500028*^9, 
  3.59597452313913*^9}},ExpressionUUID->"1f83298d-98cb-4a89-ba70-\
a84af2f02d87"],

Cell[CellGroupData[{

Cell["Unit vectors", "Subsection",
 CellChangeTimes->{{3.4575293951612*^9, 3.45752940487869*^9}, {
   3.650297038896203*^9, 3.650297040168262*^9}, 
   3.708401031669035*^9},ExpressionUUID->"48677a73-2184-415e-a77d-\
f1a29774f954"],

Cell[CellGroupData[{

Cell[TextData[{
 "U[\[Phi]]\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"U", "[", 
    RowBox[{
     SubscriptBox["\[Phi]", "1"], ",", 
     SubscriptBox["\[Phi]", "2"], ",", "..."}]}], TraditionalForm]],
  ExpressionUUID->"5d322595-cfaf-46f2-9663-a6dfee800f5e"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.457529298008823*^9, 
  3.457529360289851*^9}},ExpressionUUID->"1791f8ab-40f6-4929-8273-\
bd627d4dcfe0"],

Cell[TextData[{
 "U[\[Phi]] returns a unit vector at angle \[Phi]. U[\[Phi]1, \[Phi]2, \
\[Ellipsis] \[Phi]",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns the sum U[\[Phi]1]+U[\[Phi]2]+\[Ellipsis]U[\[Phi]",
 StyleBox["n",
  FontSlant->"Italic"],
 "]."
}], "Text",
 CellChangeTimes->{{3.4575293654747477`*^9, 
  3.457529369306418*^9}},ExpressionUUID->"4c9bd132-3376-4452-a872-\
e7e89307524c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"U", "[", "\[Phi]_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cos", "[", "\[Phi]", "]"}], ",", 
    RowBox[{"Sin", "[", "\[Phi]", "]"}]}], "}"}]}]], "Input",
 CellLabel->
  "In[213]:=",ExpressionUUID->"3dad42e0-d80b-467f-8eb0-48ce76b21ef6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"U", "[", "\[Phi]list___", "]"}], ":=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{"U", "/@", 
     RowBox[{"{", "\[Phi]list", "}"}]}], ")"}]}]}]], "Input",
 CellLabel->
  "In[214]:=",ExpressionUUID->"43506ccb-a59f-47b7-84cf-efb5ae8c5fcc"],

Cell["Examples", "Text",ExpressionUUID->"2f95c805-4b2f-4d57-a1b7-b9c77d04c27d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"U", "[", 
   RowBox[{"\[Pi]", "/", "3"}], "]"}], "//", "ShowExample"}]], "Input",
 CellLabel->
  "In[215]:=",ExpressionUUID->"e17b6798-78e3-483e-81e2-6aece4c6ceec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"U", "[", 
   RowBox[{
    RowBox[{"\[Pi]", "/", "3"}], ",", 
    RowBox[{"\[Pi]", "/", "3"}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellLabel->
  "In[216]:=",ExpressionUUID->"894423f9-ac16-462b-bf1c-4b567f2aee0c"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Intersections", "Subsection",
 CellChangeTimes->{{3.650297021926388*^9, 3.650297027233245*^9}, 
   3.708401028148224*^9},ExpressionUUID->"41e85938-690c-4699-afd0-\
662828d09b44"],

Cell[CellGroupData[{

Cell[TextData[{
 "LineInt2D[",
 StyleBox["a1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["a2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d2",
  FontSlant->"Italic"],
 "]\nLineInt2Di[",
 StyleBox["a1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["a2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d2",
  FontSlant->"Italic"],
 "]\nLineInt2D1[",
 StyleBox["p1, p2, q1, q2",
  FontSlant->"Italic"],
 "]\nLineInt2D1i[",
 StyleBox["p1, p2, q1, q2",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{
  3.457529296313657*^9, {3.457529428907439*^9, 3.4575294534402227`*^9}, {
   3.463411846940427*^9, 3.46341185085177*^9}, {3.463515062317771*^9, 
   3.463515071906694*^9}},ExpressionUUID->"1a5f7d63-958c-4ef6-b8ad-\
0ee2d2b391de"],

Cell[TextData[{
 "LineInt2D[",
 StyleBox["a1, d1, a2, d2",
  FontSlant->"Italic"],
 "] computes the intersection between two lines in ",
 "2D",
 ".  ",
 StyleBox["a1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d1",
  FontSlant->"Italic"],
 " are are a point on one line and a vector along the line, respectively; ",
 StyleBox["a2",
  FontSlant->"Italic"],
 " and ",
 StyleBox["d2",
  FontSlant->"Italic"],
 " are the same for the second line."
}], "Text",
 CellChangeTimes->{{3.457529473568157*^9, 3.457529475735516*^9}, {
   3.463510368236354*^9, 3.463510384722909*^9}, 3.463515106314643*^9, 
   3.592170590609542*^9},ExpressionUUID->"af439650-a790-4902-a2bc-\
00369dc1bf8f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineInt2D", "[", 
   RowBox[{"a1_", ",", "d1_", ",", "a2_", ",", "d2_"}], "]"}], ":=", 
  RowBox[{"a1", "+", 
   RowBox[{"d1", " ", 
    FractionBox[
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a2", "-", "a1"}], ",", "d2"}], "}"}], "]"}], 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"d1", ",", "d2"}], "}"}], "]"}]]}]}]}]], "Input",
 CellChangeTimes->{{3.463510359873132*^9, 3.46351044389151*^9}, {
  3.463515093090169*^9, 3.463515097839877*^9}},
 CellLabel->
  "In[217]:=",ExpressionUUID->"a25b7475-afa6-4eaf-a351-a5d4138e63ce"],

Cell[TextData[{
 "LineInt2Di[",
 StyleBox["a1, d1, a2, d2",
  FontSlant->"Italic"],
 "] computes the intersection between two lines in ",
 "2D",
 ".  ",
 StyleBox["a1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d1",
  FontSlant->"Italic"],
 " are are a point on one line and a vector along the line, respectively; ",
 StyleBox["a2",
  FontSlant->"Italic"],
 " and ",
 StyleBox["d2",
  FontSlant->"Italic"],
 " are the same for the second line. If the two lines are parallel, it \
returns {Indeterminate, Indeterminate}."
}], "Text",
 CellChangeTimes->{{3.457529473568157*^9, 3.457529475735516*^9}, {
   3.463510368236354*^9, 3.463510384722909*^9}, 3.4635150817964916`*^9, 
   3.5921705907101393`*^9},ExpressionUUID->"28546604-1527-44d5-acbf-\
cbd46abc4236"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineInt2Di", "[", 
   RowBox[{"a1_", ",", "d1_", ",", "a2_", ",", "d2_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "ddet", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ddet", "=", 
      RowBox[{"Det", "[", 
       RowBox[{"{", 
        RowBox[{"d1", ",", "d2"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ddet", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"Indeterminate", ",", "Indeterminate"}], "}"}], ",", 
       RowBox[{"a1", "+", 
        RowBox[{"d1", " ", 
         FractionBox[
          RowBox[{"Det", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"a2", "-", "a1"}], ",", "d2"}], "}"}], "]"}], 
          "ddet"]}]}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.463510359873132*^9, 3.46351044389151*^9}, 
   3.463515083295916*^9},
 CellLabel->
  "In[218]:=",ExpressionUUID->"1df7ed4a-fac1-419b-927d-1b6259d39f49"],

Cell[TextData[{
 "LineInt2D1[",
 StyleBox["p1, p2, q1, q2",
  FontSlant->"Italic"],
 "] computes the intersection between two lines where ",
 StyleBox["a1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b1",
  FontSlant->"Italic"],
 " are two points on the first line and ",
 StyleBox["a2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b2",
  FontSlant->"Italic"],
 " are two points on the second."
}], "Text",
 CellChangeTimes->{{3.457529479047383*^9, 3.4575294869745398`*^9}, {
  3.463510454231845*^9, 
  3.463510461581972*^9}},ExpressionUUID->"3b89dfc6-9c8a-42f8-a741-\
6a7b3631e396"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineInt2D1", "[", 
   RowBox[{"p1_", ",", "p2_", ",", "q1_", ",", "q2_"}], "]"}], ":=", 
  RowBox[{"p1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"p2", "-", "p1"}], ")"}], " ", 
    FractionBox[
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q1", "-", "p1"}], ",", 
        RowBox[{"q2", "-", "q1"}]}], "}"}], "]"}], 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p2", "-", "p1"}], ",", 
        RowBox[{"q2", "-", "q1"}]}], "}"}], "]"}]]}]}]}]], "Input",
 CellChangeTimes->{{3.463411761657784*^9, 3.463411829671805*^9}, 
   3.463509806471247*^9, {3.463510472756221*^9, 3.463510501247504*^9}, {
   3.46351514681476*^9, 3.463515151445096*^9}},
 CellLabel->
  "In[219]:=",ExpressionUUID->"5edfbb8b-9e7a-4857-9f40-f3ba43d5472b"],

Cell[TextData[{
 "LineInt2D1i[",
 StyleBox["p1, p2, q1, q2",
  FontSlant->"Italic"],
 "] computes the intersection between two lines where ",
 StyleBox["a1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b1",
  FontSlant->"Italic"],
 " are two points on the first line and ",
 StyleBox["a2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b2",
  FontSlant->"Italic"],
 " are two points on the second. If the two lines are parallel, it returns \
{Indeterminate, Indeterminate}."
}], "Text",
 CellChangeTimes->{{3.457529479047383*^9, 3.4575294869745398`*^9}, {
  3.463510454231845*^9, 3.463510461581972*^9}, {3.463515117969734*^9, 
  3.463515138861876*^9}},ExpressionUUID->"07066777-2c3c-4ac9-94d5-\
b66d8156ab8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineInt2D1i", "[", 
   RowBox[{"p1_", ",", "p2_", ",", "q1_", ",", "q2_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "ddet", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ddet", "=", 
      RowBox[{"Det", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"p2", "-", "p1"}], ",", 
         RowBox[{"q2", "-", "q1"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ddet", "\[Equal]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"Indeterminate", ",", "Indeterminate"}], "}"}], ",", 
       RowBox[{"p1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p2", "-", "p1"}], ")"}], " ", 
         FractionBox[
          RowBox[{"Det", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"q1", "-", "p1"}], ",", 
             RowBox[{"q2", "-", "q1"}]}], "}"}], "]"}], "ddet"]}]}]}], 
      "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.463411761657784*^9, 3.463411829671805*^9}, 
   3.463509806471247*^9, {3.463510472756221*^9, 3.463510501247504*^9}, 
   3.463515119550046*^9},
 CellLabel->
  "In[220]:=",ExpressionUUID->"4c31e1df-4a3f-47aa-9e43-4afa87d9bf84"],

Cell["Example", "Text",
 CellChangeTimes->{{3.457529499509418*^9, 
  3.45752950018931*^9}},ExpressionUUID->"e826fe45-1d87-48b0-ab12-\
75daeca9aab3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineInt2D1", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.457529502698356*^9, 3.457529524199013*^9}},
 CellLabel->
  "In[221]:=",ExpressionUUID->"6ec5d33d-4efd-464f-b653-1a205bd97039"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "RayCircleInt2D[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.457898057880624*^9, 3.457898109525272*^9}, {
  3.457898141284402*^9, 3.4578981545625553`*^9}, {3.457898259234185*^9, 
  3.457898276008634*^9}, {3.457899433648245*^9, 
  3.457899434421035*^9}},ExpressionUUID->"fb4aff68-ab82-4ad8-923c-\
3434fcd92952"],

Cell[TextData[{
 "RayCircleInt2D[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["d",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "] takes a ray defined by a point ",
 StyleBox["a",
  FontSlant->"Italic"],
 " and direction ",
 StyleBox["d",
  FontSlant->"Italic"],
 " and finds its intersection with a circle of radius ",
 StyleBox["r",
  FontSlant->"Italic"],
 " centered on ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", returning the intersection farthest along the ray in the direction of ",
 StyleBox["d",
  FontSlant->"Italic"],
 ". A fatal error is thrown if the ray does not intersect the circle."
}], "Text",
 CellChangeTimes->{{3.457898114077085*^9, 3.457898138275406*^9}, {
  3.4578981954613943`*^9, 3.457898213295139*^9}, {3.457898262289813*^9, 
  3.4578982813847227`*^9}, {3.457898863963726*^9, 3.457898923920466*^9}, {
  3.457899449332918*^9, 3.45789945128559*^9}, {3.629425978805447*^9, 
  3.629426015745631*^9}, {3.62942604787153*^9, 3.629426057342721*^9}, {
  3.629426097563932*^9, 3.629426098248761*^9}, {3.650296095415535*^9, 
  3.650296098900014*^9}, {3.676403280629189*^9, 
  3.6764032961630793`*^9}},ExpressionUUID->"9e365a48-24c8-40b0-9646-\
c9f4e2b79fd6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RayCircleInt2D", "::", "baddir"}], 
   "=", "\"\<Line `1` does not intersect the circle with center `2` and \
radius `3`.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.484065417488576*^9, 3.484065480223746*^9}, {
  3.629425856975171*^9, 3.629425897588959*^9}},
 CellLabel->
  "In[222]:=",ExpressionUUID->"5751baaa-96f9-43de-b3c2-e39f0b6a3bb5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RayCircleInt2D", "[", 
   RowBox[{"a_", ",", "d_", ",", "ctr_", ",", " ", "r_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "t", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "-", "ctr"}], ")"}], ".", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ".", "d"}], 
            ")"}]}], "/", 
          RowBox[{"Mag", "[", "d", "]"}]}], "]"}], ">", "r"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"RayCircleInt2D", "::", "baddir"}], ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "d"}], "}"}], ",", "ctr", ",", "r"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"a", "+", 
      RowBox[{"d", " ", 
       RowBox[{"Max", "[", 
        RowBox[{"t", "/.", 
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{"Plus", "@@", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"a", "-", "ctr", "+", 
               RowBox[{"d", " ", "t"}]}], ")"}], "2"]}], "\[Equal]", 
           SuperscriptBox["r", "2"]}], "]"}]}], "]"}]}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.457898455411862*^9, 3.457898501688746*^9}, {
  3.457898534353878*^9, 3.45789856613225*^9}, {3.457898748989589*^9, 
  3.457898757924267*^9}, {3.4578987951896677`*^9, 3.457898832703355*^9}, {
  3.457898926173418*^9, 3.4578990020491037`*^9}, {3.457899440105285*^9, 
  3.457899463944623*^9}, {3.484065488393347*^9, 3.484065516481904*^9}, {
  3.629426070385562*^9, 3.629426212576968*^9}},
 CellLabel->
  "In[223]:=",ExpressionUUID->"80aec5a6-13a1-42af-acc6-4a84df090ff5"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.457898569493155*^9, 3.457898570196619*^9}, 
   3.629426298759084*^9},ExpressionUUID->"d36bbb41-4985-4a46-868b-\
e26e856d6244"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "d", ",", "ctr", ",", "r", ",", "p"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"a", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"d", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0.5"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ctr", "=", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", "3.0"}], ";", "\[IndentingNewLine]", 
     RowBox[{"p", "=", 
      RowBox[{"RayCircleInt2D", "[", 
       RowBox[{"a", ",", "d", ",", "ctr", ",", "r"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{"ctr", ",", "r"}], "]"}], ",", "Gray"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"a", ",", "p"}], "}"}], "]"}], ",", "Red"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "a", "]"}], ",", "Red", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "ctr", "]"}], ",", "Black", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", "Green", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.457898574854389*^9, 3.4578987045344048`*^9}, 
   3.457898779322758*^9, {3.457899018808438*^9, 3.4578990257992268`*^9}, {
   3.457899485894898*^9, 3.457899551350831*^9}, {3.629425703097828*^9, 
   3.629425839794716*^9}, {3.629426357392419*^9, 3.629426391592434*^9}},
 CellLabel->
  "In[224]:=",ExpressionUUID->"15911115-720e-4f9b-9be1-cfee11311830"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.457898569493155*^9, 3.457898570196619*^9}, 
   3.629426297255077*^9},ExpressionUUID->"66c0ff1f-dfd8-43fc-b680-\
a796b80c8b16"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "d", ",", "ctr", ",", "r", ",", "p"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"a", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"d", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ctr", "=", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", "1.5"}], ";", "\[IndentingNewLine]", 
     RowBox[{"p", "=", 
      RowBox[{"RayCircleInt2D", "[", 
       RowBox[{"a", ",", "d", ",", "ctr", ",", "r"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{"ctr", ",", "r"}], "]"}], ",", "Gray"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"a", ",", "p"}], "}"}], "]"}], ",", "Red"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "a", "]"}], ",", "Red", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "ctr", "]"}], ",", "Black", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", "Green", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.457898574854389*^9, 3.4578987045344048`*^9}, 
   3.457898779322758*^9, {3.457899018808438*^9, 3.4578990257992268`*^9}, {
   3.457899485894898*^9, 3.457899551350831*^9}, {3.629425703097828*^9, 
   3.629425839794716*^9}, {3.62942624241695*^9, 3.62942625557438*^9}, 
   3.629426285643653*^9, 3.629426397448494*^9},
 CellLabel->
  "In[225]:=",ExpressionUUID->"189b3e95-32e5-43b6-bda9-740ea166c944"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Triangle properties from three sides", "Subsection",
 CellChangeTimes->{{3.595712680792164*^9, 3.595712696904934*^9}, {
   3.595805769877283*^9, 3.595805782442571*^9}, 3.595973775324111*^9, {
   3.595975749747716*^9, 3.595975750075646*^9}, {3.595977682150427*^9, 
   3.595977720491763*^9}, {3.768675760064001*^9, 
   3.768675760727398*^9}},ExpressionUUID->"0578c6ba-e570-4a94-97f5-\
e37beb1727ee"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.595712700360498*^9, 
  3.59571270076827*^9}},ExpressionUUID->"0988b20d-6e8c-40dc-ad12-\
509fd36e7f1e"],

Cell["See http://mathworld.wolfram.com/Triangle.html.", "Text",
 CellChangeTimes->{{3.595712702567973*^9, 
  3.595712716737823*^9}},ExpressionUUID->"bfa66dc5-f6da-4907-a29a-\
77912d98518f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleSemiperimeter[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]\nTriangleAreaSquared[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]\nTriangleExistsQ[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]\nTriangleArea[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]\nTriangleInradius[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.595712723560294*^9, 3.595712745141788*^9}, {
  3.595712892563699*^9, 3.5957129037773237`*^9}, {3.768688176545064*^9, 
  3.768688186011389*^9}},ExpressionUUID->"99a28ddc-075d-42bd-a6b0-\
73cbfbe4e200"],

Cell[TextData[{
 "TriangleSemiperimeter[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] gives the semiperimeter of a triangle whose side lengths are ",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["c",
  FontSlant->"Italic"],
 " (all must be nonnegative)."
}], "Text",
 CellChangeTimes->{{3.5957127480458097`*^9, 3.59571277386748*^9}, {
  3.595712929776561*^9, 3.595712930175263*^9}, {3.768688209863376*^9, 
  3.768688219041819*^9}},ExpressionUUID->"9d3c3917-48b5-4b3d-81fe-\
87d74849da75"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleSemiperimeter", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"(", 
    RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.595712787513935*^9, 3.595712804796896*^9}},
 CellLabel->
  "In[226]:=",ExpressionUUID->"689cfb56-07ca-4911-800c-fcc4f4521613"],

Cell[TextData[{
 "TriangleAreaSquared[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] gives the square of the area of a triangle from its sides, from Heron\
\[CloseCurlyQuote]s formula. If the value is negative, then the triangle is \
not possible. All of ",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 " must be nonnegative."
}], "Text",
 CellChangeTimes->{{3.595712814674049*^9, 3.5957128275236683`*^9}, 
   3.595712933145876*^9, {3.595803781125725*^9, 3.59580378510789*^9}, {
   3.76868810401036*^9, 3.768688132262946*^9}, {3.768688225004725*^9, 
   3.768688234021799*^9}},ExpressionUUID->"4e38bf51-85c4-4b4f-8ffd-\
85b621ab8ee6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleAreaSquared", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "s", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"TriangleSemiperimeter", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s", 
      RowBox[{"(", 
       RowBox[{"s", "-", "a"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", "c"}], ")"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5957128331313677`*^9, 3.5957128817674417`*^9}, {
  3.768688135775475*^9, 3.76868815973756*^9}},
 CellLabel->
  "In[227]:=",ExpressionUUID->"0c8707de-f9cf-4cb2-9adb-0132a5113396"],

Cell["Example. An equilateral triangle.", "Text",
 CellChangeTimes->{{3.768688315997945*^9, 
  3.7686883261555634`*^9}},ExpressionUUID->"b9cd930e-01e1-4ea6-9567-\
332d1f49e19b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleAreaSquared", "[", 
   RowBox[{"1", ",", "1", ",", "1"}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.768688328230453*^9, 3.768688340541236*^9}},
 CellLabel->
  "In[228]:=",ExpressionUUID->"54240e3d-6bf0-44a2-94d8-72134eab1285"],

Cell[TextData[{
 "TriangleExistsQ[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] returns True if the triangle exists (includes degenerate triangles with \
collinear vertices). All of ",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 " must be nonnegative."
}], "Text",
 CellChangeTimes->{{3.768688272137658*^9, 
  3.768688304132675*^9}},ExpressionUUID->"92794e32-46d3-4714-8fa7-\
030053e932d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleExistsQ", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"TriangleAreaSquared", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "\[GreaterEqual]", 
   "0"}]}]], "Input",
 CellChangeTimes->{{3.768688245680476*^9, 3.768688260968274*^9}, 
   3.768688381873228*^9, {3.768688458727346*^9, 3.768688460151547*^9}},
 CellLabel->
  "In[229]:=",ExpressionUUID->"4c165af1-6bc0-4c9f-8e22-886e3996115d"],

Cell["\<\
Examples: one that exists, one that\[CloseCurlyQuote]s degenerate (but \
exists), one that doesn\[CloseCurlyQuote]t.\
\>", "Text",
 CellChangeTimes->{{3.7686883889582853`*^9, 3.768688416434993*^9}, {
  3.768688469407805*^9, 
  3.76868847141692*^9}},ExpressionUUID->"84aac1d6-06bc-446b-b634-\
83385eb775ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TriangleExistsQ", "[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"TriangleExistsQ", "[", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"TriangleExistsQ", "[", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "3"}]}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.768688399648254*^9, 3.768688449247504*^9}},
 CellLabel->
  "In[230]:=",ExpressionUUID->"f1861815-f468-4e29-bc71-80f4baa80169"],

Cell[TextData[{
 "TriangleArea[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] gives the area of a triangle from its sides. (This is Heron\
\[CloseCurlyQuote]s formula.)"
}], "Text",
 CellChangeTimes->{{3.595712814674049*^9, 3.5957128275236683`*^9}, 
   3.595712933145876*^9, {3.595803781125725*^9, 
   3.59580378510789*^9}},ExpressionUUID->"96bd0163-fc82-4f51-9a7e-\
431d4fb3b1a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleArea", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  SqrtBox[
   RowBox[{"TriangleAreaSquared", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]]}]], "Input",
 CellChangeTimes->{{3.5957128331313677`*^9, 3.5957128817674417`*^9}, {
  3.768688590852428*^9, 3.768688605858189*^9}},
 CellLabel->
  "In[231]:=",ExpressionUUID->"402895b6-5e0d-429c-a8ee-19374c9d54b7"],

Cell["Example: an equilateral triangle.", "Text",
 CellChangeTimes->{{3.76868835710636*^9, 
  3.768688362423273*^9}},ExpressionUUID->"8b198372-52c5-4aac-a346-\
ad619b979430"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TriangleArea", "[", 
  RowBox[{"1", ",", "1", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.768688364021291*^9, 3.768688367667033*^9}},
 CellLabel->
  "In[232]:=",ExpressionUUID->"1a1b3f89-ecfe-4010-9a59-32363d660412"],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "4"]], "Output",
 CellChangeTimes->{3.9626352242985497`*^9, 3.9666287923984823`*^9, 
  3.96712079022501*^9},
 CellLabel->
  "Out[232]=",ExpressionUUID->"09d9e928-cab9-41d3-8c6b-c000bc8ddf0b"]
}, Closed]],

Cell["Example: a formula.", "Text",
 CellChangeTimes->{{3.5957134273345337`*^9, 3.595713428043446*^9}, {
   3.768688352573835*^9, 3.768688354201826*^9}, 
   3.768688632956197*^9},ExpressionUUID->"d635b782-1cf4-40a0-9637-\
75f1216d1564"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TriangleArea", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "//", "FullSimplify"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.595713429956806*^9, 3.595713442760597*^9}},
 CellLabel->
  "In[233]:=",ExpressionUUID->"c5b8570c-0ef8-4c3e-babe-f2130767f62e"],

Cell[TextData[{
 "TriangleInradius[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] gives the inradius of a triangle from its sides."
}], "Text",
 CellChangeTimes->{{3.5957129187616253`*^9, 
  3.595712942255546*^9}},ExpressionUUID->"4b3be19e-4380-46c8-93cd-\
e414641f9541"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleInradius", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"TriangleArea", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   RowBox[{"TriangleSemiperimeter", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}]]}]], "Input",
 CellChangeTimes->{{3.5957129492210093`*^9, 3.595712980631055*^9}},
 CellLabel->
  "In[234]:=",ExpressionUUID->"9cba85d6-83e1-4f91-8538-ac80c9ceafc5"],

Cell["Example", "Text",
 CellChangeTimes->{{3.595713451452184*^9, 
  3.5957134532906523`*^9}},ExpressionUUID->"082e4b2f-36c8-4f78-a94b-\
5fc29205a186"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TriangleInradius", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "//", "FullSimplify"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.595713429956806*^9, 3.595713463199391*^9}},
 CellLabel->
  "In[235]:=",ExpressionUUID->"3c1dae49-bb92-4061-9e76-e67f7e36a0ca"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleSinA[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]\nTriangleCosA[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]\nTriangleTanA[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{
  3.595801801301779*^9},ExpressionUUID->"5e59f45b-5e1b-4ea6-8969-\
30bc7c039ace"],

Cell[TextData[{
 "TriangleSinA[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] gives Sin[A] for angle A of a triangle with sides ",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["c",
  FontSlant->"Italic"],
 ". See also TriangleHatA, further down."
}], "Text",
 CellChangeTimes->{{3.595719631755741*^9, 3.595719654121168*^9}, {
  3.595801805332843*^9, 
  3.595801811162354*^9}},ExpressionUUID->"180fb0dd-2a96-465b-9e27-\
6601a4283656"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleSinA", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  FractionBox[
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]], 
   RowBox[{"2", " ", "b", " ", "c"}]]}]], "Input",
 CellChangeTimes->{{3.595719569996142*^9, 3.595719583508938*^9}},
 CellLabel->
  "In[236]:=",ExpressionUUID->"4e33d4d5-3ee3-482f-90ae-8aaa1e7a3a2a"],

Cell[TextData[{
 "TriangleCosA[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] gives Cos[A] for angle A of a triangle with sides ",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["c",
  FontSlant->"Italic"],
 ". (This, of course, is our old friend, the cosine law)"
}], "Text",
 CellChangeTimes->{{3.595719631755741*^9, 3.595719654121168*^9}, {
  3.5957197910997066`*^9, 3.5957197936222467`*^9}, {3.595720790986747*^9, 
  3.595720805633562*^9}},ExpressionUUID->"df102673-5bf6-479f-a565-\
299dcbfb857d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleCosA", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}], 
   RowBox[{"2", " ", "b", " ", "c"}]]}]], "Input",
 CellChangeTimes->{{3.595719569996142*^9, 3.595719583508938*^9}, {
  3.5957197601898193`*^9, 3.595719766253269*^9}},
 CellLabel->
  "In[237]:=",ExpressionUUID->"2c28d87a-d991-4f85-a2a3-c1662e89b627"],

Cell[TextData[{
 "TriangleTanA[",
 StyleBox["a, b, c",
  FontSlant->"Italic"],
 "] gives Tan[A] for angle A of a triangle with sides ",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["c",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.595719631755741*^9, 3.595719654121168*^9}, {
  3.5957197910997066`*^9, 
  3.59571980369353*^9}},ExpressionUUID->"fd12f2a2-000c-4878-ae3b-\
5aeec6262e46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleTanA", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"-", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]], 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["c", "2"]}]]}]}]], "Input",
 CellChangeTimes->{{3.595719569996142*^9, 3.595719583508938*^9}, {
  3.5957197601898193`*^9, 3.595719766253269*^9}, {3.595719807387214*^9, 
  3.595719816171101*^9}},
 CellLabel->
  "In[238]:=",ExpressionUUID->"65ffeb7f-8ef1-4081-9eaf-cabacab0b4b0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleVertices[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b, c",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.627330372021483*^9, 3.627330428977654*^9}, {
   3.627330796595438*^9, 3.627330799321912*^9}, 
   3.6273312474151597`*^9},ExpressionUUID->"4d826e7f-254a-45ec-b70c-\
0d1b15ec8253"],

Cell[TextData[{
 "TriangleVertices[",
 StyleBox["a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b, c",
  FontSlant->"Italic"],
 "] returns the vertices of an upper-half-plane triangle whose first side \
runs from {0,0} to {",
 StyleBox["a",
  FontSlant->"Italic"],
 ",0}, whose second side is of length ",
 StyleBox["b",
  FontSlant->"Italic"],
 ", and third side is of length ",
 StyleBox["c",
  FontSlant->"Italic"],
 ". Sides circulate CCW."
}], "Text",
 CellChangeTimes->{{3.627330414442642*^9, 3.627330442785091*^9}, {
  3.627330478982533*^9, 3.6273305113244886`*^9}, {3.6273305642734756`*^9, 
  3.6273305646656656`*^9}, {3.627330812930171*^9, 3.627330832176142*^9}, {
  3.627330893284253*^9, 3.62733089364473*^9}, {3.627331251544495*^9, 
  3.627331274332254*^9}},ExpressionUUID->"ac45dc8f-e9db-42fb-930a-\
7f744f672cfe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleVertices", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], 
       RowBox[{"2", " ", "a"}]], ",", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "b", "+", "c"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]], 
       RowBox[{"2", " ", "a"}]]}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.627330357188072*^9, 3.627330368279347*^9}, {
   3.627330585809696*^9, 3.627330614333336*^9}, {3.627330712747355*^9, 
   3.62733075589054*^9}, {3.627330872626669*^9, 3.62733088662584*^9}, 
   3.627331252847907*^9},
 CellLabel->
  "In[239]:=",ExpressionUUID->"8dd51489-4f53-47d9-9904-c4f91cb8278a"],

Cell["Example", "Text",
 CellChangeTimes->{{3.627330769028167*^9, 
  3.6273307698126807`*^9}},ExpressionUUID->"3d7ca5ce-9eb3-4e72-b5e8-\
6df5f08fcf9f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "verts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"TriangleVertices", "[", 
       RowBox[{"1", ",", "0.6", ",", "0.8"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Polygon", "[", "verts", "]"}], ",", "LightGray"}], "]"}], 
        "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.627330775120413*^9, 3.627330784709381*^9}, 
   3.627330987144905*^9, {3.627331046702491*^9, 3.627331141527964*^9}, 
   3.627331254535658*^9},
 CellLabel->
  "In[240]:=",ExpressionUUID->"a517cf91-0637-4ef7-93a0-093ad9d67cd5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Triangle properties from two vertices and two sides", "Subsection",
 CellChangeTimes->{{3.768673861142148*^9, 
  3.768673870584171*^9}},ExpressionUUID->"174d89f9-60a5-4711-a314-\
f9830203d492"],

Cell[CellGroupData[{

Cell["Analysis", "Subsubsection",
 CellChangeTimes->{{3.76868927151039*^9, 
  3.768689272305328*^9}},ExpressionUUID->"70cced9a-1b63-4b1d-8309-\
9dd1ed3c977c"],

Cell["Solve for the position of the third vertex.", "Text",
 CellChangeTimes->{{3.76868928095841*^9, 
  3.768689289531002*^9}},ExpressionUUID->"537f1286-4502-42b7-96d1-\
6c2a1c2e1fab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Mag2", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"cx", ",", "cy"}], "}"}], "-", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "\[Equal]", 
        SuperscriptBox["a", "2"]}], ",", 
       RowBox[{
        RowBox[{"Mag2", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"cx", ",", "cy"}], "}"}], "-", 
          RowBox[{"{", 
           RowBox[{"bx", ",", "0"}], "}"}]}], "]"}], "\[Equal]", 
        SuperscriptBox["b", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"cx", ",", "cy"}], "}"}]}], "]"}], "//", "FullSimplify"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.768689190165794*^9, 3.768689260924062*^9}, {
  3.768689292515662*^9, 3.768689294320978*^9}, {3.768689792932576*^9, 
  3.768689793632938*^9}},
 CellLabel->
  "In[241]:=",ExpressionUUID->"cff2d58c-a0de-4258-8a85-dae9b885874b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleExistsQ[{",
 StyleBox["pa",
  FontSlant->"Italic"],
 ", ",
 StyleBox["a",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["pb",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.768673883581208*^9, 3.768673897804966*^9}, {
  3.768688787523736*^9, 
  3.768688789626698*^9}},ExpressionUUID->"95bfa5ec-559d-41a0-a4f2-\
4a2b8258bbd5"],

Cell[TextData[{
 "TriangleExistsQ[{",
 StyleBox["pa",
  FontSlant->"Italic"],
 ", ",
 StyleBox["a",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["pb",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "}] returns True if a triangle exists with two vertices and two sides \
specified. It includes degenerate triangles (collinear vertices)."
}], "Text",
 CellChangeTimes->{{3.76868880669068*^9, 
  3.7686888338054647`*^9}},ExpressionUUID->"c295f10d-cc1c-40ce-b70e-\
d47761630d0e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleExistsQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pa_List", ",", "a_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pb_List", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"TriangleExistsQ", "[", 
   RowBox[{
    RowBox[{"Mag", "[", 
     RowBox[{"pa", "-", "pb"}], "]"}], ",", "a", ",", "b"}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.768688837019103*^9, 3.768688881355651*^9}},
 CellLabel->
  "In[242]:=",ExpressionUUID->"f67327a7-ce31-4c2a-a170-6d284215e78f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleVertex[{",
 StyleBox["pa",
  FontSlant->"Italic"],
 ", ",
 StyleBox["a",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["pb",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["dir",
  FontSlant->"Italic"],
 "]\nTriangleVertex[{",
 StyleBox["pa",
  FontSlant->"Italic"],
 ", ",
 StyleBox["a",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["pb",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.768673874502238*^9, 3.768673910331702*^9}, {
  3.7686887910751057`*^9, 3.768688793524392*^9}, {3.7686889216461287`*^9, 
  3.768688930254974*^9}},ExpressionUUID->"bf2441a9-d622-4e36-9f42-\
98726438cab5"],

Cell[TextData[{
 "TriangleVertex[{",
 StyleBox["pa",
  FontSlant->"Italic"],
 ", ",
 StyleBox["a",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["pb",
  FontSlant->"Italic"],
 ", ",
 StyleBox["b",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["dir",
  FontSlant->"Italic"],
 "] returns the coordinates of a third vertex located at distance a from \
point pa and distance b from point pb. If ",
 StyleBox["dir",
  FontSlant->"Italic"],
 "\[Equal]1, the third vertex completes a CCW triangle, otherwise, a CW \
triangle."
}], "Text",
 CellChangeTimes->{{3.7686889378346243`*^9, 3.768688997732707*^9}, {
  3.7686894861541157`*^9, 
  3.768689487037469*^9}},ExpressionUUID->"9abacb92-e5a0-4082-a0bb-\
566f3405bd02"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TriangleVertex", "::", "baddir"}], 
   "=", "\"\<`1` must be \[PlusMinus]1.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.768689034555518*^9, 3.7686890532351007`*^9}},
 CellLabel->
  "In[243]:=",ExpressionUUID->"73c08d71-632c-4301-abf1-c56f7b7d7592"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleVertex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pa_List", ",", "a_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pb_List", ",", "b_"}], "}"}], ",", 
    RowBox[{"dir_", ":", "1"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xx", ",", "yy", ",", "bx", ",", "cx", ",", "cy"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dir", "\[NotEqual]", "1"}], "&&", 
        RowBox[{"dir", "\[NotEqual]", 
         RowBox[{"-", "1"}]}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"TriangleVertex", "::", "baddir"}], ",", "dir"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"xx", "=", 
      RowBox[{"NormalizeReal", "[", 
       RowBox[{"pb", "-", "pa"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"yy", "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ".", "xx"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"bx", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{"pb", "-", "pa"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cx", "=", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["bx", "2"]}], 
       RowBox[{"2", " ", "bx"}]]}], ";", "\[IndentingNewLine]", 
     RowBox[{"cy", "=", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"a", "-", "b", "-", "bx"}], ")"}]}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "bx"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "b", "+", "bx"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "+", "bx"}], ")"}]}]], 
       RowBox[{"2", " ", "bx"}]]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pa", "+", 
      RowBox[{"cx", " ", "xx"}], " ", "+", " ", 
      RowBox[{"dir", " ", "cy", " ", "yy"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.768688999874907*^9, 3.7686890250434713`*^9}, {
  3.768689060055673*^9, 3.7686891840665817`*^9}, {3.768689334472105*^9, 
  3.76868937929185*^9}, {3.768689493773396*^9, 3.76868951637772*^9}, {
  3.768689728382917*^9, 3.768689729655319*^9}, {3.768689799581781*^9, 
  3.768689806753312*^9}},
 CellLabel->
  "In[244]:=",ExpressionUUID->"400f7ab8-c058-4056-a5dd-d02a57937b9a"],

Cell["Example. An equilateral triangle, with rotation and offset.", "Text",
 CellChangeTimes->{{3.7686895305599008`*^9, 
  3.768689544793426*^9}},ExpressionUUID->"186015d3-7c97-44c7-901d-\
0e62b602228a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pa", ",", "pb", ",", "rm", ",", "of", ",", "pc"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pa", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pb", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rm", "=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Phi]", "=", 
          RowBox[{"10", "\[Degree]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "\[Phi]", "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sin", "[", "\[Phi]", "]"}], ",", 
            RowBox[{"Cos", "[", "\[Phi]", "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"of", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pa", "=", 
      RowBox[{"of", "+", 
       RowBox[{"rm", ".", "pa"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pb", "=", 
      RowBox[{"of", "+", 
       RowBox[{"rm", ".", "pb"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pc", "=", 
      RowBox[{"TriangleVertex", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"pa", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"pb", ",", "1"}], "}"}], ",", 
        RowBox[{"+", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{"pa", ",", "pb", ",", "pc", ",", "pa"}], "}"}], "]"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.768689549707864*^9, 3.768689685877869*^9}, {
  3.768689818497818*^9, 3.768689864838229*^9}},
 CellLabel->
  "In[245]:=",ExpressionUUID->"42df98c7-045e-4356-9f76-069bea380c34"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Triangle properties from three vertices", "Subsection",
 CellChangeTimes->{{3.595977675448154*^9, 3.595977687382251*^9}, 
   3.59597775897134*^9, {3.701270287065623*^9, 3.701270287980093*^9}, {
   3.768675755416823*^9, 
   3.768675756072654*^9}},ExpressionUUID->"3a445ceb-ac94-41a4-96d3-\
2a53f7740de7"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.76868994782261*^9, 
  3.768689948296838*^9}},ExpressionUUID->"c299ad87-7845-4127-babd-\
483546a40fd6"],

Cell["\<\
These functions have 2D explicitly in their name because there are versions \
of the functions for 3D vertices.\
\>", "Text",
 CellChangeTimes->{{3.768689949973854*^9, 
  3.768689976413447*^9}},ExpressionUUID->"dea41795-a776-4027-a116-\
b947c4b1dd93"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleSignedArea2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]\nTriangleArea2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.595803601752149*^9, 3.595803607463738*^9}, {
  3.595803654837519*^9, 3.595803666853866*^9}, {3.595804463112875*^9, 
  3.595804466591609*^9}},ExpressionUUID->"eda03532-fce2-4a20-a49d-\
06653e77a4de"],

Cell[TextData[{
 "TriangleSignedArea2D",
 "[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "] returns the area of a triangle whose 2D vertices are ",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", positive if ",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["r",
  FontSlant->"Italic"],
 " are CCW oriented, negative otherwise."
}], "Text",
 CellChangeTimes->{{3.595803611505752*^9, 3.5958036516686683`*^9}, {
  3.595804484920073*^9, 3.595804491960034*^9}, {3.595977446925688*^9, 
  3.595977447742098*^9}},ExpressionUUID->"c2776dfc-72e9-436c-b9fa-\
f763cdfb777a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleSignedArea2D", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"q", "-", "p"}], ",", 
      RowBox[{"r", "-", "p"}]}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.595803966167073*^9, 3.595804013583435*^9}, {
   3.595804053119182*^9, 3.595804080532292*^9}, 3.595804493702386*^9},
 CellLabel->
  "In[246]:=",ExpressionUUID->"8eee0860-ccee-4e75-b5cc-900a8cf70cd7"],

Cell["Example", "Text",
 CellChangeTimes->{{3.595804017085239*^9, 
  3.595804024580319*^9}},ExpressionUUID->"093ca47b-ad8c-4b4b-aa1c-\
ae3d7bcc2c5a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleSignedArea2D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.595804029849597*^9, 3.595804045925337*^9}, {
   3.595804093378405*^9, 3.595804096097535*^9}, 3.595804497110134*^9},
 CellLabel->
  "In[247]:=",ExpressionUUID->"c8ebc9b3-2342-4223-beda-2eccd17a68a2"],

Cell[TextData[{
 "TriangleArea2D",
 "[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "] returns the area of a triangle whose vertices are ",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["r",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.595804155523175*^9, 3.595804163595165*^9}, 
   3.5958045009434757`*^9},ExpressionUUID->"8b76b004-faf7-4be5-8c49-\
0fee3a984aad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleArea2D", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  RowBox[{"Abs", "[", 
   RowBox[{"TriangleSignedArea2D", "[", 
    RowBox[{"p", ",", "q", ",", "r"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.595804121838149*^9, 3.5958041405111713`*^9}, {
  3.595804503074666*^9, 3.595804506069029*^9}},
 CellLabel->
  "In[248]:=",ExpressionUUID->"719ddfed-873b-41e7-a202-7f72ed5e3d0f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleIncenter2D[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.627397044302733*^9, 3.627397051517706*^9}, {
   3.627397631081746*^9, 3.62739764363146*^9}, 3.627397746952677*^9, {
   3.627397998880991*^9, 
   3.6273979996499667`*^9}},ExpressionUUID->"f2b7fabe-1066-4a95-af30-\
f57b8e07ee92"],

Cell[TextData[{
 "TriangleIncenter2D[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ",",
 StyleBox[" r",
  FontSlant->"Italic"],
 "] returns the incenter of a triangle with vertices ",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.627397275676227*^9, 3.62739730636558*^9}, {
  3.6273980036167808`*^9, 
  3.627398006408304*^9}},ExpressionUUID->"d61ed830-3f47-4262-946a-\
199eac239857"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleIncenter2D", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pp", ",", "qq", ",", "rr"}], "}"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"pp", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{"r", "-", "q"}], "]"}]}], ";", 
     RowBox[{"qq", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{"r", "-", "p"}], "]"}]}], ";", 
     RowBox[{"rr", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{"p", "-", "q"}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"sides", " ", "of", " ", "the", " ", "triangles"}], ",", " ", 
       RowBox[{"pp", " ", "is", " ", "opposite", " ", "p"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{
       RowBox[{"pp", " ", "p"}], " ", "+", " ", 
       RowBox[{"qq", " ", "q"}], " ", "+", " ", 
       RowBox[{"rr", " ", "r"}]}], 
      RowBox[{"pp", "+", "qq", "+", "rr"}]]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.62739705562402*^9, 3.627397087870569*^9}, {
   3.627397228694591*^9, 3.627397236660754*^9}, {3.627397334181794*^9, 
   3.627397486270749*^9}, {3.62739770691236*^9, 3.627397714794286*^9}, {
   3.627397915564421*^9, 3.627397927449885*^9}, 3.62739801105613*^9},
 CellLabel->
  "In[249]:=",ExpressionUUID->"dc399383-456d-4c76-b87a-4fb0bc317a69"],

Cell["Example", "Text",
 CellChangeTimes->{{3.627397499762535*^9, 
  3.6273975004654016`*^9}},ExpressionUUID->"d9e04f33-2e4b-4a65-bb10-\
12e43ba45f56"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r", ",", "c"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "q", ",", "r"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".6", ",", ".7"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{"TriangleIncenter2D", "[", 
       RowBox[{"p", ",", "q", ",", "r"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Point", "[", "c", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"p", ",", "q", ",", "r", ",", "p"}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Circle", "[", 
         RowBox[{"c", ",", 
          RowBox[{"TriangleInradius", "[", 
           RowBox[{
            RowBox[{"Mag", "[", 
             RowBox[{"r", "-", "q"}], "]"}], ",", 
            RowBox[{"Mag", "[", 
             RowBox[{"q", "-", "p"}], "]"}], ",", 
            RowBox[{"Mag", "[", 
             RowBox[{"p", "-", "r"}], "]"}]}], "]"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], 
  "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.627397501937532*^9, 3.627397603502629*^9}, {
   3.627397739465019*^9, 3.627397743997941*^9}, {3.62739794281791*^9, 
   3.627397958552519*^9}, 3.627398012234717*^9, {3.627398541723431*^9, 
   3.627398548100375*^9}},
 CellLabel->
  "In[250]:=",ExpressionUUID->"b43c2109-ffe1-4c94-af45-13652c31dda5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleAngles2D[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.627398193870101*^9, 
  3.627398200019949*^9}},ExpressionUUID->"62e9ba19-008a-4f05-8732-\
17aebe83b762"],

Cell[TextData[{
 "TriangleAngles2D[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "] returns the angles at the vertices ",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["r",
  FontSlant->"Italic"],
 ". They\[CloseCurlyQuote]re positive if the triangle circulates CCW, \
negative otherwise."
}], "Text",
 CellChangeTimes->{{3.627398204373601*^9, 3.62739822632218*^9}, {
  3.62739835065287*^9, 
  3.627398360417691*^9}},ExpressionUUID->"81783189-cef7-4431-9337-\
211c9004ac54"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleAngles2D", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pq", " ", ",", "qr", ",", "rp"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pq", "=", 
      RowBox[{"q", "-", "p"}]}], ";", 
     RowBox[{"qr", "=", 
      RowBox[{"r", "-", "q"}]}], ";", 
     RowBox[{"rp", "=", 
      RowBox[{"p", "-", "r"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"rp", ".", "pq"}]}], ",", 
         RowBox[{
          RowBox[{"Rotate90", "[", "rp", "]"}], ".", "pq"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"pq", ".", "qr"}]}], ",", 
         RowBox[{
          RowBox[{"Rotate90", "[", "pq", "]"}], ".", "qr"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"qr", ".", "rp"}]}], ",", 
         RowBox[{
          RowBox[{"Rotate90", "[", "qr", "]"}], ".", "rp"}]}], "]"}]}], 
      "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.62739825487927*^9, 3.627398339368621*^9}, {
  3.627398379906373*^9, 3.627398430842699*^9}, {3.627398488845635*^9, 
  3.627398509708885*^9}},
 CellLabel->
  "In[251]:=",ExpressionUUID->"ba0a16a3-66fb-4694-8e9d-68a38214a157"],

Cell["Example", "Text",
 CellChangeTimes->{{3.627397499762535*^9, 
  3.6273975004654016`*^9}},ExpressionUUID->"6f89d8e7-9bf4-4266-a54c-\
8c5203a968bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "q", ",", "r"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".6", ",", ".7"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Angles/\[Degree] = \>\"", ",", 
       RowBox[{
        RowBox[{"TriangleAngles2D", "[", 
         RowBox[{"p", ",", "q", ",", "r"}], "]"}], "/", "\[Degree]"}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"p", ",", "q", ",", "r", ",", "p"}], "}"}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.627397501937532*^9, 3.627397603502629*^9}, {
   3.627397739465019*^9, 3.627397743997941*^9}, {3.62739794281791*^9, 
   3.627397958552519*^9}, 3.627398012234717*^9, {3.627398445474513*^9, 
   3.627398474911262*^9}, {3.627398529018396*^9, 3.627398555867137*^9}},
 CellLabel->
  "In[252]:=",ExpressionUUID->"cecbc940-e7ce-4e0a-9c3b-99a6a341fbf3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Rotation and angles", "Subsection",
 CellChangeTimes->{{3.595972296862363*^9, 3.595972317698031*^9}, {
   3.59597448325484*^9, 3.595974484301979*^9}, 
   3.708401023095314*^9},ExpressionUUID->"dc3e6f85-4cdf-48e7-9b95-\
a88ce4954ff8"],

Cell[CellGroupData[{

Cell[TextData[{
 "RotationAngleSin2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]\nRotationAngleCos2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.5958042406482887`*^9, 3.595804246198234*^9}, {
  3.595804330016528*^9, 3.595804330592286*^9}, {3.595804478102748*^9, 
  3.595804479110592*^9}, {3.595804528099417*^9, 3.5958045468502893`*^9}, {
  3.595804683202808*^9, 3.5958046838736763`*^9}, {3.5958051349679728`*^9, 
  3.5958051400919447`*^9}},ExpressionUUID->"28260bcd-5ccd-4193-816d-\
f55d642c7ebd"],

Cell[TextData[{
 "RotationAngleSin2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "] returns the sin of the angle at point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " of triangle ",
 StyleBox["p,q,r",
  FontSlant->"Italic"],
 " with positive value if ",
 StyleBox["p,q,r",
  FontSlant->"Italic"],
 " circulate CCW, negative if they\[CloseCurlyQuote]re oriented CCW."
}], "Text",
 CellChangeTimes->{{3.595804252622088*^9, 3.595804400988049*^9}, {
  3.595804540037311*^9, 3.595804572849007*^9}, {3.595804702802049*^9, 
  3.595804715759862*^9}},ExpressionUUID->"b4ac1033-74a6-42d5-8e72-\
bab22b99d76f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngleSin2D", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  RowBox[{"2", 
   FractionBox[
    RowBox[{"TriangleSignedArea2D", "[", 
     RowBox[{"p", ",", "q", ",", "r"}], "]"}], 
    RowBox[{
     RowBox[{"Mag", "[", 
      RowBox[{"q", "-", "p"}], "]"}], 
     RowBox[{"Mag", "[", 
      RowBox[{"r", "-", "p"}], "]"}]}]]}]}]], "Input",
 CellChangeTimes->{{3.59580458554708*^9, 3.595804687865337*^9}, {
  3.603126710837188*^9, 3.603126711362177*^9}},
 CellLabel->
  "In[253]:=",ExpressionUUID->"fda0e4d0-7231-48e6-9f95-c33378faa58f"],

Cell["Example", "Text",
 CellChangeTimes->{{3.595804666411034*^9, 
  3.5958046673150067`*^9}},ExpressionUUID->"8401e9ad-c523-4530-8f7b-\
09f06898b299"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngleSin2D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.595804029849597*^9, 3.595804045925337*^9}, {
   3.595804093378405*^9, 3.595804096097535*^9}, 3.595804497110134*^9, {
   3.5958046756872463`*^9, 3.595804689151045*^9}},
 CellLabel->
  "In[254]:=",ExpressionUUID->"4140bab7-9f3d-48a4-a110-a6dca391c26b"],

Cell[TextData[{
 "RotationAngleCos2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "] returns the cosine of the angle at point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " of triangle ",
 StyleBox["p,q,r.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.595804252622088*^9, 3.595804400988049*^9}, {
  3.595804540037311*^9, 3.595804572849007*^9}, {3.595804702802049*^9, 
  3.595804715759862*^9}, {3.595805156549969*^9, 
  3.595805167639102*^9}},ExpressionUUID->"e9b2efb2-c236-4f08-b0b9-\
4db78048add2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngleCos2D", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"q", "-", "p"}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{"r", "-", "p"}], ")"}]}], 
   RowBox[{
    RowBox[{"Mag", "[", 
     RowBox[{"q", "-", "p"}], "]"}], 
    RowBox[{"Mag", "[", 
     RowBox[{"r", "-", "p"}], "]"}]}]]}]], "Input",
 CellChangeTimes->{{3.59580458554708*^9, 3.595804687865337*^9}, {
   3.595805174225828*^9, 3.595805187500271*^9}, 3.5958052905950747`*^9},
 CellLabel->
  "In[255]:=",ExpressionUUID->"628e64a0-5c59-42f9-9b98-2ddaaee8b383"],

Cell["Example", "Text",
 CellChangeTimes->{{3.595804666411034*^9, 
  3.5958046673150067`*^9}},ExpressionUUID->"b57306d3-e7b5-43d4-a552-\
994c3bfc46c5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngleCos2D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.595804029849597*^9, 3.595804045925337*^9}, {
   3.595804093378405*^9, 3.595804096097535*^9}, 3.595804497110134*^9, {
   3.5958046756872463`*^9, 3.595804689151045*^9}, 3.595805301494165*^9},
 CellLabel->
  "In[256]:=",ExpressionUUID->"cfa3ea83-000a-4c18-aaa2-e1dfa97d756e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnnormalizedRotationMatrix2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]\nRotationMatrix2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.469130092041546*^9, 3.4691301107135987`*^9}, {
   3.4691312231618*^9, 3.46913125484473*^9}, 3.595805506660266*^9, 
   3.595805538251283*^9, {3.595805570500829*^9, 
   3.595805578545511*^9}},ExpressionUUID->"a17f137c-c6ea-4e8f-a68f-\
106d1d166f1d"],

Cell[TextData[{
 "UnnormalizedRotationMatrix2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "] returns a rotation matrix giving the CCW rotation from ",
 StyleBox["q",
  FontSlant->"Italic"],
 " to ",
 StyleBox["r",
  FontSlant->"Italic"],
 " about the point ",
 StyleBox["p",
  FontSlant->"Italic"],
 ". This is calculated using vector functions, not trig functions, but is not \
normalized."
}], "Text",
 CellChangeTimes->{{3.469129784936438*^9, 3.4691298428044252`*^9}, 
   3.594079647727311*^9, 3.595805506855743*^9, {3.595805570610725*^9, 
   3.595805578654939*^9}},ExpressionUUID->"8dac44ad-cb1b-4daa-9ec7-\
5d0f0145ba9e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnnormalizedRotationMatrix2D", "[", 
   RowBox[{"p_", ",", "q_", ",", "r_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r1", ",", "r2", ",", "c", ",", "s"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"r1", "=", 
      RowBox[{"q", "-", "p"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r2", "=", 
      RowBox[{"r", "-", "p"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{"r1", ".", "r2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{"r1", ".", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}], ".", "r2"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", 
         RowBox[{"-", "s"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "c"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.469129847884962*^9, 3.4691299645089273`*^9}, 
   3.595805506899208*^9, {3.595805570713594*^9, 3.595805639063745*^9}},
 CellLabel->
  "In[257]:=",ExpressionUUID->"2092e736-2572-4eb7-940d-d717f53f5e22"],

Cell["Example", "Text",
 CellChangeTimes->{{3.469129986785536*^9, 
  3.469129987463975*^9}},ExpressionUUID->"bb51e3b0-7b1e-439a-8a06-\
e616223ac4bd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnnormalizedRotationMatrix2D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.4691299892419176`*^9, 3.469130004331946*^9}, {
   3.469130068439855*^9, 3.469130070480109*^9}, {3.469131523064151*^9, 
   3.4691315280395*^9}, 3.595805507155334*^9},
 CellLabel->
  "In[258]:=",ExpressionUUID->"1b2d4b71-587e-4b9f-a994-a33339a761c3"],

Cell[TextData[{
 "RotationMatrix2D[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "] returns the same thing but the result is normalized to produce a unitary \
matrix."
}], "Text",
 CellChangeTimes->{{3.469130027236946*^9, 3.469130062189808*^9}, {
   3.595803516437998*^9, 3.595803516717447*^9}, 3.595805538326393*^9, {
   3.595805570786973*^9, 3.5958055787439003`*^9}, 
   3.5958056776022177`*^9},ExpressionUUID->"7228a2d6-8922-4589-a46d-\
c0e743a4a325"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix2D", "[", 
   RowBox[{"p_", ",", "q_", ",", "r_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", "s"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c", "=", 
      RowBox[{"RotationAngleCos2D", "[", 
       RowBox[{"p", ",", "q", ",", "r"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{"RotationAngleSin2D", "[", 
       RowBox[{"p", ",", "q", ",", "r"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", 
         RowBox[{"-", "s"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "c"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.469129847884962*^9, 3.4691299645089273`*^9}, 
   3.469130081253197*^9, {3.469130128856967*^9, 3.469130176675707*^9}, 
   3.5958055383589993`*^9, {3.595805570823778*^9, 3.5958055784584208`*^9}, {
   3.595805685621784*^9, 3.5958057113619843`*^9}},
 CellLabel->
  "In[259]:=",ExpressionUUID->"1bc765dc-10bf-4ff8-8554-b949148059a4"],

Cell["Example", "Text",
 CellChangeTimes->{{3.469129986785536*^9, 
  3.469129987463975*^9}},ExpressionUUID->"b1277550-1aec-44fc-a8c2-\
2d15c4572823"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix2D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}], "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.4691299892419176`*^9, 3.469130004331946*^9}, {
   3.469130068439855*^9, 3.469130082651464*^9}, {3.469131533224663*^9, 
   3.469131537423579*^9}, 3.595805538391992*^9},
 CellLabel->
  "In[260]:=",ExpressionUUID->"01affec5-156e-4037-94c3-211dfd9a3582"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "RotationMatrix2D[\[Phi]]\nRotationMatrix2D[{",
 StyleBox["c",
  FontSlant->"Italic"],
 ", ",
 StyleBox["s",
  FontSlant->"Italic"],
 "}]\nRotationMatrix[\[Phi]] [deprecated]"
}], "Subsubsection",
 CellChangeTimes->{{3.595973417916556*^9, 3.595973418730864*^9}, {
  3.688166689920376*^9, 3.68816669423217*^9}, {3.688166867702128*^9, 
  3.688166881668052*^9}, {3.691276136163655*^9, 
  3.691276153897573*^9}},ExpressionUUID->"c8521dcb-1eda-4e96-bef6-\
7667e3658bda"],

Cell[TextData[{
 "RotationMatrix2D[\[Phi]] returns the rotation matrix in 2D that rotates \
through an angle \[Phi] in the counterclockwise direction. We use the \
built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function."
}], "Text",
 CellChangeTimes->{{3.595527150814253*^9, 3.595527155830255*^9}, {
  3.5959734406585283`*^9, 
  3.595973450744684*^9}},ExpressionUUID->"8bd07a22-9c23-4a89-a2f9-\
2142402da8ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix2D", "[", "\[Phi]_", "]"}], ":=", 
  RowBox[{"RotationMatrix", "[", "\[Phi]", "]"}]}]], "Input",
 CellChangeTimes->{{3.457611662714284*^9, 3.457611665960946*^9}},
 CellLabel->
  "In[261]:=",ExpressionUUID->"2480f935-35e7-4dd6-b3c7-d69799d4c9a1"],

Cell["\<\
The 2D matrices for a 90\[Degree] left or right turn are pretty common, so we \
give explicit versions to save some trig evaluations. Some timing tests show \
about a factor of 20\[Times] improvement.\
\>", "Text",
 CellChangeTimes->{{3.799598725434896*^9, 3.7995987488503337`*^9}, {
  3.799598976005332*^9, 3.799598981916487*^9}, {3.799599057005585*^9, 
  3.799599145069512*^9}},ExpressionUUID->"50b108e6-d2d6-401f-a5b8-\
8f15fbeb30cb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RotationMatrix2D", "[", 
    RowBox[{"\[Pi]", "/", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RotationMatrix2D", "[", 
    RowBox[{
     RowBox[{"-", "\[Pi]"}], "/", "2"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.799598994107117*^9, 3.79959904386614*^9}},
 CellLabel->
  "In[262]:=",ExpressionUUID->"d378aabf-b205-4ada-b2cc-a47aa4e7aa42"],

Cell[TextData[{
 "RotationMatrix2D[{",
 StyleBox["c",
  FontSlant->"Italic"],
 ",",
 StyleBox["s",
  FontSlant->"Italic"],
 "}] returns the rotation matrix in 2D that rotates through an angle whose \
angle cosine is ",
 StyleBox["c",
  FontSlant->"Italic"],
 " and whose angle sine is ",
 StyleBox["s",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.691276170313834*^9, 
  3.691276283292976*^9}},ExpressionUUID->"6f55bcec-45bb-44b1-bd8f-\
5679b97d2563"],

Cell["\<\
This can be useful in vector analyses, where you can construct the angle \
sines and cosines with dot products, and using this function to perform \
rotations avoids using inverse trig functions, which can be problematic in \
analytic analyses.\
\>", "Text",
 CellChangeTimes->{{3.69127628557349*^9, 
  3.691276318053104*^9}},ExpressionUUID->"ff8cc52f-bcf7-42fd-83c3-\
219956d9a454"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix2D", "[", 
   RowBox[{"{", 
    RowBox[{"c_", ",", "s_"}], "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"-", "s"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "c"}], "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.691276319813118*^9, 3.6912763475980673`*^9}},
 CellLabel->
  "In[264]:=",ExpressionUUID->"8dcc3e4a-7102-4bac-9f34-cbb22d3b06f5"],

Cell["\<\
RotationMatrix[\[Phi]] is the built-in function that returns the 2D matrix \
that rotates a vector through an angle \[Phi] in the counterclockwise \
direction. I suggest using RotationMatrix2D, to make clear the dimensionality \
for readability.\
\>", "Text",
 CellChangeTimes->{{3.595972729134034*^9, 3.595972758502877*^9}, {
  3.688166710935295*^9, 
  3.688166751204032*^9}},ExpressionUUID->"0d644afd-1e8c-4e65-b8fc-\
fe1a61c844cd"],

Cell["Example", "Text",
 CellChangeTimes->{{3.688166662012147*^9, 
  3.688166662761397*^9}},ExpressionUUID->"bcd00050-9230-439a-bfc6-\
5cdf3279a0f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationMatrix", "[", "\[Phi]", "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.688166664199812*^9, 3.688166676706779*^9}},
 CellLabel->
  "In[265]:=",ExpressionUUID->"e88511ef-7475-47f7-a0e9-1cd68acea910"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Rotate90[",
 StyleBox["p",
  FontSlant->"Italic"],
 "]\nRotateSegment90[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{
  3.457529432714981*^9, {3.457529683918068*^9, 3.457529693629096*^9}, 
   3.457532343057173*^9, {3.4852202737907867`*^9, 3.485220275115965*^9}, {
   3.551817503079177*^9, 3.551817514196315*^9}, 3.595806214510419*^9, 
   3.595972596907359*^9, 
   3.5959728098896*^9},ExpressionUUID->"4406ceab-d6c9-48b3-a51c-b108f6570592"],

Cell[TextData[{
 "Rotate90[",
 StyleBox["p",
  FontSlant->"Italic"],
 "] rotates the point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " by 90 degrees CCW about the origin (or rotates a direction vector v by 90\
\[Degree])."
}], "Text",
 CellChangeTimes->{{3.551817573544958*^9, 3.55181757523993*^9}, {
  3.595972812474086*^9, 
  3.595972834224523*^9}},ExpressionUUID->"4b6989f1-0213-4be1-a3b7-\
bbc01b8bc197"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rotate90", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ".", "#"}], "&"}]}], 
  ";"}]], "Input",
 CellLabel->
  "In[266]:=",ExpressionUUID->"5f81159d-4f2e-4eb7-a454-637444c13076"],

Cell["Example", "Text",
 CellChangeTimes->{{3.551817760561383*^9, 
  3.55181776124937*^9}},ExpressionUUID->"a6a7655a-c24e-4b27-bd00-\
eb1a997b020f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Rotate90", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.551817762590546*^9, 3.551817776491908*^9}},
 CellLabel->
  "In[267]:=",ExpressionUUID->"7ee39b3b-1af5-425a-83c6-024e0c47428c"],

Cell[TextData[{
 "RotateSegment90[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}] rotates the line segment {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} by 90\[Degree] CCW."
}], "Text",
 CellChangeTimes->{{3.551817542759199*^9, 
  3.551817571903932*^9}},ExpressionUUID->"c9519d88-9971-4897-9f01-\
33c5b1f1d20b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotateSegment90", "[", 
   RowBox[{"{", 
    RowBox[{"p1_", ",", "p2_"}], "}"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "=", 
       FractionBox[
        RowBox[{"p1", "+", "p2"}], "2"]}], ",", 
      RowBox[{"r", "=", 
       RowBox[{"Rotate90", "[", 
        FractionBox[
         RowBox[{"p2", "-", "p1"}], "2"], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "-", "r"}], ",", 
      RowBox[{"s", "+", "r"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.551817520443983*^9, 3.551817540037963*^9}, {
  3.551817594361504*^9, 3.551817686730467*^9}},
 CellLabel->
  "In[268]:=",ExpressionUUID->"f3b35625-9263-475d-a568-903181ca00b9"],

Cell["Example", "Text",
 CellChangeTimes->{{3.551817691472491*^9, 
  3.551817692142346*^9}},ExpressionUUID->"a1b409f2-d029-4522-bdaf-\
b97ca3410b29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotateSegment90", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.5518176949897137`*^9, 3.551817752182363*^9}},
 CellLabel->
  "In[269]:=",ExpressionUUID->"3f7514c6-df65-4fe8-b2cc-90a99c439db0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "AbsoluteAngle[",
 StyleBox["r",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.457661577694493*^9, 3.457661623625711*^9}, {
   3.457661666606838*^9, 3.457661670687749*^9}, {3.458173240797171*^9, 
   3.4581732690957203`*^9}, {3.628786185153776*^9, 3.62878618521703*^9}, 
   3.726085305784305*^9},ExpressionUUID->"2f463a0b-4c18-4051-986a-\
7c862b41b067"],

Cell[TextData[{
 "AbsoluteAngle",
 "[",
 StyleBox["r",
  FontSlant->"Italic"],
 "] returns the absolute 2D angle of vector ",
 StyleBox["r",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.457661673414407*^9, 3.457661687998254*^9}, 
   3.458173269115253*^9, 
   3.628786185279459*^9},ExpressionUUID->"4e6ef825-281d-4d17-9915-\
50434746490f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AbsoluteAngle", "[", "r_List", "]"}], ":=", 
  RowBox[{"ArcTan", "@@", "r"}]}]], "Input",
 CellChangeTimes->{{3.457661701741249*^9, 3.457661711862779*^9}, 
   3.4581732691342278`*^9, 3.628786185303348*^9, {3.677077618589479*^9, 
   3.677077618893205*^9}},
 CellLabel->
  "In[270]:=",ExpressionUUID->"aff36a46-ac66-43d1-ad47-8885ee92dbae"],

Cell["Example", "Text",
 CellChangeTimes->{{3.4576617231007223`*^9, 
  3.457661725451115*^9}},ExpressionUUID->"4a577b48-de3b-4a9a-ba13-\
0d09538f777d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"AbsoluteAngle", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "]"}], "/", "\[Degree]"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.457661727144067*^9, 3.457661748684517*^9}, 
   3.458173269168275*^9, 3.628786185347219*^9},
 CellLabel->
  "In[271]:=",ExpressionUUID->"1a20aa2f-d2f1-47d0-a8b1-21543a93973a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "RotationAngle[",
 StyleBox["r1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r2",
  FontSlant->"Italic"],
 "]\nRotationAngle[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]\nRotationAngle[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.457661804738179*^9, 3.457661821665165*^9}, {
  3.4576618981562557`*^9, 3.457661943482769*^9}, {3.552089205484733*^9, 
  3.5520892083718224`*^9}, {3.627572249590704*^9, 3.627572250489521*^9}, {
  3.627573212502178*^9, 3.627573215496398*^9}, {3.6287862211723967`*^9, 
  3.62878622136578*^9}, {3.778749249572455*^9, 3.778749256588821*^9}, {
  3.7787496710543203`*^9, 
  3.778749676571596*^9}},ExpressionUUID->"64708bc5-8d7f-4ea6-b482-\
11d9943609ca"],

Cell[TextData[{
 "RotationAngle[",
 StyleBox["r1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r2",
  FontSlant->"Italic"],
 "] returns the CCW rotation angle from direction ",
 StyleBox["r1",
  FontSlant->"Italic"],
 " to direction ",
 StyleBox["r2",
  FontSlant->"Italic"],
 " with the angle in the range (-\[Pi], \[Pi]]."
}], "Text",
 CellChangeTimes->{{3.552088882545014*^9, 3.552088956492278*^9}, {
   3.627573110934926*^9, 3.627573115140402*^9}, {3.628786221451331*^9, 
   3.62878622151293*^9}, 3.778749267929983*^9, {3.778750021822681*^9, 
   3.778750032917762*^9}},ExpressionUUID->"769109fc-ad04-4662-8378-\
56edf25af94c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngle", "[", 
   RowBox[{"r1_List", ",", "r2__List"}], "]"}], ":=", 
  RowBox[{"ArcTan", "[", 
   RowBox[{
    RowBox[{"r1", ".", "r2"}], ",", 
    RowBox[{
     RowBox[{"Rotate90", "[", "r1", "]"}], ".", "r2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4576618453686743`*^9, 3.457661861665861*^9}, {
   3.457661952132098*^9, 3.457661985098384*^9}, {3.45817326932606*^9, 
   3.458173269348318*^9}, {3.5520891726943293`*^9, 3.5520891775967627`*^9}, {
   3.627572253535713*^9, 3.627572254467901*^9}, {3.627573138274952*^9, 
   3.627573183751463*^9}, 3.628786221536851*^9, {3.778749323642242*^9, 
   3.77874933129638*^9}, {3.778749422797147*^9, 3.778749424578678*^9}, {
   3.778749896037099*^9, 3.778749900318091*^9}},
 CellLabel->
  "In[272]:=",ExpressionUUID->"50421523-5e15-4706-8ec6-14043f29c965"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.5520890148318987`*^9, 3.552089015540592*^9}, {
  3.778749297841058*^9, 
  3.77874929857685*^9}},ExpressionUUID->"c233e615-fdf8-40a3-b07c-\
58513708d6c1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAngle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "/", "\[Degree]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.5520890179911203`*^9, 3.5520890517235518`*^9}, {
   3.552089090161071*^9, 3.552089129135871*^9}, 3.628786221579646*^9, 
   3.692225688358957*^9},
 CellLabel->
  "In[273]:=",ExpressionUUID->"9e966c72-5996-46ed-b392-22bedf46465a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAngle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "/", "\[Degree]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.552089136279097*^9, 3.552089140991652*^9}, 
   3.628786221629806*^9, 3.692225690037181*^9},
 CellLabel->
  "In[274]:=",ExpressionUUID->"e6dc68f6-1af1-4761-be61-a60f35e0b934"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.778750000450873*^9, 3.7787500141810102`*^9}},
 CellLabel->
  "In[275]:=",ExpressionUUID->"bd617014-910e-4b7b-b50f-5c845fcec7c9"],

Cell[TextData[{
 "RotationAngle[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "] returns the CCW rotation angle from the line segment running from ",
 StyleBox["p",
  FontSlant->"Italic"],
 " to ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", to the line segment running from ",
 StyleBox["p",
  FontSlant->"Italic"],
 " to ",
 StyleBox["r",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.457662057582595*^9, 3.457662100742443*^9}, {
   3.53454534784383*^9, 3.53454534889999*^9}, 3.62757225537214*^9, {
   3.627572309421568*^9, 3.627572326706611*^9}, {3.628786221752411*^9, 
   3.6287862218199806`*^9}, 3.778749628464129*^9, {3.778749834341109*^9, 
   3.778749856643696*^9}},ExpressionUUID->"e986797c-07fd-4f82-b4c9-\
66d35f7b8b11"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngle", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  RowBox[{"RotationAngle", "[", 
   RowBox[{
    RowBox[{"q", "-", "p"}], ",", 
    RowBox[{"r", "-", "p"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4576618453686743`*^9, 3.457661861665861*^9}, {
   3.457661952132098*^9, 3.457661985098384*^9}, {3.45817326932606*^9, 
   3.458173269348318*^9}, {3.5520891726943293`*^9, 3.5520891775967627`*^9}, {
   3.627572253535713*^9, 3.627572254467901*^9}, {3.627573138274952*^9, 
   3.627573183751463*^9}, 3.628786221536851*^9, {3.778749323642242*^9, 
   3.77874933129638*^9}, {3.778749422797147*^9, 3.778749424578678*^9}, {
   3.778749868661495*^9, 3.778749890652421*^9}},
 CellLabel->
  "In[276]:=",ExpressionUUID->"1d251645-0917-4358-ab55-91597553b3f3"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.778749910340748*^9, 
  3.778749911643952*^9}},ExpressionUUID->"63fb24eb-2f21-466c-b39b-\
f32c55154096"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAngle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}]}], "]"}], "/", "\[Degree]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.778749914276853*^9, 3.778749970796717*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"8b0ecbae-a681-4cc1-b7a4-76ef3dbe8913"],

Cell[TextData[{
 "RotationAngle[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] returns the CCW rotation angle from the line segment running from ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " to ",
 StyleBox["p2",
  FontSlant->"Italic"],
 ", to the line segment running from ",
 StyleBox["q1",
  FontSlant->"Italic"],
 " to ",
 StyleBox["q2.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.457662057582595*^9, 3.457662100742443*^9}, {
   3.53454534784383*^9, 3.53454534889999*^9}, 3.62757225537214*^9, {
   3.627572309421568*^9, 3.627572326706611*^9}, {3.628786221752411*^9, 
   3.6287862218199806`*^9}, 
   3.778749628464129*^9},ExpressionUUID->"420a45e9-69f2-4869-b5fc-\
60eb12ee6498"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_List", ",", "p2_List"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"RotationAngle", "[", 
   RowBox[{
    RowBox[{"p2", "-", "p1"}], ",", 
    RowBox[{"q2", "-", "q1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4576621129874372`*^9, 3.457662151223184*^9}, {
   3.458174195796048*^9, 3.458174208520958*^9}, 3.534545641971156*^9, {
   3.62757225621249*^9, 3.62757225708817*^9}, {3.628786221864107*^9, 
   3.628786221897014*^9}, {3.778749770504678*^9, 3.778749772346949*^9}},
 CellLabel->
  "In[278]:=",ExpressionUUID->"f67953fd-bd51-4522-b512-169fee595ce1"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.627573247319663*^9, 3.627573252758282*^9}, 
   3.778749817539822*^9},ExpressionUUID->"db6c9235-9ef2-48ec-8e0d-\
5a5c2c5680c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.534545655355576*^9, 3.534545717680284*^9}, 
   3.628786221948097*^9},
 CellLabel->
  "In[279]:=",ExpressionUUID->"64307313-8237-40e5-8344-cc02436510b4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "RotationAnglePositive[",
 StyleBox["r1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r2",
  FontSlant->"Italic"],
 "]\nRotationAnglePositive[",
 StyleBox["p, q, r",
  FontSlant->"Italic"],
 "]\nRotationAnglePositive[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.778749251939061*^9, 3.778749261145402*^9}, {
  3.778749450489572*^9, 3.77874945920222*^9}, {3.77875081599593*^9, 
  3.778750837547447*^9}},ExpressionUUID->"ed7b70d7-1cf0-482f-8360-\
b18a264f2bf6"],

Cell[TextData[{
 "RotationAnglePositive[",
 StyleBox["r1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r2",
  FontSlant->"Italic"],
 "] does the same thing as RotationAngle[",
 StyleBox["r1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r2",
  FontSlant->"Italic"],
 "], but maps the angle to the range [0, 2\[Pi]]."
}], "Text",
 CellChangeTimes->{{3.77874927085993*^9, 3.7787492736179547`*^9}, {
  3.778749465627954*^9, 3.778749474545839*^9}, {3.778750816022304*^9, 
  3.7787508481200533`*^9}},ExpressionUUID->"4491c49a-5de4-420f-a38a-\
80cc0dd14e76"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAnglePositive", "[", 
   RowBox[{"r1_List", ",", "r2_List"}], "]"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"RotationAngle", "[", 
     RowBox[{"r1", ",", "r2"}], "]"}], ",", 
    RowBox[{"2", "\[Pi]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4576618453686743`*^9, 3.457661861665861*^9}, {
   3.457661952132098*^9, 3.457661985098384*^9}, {3.45817326932606*^9, 
   3.458173269348318*^9}, {3.5520891726943293`*^9, 3.5520891775967627`*^9}, {
   3.627572253535713*^9, 3.627572254467901*^9}, {3.627573138274952*^9, 
   3.627573183751463*^9}, 3.628786221536851*^9, {3.77874948145418*^9, 
   3.778749489681741*^9}, {3.778750172622145*^9, 3.778750178686013*^9}, {
   3.778750252744483*^9, 3.778750258942249*^9}, 3.778750816030512*^9, {
   3.778750860115389*^9, 3.778750863907316*^9}, {3.778750952013349*^9, 
   3.778750965878435*^9}, {3.778762172530182*^9, 3.778762173006834*^9}},
 CellLabel->
  "In[280]:=",ExpressionUUID->"20e949ea-d1c7-40ff-90c3-1a9e13ca69bd"],

Cell["Example. Compare RotationAngle and RotationAnglePositive.", "Text",
 CellChangeTimes->{{3.77874943753817*^9, 3.778749447554125*^9}, 
   3.77875081604078*^9},ExpressionUUID->"d01692d0-9baa-4d54-8443-\
43b1bfc9db68"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAngle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "/", "\[Degree]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.552089136279097*^9, 3.552089140991652*^9}, 
   3.628786221629806*^9, 3.692225690037181*^9},
 CellLabel->
  "In[281]:=",ExpressionUUID->"011abc51-537a-45bd-8c77-c96c7ebb021f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAnglePositive", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "/", "\[Degree]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.552089136279097*^9, 3.552089140991652*^9}, {
   3.627573270264966*^9, 3.62757327077602*^9}, 3.628786221680186*^9, 
   3.692225691277048*^9, {3.778749504411353*^9, 3.778749505209565*^9}, 
   3.778750816051547*^9, {3.77875087259582*^9, 3.778750872963373*^9}},
 CellLabel->
  "In[282]:=",ExpressionUUID->"90657510-b63d-419d-ac1f-a5e255fb9f4b"],

Cell[TextData[{
 "RotationAnglePositive[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "] does the same thing as RotationAngle[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "] but maps the angle to the range [0, 2\[Pi]]."
}], "Text",
 CellChangeTimes->{
  3.7787501531683598`*^9, {3.778750193926263*^9, 3.778750205278537*^9}, 
   3.778750816062231*^9, {3.778750875875625*^9, 
   3.778750884855145*^9}},ExpressionUUID->"a77041d5-dc9a-42c9-8cf9-\
53fa21578d72"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAnglePositive", "[", 
   RowBox[{"p_List", ",", "q_List", ",", "r_List"}], "]"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"RotationAngle", "[", 
     RowBox[{"p", ",", "q", ",", "r"}], "]"}], ",", 
    RowBox[{"2", "\[Pi]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.778750228847423*^9, 3.7787502390462103`*^9}, 
   3.778750816071159*^9, {3.778750887846296*^9, 3.778750893603471*^9}, 
   3.778750977662312*^9, {3.778762176604189*^9, 3.778762176919921*^9}},
 CellLabel->
  "In[283]:=",ExpressionUUID->"fc9b228f-0e5d-43d5-a534-26581198c847"],

Cell["Example. Compare RotationAngle and RotationAnglePositive.", "Text",
 CellChangeTimes->{{3.77874943753817*^9, 3.778749447554125*^9}, 
   3.778750816081799*^9},ExpressionUUID->"ce3375d7-25ba-4337-ba27-\
39d4648142b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAngle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.1", ",", " ", "0.2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "/", "\[Degree]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.552089136279097*^9, 3.552089140991652*^9}, 
   3.628786221629806*^9, 3.692225690037181*^9, {3.778750290232816*^9, 
   3.778750297822397*^9}},
 CellLabel->
  "In[284]:=",ExpressionUUID->"a85b886d-97d8-4ac6-a1a5-904fb652d6b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAnglePositive", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.1", ",", " ", "0.2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], "/", "\[Degree]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.552089136279097*^9, 3.552089140991652*^9}, {
   3.627573270264966*^9, 3.62757327077602*^9}, 3.628786221680186*^9, 
   3.692225691277048*^9, {3.778749504411353*^9, 3.778749505209565*^9}, 
   3.778750303345715*^9, 3.778750816092875*^9, {3.778750899619255*^9, 
   3.778750899971374*^9}},
 CellLabel->
  "In[285]:=",ExpressionUUID->"e30ce203-f282-4231-ade9-a41af7d6d606"],

Cell[TextData[{
 "RotationAnglePositive[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}, ",
 StyleBox["angleoffset",
  FontSlant->"Italic"],
 "] does the same thing as RotationAngle[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] but maps the angle to the range [0, 2\[Pi]]."
}], "Text",
 CellChangeTimes->{{3.778749634541078*^9, 3.778749647548086*^9}, {
   3.778750324042055*^9, 3.778750327871566*^9}, 3.778750816104065*^9, 
   3.778750906245591*^9},ExpressionUUID->"68bb23ee-3edd-4a72-a246-\
e03bbc376ceb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAnglePositive", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_List", ",", "p2_List"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"RotationAngle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}], ",", 
    RowBox[{"2", "\[Pi]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4576621129874372`*^9, 3.457662151223184*^9}, {
   3.458174195796048*^9, 3.458174208520958*^9}, 3.534545641971156*^9, {
   3.62757225621249*^9, 3.62757225708817*^9}, {3.628786221864107*^9, 
   3.628786221897014*^9}, {3.778749527432982*^9, 3.778749532065814*^9}, {
   3.7787503390572033`*^9, 3.778750355334927*^9}, 3.778750816113926*^9, {
   3.7787509096041107`*^9, 3.77875091222744*^9}, 3.778750983501834*^9},
 CellLabel->
  "In[286]:=",ExpressionUUID->"60141f1a-068e-4abc-9950-d71e9609fd2d"],

Cell["Example. Compare RotationAngle and RotationAnglePositive.", "Text",
 CellChangeTimes->{{3.627573247319663*^9, 3.627573252758282*^9}, 
   3.778749817539822*^9, 3.778750388746557*^9, 
   3.778750816132679*^9},ExpressionUUID->"495a5a68-e198-4a10-9c83-\
2f6a80524713"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAngle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.", ",", "0."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}], "/", "\[Degree]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.534545655355576*^9, 3.534545717680284*^9}, 
   3.628786221948097*^9, {3.778750409905025*^9, 3.778750428439323*^9}, 
   3.778750461457748*^9},
 CellLabel->
  "In[287]:=",ExpressionUUID->"404e9462-f5ca-4e2d-a80c-8582b17b84cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RotationAnglePositive", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.", ",", "0."}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}], "/", "\[Degree]"}], "//",
   "ShowExample"}]], "Input",
 CellChangeTimes->{{3.534545655355576*^9, 3.534545717680284*^9}, 
   3.628786221948097*^9, {3.778750409905025*^9, 3.778750428439323*^9}, {
   3.778750473896888*^9, 3.778750485732031*^9}, 3.778750816145068*^9, {
   3.7787509159635897`*^9, 3.778750916364046*^9}},
 CellLabel->
  "In[288]:=",ExpressionUUID->"932f1f11-17ff-4024-80c8-ce214c06b2bb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "AbsoluteAngles[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["plist",
  FontSlant->"Italic"],
 "]\nRotationAngles[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["plist",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.677077505077634*^9, 
  3.67707755351892*^9}},ExpressionUUID->"f2bf0996-f73d-4a38-bb2e-\
49fc5917bcfe"],

Cell[TextData[{
 "AbsoluteAngles[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["plist",
  FontSlant->"Italic"],
 "] gives the absolute angles from point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " to to each of the points in ",
 StyleBox["plist",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.6770775570934367`*^9, 3.677077596940702*^9}, {
  3.778748987711408*^9, 
  3.778748988199016*^9}},ExpressionUUID->"21e67e4d-bd80-47cd-931b-\
aa665055deb9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AbsoluteAngles", "[", 
   RowBox[{"p_List", ",", "plist_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"AbsoluteAngle", "[", 
     RowBox[{"#", "-", "p"}], "]"}], "&"}], "/@", "plist"}]}]], "Input",
 CellChangeTimes->{{3.677077609383117*^9, 3.677077649789316*^9}},
 CellLabel->
  "In[289]:=",ExpressionUUID->"eaeff00b-a625-40f4-bdd7-b7e6ad982d2b"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.6770776728220587`*^9, 
  3.677077674086686*^9}},ExpressionUUID->"2cbf9ce8-9394-4fb0-9dd7-\
a76ddd487099"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "plist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"plist", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"p", ",", "#"}], "}"}], "]"}], "&"}], "/@", "plist"}], 
           ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", "Black"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", "plist"}], ",", "Red"}], "]"}]}], "}"}], 
       "]"}], "//", "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"AbsoluteAngles", "[", 
        RowBox[{"p", ",", "plist"}], "]"}], "/", "\[Degree]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.677077675947906*^9, 3.677077831510381*^9}},
 CellLabel->
  "In[290]:=",ExpressionUUID->"1aa37592-93ed-47af-ae7b-ecf8b3604b4d"],

Cell[TextData[{
 "RotationAngles[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", ",
 StyleBox["plist",
  FontSlant->"Italic"],
 "] gives the CCW rotation angles about ",
 StyleBox["p",
  FontSlant->"Italic"],
 " between successive points in ",
 StyleBox["plist",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.677077517088592*^9, 3.677077525209014*^9}, {
  3.677077839341764*^9, 3.6770778600596538`*^9}, {3.778749005390739*^9, 
  3.778749009062947*^9}},ExpressionUUID->"6850e636-52aa-4d00-b4d0-\
6e23eba82112"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngles", "[", 
   RowBox[{"p_List", ",", "plist_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"#", ",", 
      RowBox[{"2", "\[Pi]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RotateLeft", "[", 
        RowBox[{"#", ",", "1"}], "]"}], "-", "#"}], "&"}], "@", 
     RowBox[{"AbsoluteAngles", "[", 
      RowBox[{"p", ",", "plist"}], "]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.677077869956356*^9, 3.6770779749084663`*^9}, {
  3.677078007379938*^9, 3.67707801813748*^9}},
 CellLabel->
  "In[291]:=",ExpressionUUID->"5fdb2530-db38-40a6-b455-cfbdc5cf53fb"],

Cell["Example", "Text",
 CellChangeTimes->{{3.6770779848022614`*^9, 
  3.6770779855395803`*^9}},ExpressionUUID->"0294dfc5-03ac-4937-8540-\
10c6424ff59b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "plist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"plist", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"p", ",", "#"}], "}"}], "]"}], "&"}], "/@", "plist"}], 
           ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", "Black"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "/@", "plist"}], ",", "Red"}], "]"}]}], "}"}], 
       "]"}], "//", "Print"}], ";", "\[IndentingNewLine]", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"RotationAngles", "[", 
        RowBox[{"p", ",", "plist"}], "]"}], "/", "\[Degree]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.677077675947906*^9, 3.677077831510381*^9}, {
  3.677077995170511*^9, 3.67707799926793*^9}, {3.677078030556426*^9, 
  3.67707803230634*^9}},
 CellLabel->
  "In[292]:=",ExpressionUUID->"fd064929-39dd-44e3-a451-5188550e3817"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ScaleRotationOffset[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.627571991193032*^9, 3.627572039308728*^9}, {
   3.627572372744852*^9, 3.627572376382674*^9}, {3.627572756854209*^9, 
   3.627572764551322*^9}, {3.627572889624671*^9, 3.627572896198857*^9}, {
   3.627573020485746*^9, 3.627573028959056*^9}, {3.62878624699825*^9, 
   3.628786247066728*^9}, 
   3.7787511891746197`*^9},ExpressionUUID->"7677da3d-716d-4ffc-bc7c-\
1e35fd1ac7a5"],

Cell[TextData[{
 "ScaleRotationOffset[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] returns a list {",
 StyleBox["scale, rotation, offset",
  FontSlant->"Italic"],
 "} that transforms the line segment {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} to the segment {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}, via sequential scale, rotation-about-origin, offset. Rotation is given \
as an angle. Note that the offset is applied last."
}], "Text",
 CellChangeTimes->{{3.627572047396574*^9, 3.62757216630088*^9}, 
   3.627572765625537*^9, {3.627572832600632*^9, 3.627572859231009*^9}, 
   3.627572902303552*^9, {3.627572980208088*^9, 3.6275730025175357`*^9}, {
   3.627573366497279*^9, 3.6275733879085636`*^9}, 3.627573427982486*^9, {
   3.6287823357448463`*^9, 3.628782357404974*^9}, 3.628786247150931*^9, {
   3.649955513406292*^9, 3.6499555188681393`*^9}, {3.778677556375963*^9, 
   3.778677561614482*^9}},ExpressionUUID->"d83666ca-c094-4f18-b263-\
a7a87bb1d345"],

Cell["\<\
This is used in tiling functions EmbedTile, EmbedTiling and JoinTiling, see \
below.\
\>", "Text",
 CellChangeTimes->{{3.627572402860952*^9, 3.627572439139001*^9}, 
   3.627652612751782*^9},ExpressionUUID->"a2709416-f000-4a1f-a063-\
f7ff9dbf5516"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ScaleRotationOffset", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_", ",", "p2_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_", ",", "q2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rp", ",", "rq", ",", "offset", ",", "scale", ",", "rotation"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rp", "=", 
      RowBox[{"p2", "-", "p1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rq", "=", 
      RowBox[{"q2", "-", "q1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rotation", "=", 
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{"rp", ".", "rq"}], ",", 
        RowBox[{
         RowBox[{"Rotate90", "[", "rp", "]"}], ".", "rq"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"scale", "=", 
      RowBox[{
       RowBox[{"Mag", "[", "rq", "]"}], "/", 
       RowBox[{"Mag", "[", "rp", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"offset", "=", 
      RowBox[{"q1", "-", 
       RowBox[{"(", 
        RowBox[{"scale", " ", 
         RowBox[{
          RowBox[{"RotationMatrix2D", "[", "rotation", "]"}], ".", "p1"}]}], 
        ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"scale", ",", " ", "rotation", ",", " ", "offset"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.627572027602129*^9, 3.627572041437995*^9}, {
   3.6275724448131847`*^9, 3.6275724545101438`*^9}, {3.627572565967601*^9, 
   3.627572729253528*^9}, 3.627572767444781*^9, 3.627572904342184*^9, {
   3.62757294517695*^9, 3.627572950063218*^9}, {3.627573036469166*^9, 
   3.627573066351201*^9}, {3.627573429590871*^9, 3.627573447016932*^9}, {
   3.6286996335747538`*^9, 3.628699648917762*^9}, {3.628699829879368*^9, 
   3.628699853127877*^9}, 3.6286999238128967`*^9, 3.62878624717598*^9, {
   3.631089237727402*^9, 3.631089286631709*^9}, 3.688166835955517*^9, 
   3.778751207135627*^9, {3.7787512961127*^9, 3.778751300582733*^9}},
 CellLabel->
  "In[293]:=",ExpressionUUID->"ace2cd6e-c1c1-40f3-87d6-1e3eb165e4e6"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.6275724625765557`*^9, 3.6275724633442793`*^9}, 
   3.778751316958664*^9},ExpressionUUID->"f41fb567-5fc4-40ec-a31a-\
b66a717f5458"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q1", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], ";", 
     RowBox[{"q2", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "/", "2"}], ",", 
        RowBox[{"3", "/", "2"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<{scale, rotation, offset} = \>\"", ",", 
       RowBox[{"ScaleRotationOffset", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p1", ",", "p2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Blue"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.627572464882554*^9, 3.627572550360984*^9}, {
   3.627572783258884*^9, 3.6275728201368*^9}, {3.627572906334482*^9, 
   3.627572928441511*^9}, {3.6275729612540693`*^9, 3.627572965253971*^9}, {
   3.62757343143579*^9, 3.627573438271096*^9}, 3.628786247205649*^9},
 CellLabel->
  "In[294]:=",ExpressionUUID->"7eeb0dd2-ae80-4b56-bee4-22d017b88354"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ScaleRotationOffsetFixedPoint[{",
 StyleBox["scale",
  FontSlant->"Italic"],
 ", ",
 StyleBox["rotation",
  FontSlant->"Italic"],
 ", ",
 StyleBox["offset",
  FontSlant->"Italic"],
 "}]\nScaleRotationOffsetFixedPoint[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.628782368308959*^9, 3.628782382059298*^9}, {
  3.628782781218118*^9, 
  3.628782795074729*^9}},ExpressionUUID->"48bb833f-6885-447b-bdee-\
649d8f3df541"],

Cell[TextData[{
 "ScaleRotationOffsetFixedPoint[{",
 StyleBox["scale",
  FontSlant->"Italic"],
 ", ",
 StyleBox["rotation",
  FontSlant->"Italic"],
 ", ",
 StyleBox["offset",
  FontSlant->"Italic"],
 "}] returns the point {",
 StyleBox["x",
  FontSlant->"Italic"],
 ", ",
 StyleBox["y",
  FontSlant->"Italic"],
 "} that is left unchanged by application of the specified ",
 StyleBox["scale",
  FontSlant->"Italic"],
 ", ",
 StyleBox["rotation",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["offset",
  FontSlant->"Italic"],
 ". It can be considered the center of a {",
 StyleBox["scale",
  FontSlant->"Italic"],
 ", ",
 StyleBox["rotation",
  FontSlant->"Italic"],
 "} transformation."
}], "Text",
 CellChangeTimes->{{3.628782396799987*^9, 3.628782427656363*^9}, {
  3.628782579911208*^9, 3.62878258768637*^9}, {3.6287827443403187`*^9, 
  3.628782773850589*^9}, {3.631089386490818*^9, 
  3.631089389816576*^9}},ExpressionUUID->"bf347f36-912a-4151-86fb-\
a8ade6c79030"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ScaleRotationOffsetFixedPoint", "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["scale_",
      FontSlant->"Italic"], ",", " ", 
     StyleBox["rotation_",
      FontSlant->"Italic"], ",", " ", 
     StyleBox["offset_",
      FontSlant->"Italic"]}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "\[Equal]", 
         RowBox[{
          RowBox[{"scale", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"RotationMatrix2D", "[", "rotation", "]"}], ".", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}]}], ")"}]}], "+", "offset"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[LeftDoubleBracket]", "1",
       "\[RightDoubleBracket]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.628782438179922*^9, 3.628782515695488*^9}, 
   3.688166835977981*^9, {3.7786782340977483`*^9, 3.778678238522605*^9}},
 CellLabel->
  "In[295]:=",ExpressionUUID->"d3d10e22-c629-4eea-893b-d1a5c19a9fb9"],

Cell["Example", "Text",
 CellChangeTimes->{{3.628782519964375*^9, 
  3.628782520818465*^9}},ExpressionUUID->"a8be4432-2561-445a-bb28-\
dc71b51d0c68"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "p1", ",", "p2", ",", "q1", ",", "q2", ",", "s", ",", "r", ",", "o", ",", 
     "ctr"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "q1", ",", "q2"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", "1"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", "r", ",", "o"}], "}"}], "=", 
     RowBox[{"ScaleRotationOffset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p1", ",", "p2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ctr", "=", 
     RowBox[{"ScaleRotationOffsetFixedPoint", "[", 
      RowBox[{"{", 
       RowBox[{"s", ",", "r", ",", "o"}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"PrintThis", "[", "ctr", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",", 
       
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Green"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Point", "[", "ctr", "]"}], ",", "Black"}], "]"}]}], "}"}], 
     "]"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.628782523698518*^9, 3.628782569315893*^9}, {
   3.628782604080317*^9, 3.628782734139502*^9}, 3.628786247255522*^9, {
   3.778678208819607*^9, 3.778678214920373*^9}, 3.778751179497716*^9},
 CellLabel->
  "In[296]:=",ExpressionUUID->"8f021c5e-ad75-4ef5-af55-9debd4fc522e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["ctr$30823",
    HoldForm], "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0.6`"}], "}"}]}],
  SequenceForm[
   HoldForm[$CellContext`ctr$30823], " = ", {0.2, 0.6}],
  Editable->False]], "Print",
 CellChangeTimes->{3.962635224482641*^9, 3.9666287926962023`*^9, 
  3.967120790445333*^9},
 CellLabel->
  "During evaluation of \
In[296]:=",ExpressionUUID->"f2244fb1-9b10-45c0-a01e-cd4184b57b53"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], LineBox[{{0, 0}, {1, 0}}]}, 
   {RGBColor[0, 1, 0], LineBox[{{0.5, 0.5}, {0.5, 1}}]}, 
   {GrayLevel[0], PointBox[{0.2, 0.6}]}}]], "Output",
 CellChangeTimes->{3.9626352244938602`*^9, 3.9666287927085543`*^9, 
  3.967120790449827*^9},
 CellLabel->
  "Out[296]=",ExpressionUUID->"21644ca1-1936-4423-9452-2c09e7294348"]
}, Closed]],

Cell[TextData[{
 "ScaleRotationOffsetFixedPoint[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] returns the fixed point of the scale-rotation-offset transformation that \
takes segment {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ",",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} to ",
 StyleBox["q1",
  FontSlant->"Italic"],
 ",",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}."
}], "Text",
 CellChangeTimes->{{3.628782810122484*^9, 
  3.62878284159822*^9}},ExpressionUUID->"febcc0ab-b4f3-4d5f-99f7-\
6d4d93e3c948"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ScaleRotationOffsetFixedPoint", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["p1_",
       FontSlant->"Italic"], ",", " ", 
      StyleBox["p2_",
       FontSlant->"Italic"]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["q1_",
       FontSlant->"Italic"], ",", " ", 
      StyleBox["q2_",
       FontSlant->"Italic"]}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", ",", "r", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "r", ",", "o"}], "}"}], "=", 
      RowBox[{"ScaleRotationOffset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ScaleRotationOffsetFixedPoint", "[", 
      RowBox[{"{", 
       RowBox[{"s", ",", "r", ",", "o"}], "}"}], "]"}]}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.62878285754265*^9, 3.628782889710027*^9}, 
   3.628786247307906*^9, 3.778751179501453*^9},
 CellLabel->
  "In[297]:=",ExpressionUUID->"bf67df69-3179-4f72-9696-27b840fc940d"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Similarity transformations", "Subsection",
 CellChangeTimes->{{3.6500329814481153`*^9, 3.650033010890065*^9}, 
   3.7084010194114037`*^9},ExpressionUUID->"a2be889c-e084-4ff5-8748-\
5cfe145c4db1"],

Cell[CellGroupData[{

Cell[TextData[{
 "SimilarityPair2D[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1, q2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.649955594143674*^9, 3.649955611765958*^9}, {
   3.649955666362898*^9, 3.649955666882547*^9}, {3.649955911620886*^9, 
   3.649955913915178*^9}, 3.649955947001966*^9, {3.649955989254223*^9, 
   3.649955989637965*^9}, {3.649956054194582*^9, 3.649956056281979*^9}, {
   3.649957261598538*^9, 3.649957262693189*^9}, 3.649957930694928*^9, {
   3.7787513795832644`*^9, 
   3.77875138071005*^9}},ExpressionUUID->"d61e8bbd-b009-4ffd-b19d-\
8a79e33c80a4"],

Cell[TextData[{
 "SimilarityPair2D[{",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "}, {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] returns a list {",
 StyleBox["mat, offset",
  FontSlant->"Italic"],
 "} that describes the handedness-preserving similarity transformation from \
the line segment {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} to the segment {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}, via sequential matrix multiplication by ",
 StyleBox["mat",
  FontSlant->"Italic"],
 " followed by an addition of ",
 StyleBox["offset.",
  FontSlant->"Italic"],
 " It is similar to, but more efficient than ScaleRotationOffset because we \
don\[CloseCurlyQuote]t go through the trig functions needed to get the \
rotation angle. The matrix is effectively the product of a scale and a \
rotation."
}], "Text",
 CellChangeTimes->{{3.627572047396574*^9, 3.62757216630088*^9}, 
   3.627572765625537*^9, {3.627572832600632*^9, 3.627572859231009*^9}, 
   3.627572902303552*^9, {3.627572980208088*^9, 3.6275730025175357`*^9}, {
   3.627573366497279*^9, 3.6275733879085636`*^9}, 3.627573427982486*^9, {
   3.6287823357448463`*^9, 3.628782357404974*^9}, 3.628786247150931*^9, {
   3.649955513406292*^9, 3.6499555188681393`*^9}, {3.649955626919237*^9, 
   3.649955630916848*^9}, {3.649955671275254*^9, 3.6499557935149403`*^9}, 
   3.6499559186164293`*^9, {3.649955949624859*^9, 3.649955949920956*^9}, {
   3.6499559949410887`*^9, 3.649956071249892*^9}, {3.649957093008771*^9, 
   3.6499570931923532`*^9}, 3.649957930733796*^9, 3.726084755193338*^9, 
   3.778751179587873*^9, {3.778751381719481*^9, 
   3.778751382751273*^9}},ExpressionUUID->"559a2397-c361-4f6d-a107-\
52e9eca7ffdc"],

Cell["\<\
This is used in JoinGraphs and JoinGraph2DAssigneds, see below.\
\>", "Text",
 CellChangeTimes->{{3.649957221728981*^9, 3.649957234391599*^9}, {
   3.649957838569211*^9, 3.6499578465362477`*^9}, {3.649958248134954*^9, 
   3.649958249526729*^9}, 
   3.726179190695672*^9},ExpressionUUID->"f3d81f7b-6e03-4fe9-8a3d-\
f15594b2d4e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SimilarityPair2D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1_", ",", "p2_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q1_", ",", "q2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "rm", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rm", "=", 
      RowBox[{
       RowBox[{"(", 
        FractionBox[
         RowBox[{"Mag", "[", 
          RowBox[{"q2", "-", "q1"}], "]"}], 
         RowBox[{"Mag", "[", 
          RowBox[{"p2", "-", "p1"}], "]"}]], ")"}], "*", 
       RowBox[{"RotationMatrix2D", "[", 
        RowBox[{"p1", ",", "p2", ",", 
         RowBox[{"p1", "+", 
          RowBox[{"(", 
           RowBox[{"q2", "-", "q1"}], ")"}]}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"rm", ",", 
       RowBox[{"q1", "-", 
        RowBox[{"rm", ".", "p1"}]}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.64995611200163*^9, 3.64995626723049*^9}, {
   3.6499563007419662`*^9, 3.6499563158542337`*^9}, {3.6499570738130693`*^9, 
   3.649957078834021*^9}, {3.649957627865454*^9, 3.649957630164797*^9}, 
   3.64995793075075*^9},
 CellLabel->
  "In[298]:=",ExpressionUUID->"081e65ce-0145-4d05-a8da-6f209676803c"],

Cell["Example", "Text",
 CellChangeTimes->{{3.649957101951585*^9, 
  3.64995710601497*^9}},ExpressionUUID->"a4b16958-280e-4064-af0b-\
a5565d5be8ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "q1", ",", "q2", ",", "rm", ",", "offset"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q1", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], ";", 
     RowBox[{"q2", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "/", "2"}], ",", 
        RowBox[{"3", "/", "2"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"rm", ",", "offset"}], "}"}], "=", 
      RowBox[{"SimilarityPair2D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"p1", ",", "p2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<{rm, offset} = \>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MatrixForm", "[", "rm", "]"}], ",", "offset"}], "}"}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", "Red"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p2", "]"}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Blue"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", 
            RowBox[{"offset", "+", 
             RowBox[{"(", 
              RowBox[{"rm", ".", "p2"}], ")"}]}], "]"}], ",", 
           RowBox[{"Darker", "[", "Blue", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.627572464882554*^9, 3.627572550360984*^9}, {
   3.627572783258884*^9, 3.6275728201368*^9}, {3.627572906334482*^9, 
   3.627572928441511*^9}, {3.6275729612540693`*^9, 3.627572965253971*^9}, {
   3.62757343143579*^9, 3.627573438271096*^9}, 3.628786247205649*^9, {
   3.6499571225545673`*^9, 3.649957172335487*^9}, {3.64995744964009*^9, 
   3.649957601211708*^9}, {3.6499576373782473`*^9, 3.649957637959407*^9}, 
   3.649957930774685*^9},
 CellLabel->
  "In[299]:=",ExpressionUUID->"3ffd26fa-c20c-4810-8b03-e89ba7d64125"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Reflection", "Subsection",
 CellChangeTimes->{{3.5959728539445057`*^9, 3.595972864719514*^9}, 
   3.5959735887700577`*^9, 
   3.7084010097394857`*^9},ExpressionUUID->"4890cbe1-a9d6-4d36-a44c-\
0ce16150beb3"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.690652703983145*^9, 
  3.6906527044538937`*^9}},ExpressionUUID->"4eea6a72-e577-4de7-8538-\
b35f88ec2d0a"],

Cell["\<\
We can use the N-dimension reflection functions Reflect and Reflectu for 2D \
reflections. We also provide a specialized version for 2D here.\
\>", "Text",
 CellChangeTimes->{{3.6906527063127604`*^9, 3.690652735751359*^9}, {
  3.690653011728364*^9, 
  3.690653021162526*^9}},ExpressionUUID->"a0d0ba17-564f-41db-8ac4-\
33bf3fda2633"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Reflect2D",
 "[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}]"
}], "Subsubsection",
 CellChangeTimes->{{3.458221541309735*^9, 3.458221565867704*^9}, 
   3.5959735887703333`*^9, {3.69065255216182*^9, 3.690652564259264*^9}, {
   3.6906529703414593`*^9, 
   3.690652980849745*^9}},ExpressionUUID->"4d0565fb-9ac1-43fd-b100-\
8cdfd3bbf7e0"],

Cell[TextData[{
 "Reflect2D",
 "[",
 StyleBox["p",
  FontSlant->"Italic"],
 ", {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2",
  FontSlant->"Italic"],
 "}] reflects the point ",
 StyleBox["p",
  FontSlant->"Italic"],
 " through the line passing through ",
 StyleBox["q1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["q2.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.458221575203116*^9, 3.458221593401992*^9}, 
   3.595973588770713*^9, 
   3.690652982829739*^9},ExpressionUUID->"d8188fe2-a669-47d4-b1d6-\
110ff38a5d81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reflect2D", "[", 
   RowBox[{"p_List", ",", 
    RowBox[{"{", 
     RowBox[{"q1_List", ",", "q2_List"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ".", 
       RowBox[{"(", 
        RowBox[{"q2", "-", "q1"}], ")"}]}]}], "}"}], ",", 
    RowBox[{"q1", "+", 
     RowBox[{"(", 
      RowBox[{"p", "-", "q1"}], ")"}], "-", 
     RowBox[{"2", " ", "u", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "q1"}], ")"}], ".", "u"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"u", ".", "u"}], ")"}]}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.458221609866026*^9, 3.458221631939505*^9}, {
   3.45822178270909*^9, 3.458221841870766*^9}, {3.594232300750389*^9, 
   3.594232308938307*^9}, 3.59597358877135*^9, {3.690652521650879*^9, 
   3.6906525283758373`*^9}, 3.690652983533703*^9},
 CellLabel->
  "In[300]:=",ExpressionUUID->"916f101d-2c44-49b2-afba-ebd59f23b870"],

Cell["Example", "Text",
 CellChangeTimes->{{3.458221862216172*^9, 3.458221862943704*^9}, 
   3.595973588771586*^9},ExpressionUUID->"6029f5f1-809b-4243-bd05-\
3b1f5f51a574"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "q1", ",", "q2", ",", "pp"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"q1", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q2", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0.5"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p", "=", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", "0.1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pp", "=", 
      RowBox[{"Reflect2D", "[", 
       RowBox[{"p", ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q2"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"MapThread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"#1", ",", "#2", ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "0"}], "}"}]}], "]"}], "&"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\"\<p\>\"", ",", "\"\<q1\>\"", ",", "\"\<q2\>\"", 
               ",", "\"\<pp\>\""}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"p", ",", "q1", ",", "q2", ",", "pp"}], "}"}]}], 
            "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"q1", ",", "q2"}], "}"}], "]"}], ",", "Gray"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{"p", ",", "pp"}], "}"}], "]"}], ",", "Black"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "p", "]"}], ",", "Red", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "q1", "]"}], ",", "Green", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "q2", "]"}], ",", "Green", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "pp", "]"}], ",", "Blue", ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.458221867985476*^9, 3.458222011266855*^9}, 
   3.595973588772477*^9, {3.690652596928438*^9, 3.690652673925559*^9}, 
   3.690652985570422*^9, {3.794834737976954*^9, 3.794834750230433*^9}},
 CellLabel->
  "In[301]:=",ExpressionUUID->"54db2664-5670-40f9-a819-193aebd35660"]
}, Closed]],

Cell[CellGroupData[{

Cell["ReflectionXMatrix2D", "Subsubsection",
 CellChangeTimes->{
  3.595973588772721*^9},ExpressionUUID->"8298e97a-7ff3-4c7f-9675-\
b0cff71901a9"],

Cell["\<\
ReflectionXMatrix2D returns the 2D matrix that reflects the image through the \
x axis.\
\>", "Text",
 CellChangeTimes->{
  3.595973588778751*^9},ExpressionUUID->"a8c2253b-18f9-4cea-b6d7-\
adc67f4be906"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReflectionXMatrix2D", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{3.595973588779532*^9},
 CellLabel->
  "In[302]:=",ExpressionUUID->"3e294d73-7ab7-4ebe-a1e1-06b366ae2f62"]
}, Closed]],

Cell[CellGroupData[{

Cell["ReflectionYMatrix2D", "Subsubsection",
 CellChangeTimes->{{3.52683706530376*^9, 3.526837065854083*^9}, 
   3.595973588779784*^9},ExpressionUUID->"ef701468-03f7-4986-ad4d-\
639659872d56"],

Cell[TextData[{
 "ReflectionXMatrix2D returns the 2D matrix that reflects the image through \
the ",
 StyleBox["y",
  FontSlant->"Italic"],
 " axis."
}], "Text",
 CellChangeTimes->{3.526837069158281*^9, 
  3.595973588780071*^9},ExpressionUUID->"ae9226c3-e24a-48b7-b380-\
39086fe56c30"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReflectionYMatrix2D", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.526837074527799*^9, 3.526837082335498*^9}, 
   3.595973588780336*^9},
 CellLabel->
  "In[303]:=",ExpressionUUID->"864a4719-0eac-476b-b6b6-f55aa27956d0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Arcs", "Subsection",
 CellChangeTimes->{{3.631995792347268*^9, 3.631995806374573*^9}, 
   3.708401006555728*^9},ExpressionUUID->"9ac632dd-08cb-48d1-a721-\
ebebe092a88b"],

Cell[CellGroupData[{

Cell[TextData[{
 "PolygonalEllipseArc2D[",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) ",
 "ArcMaximumAngle",
 ", ArcMethod, ArcDirection\n\t(option values)  InscribedArc, CircumscribedArc"
}], "Subsubsection",
 CellChangeTimes->{{3.593987117470357*^9, 3.593987156164545*^9}, {
   3.593987229805506*^9, 3.593987231285199*^9}, 3.595973395526351*^9, 
   3.595982778938464*^9, {3.650297268881871*^9, 3.650297272289769*^9}, 
   3.650297608631998*^9, 3.6502981234526157`*^9, 
   3.668985032371342*^9},ExpressionUUID->"6ae6aeea-6b37-4ecf-bc75-\
886e131f0077"],

Cell[TextData[{
 "PolygonalEllipseArc2D[",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] returns a list of points {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ..., ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "} that creates a polygonal path from ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " to ",
 StyleBox["p2",
  FontSlant->"Italic"],
 " that approximates the surface of an ellipse centered on the origin that \
runs through both ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p2",
  FontSlant->"Italic"],
 ". The arc takes the \"shortest way\" from ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " to ",
 StyleBox["p2",
  FontSlant->"Italic"],
 "; if they are equal and opposite, an error will result. Options are:\n\t\
ArcDivisions \[Rule] ",
 StyleBox["n",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["n",
  FontSlant->"Italic"],
 " is the number of divisions to use in the path.\n\t",
 "ArcMaximumAngle",
 " \[Rule] \[CapitalDelta]\[Phi], which \[CapitalDelta]\[Phi] is the desired \
minimum angle. This could override the number of divisions.\n\tArcMethod  \
\[Rule] ",
 StyleBox["am",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["am",
  FontSlant->"Italic"],
 " is one of InscribedArc or CircumscribedArc. If InscribedArc, then the path \
lies entirely within the ellipsoid with its vertices on the surface. If \
CircumscribedArc, then the path lies outside the ellipsoid with each segment \
tangent to the surface (or roughly so). If ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p2",
  FontSlant->"Italic"],
 " have the same magnitude, then all segments for options CircumscribedArc \
will be tangent to the sphere whose surface contains both ",
 StyleBox["p1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p2.\n\t",
  FontSlant->"Italic"],
 "ArcDirection \[Rule] CCW | CW, which specifies the rotation direction of \
the arc."
}], "Text",
 CellChangeTimes->{{3.483690555829352*^9, 3.4836905632274733`*^9}, {
   3.483690642925875*^9, 3.483690707169496*^9}, {3.483690746158805*^9, 
   3.483690972510628*^9}, {3.4837033917382936`*^9, 3.483703416161321*^9}, {
   3.484038913757167*^9, 3.484038922681961*^9}, {3.484038962450033*^9, 
   3.48403897970202*^9}, {3.484039040485818*^9, 3.4840390826467547`*^9}, {
   3.484055880885295*^9, 3.484055896324124*^9}, {3.48405593200026*^9, 
   3.484055963637096*^9}, {3.484057522426022*^9, 3.484057595481192*^9}, {
   3.593987170074974*^9, 3.593987223757676*^9}, 3.595973395721153*^9, 
   3.5959827790133247`*^9, {3.65029725251621*^9, 3.650297256339845*^9}, {
   3.650297355261019*^9, 3.650297448393215*^9}, 3.650297608675046*^9, {
   3.6502981302113667`*^9, 3.650298189791704*^9}, {3.650298307553342*^9, 
   3.650298348302088*^9}, 
   3.668985033066373*^9},ExpressionUUID->"b41c2e3d-4260-47c7-8fd8-\
75a980de6502"],

Cell["See also PolygonalEllipseArc3D.", "Text",
 CellChangeTimes->{{3.593987240348423*^9, 3.593987253979473*^9}, 
   3.5959733957851877`*^9, 3.595977851021542*^9, 
   3.5959827790983953`*^9},ExpressionUUID->"48361cf5-7de0-411d-854b-\
d17c7e6d7fd9"],

Cell["\<\
Note the interplay between ArcDivisions and ArcMaximumAngle. ArcDivisions \
sets a minimum number of divisions; ArcMaximumAngle might bump it up. The \
default sets ArcDivisions to 1, so that the number of divisions is determined \
entirely from ArcMaximumAngle. If you want to absolutely specify the number \
of divisions, set ArcMaximumAngle \[Rule] \[Infinity] (or 2\[Pi] would work).\
\
\>", "Text",
 CellChangeTimes->{{3.650298353412766*^9, 3.6502984721258*^9}, {
  3.668985033865858*^9, 3.668985044349944*^9}, {3.6938364734715633`*^9, 
  3.693836473870223*^9}},ExpressionUUID->"2c3c2388-a2c4-4564-a232-\
3022926a1034"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArcDivisions", "::", "usage"}], 
   "=", "\"\<ArcDivisions is an option to PolygonalEllipseArc2D that \
specifies the number of points to use in approximating the circular \
arc.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.59180093314872*^9, 3.5918009627385683`*^9}, 
   3.5918010155871983`*^9, 3.5918011259761467`*^9, {3.59398726906135*^9, 
   3.593987269181647*^9}, 3.595973395809965*^9, 3.5959827791532383`*^9},
 CellLabel->
  "In[304]:=",ExpressionUUID->"a8b10bcc-94dc-4755-8747-f1e61d758088"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArcMaximumAngle", "::", "usage"}], 
   "=", "\"\<ArcMaximumAngle is an option to PolygonalEllipseArc2D that \
specifies the minimum angle quantization.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.650297297186878*^9, 3.650297345206023*^9}, 
   3.650297608728228*^9, {3.650298210162776*^9, 3.650298211958971*^9}, {
   3.668985046513329*^9, 3.668985047273532*^9}},
 CellLabel->
  "In[305]:=",ExpressionUUID->"5b4d4107-b65a-456a-8f15-2b0e9e515152"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArcMethod", "::", "usage"}], 
   "=", "\"\<ArcMethod is an option to PolygonalEllipseArc2D that specifies \
whether to inscribe or circumscribe in creating the arc.\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.59180093314872*^9, 3.591801017458861*^9}, {
   3.591801128473906*^9, 3.591801152218376*^9}, {3.59398727154897*^9, 
   3.593987271709141*^9}, 3.595973395823441*^9, 3.5959827793931513`*^9, 
   3.650297608754755*^9},
 CellLabel->
  "In[306]:=",ExpressionUUID->"fff0e6bd-c455-4263-b714-bfd21fa4d0dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InscribedArc", "::", "usage"}], 
   "=", "\"\<InscribedArc is a value of option ArcMethod that specifies to \
use an inscribed polygon in creating the arc.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.59180093314872*^9, 3.591801017458861*^9}, {
  3.591801128473906*^9, 3.591801199504471*^9}},
 CellLabel->
  "In[307]:=",ExpressionUUID->"46c9b715-6003-4f11-962c-8341908282b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CircumscribedArc", "::", "usage"}], 
   "=", "\"\<CircumscribedArc is a value of option ArcMethod that specifies \
to use a circumscribed polygon in creating the arc.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.59180093314872*^9, 3.591801017458861*^9}, {
  3.591801128473906*^9, 3.591801213030498*^9}},
 CellLabel->
  "In[308]:=",ExpressionUUID->"1a144c3b-68fc-4572-817c-69cf52bfcc2d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArcDirection", "::", "usage"}], 
   "=", "\"\<ArcDirection is an option to PolygonalEllipseArc2D that \
specifies the direction of the arc.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.59180093314872*^9, 3.591801017458861*^9}, {
   3.591801128473906*^9, 3.591801267924249*^9}, {3.593987284132514*^9, 
   3.593987301770858*^9}, 3.595973395839901*^9, 3.595982779645235*^9, 
   3.650297608780592*^9},
 CellLabel->
  "In[309]:=",ExpressionUUID->"40566a75-4354-4fcd-a019-9572cda5c366"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CCW", "::", "usage"}], 
   "=", "\"\<CCW specifies a counterclockwise rotational direction.\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.593989926531903*^9, {3.628724721885589*^9, 3.628724729468882*^9}},
 CellLabel->
  "In[310]:=",ExpressionUUID->"2f6f8f10-a9cf-42b8-842f-953ea1f0c216"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CW", "::", "usage"}], " ", "=", 
   " ", "\"\<CW specifies a clockwise rotational direction.\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.59398991062956*^9, 3.5939899275078278`*^9}, {
  3.628724733805559*^9, 3.628724743050694*^9}},
 CellLabel->
  "In[311]:=",ExpressionUUID->"f90cb7e6-4d33-4c41-b6f9-7df0967775e2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PolygonalEllipseArc2D", "::", "badmet"}], 
   "=", "\"\<ArcMethod\[Rule]`1` is not a valid option.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolygonalEllipseArc2D", "::", "baddiv"}], 
   "=", "\"\<The value of ArcDivisions (`1`) must be \[GreaterEqual]1\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PolygonalEllipseArc2D", "::", "baddir"}], 
   "=", "\"\<ArcDirection\[Rule]`1` is not a valid option.\>\""}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.48369126326139*^9, 3.483691306120932*^9}, 
   3.48405616628185*^9, {3.484057490022403*^9, 3.484057502061843*^9}, {
   3.593987315506581*^9, 3.59398735879211*^9}, {3.595973395890451*^9, 
   3.595973395960306*^9}, {3.595982779912365*^9, 3.595982780394327*^9}, {
   3.65029760880669*^9, 3.650297608842566*^9}},
 CellLabel->
  "In[312]:=",ExpressionUUID->"04cb9ca1-73f5-4fdf-abeb-d3689f0fa575"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "PolygonalEllipseArc2D", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ArcDivisions", "\[Rule]", "1"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ArcMaximumAngle", "\[Rule]", 
      RowBox[{"5", "\[Degree]"}]}], ",", 
     RowBox[{"(*", " ", 
      RowBox[{"this", " ", "looks", " ", "smooth", " ", "visually"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"ArcMethod", "\[Rule]", "InscribedArc"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ArcDirection", "\[Rule]", "CCW"}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.483691087025951*^9, 3.4836911182947493`*^9}, {
   3.48403911177534*^9, 3.4840391137271233`*^9}, {3.484056699925251*^9, 
   3.48405670893934*^9}, {3.593987366134856*^9, 3.593987373791905*^9}, 
   3.595973396010089*^9, 3.595982780629279*^9, {3.650297550105177*^9, 
   3.6502975657518682`*^9}, 3.650297608866555*^9, {3.650298217790856*^9, 
   3.6502982201613293`*^9}, 3.650298370334276*^9, {3.650298987329877*^9, 
   3.650298993428817*^9}, 3.668985048331471*^9},
 CellLabel->
  "In[315]:=",ExpressionUUID->"5f81e9fe-6ccf-4495-a1df-ea72a9ff8386"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolygonalEllipseArc2D", "[", 
   RowBox[{"p1_List", ",", " ", "p2_List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "n", ",", "ama", ",", "am", ",", "ad", ",", "m1", ",", "m2", ",", "a1", ",",
       "a2", ",", "dw", ",", "w", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"ArcDivisions", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "PolygonalEllipseArc2D", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ama", "=", 
      RowBox[{
       RowBox[{"ArcMaximumAngle", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "PolygonalEllipseArc2D", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"am", "=", 
      RowBox[{
       RowBox[{"ArcMethod", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "PolygonalEllipseArc2D", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"ad", "=", 
      RowBox[{
       RowBox[{"ArcDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "PolygonalEllipseArc2D", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", "<", "1"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"PolygonalEllipseArc2D", "::", "baddiv"}], ",", "n"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"InscribedArc", ",", "CircumscribedArc"}], "}"}], ",", 
          "am"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"PolygonalEllipseArc2D", "::", "badmet"}], ",", "am"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"CCW", ",", "CW"}], "}"}], ",", "ad"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"PolygonalEllipseArc2D", "::", "baddir"}], ",", "ad"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"m1", "=", 
      RowBox[{"Mag", "[", "p1", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"m2", "=", 
      RowBox[{"Mag", "[", "p2", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"a1", "=", 
      RowBox[{"ArcTan", "@@", "p1"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"a2", "=", 
      RowBox[{"ArcTan", "@@", "p2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ad", "===", "CCW"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"a2", "<", "a1"}], ",", 
         RowBox[{"a2", "+=", 
          RowBox[{"2", "\[Pi]"}]}]}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"a2", ">", "a1"}], ",", 
         RowBox[{"a2", "-=", 
          RowBox[{"2", "\[Pi]"}]}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"Max", "[", 
       RowBox[{"n", ",", 
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"Abs", "[", 
            RowBox[{"a2", "-", "a1"}], "]"}], "]"}], "/", "ama"}], "]"}]}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"dw", "=", 
      RowBox[{"1", "/", "n"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"am", ",", "\[IndentingNewLine]", "InscribedArc", ",", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", "p1", "}"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            SuperscriptBox["m1", 
             RowBox[{"(", 
              RowBox[{"1", "-", "w"}], ")"}]], 
            SuperscriptBox["m2", 
             RowBox[{"(", "w", ")"}]], 
            RowBox[{"U", "[", 
             RowBox[{
              RowBox[{"a1", 
               RowBox[{"(", 
                RowBox[{"1", "-", "w"}], ")"}]}], "+", 
              RowBox[{"a2", " ", "w"}]}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"w", ",", "dw", ",", 
             RowBox[{"1", "-", "dw"}], ",", "dw"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", "p2", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       "CircumscribedArc", ",", 
       RowBox[{
        RowBox[{"r", "=", 
         RowBox[{"Sec", "[", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"a1", "-", "a2"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "n"}], ")"}]}], "]"}]}], ";", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", "p1", "}"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["m1", 
              RowBox[{"(", 
               RowBox[{"1", "-", "w"}], ")"}]], 
             SuperscriptBox["m2", 
              RowBox[{"(", "w", ")"}]], 
             RowBox[{"U", "[", 
              RowBox[{
               RowBox[{"a1", 
                RowBox[{"(", 
                 RowBox[{"1", "-", "w"}], ")"}]}], "+", 
               RowBox[{"a2", " ", "w"}]}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"w", ",", 
              RowBox[{"dw", "/", "2"}], ",", 
              RowBox[{"1", "-", 
               RowBox[{"dw", "/", "2"}]}], ",", "dw"}], "}"}]}], "]"}], ",", 
          RowBox[{"{", "p2", "}"}]}], "]"}]}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.439841500019602*^9, 3.439841655590064*^9}, {
   3.4398417225542507`*^9, 3.439841933739073*^9}, {3.439841979990861*^9, 
   3.439841982645014*^9}, {3.439842018201121*^9, 3.439842035415137*^9}, {
   3.4398420680517583`*^9, 3.439842154956439*^9}, {3.439842204755604*^9, 
   3.439842234527113*^9}, 3.439842982144796*^9, {3.43984323201445*^9, 
   3.439843269240205*^9}, {3.439843381468116*^9, 3.439843496248922*^9}, {
   3.439843536589584*^9, 3.439843536947706*^9}, {3.439843601974857*^9, 
   3.439843602557019*^9}, {3.439848301341806*^9, 3.439848332165073*^9}, {
   3.439849497536191*^9, 3.43984955280888*^9}, 3.439950169202766*^9, {
   3.4399914256666307`*^9, 3.439991437490768*^9}, {3.440447454055791*^9, 
   3.440447459118355*^9}, 3.440448176185439*^9, {3.442616973891303*^9, 
   3.442617005088023*^9}, {3.44320544977281*^9, 3.443205492958008*^9}, {
   3.4432068093456087`*^9, 3.443206823102892*^9}, {3.483691005041853*^9, 
   3.483691044838471*^9}, {3.4836910766972446`*^9, 3.483691078282538*^9}, {
   3.483691256106406*^9, 3.483691259938282*^9}, {3.483691312063257*^9, 
   3.483691446671756*^9}, {3.483691712365836*^9, 3.483691765792849*^9}, {
   3.483691812232006*^9, 3.483691845613246*^9}, {3.483694453034344*^9, 
   3.483694530098952*^9}, {3.483701870760981*^9, 3.483701873240061*^9}, {
   3.483701955859225*^9, 3.48370196638476*^9}, {3.483702010197394*^9, 
   3.483702012164675*^9}, {3.484038589280328*^9, 3.484038634363782*^9}, 
   3.48403872758529*^9, {3.484038765462273*^9, 3.484038768795549*^9}, {
   3.48403913741918*^9, 3.484039143690826*^9}, {3.484039336663011*^9, 
   3.484039425303154*^9}, {3.593987831843263*^9, 3.593987831993591*^9}, {
   3.59398804715818*^9, 3.593988050763006*^9}, {3.5939881100879097`*^9, 
   3.593988333314163*^9}, {3.5939887307154417`*^9, 3.593988770542096*^9}, 
   3.593988901343868*^9, {3.593989002932819*^9, 3.593989160997303*^9}, {
   3.593989195801005*^9, 3.593989198232611*^9}, 3.5939893402338257`*^9, {
   3.593989405330042*^9, 3.593989463199638*^9}, {3.5939895097469*^9, 
   3.593989592267543*^9}, {3.593989643124297*^9, 3.593989654644972*^9}, {
   3.59398971763169*^9, 3.593989755152974*^9}, {3.593989833911563*^9, 
   3.593989836057679*^9}, {3.595973396057925*^9, 3.595973396259839*^9}, {
   3.595982780884115*^9, 3.5959827823193693`*^9}, {3.650297608892396*^9, 
   3.650297609007624*^9}, {3.650298582929562*^9, 3.6502986252722197`*^9}, {
   3.650298766680787*^9, 3.650298779477837*^9}, 3.650298923371937*^9, {
   3.650304762740387*^9, 3.650304872122487*^9}, 3.668985049154507*^9},
 CellLabel->
  "In[316]:=",ExpressionUUID->"603e3268-8a5e-4085-bc95-505f9ac426c9"],

Cell["\<\
Examples. First uses default settings for quantization, second two override \
ArcMaximumAngle to specify the number of divisions.\
\>", "Text",
 CellChangeTimes->{{3.483691525294908*^9, 3.483691527190901*^9}, {
   3.593989857631633*^9, 3.593989857938943*^9}, {3.650298930639642*^9, 
   3.650298941423211*^9}, {3.6502990076114697`*^9, 3.65029901859437*^9}, 
   3.668985051689925*^9},ExpressionUUID->"57104b42-9c35-49c9-b460-\
f5b6bf493527"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2", ",", "n", ",", "circle", ",", "gfn"}], "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"n", "=", "4"}], ";", "\[IndentingNewLine]", 
     RowBox[{"circle", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            SqrtBox["2"]}], "]"}], ",", "Gray"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Point", "[", "p1", "]"}], ",", 
            RowBox[{"Point", "[", "p2", "]"}]}], "}"}], ",", 
          RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", "Black"}], 
         "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "opts___", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"circle", ",", 
          RowBox[{"Line", "[", 
           RowBox[{"PolygonalEllipseArc2D", "[", 
            RowBox[{"p1", ",", "p2", ",", "opts"}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsGrid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"gfn", "[", 
           RowBox[{"ArcDirection", "\[Rule]", "CCW"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"gfn", "[", 
           RowBox[{
            RowBox[{"ArcDivisions", "\[Rule]", "n"}], ",", 
            RowBox[{"ArcMaximumAngle", "\[Rule]", "\[Infinity]"}], ",", 
            RowBox[{"ArcDirection", "\[Rule]", "CCW"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"gfn", "[", 
           RowBox[{
            RowBox[{"ArcDivisions", "\[Rule]", "n"}], ",", 
            RowBox[{"ArcMaximumAngle", "\[Rule]", "\[Infinity]"}], ",", 
            RowBox[{"ArcMethod", "\[Rule]", "InscribedArc"}], ",", 
            RowBox[{"ArcDirection", "\[Rule]", "CCW"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"gfn", "[", 
           RowBox[{
            RowBox[{"ArcDivisions", "\[Rule]", "n"}], ",", 
            RowBox[{"ArcMaximumAngle", "\[Rule]", "\[Infinity]"}], ",", 
            RowBox[{"ArcMethod", "\[Rule]", "CircumscribedArc"}], ",", 
            RowBox[{"ArcDirection", "\[Rule]", "CCW"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"gfn", "[", 
           RowBox[{"ArcDirection", "\[Rule]", "CW"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"gfn", "[", 
           RowBox[{
            RowBox[{"ArcDivisions", "\[Rule]", "n"}], ",", 
            RowBox[{"ArcMaximumAngle", "\[Rule]", "\[Infinity]"}], ",", 
            RowBox[{"ArcDirection", "\[Rule]", "CW"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"gfn", "[", 
           RowBox[{
            RowBox[{"ArcDivisions", "\[Rule]", "n"}], ",", 
            RowBox[{"ArcMaximumAngle", "\[Rule]", "\[Infinity]"}], ",", 
            RowBox[{"ArcMethod", "\[Rule]", "InscribedArc"}], ",", 
            RowBox[{"ArcDirection", "\[Rule]", "CW"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"gfn", "[", 
           RowBox[{
            RowBox[{"ArcDivisions", "\[Rule]", "n"}], ",", 
            RowBox[{"ArcMaximumAngle", "\[Rule]", "\[Infinity]"}], ",", 
            RowBox[{"ArcMethod", "\[Rule]", "CircumscribedArc"}], ",", 
            RowBox[{"ArcDirection", "\[Rule]", "CW"}]}], "]"}]}], 
         "\[IndentingNewLine]", "}"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.483691534871138*^9, 3.483691678195761*^9}, {
   3.483691849966091*^9, 3.483691852173922*^9}, {3.483694541619237*^9, 
   3.483694542057722*^9}, {3.483694581511416*^9, 3.483694585330426*^9}, 
   3.483701818148183*^9, {3.483701879503068*^9, 3.483701881694717*^9}, {
   3.484046662896797*^9, 3.484046666513509*^9}, {3.484056024089711*^9, 
   3.484056129532906*^9}, {3.48405706635522*^9, 3.484057101392037*^9}, {
   3.4840573079085913`*^9, 3.484057326648172*^9}, {3.484057417457244*^9, 
   3.484057428327458*^9}, {3.533504277577464*^9, 3.533504279141057*^9}, {
   3.593988369362033*^9, 3.593988535641394*^9}, {3.593988576635732*^9, 
   3.593988606153706*^9}, {3.5939886416088457`*^9, 3.593988678115981*^9}, 
   3.593988776513356*^9, {3.593988923021456*^9, 3.593988978442888*^9}, {
   3.593989268674871*^9, 3.593989299311925*^9}, {3.593989669168168*^9, 
   3.5939896951401243`*^9}, {3.59398976691549*^9, 3.59398980719223*^9}, {
   3.5959733963110247`*^9, 3.595973396413068*^9}, {3.5959827825598907`*^9, 
   3.595982783012012*^9}, {3.650297609038507*^9, 3.650297609096592*^9}, {
   3.65029864513695*^9, 3.650298731623334*^9}, {3.650298801136199*^9, 
   3.650298893020869*^9}, {3.650299473466732*^9, 3.65029950254269*^9}, {
   3.668985053431316*^9, 3.66898505618533*^9}},
 CellLabel->
  "In[317]:=",ExpressionUUID->"68c42ca7-4254-468c-abe8-0e6914322653"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Point lists and their properties", "Subsection",
 CellChangeTimes->{{3.595972392030884*^9, 3.595972393908754*^9}, {
   3.631522195178618*^9, 3.631522197057638*^9}, {3.631995863803087*^9, 
   3.631995865922325*^9}, 
   3.708401003706901*^9},ExpressionUUID->"b97ad387-0dcd-4470-84fe-\
b4fa6f4002e3"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.628523887231872*^9, 3.628523887557745*^9}, {
  3.628531127665876*^9, 
  3.628531128088793*^9}},ExpressionUUID->"b2f7df82-9342-4805-95db-\
aa1a7cdbd45e"],

Cell["\<\
These functions return properties of polygons specified by the vertices or \
corner angles.\
\>", "Text",
 CellChangeTimes->{{3.629219482256607*^9, 
  3.629219496670802*^9}},ExpressionUUID->"f2f4590d-ca38-4652-b155-\
c0edd6bed5af"],

Cell["\<\
A polygon that whose vertices lie on a circle is called \
\[OpenCurlyDoubleQuote]concyclic.\[CloseCurlyDoubleQuote] This property \
arises in twist tiles.\
\>", "Text",
 CellChangeTimes->{{3.6285238896853943`*^9, 3.628523910676735*^9}, {
  3.628531133200302*^9, 
  3.628531159966155*^9}},ExpressionUUID->"5eada36c-fe95-4626-9bc5-\
c7af1b7fc3ca"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Centroid[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.485207087859019*^9, 
  3.485207093882036*^9}},ExpressionUUID->"b14f21d5-7801-429e-8497-\
05db9f85ec9d"],

Cell[TextData[{
 "Centroid[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "] returns the centroid (center of mass) of the given list of points."
}], "Text",
 CellChangeTimes->{{3.485207096066152*^9, 
  3.4852071111143093`*^9}},ExpressionUUID->"d03fc538-7560-4d48-8ad4-\
c4a6cd5f0cc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Centroid", "[", "plist_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Plus", "@@", "plist"}], "/", 
   RowBox[{"Length", "[", "plist", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.485207113261592*^9, 3.485207129638221*^9}},
 CellLabel->
  "In[318]:=",ExpressionUUID->"e66579c0-0ec3-43c8-9c64-f968df1ab0f3"],

Cell["Example", "Text",
 CellChangeTimes->{{3.485207132354105*^9, 
  3.485207133137741*^9}},ExpressionUUID->"99fb0914-0fad-408c-a7d8-\
f86238b8337a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Centroid", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.485207135180379*^9, 3.485207182636726*^9}, {
  3.485210261042178*^9, 3.48521026295398*^9}},
 CellLabel->
  "In[319]:=",ExpressionUUID->"6f8e594a-4d35-4ce2-87af-112899a721b5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ConcyclicInfo[",
 StyleBox["plist, opts",
  FontSlant->"Italic"],
 "]\n\t(options) ConcyclicTolerance\nConcyclicQ[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "]\n\t(options) ConcyclicTolerance\nCircumcenter[",
 StyleBox["plist, opts",
  FontSlant->"Italic"],
 "]\n\t(options) ConcyclicTolerance\nCircumradius[",
 StyleBox["plist, opts",
  FontSlant->"Italic"],
 "]\n\t(options) ConcyclicTolerance\nConcyclicConditions[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.48520719927413*^9, 3.485207206697785*^9}, {
   3.485207252321917*^9, 3.485207288129624*^9}, {3.485207334946877*^9, 
   3.485207350529625*^9}, {3.485210786155573*^9, 3.485210821883089*^9}, {
   3.627394572583454*^9, 3.627394583308363*^9}, 3.628531116649837*^9, 
   3.628531174460144*^9, {3.631471229087461*^9, 3.631471231027763*^9}, {
   3.6320922516393013`*^9, 3.632092260148459*^9}, {3.708342312442322*^9, 
   3.708342317622457*^9}, {3.708342629454335*^9, 
   3.708342632489757*^9}},ExpressionUUID->"87158047-dbd8-4ddd-b2ca-\
063934575135"],

Cell[TextData[{
 "ConcyclicInfo",
 "[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "] takes a list of points ",
 StyleBox["plist",
  FontSlant->"Italic"],
 " and returns a list {",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["flag",
  FontSlant->"Italic"],
 ", {",
 StyleBox["d1",
  FontSlant->"Italic"],
 ",...}} where ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 " is the center of the circumcircle of the polygon; ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the radius of the circumscribing circle; ",
 StyleBox["flag",
  FontSlant->"Italic"],
 " is True iff all points lie on the circle (to within a specified \
tolerance); and {",
 StyleBox["d1",
  FontSlant->"Italic"],
 ",...} is the distance from the circumcenter to each point of ",
 StyleBox["plist",
  FontSlant->"Italic"],
 ". For up to 3 points, we compute it directly. For more than 3 points, we \
check all possible triples and pick the one that encloses all points and has \
the smallest radius. This is slower than doing it by minimization, but our \
polygons are typically small and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s minimization routine finds a numerical solution; we'd like the exact \
solution if it exists."
}], "Text",
 CellChangeTimes->{{3.48520729212987*^9, 3.485207327633739*^9}, {
   3.485207369897734*^9, 3.485207397921605*^9}, {3.485208008618243*^9, 
   3.485208024941577*^9}, {3.485208205865847*^9, 3.4852082631114273`*^9}, {
   3.485209460871509*^9, 3.4852094654469833`*^9}, {3.4852106910820417`*^9, 
   3.4852107429879723`*^9}, {3.4852112734091053`*^9, 3.485211278362946*^9}, {
   3.5335954104944572`*^9, 3.53359541514695*^9}, 
   3.628531116711045*^9},ExpressionUUID->"f12c6f09-0685-44b2-a14d-\
495c3373c03b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConcyclicTolerance", "::", "usage"}], 
   "=", "\"\<ConcyclicTolerance is an option used in testing for \
Concyclicity, points lying on a common circle.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.708342656157218*^9, 3.7083426957173853`*^9}},
 CellLabel->
  "In[320]:=",ExpressionUUID->"202f2482-5aea-4548-a91d-952afba03a41"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ConcyclicInfo", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"ConcyclicTolerance", "\[Rule]", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.485209605676954*^9, 3.48520962339529*^9}, 
   3.485210915975309*^9, 3.628531116739062*^9, 3.708342320883862*^9, 
   3.7083425979085283`*^9},
 CellLabel->
  "In[321]:=",ExpressionUUID->"5cebfcd5-9148-4690-b5a5-6f8d3530aca1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConcyclicInfo", "::", "badlen"}], "=", "\"\<List is empty.\>\""}],
   ";"}]], "Input",
 CellChangeTimes->{{3.48520855477318*^9, 3.48520859509007*^9}, {
   3.485209944981079*^9, 3.485209949012553*^9}, 3.485209979167438*^9, 
   3.628531116765783*^9},
 CellLabel->
  "In[322]:=",ExpressionUUID->"c9e57406-5836-4990-88da-c091d9d6a749"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{"ConcyclicInfo", "::", "badlen"}], "]"}], ";", 
     RowBox[{"Abort", "[", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.485209958447005*^9, 3.485209986644846*^9}, {
  3.628531116800602*^9, 3.628531116816701*^9}},
 CellLabel->
  "In[323]:=",ExpressionUUID->"2d17eeb3-fc92-4795-b612-87bafc519772"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", "p1_", "}"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "0", ",", "True", ",", 
    RowBox[{"{", "0", "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.485209720258643*^9, 3.485209740951035*^9}, {
   3.485210758405684*^9, 3.485210758838529*^9}, 3.628531116848735*^9},
 CellLabel->
  "In[324]:=",ExpressionUUID->"9051d9d4-6723-4a0c-bf51-37bb9afb2329"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", 
    RowBox[{"p1_", ",", "p2_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "r", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"r", "=", 
      RowBox[{
       RowBox[{"Mag", "[", 
        RowBox[{"p1", "-", "p2"}], "]"}], "/", "2"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p1", "+", "p2"}], ")"}], "/", "2"}], ",", "r", ",", "True", 
       ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "r"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.485209742891588*^9, 3.485209809854618*^9}, {
   3.48521076317581*^9, 3.485210764398436*^9}, 3.628531116882987*^9},
 CellLabel->
  "In[325]:=",ExpressionUUID->"6d29b378-ad75-4ae6-a668-f044aaba1e21"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", 
    RowBox[{"p1_", ",", "p2_", ",", "p3_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "/.", 
       RowBox[{
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Mag2", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}], "-", "p1"}], "]"}], "==", 
             RowBox[{"Mag2", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}], "-", "p2"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"Mag2", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}], "-", "p2"}], "]"}], "\[Equal]", 
             RowBox[{"Mag2", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}], "-", "p3"}], "]"}]}]}], "}"}],
           ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[LeftDoubleBracket]", 
        "1", "\[RightDoubleBracket]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "-", "p1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "r", ",", "True", ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "r", ",", "r"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.485208030278748*^9, 3.485208159535178*^9}, {
   3.48521076719346*^9, 3.485210768097841*^9}, {3.533596961452608*^9, 
   3.533596962852129*^9}, 3.628531116918215*^9},
 CellLabel->
  "In[326]:=",ExpressionUUID->"18a90944-49bd-4296-b5d0-ea9c41608150"],

Cell["\<\
For precisely 3 points, we use the fact that the circumcenter is the \
intersection of the perpendicular bisectors of any two sides.\
\>", "Text",
 CellChangeTimes->{{3.533596613419029*^9, 3.533596616209925*^9}, {
  3.533596814941383*^9, 3.533596833027872*^9}, {3.5335969786504717`*^9, 
  3.533596991809327*^9}, {3.594073005385478*^9, 
  3.594073005687784*^9}},ExpressionUUID->"130fe7d5-efd8-4780-b0cc-\
28e30b325549"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", 
    RowBox[{"p1_", ",", "p2_", ",", "p3_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"q", ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"q", "=", 
      RowBox[{"LineInt2D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p1", "+", "p2"}], ")"}], "/", "2"}], ",", 
        RowBox[{"Rotate90", "[", 
         RowBox[{"p2", "-", "p1"}], "]"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p2", "+", "p3"}], ")"}], "/", "2"}], ",", 
        RowBox[{"Rotate90", "[", 
         RowBox[{"p3", "-", "p2"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{"q", "-", "p1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"q", ",", "r", ",", "True", ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "r", ",", "r"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.485208030278748*^9, 3.485208159535178*^9}, {
   3.48521076719346*^9, 3.485210768097841*^9}, {3.533596961452608*^9, 
   3.533596962852129*^9}, {3.5335970667892942`*^9, 3.533597222804261*^9}, 
   3.628531116951404*^9},
 CellLabel->
  "In[327]:=",ExpressionUUID->"63d79925-e316-4c82-8824-53456419d38e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"plist_", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "tol", ",", "n", ",", "triples", ",", "crlist", ",", "crlist1", ",", 
      "ctr", ",", "r", ",", "dlist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"tol", "=", 
      RowBox[{
       RowBox[{"ConcyclicTolerance", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "ConcyclicInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"Length", "[", "plist", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"triples", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i", ",", "j", ",", "k"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"n", "-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"i", "+", "1"}], ",", 
            RowBox[{"n", "-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"j", "+", "1"}], ",", "n"}], "}"}]}], "]"}], ",", "2"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"crlist", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{
          RowBox[{"ConcyclicInfo", "[", 
           RowBox[{
           "plist", "\[LeftDoubleBracket]", "#", "\[RightDoubleBracket]"}], 
           "]"}], ",", "2"}], "]"}], "&"}], "/@", "triples"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ctr", ",", " ", "r"}], "}"}], " ", "for", " ", "each", " ", 
       "triple"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"crlist1", "=", 
      RowBox[{"Select", "[", 
       RowBox[{"crlist", ",", 
        RowBox[{"Function", "[", 
         RowBox[{"cr", ",", 
          RowBox[{"And", "@@", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Mag", "[", 
                RowBox[{
                 RowBox[{
                 "cr", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                  "-", "#"}], "]"}], "\[LessEqual]", 
               RowBox[{
               "cr", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
               "&"}], "/@", "plist"}], ")"}]}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"circle", " ", "must", " ", "contain", " ", "all", " ", "pts"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ctr", ",", "r"}], "}"}], "=", 
      RowBox[{
       RowBox[{"Sort", "[", 
        RowBox[{"crlist1", ",", 
         RowBox[{
          RowBox[{
           RowBox[{
           "#1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "<", 
           
           RowBox[{
           "#2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
          "&"}]}], "]"}], "\[LeftDoubleBracket]", "1", 
       "\[RightDoubleBracket]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "pick", " ", "the", " ", "one", " ", "with", " ", "smallest", " ", 
       "radius"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"dlist", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Mag", "[", 
         RowBox[{"#", "-", "ctr"}], "]"}], "&"}], "/@", "plist"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"ctr", ",", "r", ",", 
       RowBox[{"And", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{"#", "-", "r"}], "]"}], "\[LessEqual]", "tol"}], "&"}], "/@",
           "dlist"}], ")"}]}], ",", "dlist"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4852074119757833`*^9, 3.4852075898846197`*^9}, {
   3.485207656885408*^9, 3.485207663403522*^9}, {3.485207697051009*^9, 
   3.485207721667059*^9}, {3.485207776506418*^9, 3.485207847961686*^9}, {
   3.485208302336873*^9, 3.4852084415605097`*^9}, {3.4852084890859423`*^9, 
   3.485208550565158*^9}, {3.485208629967146*^9, 3.485208706687293*^9}, {
   3.485208751256731*^9, 3.485208960735833*^9}, {3.48520908105797*^9, 
   3.485209231988077*^9}, {3.485209273590906*^9, 3.485209279820031*^9}, 
   3.485209935440762*^9, {3.485210837279567*^9, 3.485210899560288*^9}, {
   3.485210930222233*^9, 3.485210956942705*^9}, 3.533595343176103*^9, {
   3.628531116987005*^9, 3.628531117022766*^9}, 3.708342322479012*^9, 
   3.708342598714418*^9},
 CellLabel->
  "In[328]:=",ExpressionUUID->"3ae9bd55-a433-4264-8ea5-1ec53d947967"],

Cell["Examples", "Text",
 CellChangeTimes->{{3.485207592863354*^9, 3.485207593631157*^9}, 
   3.485209823373025*^9},ExpressionUUID->"adcd282b-1ef1-4f2d-a43f-\
e8dcd6bbf270"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.465947696880206*^9, 3.465947715408637*^9}, {
   3.4852081701643887`*^9, 3.4852081705311*^9}, {3.485209839767001*^9, 
   3.485209861117467*^9}, 3.485210982621735*^9, 3.48521122754053*^9, 
   3.628531117054697*^9},
 CellLabel->
  "In[329]:=",ExpressionUUID->"5057fc98-514b-4440-8d3b-9a776f85f493"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.465947696880206*^9, 3.465947715408637*^9}, {
   3.4852081701643887`*^9, 3.4852081705311*^9}, {3.485209845949818*^9, 
   3.485209866663533*^9}, 3.485210985934808*^9, 3.485211230035157*^9, 
   3.628531117084884*^9},
 CellLabel->
  "In[330]:=",ExpressionUUID->"af6b3a2a-e14c-4ff8-8d80-d33c5fb4d720"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.465947696880206*^9, 3.465947715408637*^9}, {
   3.4852081701643887`*^9, 3.4852081705311*^9}, 3.485209868879434*^9, 
   3.485210990709477*^9, 3.485211233188951*^9, 3.62853111711779*^9},
 CellLabel->
  "In[331]:=",ExpressionUUID->"c4b8e5aa-19dd-49f3-b31c-e3344188292a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicInfo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.465947696880206*^9, 3.465947715408637*^9}, {
   3.4852081701643887`*^9, 3.4852081705311*^9}, 3.485209868879434*^9, 
   3.485210990709477*^9, 3.485211233188951*^9, {3.5335959409830093`*^9, 
   3.533595961251347*^9}, 3.628531117152431*^9},
 CellLabel->
  "In[332]:=",ExpressionUUID->"21206f55-379f-45e1-bd27-68913983b198"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"plist", ",", "ccinfo"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"plist", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Random", "[", "]"}], ",", 
          RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
        RowBox[{"{", "7", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ccinfo", "=", 
      RowBox[{"ConcyclicInfo", "[", "plist", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "ccinfo", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Point", "/@", "plist"}], ",", 
          RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", "Red"}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{
           "ccinfo", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "]"}], ",", 
          RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", "Black"}], "]"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{
            "ccinfo", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
            ",", 
            RowBox[{
            "ccinfo", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}], "]"}], ",", "Gray"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], 
  "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.485207595568248*^9, 3.485207651994521*^9}, {
   3.485207766554676*^9, 3.485207766872755*^9}, 3.485207807044079*^9, 
   3.485208420930738*^9, {3.485208979300079*^9, 3.485208986772026*^9}, 
   3.485209241987753*^9, {3.485209288684315*^9, 3.485209430504431*^9}, {
   3.485209475220246*^9, 3.485209477888489*^9}, 3.4852110003308487`*^9, 
   3.485211224085807*^9, 3.628531117186133*^9},
 CellLabel->
  "In[333]:=",ExpressionUUID->"c0d03af0-ed12-481d-a1a4-73876ac5cb45"],

Cell[TextData[{
 "ConcyclicQ[",
 StyleBox["plist, opts",
  FontSlant->"Italic"],
 "] returns True if all points in the list lie on the circle. Options are:\n\t\
Tolerance \[Rule] ",
 StyleBox["tol",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["tol",
  FontSlant->"Italic"],
 " is the distance tolerance on whether a point lies on the circle."
}], "Text",
 CellChangeTimes->{{3.485209512777079*^9, 3.485209527933959*^9}, {
   3.485209578406005*^9, 3.4852095963094797`*^9}, {3.4852100630817423`*^9, 
   3.48521006377227*^9}, 3.628531174534831*^9, 
   3.708342916717413*^9},ExpressionUUID->"70300e4a-170f-4759-bf4d-\
8b653e8ab89c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "ConcyclicQ", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"ConcyclicTolerance", "\[Rule]", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.485209605676954*^9, 3.48520962339529*^9}, 
   3.485210915975309*^9, 3.48521111955652*^9, 3.628531174643369*^9, 
   3.708342325276183*^9, 3.7083426002200403`*^9},
 CellLabel->
  "In[334]:=",ExpressionUUID->"b3d2a15c-9288-481e-8313-236b9051bfdd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicQ", "[", 
   RowBox[{"plist_", ",", "opts___"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"ConcyclicInfo", "[", 
    RowBox[{"plist", ",", "opts"}], "]"}], "\[LeftDoubleBracket]", "3", 
   "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.485209647307308*^9, 3.4852096774485483`*^9}, {
   3.485210053132881*^9, 3.485210054708304*^9}, {3.485211091628528*^9, 
   3.485211149483721*^9}, 3.62853111720196*^9, 3.628531174759516*^9},
 CellLabel->
  "In[335]:=",ExpressionUUID->"3da90078-929f-43a8-86e8-197d02871ad6"],

Cell["Example", "Text",
 CellChangeTimes->{{3.4852101874241037`*^9, 
  3.485210188111976*^9}},ExpressionUUID->"f5308630-6e4b-41a6-9371-\
d16089ce5fc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.00001"}], "}"}]}], "}"}], ",", 
    RowBox[{"ConcyclicTolerance", "\[Rule]", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}]}], "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.4852101898510923`*^9, 3.485210243330458*^9}, {
   3.485211191844822*^9, 3.485211215387072*^9}, 3.628531174862397*^9, 
   3.708342327962547*^9, 3.7083426017636003`*^9},
 CellLabel->
  "In[336]:=",ExpressionUUID->"32437553-8e98-4fa7-a377-f1e91138f094"],

Cell[TextData[{
 "Circumcenter[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "] returns just the circumcenter."
}], "Text",
 CellChangeTimes->{{3.485207216649664*^9, 3.485207224402144*^9}, {
  3.485209486350279*^9, 
  3.485209490046063*^9}},ExpressionUUID->"7b72f8ad-83b5-4d81-91d8-\
d919502b9d21"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Circumcenter", "[", "plist_", "]"}], ":=", 
  RowBox[{
   RowBox[{"ConcyclicInfo", "[", "plist", "]"}], "\[LeftDoubleBracket]", "1", 
   "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.4852094926131*^9, 3.485209506592967*^9}, 
   3.628531117208935*^9},
 CellLabel->
  "In[337]:=",ExpressionUUID->"821fe2ac-70eb-442a-841f-7687ccd4fdd4"],

Cell["Example", "Text",
 CellChangeTimes->{{3.485211164184374*^9, 
  3.485211164888371*^9}},ExpressionUUID->"b11081c7-2298-4c3c-b233-\
fca6ee8c59ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Circumcenter", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.00001"}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.4852101898510923`*^9, 3.485210243330458*^9}, {
  3.485211173996801*^9, 3.485211220572331*^9}},
 CellLabel->
  "In[338]:=",ExpressionUUID->"c8cab121-5570-42aa-a1c0-e2cef4572c58"],

Cell[TextData[{
 "Circumradius[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "] returns just the circumradius."
}], "Text",
 CellChangeTimes->{{3.485207216649664*^9, 3.485207224402144*^9}, {
  3.485209486350279*^9, 3.485209490046063*^9}, {3.627394596462167*^9, 
  3.627394602035358*^9}},ExpressionUUID->"f929cdcd-c391-4c2d-af3c-\
2545a286ccc3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Circumradius", "[", "plist_", "]"}], ":=", 
  RowBox[{
   RowBox[{"ConcyclicInfo", "[", "plist", "]"}], "\[LeftDoubleBracket]", "2", 
   "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.4852094926131*^9, 3.485209506592967*^9}, {
   3.627394605830158*^9, 3.6273946096010656`*^9}, 3.628531117215654*^9},
 CellLabel->
  "In[339]:=",ExpressionUUID->"b8267a5c-b88b-408b-8bb3-ac7ff1bd153e"],

Cell["Example", "Text",
 CellChangeTimes->{{3.485211164184374*^9, 
  3.485211164888371*^9}},ExpressionUUID->"83a5abe1-a3f9-4d40-9481-\
7edb69763c46"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Circumradius", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.00001"}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.4852101898510923`*^9, 3.485210243330458*^9}, {
   3.485211173996801*^9, 3.485211220572331*^9}, 3.627394612978078*^9},
 CellLabel->
  "In[340]:=",ExpressionUUID->"96838216-d3c2-42f9-82e1-53cc79eb6a7e"],

Cell[TextData[{
 "ConcyclicConditions[",
 StyleBox["plist",
  FontSlant->"Italic"],
 "] takes a list ",
 StyleBox["plist",
  FontSlant->"Italic"],
 " of ",
 StyleBox["n",
  FontSlant->"Italic"],
 " points and returns a list of (",
 StyleBox["n",
  FontSlant->"Italic"],
 "-3) quantities whose value is equal to zero if and only if the points are \
concyclic. You can use these conditions to solve for vertices of concyclic \
polygons, either analytically or numerically."
}], "Text",
 CellChangeTimes->{{3.631470608676549*^9, 3.631470736634785*^9}, {
  3.631470958500554*^9, 
  3.63147096536618*^9}},ExpressionUUID->"df7d6e39-de2a-44c2-90ec-\
c3b38a9ad67e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicConditions", "[", "plist_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", "ctr", ",", "r2"}], "}"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"Length", "[", "plist", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", "<", "4"}], ",", 
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ctr", "=", 
         RowBox[{"LineInt2D", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
              "plist", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
               "+", 
              RowBox[{
              "plist", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ")"}], "/", "2"}], ",", 
           RowBox[{"Rotate90", "[", 
            RowBox[{
             RowBox[{
             "plist", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "-", 
             RowBox[{
             "plist", "\[LeftDoubleBracket]", "1", 
              "\[RightDoubleBracket]"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
              "plist", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
               "+", 
              RowBox[{
              "plist", "\[LeftDoubleBracket]", "3", 
               "\[RightDoubleBracket]"}]}], ")"}], "/", "2"}], ",", 
           RowBox[{"Rotate90", "[", 
            RowBox[{
             RowBox[{
             "plist", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
             "-", 
             RowBox[{
             "plist", "\[LeftDoubleBracket]", "2", 
              "\[RightDoubleBracket]"}]}], "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r2", "=", 
         RowBox[{"Mag2", "[", 
          RowBox[{"ctr", "-", 
           RowBox[{
           "plist", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Mag2", "[", 
            RowBox[{"ctr", "-", "#"}], "]"}], "-", "r2"}], "&"}], "/@", 
         RowBox[{"Drop", "[", 
          RowBox[{"plist", ",", "3"}], "]"}]}]}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.6314706239259157`*^9, 3.631470633756651*^9}, {
   3.631470768371476*^9, 3.631470769154111*^9}, {3.631470949201474*^9, 
   3.631471126791172*^9}, 3.631471283285681*^9, {3.631471323884335*^9, 
   3.631471339514188*^9}},
 CellLabel->
  "In[341]:=",ExpressionUUID->"33ca6c34-d994-4b84-95f1-bb75bfed76c6"],

Cell["Example. Three vertices of a square.", "Text",
 CellChangeTimes->{{3.6314712504516997`*^9, 3.631471251234125*^9}, {
  3.631471362731761*^9, 
  3.631471366435821*^9}},ExpressionUUID->"380a2a2f-8b10-4ab9-a978-\
b79122127d5c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicConditions", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.63147125469598*^9, 3.631471302034488*^9}},
 CellLabel->
  "In[342]:=",ExpressionUUID->"94395779-4b71-429f-bfd7-03217bcb046e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "BrocardPointPositive[",
 StyleBox["{q1a, q1b}, {q2a, q2b}, {q3a, q3b}",
  FontSlant->"Italic"],
 "]\nBrocardPointNegative[",
 StyleBox["{q1a, q1b}, {q2a, q2b}, {q3a, q3b}",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.631489496641709*^9, 3.6314895368594093`*^9}, 
   3.631490340095296*^9, {3.631490419107396*^9, 3.6314904200586033`*^9}, {
   3.631996082893281*^9, 3.631996088099964*^9}, {3.631996189084135*^9, 
   3.631996204537104*^9}, {3.631996266542356*^9, 3.631996270555406*^9}, {
   3.632078894700842*^9, 
   3.632078897733635*^9}},ExpressionUUID->"9ece8e2e-e6a3-4c9c-be8d-\
0956fece5cab"],

Cell[TextData[{
 "BrocardPointPositive",
 "[",
 StyleBox["{q1a,q1b},{q2a,q2b},{q3a,q3b}",
  FontSlant->"Italic"],
 "] takes the endpoints of three edges of a polygon and returns the positive \
Brocard point, i.e., the point ",
 StyleBox["c",
  FontSlant->"Italic"],
 " such that the lines from ",
 StyleBox["c",
  FontSlant->"Italic"],
 " to ",
 StyleBox["q1a",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2a",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["q3a",
  FontSlant->"Italic"],
 " all make the same angle with their respective adjacent edges."
}], "Text",
 CellChangeTimes->{
  3.6275012934614487`*^9, {3.627508014354229*^9, 3.627508038480196*^9}, {
   3.631489301189025*^9, 3.631489305131119*^9}, {3.631489573291494*^9, 
   3.631489573897725*^9}, {3.631489658067294*^9, 3.631489711928648*^9}, {
   3.631490296306636*^9, 3.631490302387119*^9}, {3.631996189294634*^9, 
   3.6319962150123596`*^9}},ExpressionUUID->"0971faba-6eb4-4f1d-b61b-\
e13e2c69441b"],

Cell["\<\
Note that this method is fully algebraic, i.e., no trig functions involved.\
\>", "Text",
 CellChangeTimes->{{3.6322264186034737`*^9, 
  3.632226433100251*^9}},ExpressionUUID->"0c9b18ff-808b-4d65-abd6-\
15ac40c425a1"],

Cell["See also ThreeCycleCriticalTwistAngleCCW below.", "Text",
 CellChangeTimes->{{3.631490225312588*^9, 
  3.631490229014976*^9}},ExpressionUUID->"30b400fa-0a0a-486c-a1a7-\
06487866931f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BrocardPointPositive", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"q1a_", ",", "q1b_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q2a_", ",", "q2b_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q3a_", ",", "q3b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "s1", ",", "s2", ",", "s3", ",", "ii", ",", "rpm", ",", "rt", ",", "p12",
       ",", "p23", ",", "p31", ",", "t12", ",", "t23", ",", "t31", ",", "u2", 
      ",", "u3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"s1", "=", 
      RowBox[{"q1a", "-", "q1b"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s2", "=", 
      RowBox[{"q2a", "-", "q2b"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"s3", "=", 
      RowBox[{"q3a", "-", "q3b"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rpm", "=", 
      RowBox[{"RotationMatrix2D", "[", 
       FractionBox[
        RowBox[{"-", "\[Pi]"}], "2"], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ii", "=", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rt", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"rpm", ",", 
          RowBox[{"-", "ii"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ii", ",", "rpm"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p12", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"q2a", "-", "q1a"}], ")"}], ".", "rt"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p23", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"q3a", "-", "q2a"}], ")"}], ".", "rt"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p31", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"q1a", "-", "q3a"}], ")"}], ".", "rt"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"t12", "=", 
      RowBox[{"LineInt2D", "[", 
       RowBox[{"q1a", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s2", ".", "p12"}], ")"}], ".", "s1"}], ",", "q2a", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s1", ".", "p12"}], ")"}], ".", "s2"}]}], "]"}]}], ";", 
     RowBox[{"t23", "=", 
      RowBox[{"LineInt2D", "[", 
       RowBox[{"q2a", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s3", ".", "p23"}], ")"}], ".", "s2"}], ",", "q3a", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s2", ".", "p23"}], ")"}], ".", "s3"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"t31", "=", 
      RowBox[{"LineInt2D", "[", 
       RowBox[{"q3a", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s1", ".", "p31"}], ")"}], ".", "s3"}], ",", "q1a", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s3", ".", "p31"}], ")"}], ".", "s1"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"u2", "=", 
      RowBox[{"rpm", ".", 
       RowBox[{"(", 
        RowBox[{"t12", "-", "t23"}], ")"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "direction", " ", "vector", " ", "of", " ", "line", " ", "from", " ", 
       "q2b", " ", "to", " ", "intersection", " ", "pt"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"u3", "=", 
      RowBox[{"rpm", ".", 
       RowBox[{"(", 
        RowBox[{"t31", "-", "t23"}], ")"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "direction", " ", "vector", " ", "of", " ", "line", " ", "from", " ", 
       "q3b", " ", "to", " ", "intersection", " ", "pt"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"LineInt2D", "[", 
      RowBox[{"q2a", ",", "u2", ",", "q3a", ",", "u3"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.62750129349044*^9, {3.627502267838868*^9, 3.62750227997735*^9}, {
   3.627504108443743*^9, 3.627504110912149*^9}, {3.627508050014021*^9, 
   3.627508100432781*^9}, 3.629058085272165*^9, {3.6314867403992867`*^9, 
   3.631486749505935*^9}, 3.631486823193956*^9, {3.631488375599271*^9, 
   3.631488417566869*^9}, {3.631488458467365*^9, 3.631488502744879*^9}, {
   3.631488932434873*^9, 3.63148893748124*^9}, {3.631488990040285*^9, 
   3.631489332800519*^9}, {3.6314897340878468`*^9, 3.63148973614662*^9}, {
   3.631522318229763*^9, 3.631522392845372*^9}, 3.631996203718189*^9, {
   3.6320787367501507`*^9, 3.632078803626158*^9}, 3.688166836004822*^9},
 CellLabel->
  "In[343]:=",ExpressionUUID->"016e9452-1ecf-481a-9278-e276161a9b92"],

Cell["Example", "Text",
 CellChangeTimes->{{3.631490370094748*^9, 
  3.6314903708696423`*^9}},ExpressionUUID->"c79bb27d-966c-4dd6-8e82-\
614a3f6fbcec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "pts", ",", "q1a", ",", "q1b", ",", "q2a", ",", "q2b", ",", "q3a", ",", 
      "q3b", ",", "c"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", ".5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.8", ",", 
          RowBox[{"-", "0.2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "0.7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.6", ",", ".5"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "q1a", ",", "q1b", ",", "q2a", ",", "q2b", ",", "q3a", ",", "q3b"}], 
       "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"pts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{
        "pts", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}]}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{"BrocardPointPositive", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"q1a", ",", "q1b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q2a", ",", "q2b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q3a", ",", "q3b"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Line", "[", 
           RowBox[{"AppendFirst", "[", "pts", "]"}], "]"}], ",", 
          "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"q1a", ",", "q1b"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"q2a", ",", "q2b"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"q3a", ",", "q3b"}], "}"}], "]"}]}], "}"}], ",", 
          "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"c", ",", "q1a"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"c", ",", "q2a"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"c", ",", "q3a"}], "}"}], "]"}]}], "}"}], ",", "Red"}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Point", "[", "c", "]"}], ",", 
          RowBox[{"Darker", "[", "Red", "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Point", "/@", "pts"}], ",", "Black"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q1a\>\"", ",", "q1a", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q1b\>\"", ",", "q1b", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q2a\>\"", ",", "q2a", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q2b\>\"", ",", "q2b", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q3a\>\"", ",", "q3a", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q3b\>\"", ",", "q3b", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<c\>\"", ",", "c", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}]}], 
           "\[IndentingNewLine]", "}"}], ",", "Black"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], 
  "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.631489754482333*^9, 3.631489985616503*^9}, {
   3.63149003449815*^9, 3.631490038343445*^9}, {3.631490379405686*^9, 
   3.631490391604755*^9}, 3.631996100773074*^9, 3.631996189571755*^9, 
   3.632078867435223*^9, {3.632079323668016*^9, 3.632079332003838*^9}},
 CellLabel->
  "In[344]:=",ExpressionUUID->"c8ab8634-447f-43ee-800d-6cf1d117d7c2"],

Cell[TextData[{
 "BrocardPointNegative",
 "[",
 StyleBox["{q1a,q1b},{q2a,q2b},{q3a,q3b}",
  FontSlant->"Italic"],
 "] takes the endpoints of three edges of a polygon and returns the point ",
 StyleBox["c",
  FontSlant->"Italic"],
 " such that the lines from ",
 StyleBox["c",
  FontSlant->"Italic"],
 " to ",
 StyleBox["q1b",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q2b",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["q3b",
  FontSlant->"Italic"],
 " all make the same angle with their respective adjacent edges."
}], "Text",
 CellChangeTimes->{
  3.6275012934614487`*^9, {3.627508014354229*^9, 3.627508038480196*^9}, {
   3.631489301189025*^9, 3.631489305131119*^9}, {3.631489573291494*^9, 
   3.631489573897725*^9}, {3.631489658067294*^9, 3.631489711928648*^9}, 
   3.631996203642931*^9},ExpressionUUID->"0cd49c35-589f-4914-95ed-\
08cd051a5951"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BrocardPointNegative", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"q1a_", ",", "q1b_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q2a_", ",", "q2b_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q3a_", ",", "q3b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"BrocardPointPositive", "[", 
   RowBox[{
    RowBox[{
     StyleBox["{",
      FontSlant->"Italic"], 
     RowBox[{"q1b", ",", " ", "q1a"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"q2b", ",", " ", "q2a"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"q3b", ",", " ", "q3a"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.631490317494359*^9, 3.631490365604034*^9}, {
  3.631996189320757*^9, 3.631996204634024*^9}, {3.632078836509661*^9, 
  3.632078842353499*^9}},
 CellLabel->
  "In[345]:=",ExpressionUUID->"60476310-2818-4cd5-8c19-104c00647f68"],

Cell["Example", "Text",
 CellChangeTimes->{{3.631489748541637*^9, 
  3.631489749373702*^9}},ExpressionUUID->"fee4cee5-ebdf-4469-b2c6-\
32a6af0b89d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "pts", ",", "q1a", ",", "q1b", ",", "q2a", ",", "q2b", ",", "q3a", ",", 
      "q3b", ",", "c"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", ".5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.8", ",", 
          RowBox[{"-", "0.2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "0.7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.6", ",", ".5"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "q1a", ",", "q1b", ",", "q2a", ",", "q2b", ",", "q3a", ",", "q3b"}], 
       "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"pts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{"pts", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}],
         ",", 
        RowBox[{
        "pts", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}]}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{"BrocardPointNegative", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"q1a", ",", "q1b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q2a", ",", "q2b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"q3a", ",", "q3b"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Line", "[", 
           RowBox[{"AppendFirst", "[", "pts", "]"}], "]"}], ",", 
          "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"q1a", ",", "q1b"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"q2a", ",", "q2b"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"q3a", ",", "q3b"}], "}"}], "]"}]}], "}"}], ",", 
          "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"c", ",", "q1b"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"c", ",", "q2b"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{"c", ",", "q3b"}], "}"}], "]"}]}], "}"}], ",", 
          "Green"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Point", "[", "c", "]"}], ",", 
          RowBox[{"Darker", "[", "Green", "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Point", "/@", "pts"}], ",", "Black"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q1a\>\"", ",", "q1a", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q1b\>\"", ",", "q1b", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q2a\>\"", ",", "q2a", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q2b\>\"", ",", "q2b", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q3a\>\"", ",", "q3a", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<q3b\>\"", ",", "q3b", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<c\>\"", ",", "c", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}]}], 
           "\[IndentingNewLine]", "}"}], ",", "Black"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], 
  "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.631489754482333*^9, 3.631489985616503*^9}, {
   3.63149003449815*^9, 3.631490038343445*^9}, {3.631995930008758*^9, 
   3.631996058729451*^9}, 3.631996204117269*^9, 3.632078881421473*^9, {
   3.632079337880742*^9, 3.632079342754325*^9}},
 CellLabel->
  "In[346]:=",ExpressionUUID->"18f9e629-646e-4bae-b0c2-7bdf13ff7afa"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "RotationAngles[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "]\nPolygonAngles[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.6281180250401897`*^9, 3.628118029189508*^9}, {
   3.628529073861843*^9, 3.628529078173212*^9}, 3.628786271100699*^9, {
   3.629219407751456*^9, 
   3.629219408497888*^9}},ExpressionUUID->"a4eb8db2-95a9-4705-858f-\
2bd67e28117a"],

Cell[TextData[{
 "RotationAngles[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "] returns a list of the CCW rotation angles of the closed polygon whose \
vertices are ",
 StyleBox["verts",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.628118030965605*^9, 3.628118085497855*^9}, 
   3.628786271174198*^9, {3.629219409191688*^9, 
   3.629219409944655*^9}},ExpressionUUID->"801c64a7-33f5-424d-b212-\
abbfa91036aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RotationAngles", "[", "verts_List", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"RotationAngle", "@@", "#"}], "&"}], "/@", 
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RotateRight", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "@", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"verts", ",", 
        RowBox[{"RotateLeft", "[", "verts", "]"}]}], "}"}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.628118095364386*^9, 3.628118114587935*^9}, {
   3.628118182662267*^9, 3.628118201093378*^9}, {3.628118243949772*^9, 
   3.628118331907434*^9}, {3.628118364671238*^9, 3.628118372298635*^9}, 
   3.628786221998147*^9, 3.628786271197549*^9, {3.629219410736442*^9, 
   3.629219411951655*^9}, 3.778749050111171*^9},
 CellLabel->
  "In[347]:=",ExpressionUUID->"c021d99d-65b8-4145-af52-68ea6d92c218"],

Cell["Example", "Text",
 CellChangeTimes->{{3.6281181167998238`*^9, 
  3.6281181175519347`*^9}},ExpressionUUID->"52637610-bea6-4084-a71a-\
bb70d125b1c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "verts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Line", "[", 
        RowBox[{"Append", "[", 
         RowBox[{"verts", ",", 
          RowBox[{
          "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
         "]"}], "]"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"RotationAngles", "[", "verts", "]"}]}]}], "\[IndentingNewLine]",
    "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6281181361399813`*^9, 3.628118170951249*^9}, {
   3.628118392049945*^9, 3.628118451976584*^9}, 3.628786271244761*^9, {
   3.6292194126172943`*^9, 3.629219414853862*^9}},
 CellLabel->
  "In[348]:=",ExpressionUUID->"8893a2aa-b67d-4d40-ab80-74b5631f8d68"],

Cell[TextData[{
 "PolygonAngles[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "] returns the CCW interior angles of the closed polygon whose vertices are ",
 StyleBox["verts",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.628529083740372*^9, 3.628529105659264*^9}, {
  3.62921941556915*^9, 
  3.6292194162668447`*^9}},ExpressionUUID->"570f4074-0b2d-4c37-a65c-\
e1b5a8b17d02"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolygonAngles", "[", "verts_List", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Pi]", "-", "#"}], "&"}], "/@", 
   RowBox[{"RotationAngles", "[", "verts", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.628529113967903*^9, 3.628529132755188*^9}, 
   3.628786271292363*^9, {3.629219416892385*^9, 3.629219417485405*^9}},
 CellLabel->
  "In[349]:=",ExpressionUUID->"1402aea7-2914-48db-b170-fc19472901c0"],

Cell["Example", "Text",
 CellChangeTimes->{{3.6281181167998238`*^9, 
  3.6281181175519347`*^9}},ExpressionUUID->"34115cff-be31-4a20-a8b8-\
0095eab0bf57"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "verts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Line", "[", 
        RowBox[{"Append", "[", 
         RowBox[{"verts", ",", 
          RowBox[{
          "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
         "]"}], "]"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"PolygonAngles", "[", "verts", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6281181361399813`*^9, 3.628118170951249*^9}, {
   3.628118392049945*^9, 3.628118451976584*^9}, 3.628529147677987*^9, {
   3.629219418206552*^9, 3.629219422020842*^9}},
 CellLabel->
  "In[350]:=",ExpressionUUID->"4d5bc5a7-0421-4eea-b6c5-dae4cc3426c7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "CompletePolygonAngles[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.6285286282337937`*^9, 
  3.628528638023561*^9}},ExpressionUUID->"7ae2bc70-ee77-4b3f-9a01-\
96aac7f3760d"],

Cell[TextData[{
 "CompletePolygonAngles[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "] takes a list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " of ",
 StyleBox["n",
  FontSlant->"Italic"],
 " interior angles for a polygon and returns a list of ",
 StyleBox["n+1",
  FontSlant->"Italic"],
 " angles that are the interior angles of an (",
 StyleBox["n+1",
  FontSlant->"Italic"],
 ")-gon."
}], "Text",
 CellChangeTimes->{{3.628528651627868*^9, 3.628528700509684*^9}, {
  3.628529178711892*^9, 
  3.62852918544574*^9}},ExpressionUUID->"a2b7545b-93b5-4ad0-8cca-\
11c601164040"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CompletePolygonAngles", "[", "angles_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "n", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"1", "+", 
       RowBox[{"Length", "[", "angles", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Append", "[", 
      RowBox[{"angles", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"\[Pi]", "-", "#"}], "&"}], "/@", "angles"}], ")"}]}], 
         ")"}], "-", "\[Pi]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.628528713439636*^9, 3.628528805074437*^9}, {
  3.628528957352108*^9, 3.628528963056857*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"c075e2e5-bb1b-445b-b16b-57b86201956c"],

Cell["Examples.", "Text",
 CellChangeTimes->{{3.628528809352582*^9, 3.6285288100218368`*^9}, {
  3.6285288966888127`*^9, 
  3.628528897128653*^9}},ExpressionUUID->"4784bb32-24a7-4dcb-b5c4-\
7e0749a53ac4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CompletePolygonAngles", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"90", "\[Degree]"}], ",", 
       RowBox[{"90", "\[Degree]"}], ",", 
       RowBox[{"89", "\[Degree]"}]}], "}"}], "]"}], "/", "\[Degree]"}], "//", 
   "N"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628528812764298*^9, 3.628528860559042*^9}, {
  3.628528970870718*^9, 3.628528971063638*^9}},
 CellLabel->
  "In[352]:=",ExpressionUUID->"68562742-8f6d-4f1c-9ab2-952c13cc8b2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CompletePolygonAngles", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"108", "\[Degree]"}], ",", 
       RowBox[{"108", "\[Degree]"}], ",", 
       RowBox[{"108", "\[Degree]"}], ",", 
       RowBox[{"109", "\[Degree]"}]}], "}"}], "]"}], "/", "\[Degree]"}], "//",
    "N"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628528812764298*^9, 3.628528876327021*^9}, {
  3.628528972918989*^9, 3.628528973383194*^9}},
 CellLabel->
  "In[353]:=",ExpressionUUID->"931fdcca-4048-4935-9edc-2c85d2923b25"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "ConcyclicCenterAngles[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.628538581435169*^9, 3.6285385888001747`*^9}, {
   3.6285387207600117`*^9, 3.628538731570468*^9}, 3.628538812362753*^9, {
   3.628546864760808*^9, 
   3.628546865341612*^9}},ExpressionUUID->"606e6931-d118-45a4-b9f7-\
4b663105a839"],

Cell[TextData[{
 "ConcyclicCenterAngles[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side",
  FontSlant->"Italic"],
 "] returns the center angles of a cyclic polygon (a polygon whose vertices \
are concyclic, i.e., they all lie on a common circle) where ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " is a list of the desired corner angles of the polygon. For odd-order \
polygons, the solution is unique; for even-order polygons, one can add any \
alternating sequence {\[Alpha],-\[Alpha],...} to the returned solution and \
still have a solution."
}], "Text",
 CellChangeTimes->{{3.628538598341703*^9, 3.628538621494124*^9}, {
  3.628538653070487*^9, 3.628538877318001*^9}, {3.62853904809167*^9, 
  3.628539058562343*^9}, {3.628546875212853*^9, 3.6285469869096403`*^9}, {
  3.628554266547312*^9, 
  3.62855428965751*^9}},ExpressionUUID->"cde1c115-0f5b-487c-9f31-\
f059e9f6f628"],

Cell[TextData[{
 "Note that ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " must sum to (",
 StyleBox["n",
  FontSlant->"Italic"],
 "-2)\[Pi], so the last angle in the list will be ignored (we\
\[CloseCurlyQuote]ll use the appropriate value). For even-degree polygons, \
the corner angles must also satisfy Kasasaki\[CloseCurlyQuote]s Condition \
(alternating sum to zero), so the second-to-last angle will also be ignored \
(or rather, the forced value will be used)."
}], "Text",
 CellChangeTimes->{{3.628538882645824*^9, 3.628538994734808*^9}, {
  3.628546991757769*^9, 3.628546992277831*^9}, {3.6285479777775526`*^9, 
  3.628548020483958*^9}},ExpressionUUID->"ce41d38e-60c0-483a-9261-\
90fa787efe8d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicCenterAngles", "[", 
   StyleBox["angles_",
    FontSlant->"Italic"], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "n", ",", "inv"}], "}"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "angles", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"a", "=", 
       RowBox[{"CompletePolygonAngles", "[", 
        RowBox[{"Drop", "[", 
         RowBox[{"angles", ",", 
          RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"inv", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{"i", "<", "j"}], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"i", "+", "j", "-", "1"}]], ",", 
           RowBox[{"i", ">", "j"}], ",", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"i", "+", "j"}]], ",", "True", ",", "1"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "n"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Pi]", "-", "#"}], "&"}], "/@", 
       RowBox[{"(", 
        RowBox[{"inv", ".", "a"}], ")"}]}]}]}], "]"}], "/;", 
   RowBox[{"OddQ", "[", 
    RowBox[{"Length", "[", "angles", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.628539003308576*^9, 3.628539031967636*^9}, {
   3.628539062710065*^9, 3.628539225932654*^9}, {3.628539270365346*^9, 
   3.628539287017611*^9}, {3.628539508743231*^9, 3.628539527228423*^9}, {
   3.628539708367744*^9, 3.628539710014162*^9}, {3.628539748386902*^9, 
   3.628539768384179*^9}, 3.628547001905837*^9, 3.628553026553389*^9, {
   3.6285534103677998`*^9, 3.628553447245791*^9}},
 CellLabel->
  "In[354]:=",ExpressionUUID->"f96baeba-9f98-4e29-9fbf-358ceb7cca0c"],

Cell["Example: odd numbers. We can drop the last angle.", "Text",
 CellChangeTimes->{{3.6285392320550346`*^9, 3.628539232798723*^9}, {
  3.628552605485578*^9, 3.628552607197432*^9}, {3.628553523622304*^9, 
  3.628553529650386*^9}},ExpressionUUID->"9fb8e2f2-7009-44c4-9917-\
af86b789156e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConcyclicCenterAngles", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"40", "\[Degree]"}], ",", 
      RowBox[{"60", "\[Degree]"}], ",", "0"}], "}"}], "]"}], "/", 
   "\[Degree]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.628539234545133*^9, 3.62853925034675*^9}, {
  3.62853958890772*^9, 3.628539590418661*^9}, {3.628539651033592*^9, 
  3.628539678631802*^9}, {3.6285534978646193`*^9, 3.62855350400949*^9}},
 CellLabel->
  "In[355]:=",ExpressionUUID->"cad3b566-4eb6-4c9d-b3e4-753113eb2b49"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"160.`", ",", "80.`", ",", "120.`"}], "}"}]], "Output",
 CellChangeTimes->{3.962635224653953*^9, 3.966628792941053*^9, 
  3.9671207906545486`*^9},
 CellLabel->
  "Out[355]=",ExpressionUUID->"c68a8b9b-2887-4262-9033-5ac9208153f5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConcyclicCenterAngles", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"98", "\[Degree]"}], ",", 
      RowBox[{"108", "\[Degree]"}], ",", 
      RowBox[{"118", "\[Degree]"}], ",", 
      RowBox[{"128", "\[Degree]"}], ",", "0"}], "}"}], "]"}], "/", 
   "\[Degree]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.628539234545133*^9, 3.62853925034675*^9}, {
   3.62853958890772*^9, 3.628539590418661*^9}, {3.628539651033592*^9, 
   3.628539678631802*^9}, {3.62855336383542*^9, 3.628553402414281*^9}, 
   3.628553458905634*^9, {3.628553511557867*^9, 3.6285535164387217`*^9}},
 CellLabel->
  "In[356]:=",ExpressionUUID->"4dd9a865-1f4f-418d-af30-9f4efb464d6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "52.00000000000002`", ",", "92.00000000000003`", ",", "31.999999999999943`",
    ",", "72.`", ",", "112.00000000000006`"}], "}"}]], "Output",
 CellChangeTimes->{3.962635224668358*^9, 3.9666287929546537`*^9, 
  3.967120790667561*^9},
 CellLabel->
  "Out[356]=",ExpressionUUID->"af810476-549c-4a06-a362-01e7ad0c540f"]
}, Closed]],

Cell["\<\
For even version, we need to use the Pseudoinverse (which we construct \
explicitly).\
\>", "Text",
 CellChangeTimes->{{3.628552885220899*^9, 
  3.628552901419044*^9}},ExpressionUUID->"a1d2ec36-f0a8-494f-b6ee-\
a1f2c740ba07"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConcyclicCenterAngles", "[", 
   StyleBox["angles_",
    FontSlant->"Italic"], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "sum", ",", "diff", ",", "a", ",", "inv"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"Length", "[", "angles", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sum", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"Drop", "[", 
          RowBox[{"angles", ",", 
           RowBox[{"-", "2"}]}], "]"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"diff", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"i", "-", "1"}]], 
           RowBox[{
           "angles", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}],
           ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{
             RowBox[{"Length", "[", "angles", "]"}], "-", "2"}]}], "}"}]}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"a", "=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"angles", ",", 
           RowBox[{"-", "2"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "\[Pi]"}], "-", "sum", "-", 
              "diff"}], ")"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "\[Pi]"}], "-", "sum", "+", 
              "diff"}], ")"}], "/", "2"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"inv", "=", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"i", "+", "j", "-", "1"}]], "2", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"i", "-", "j", "+", 
                RowBox[{"1", "/", "2"}]}], ",", "n"}], "]"}], "-", 
             RowBox[{"n", "/", "2"}]}], ")"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "n"}], "}"}]}], "]"}], "/", "n"}]}], ";", 
      RowBox[{"(*", " ", "pseudoinverse", " ", "*)"}], "\[IndentingNewLine]", 
      
      RowBox[{"inv", ".", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", "a"}], ")"}]}]}]}], "]"}], "/;", 
   RowBox[{"EvenQ", "[", 
    RowBox[{"Length", "[", "angles", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.628539738042282*^9, 3.628539738490769*^9}, {
   3.62853978336744*^9, 3.628539783952856*^9}, {3.62853981785376*^9, 
   3.628539845412421*^9}, {3.628539919299752*^9, 3.628539938209272*^9}, {
   3.628540061320988*^9, 3.628540080301979*^9}, {3.628547005946774*^9, 
   3.628547093156603*^9}, {3.628547182625277*^9, 3.628547214297623*^9}, {
   3.628547304978346*^9, 3.628547334773923*^9}, {3.628547501167242*^9, 
   3.628547567082044*^9}, 3.628547606028761*^9, {3.628552533872356*^9, 
   3.6285525341375318`*^9}, {3.628552580532111*^9, 3.628552588740732*^9}, {
   3.628552914433522*^9, 3.628553023537444*^9}},
 CellLabel->
  "In[357]:=",ExpressionUUID->"bb3525d3-1bb9-407e-b8f3-46c0ecea1ba9"],

Cell["Example: even numbers. We can drop the last two angles.", "Text",
 CellChangeTimes->{{3.6285392320550346`*^9, 3.628539232798723*^9}, {
  3.628552609493243*^9, 3.628552611053684*^9}, {3.628553533714452*^9, 
  3.628553537657961*^9}},ExpressionUUID->"2d4ca2ce-9fc3-4ec2-a513-\
9a5d6c8f68ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConcyclicCenterAngles", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"80", "\[Degree]"}], ",", 
      RowBox[{"90", "\[Degree]"}], ",", "0", ",", "0"}], "}"}], "]"}], "/", 
   "\[Degree]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.628552497556426*^9, 3.628552524436602*^9}, 
   3.628553474603167*^9, {3.6285535631078672`*^9, 3.628553572418723*^9}},
 CellLabel->
  "In[358]:=",ExpressionUUID->"f990537e-6f5c-4129-a9fb-ef5fbb45a136"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "99.99999999999999`", ",", "80.`", ",", "80.00000000000001`", ",", 
   "100.`"}], "}"}]], "Output",
 CellChangeTimes->{3.96263522469529*^9, 3.966628792969952*^9, 
  3.967120790684134*^9},
 CellLabel->
  "Out[358]=",ExpressionUUID->"7f6f97a2-b333-4d41-9f7d-fbe5ad8fd9fc"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConcyclicCenterAngles", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"128", "\[Degree]"}], ",", 
      RowBox[{"119", "\[Degree]"}], ",", 
      RowBox[{"118", "\[Degree]"}], ",", 
      RowBox[{"115", "\[Degree]"}], ",", "0", ",", "0"}], "}"}], "]"}], "/", 
   "\[Degree]"}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.628539234545133*^9, 3.62853925034675*^9}, {
  3.62853958890772*^9, 3.628539590418661*^9}, {3.628539651033592*^9, 
  3.628539678631802*^9}, {3.628547261880319*^9, 3.628547296685574*^9}, {
  3.62855354511735*^9, 3.62855354970866*^9}},
 CellLabel->
  "In[359]:=",ExpressionUUID->"01cc32f0-3bc1-456e-a12f-042026974f17"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "58.00000000000001`", ",", "63.999999999999986`", ",", 
   "59.999999999999986`", ",", "70.00000000000003`", ",", 
   "62.000000000000014`", ",", "45.999999999999986`"}], "}"}]], "Output",
 CellChangeTimes->{3.962635224718356*^9, 3.966628792975007*^9, 
  3.967120790689313*^9},
 CellLabel->
  "Out[359]=",ExpressionUUID->"e717e546-c49d-49e6-8a96-a9b276b9233d"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "PolygonSides[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "]\nPolygonPerimeter[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.629219097010316*^9, 3.629219110537328*^9}, {
  3.629219176452571*^9, 3.6292191856027946`*^9}, {3.6730973496668677`*^9, 
  3.67309734990442*^9}, {3.673097384463716*^9, 
  3.673097385030541*^9}},ExpressionUUID->"d05730b5-5a46-4284-bd97-\
3655d470c532"],

Cell[TextData[{
 "PolygonSides[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "] returns a list of the lengths of the sides of the closed polygon whose \
vertices are ",
 StyleBox["verts",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.629219124444591*^9, 3.629219148948739*^9}, {
  3.629219181502844*^9, 3.6292191910661077`*^9}, {3.629219444267679*^9, 
  3.629219452305471*^9}},ExpressionUUID->"5fe1fa29-48b4-4885-9b34-\
df55573dd7a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolygonSides", "[", "verts_List", "]"}], ":=", 
  RowBox[{"Mag", "/@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"RotateLeft", "[", "verts", "]"}], "-", "verts"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.629219118601519*^9, 3.6292191186047573`*^9}, {
  3.629219197881915*^9, 3.629219219802407*^9}},
 CellLabel->
  "In[360]:=",ExpressionUUID->"6410622f-2e53-4c44-be21-0ce66774acd8"],

Cell["Example", "Text",
 CellChangeTimes->{{3.629219224907051*^9, 
  3.629219225647904*^9}},ExpressionUUID->"48be9602-d949-41bb-b3a3-\
d5360f6c3b3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolygonSides", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["16", "25"], ",", 
       FractionBox["12", "25"]}], "}"}]}], "}"}], "]"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.629219227514612*^9, 3.629219235217831*^9}, {
  3.629219337652478*^9, 3.629219353621439*^9}},
 CellLabel->
  "In[361]:=",ExpressionUUID->"fef13754-891f-4490-a814-48c72d3eea8b"],

Cell[TextData[{
 "PolygonPerimeter[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "] returns the perimeter of a closed 2D polygon. Arguments are:\n\tpts \
\[LongDash] the list of vertices."
}], "Text",
 CellChangeTimes->{{3.671378648264635*^9, 3.6713786840624247`*^9}, 
   3.673097357330719*^9},ExpressionUUID->"7fbfe170-68f8-41d6-8982-\
23a3b8c296f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolygonPerimeter", "[", "verts_List", "]"}], ":=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"(", 
    RowBox[{"Mag", "/@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"RotateLeft", "[", "verts", "]"}], "-", "verts"}], ")"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.671378686098822*^9, 3.671378727751457*^9}, {
  3.6730973614359*^9, 3.673097367322442*^9}},
 CellLabel->
  "In[362]:=",ExpressionUUID->"3904e943-ee45-4b3b-9a3a-cab052395acb"],

Cell["Example", "Text",
 CellChangeTimes->{{3.671378734076025*^9, 
  3.671378735626995*^9}},ExpressionUUID->"8d9bf00c-42bc-4ba1-8506-\
ab5f123bdb78"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "verts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"PolygonPerimeter", "[", "verts", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.6713787434396544`*^9, 3.671378784937113*^9}, {
  3.67309736879676*^9, 3.673097371467345*^9}},
 CellLabel->
  "In[363]:=",ExpressionUUID->"a6dc3f0d-66d3-4430-8dec-8a30a721f5d4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "PolygonSignedArea2D[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.693484762626642*^9, 3.693484770211238*^9}, {
  3.6934848752283373`*^9, 
  3.693484875692091*^9}},ExpressionUUID->"f2b7ea84-4703-4d08-ad17-\
b7f431a260b2"],

Cell[TextData[{
 "PolygonSignedArea2D[",
 StyleBox["verts",
  FontSlant->"Italic"],
 "] returns the total signed area of a 2D polygon whose vertices are ",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", positive for CCW circulation, negative for CW."
}], "Text",
 CellChangeTimes->{{3.69348477197077*^9, 3.693484813587718*^9}, 
   3.693484879134808*^9},ExpressionUUID->"5706f8f1-1903-42ff-bdac-\
3ecb89292b2c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolygonSignedArea2D", "[", "verts_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "ctr", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ctr", "=", 
      RowBox[{"Centroid", "[", "verts", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Plus", "@@", 
      RowBox[{"MapThread", "[", 
       RowBox[{"TriangleSignedArea2D", ",", 
        RowBox[{"{", 
         RowBox[{"verts", ",", 
          RowBox[{"RotateLeft", "[", "verts", "]"}], ",", 
          RowBox[{"Table", "[", 
           RowBox[{"ctr", ",", 
            RowBox[{"{", 
             RowBox[{"Length", "[", "verts", "]"}], "}"}]}], "]"}]}], "}"}]}],
        "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.693484826926503*^9, 3.6934849555598917`*^9}},
 CellLabel->
  "In[364]:=",ExpressionUUID->"d7eeea80-342d-47d1-be61-a396b11b2a33"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.693484958659942*^9, 
  3.69348495960469*^9}},ExpressionUUID->"5b3c8a10-8dbd-4338-af0e-\
c6640440a766"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "verts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"PolygonSignedArea2D", "[", "verts", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.693484961648247*^9, 3.693484998135536*^9}},
 CellLabel->
  "In[365]:=",ExpressionUUID->"b5e90cc8-f372-4a5c-a202-75efedcb28e8"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit polygons", "Subsection",
 CellChangeTimes->{{3.627339771557445*^9, 3.627339774910503*^9}, 
   3.70840099930591*^9},ExpressionUUID->"41e852fc-06c9-4a60-a120-\
9db580ddeb48"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.627339815707698*^9, 
  3.627339816610568*^9}},ExpressionUUID->"f1ffa93d-b822-4de8-a98b-\
2235c5308fc2"],

Cell["\<\
We define a \[OpenCurlyDoubleQuote]unit polygon\[CloseCurlyDoubleQuote] as a \
polygon whose first vertex is at {0,0}, second vertex at {1,0}, and that \
cycles counterclockwise, so that if it is convex, it resides in the upper \
half-plane. this serves as a sort of \[OpenCurlyDoubleQuote]standard position\
\[CloseCurlyDoubleQuote] for many different types of polygon.\
\>", "Text",
 CellChangeTimes->{{3.6273398192992887`*^9, 
  3.6273398851097736`*^9}},ExpressionUUID->"aa37846b-7388-4bf2-928f-\
c100056c1a93"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitTriangleVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.628554092630999*^9, 
  3.628554094135292*^9}},ExpressionUUID->"8d49eb4b-2418-4a93-837a-\
a8d141140fcd"],

Cell[TextData[{
 "UnitTriangleVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "] returns a list of 3 vertices for a triangle whose angles are given in the \
specified list (you can drop the last one, which is ignored in any event). \
The base of the triangle is of unit length, and the first angle is lower \
left. Note that this convention is the same as that for ",
 "UnitRegularPolygon",
 "Tile in the next section."
}], "Text",
 CellChangeTimes->{{3.5345373126592917`*^9, 3.534537438861646*^9}, 
   3.6273397024830737`*^9},ExpressionUUID->"689c370a-608b-48bd-bf3f-\
e8edca85b248"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitTriangleVertices", "[", "angles_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"A", ",", "B", ",", "C", ",", "b"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"A", ",", "B"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{"angles", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"C", "=", 
      RowBox[{"\[Pi]", "-", 
       RowBox[{"(", 
        RowBox[{"A", "+", "B"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"b", "=", 
      RowBox[{
       RowBox[{"Sin", "[", "B", "]"}], "/", 
       RowBox[{"Sin", "[", "C", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"b", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "A", "]"}], ",", 
          RowBox[{"Sin", "[", "A", "]"}]}], "}"}]}]}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.534537440652926*^9, 3.534537452857266*^9}, {
  3.534537490298719*^9, 3.534537554762274*^9}, {3.534537631022314*^9, 
  3.534537689738237*^9}},
 CellLabel->
  "In[366]:=",ExpressionUUID->"9e2bfa19-20bb-4117-ae62-6d747975909b"],

Cell["Example", "Text",
 CellChangeTimes->{{3.534537693444166*^9, 
  3.534537694148123*^9}},ExpressionUUID->"26d0bf63-b103-4a5e-9ace-\
c9df4d5d1535"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pa", ",", "pb", ",", "pc"}], "}"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"pa", ",", "pb", ",", "pc"}], "}"}], "=", 
      RowBox[{"UnitTriangleVertices", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"40", "\[Degree]"}], ",", 
         RowBox[{"60", "\[Degree]"}], ",", 
         RowBox[{"80", "\[Degree]"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"pa", ",", "pb", ",", "pc", ",", "pa"}], "}"}], "]"}], 
      "]"}]}]}], "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",\

 CellChangeTimes->{{3.534537696331989*^9, 3.534537743635376*^9}},
 CellLabel->
  "In[367]:=",ExpressionUUID->"f4f5a8b0-fe73-4c85-8c1b-0e835f4c2a0a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit cyclic polygons", "Subsection",
 CellChangeTimes->{{3.4577121885958433`*^9, 3.457712189953725*^9}, {
   3.4579202479961653`*^9, 3.457920248607415*^9}, 3.457920319464107*^9, {
   3.595975220144129*^9, 3.595975222382164*^9}, {3.62733972067495*^9, 
   3.627339721465081*^9}, 3.6285218167415137`*^9, {3.628532187325913*^9, 
   3.628532187963628*^9}, {3.6285540470515633`*^9, 3.628554047816944*^9}, 
   3.7084009964159813`*^9},ExpressionUUID->"20a7a5ee-7015-4535-a5ff-\
acd2de8873a1"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.628554406970674*^9, 
  3.628554407410512*^9}},ExpressionUUID->"5869a81a-6ee5-451a-b8ec-\
681c12b0f293"],

Cell[TextData[{
 "A polygon whose vertices lie on a circle is called a ",
 StyleBox["cyclic polygon",
  FontSlant->"Italic"],
 ". The vertices are said to be ",
 StyleBox["concyclic",
  FontSlant->"Italic"],
 ". Cyclic polygons are used in centered twist tiles."
}], "Text",
 CellChangeTimes->{{3.628522677656603*^9, 3.628522700851478*^9}, 
   3.628531250914895*^9, {3.628554123902289*^9, 3.628554136907227*^9}, {
   3.6285543820282097`*^9, 3.62855441628181*^9}, {3.6301083843766117`*^9, 
   3.630108385728938*^9}, {3.631995283006887*^9, 
   3.631995285666238*^9}},ExpressionUUID->"0f409b89-7956-4034-83c3-\
97ddc4df5ac7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitTriangleConcyclicInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{
  3.534538188742907*^9, 3.5919790466436453`*^9, {3.628521423663339*^9, 
   3.628521427566437*^9}, {3.628521540144013*^9, 3.628521577516931*^9}, {
   3.628530863113396*^9, 3.6285308738324556`*^9}, 3.628531234983623*^9, 
   3.628554083290891*^9},ExpressionUUID->"c2b4765f-71b8-4145-b914-\
a7c992efd3c4"],

Cell[TextData[{
 "UnitTriangleConcyclicInfo",
 "[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "] returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "}, for a triangle whose angles are given in the specified list (the third \
angle is ignored). ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 " is the circumcenter, ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the circumradius."
}], "Text",
 CellChangeTimes->{{3.628521281161182*^9, 3.628521356507361*^9}, {
   3.62852162423439*^9, 3.628521632314658*^9}, {3.628521678622818*^9, 
   3.628521679286143*^9}, {3.628521712052342*^9, 3.628521760849154*^9}, 
   3.628522706854712*^9, {3.62852273725004*^9, 3.628522791909491*^9}, {
   3.628523424491893*^9, 3.628523592313291*^9}, {3.628530888258953*^9, 
   3.628530954395732*^9}, 
   3.628531235047431*^9},ExpressionUUID->"0704b122-7def-4841-a7bb-\
3b911be72158"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitTriangleConcyclicInfo", "[", "angles_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"verts", ",", "cinfo"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"UnitTriangleVertices", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cinfo", "=", 
      RowBox[{"ConcyclicInfo", "[", "verts", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", 
       RowBox[{
       "cinfo", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
       RowBox[{
       "cinfo", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
      "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.628530961642805*^9, 3.628530989703931*^9}, {
   3.628531041210846*^9, 3.628531041961454*^9}, 3.628531117222988*^9, 
   3.628531235085518*^9},
 CellLabel->
  "In[368]:=",ExpressionUUID->"717c9359-28d1-4533-9734-59f45bd8ce0b"],

Cell["Example", "Text",
 CellChangeTimes->{{3.628531001963294*^9, 
  3.628531002704198*^9}},ExpressionUUID->"c40f0933-ae08-4261-b68c-\
cdec4849482d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitTriangleConcyclicInfo", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"40", "\[Degree]"}], ",", 
      RowBox[{"60", "\[Degree]"}], ",", 
      RowBox[{"80", "\[Degree]"}]}], "}"}], "]"}], "//", "N"}], "//", 
  "ShowExample"}]], "Input",
 CellChangeTimes->{{3.534537696331989*^9, 3.534537743635376*^9}, {
   3.628531022788073*^9, 3.628531049977085*^9}, 3.628531235318755*^9, {
   3.628548751294777*^9, 3.628548773189698*^9}},
 CellLabel->
  "In[369]:=",ExpressionUUID->"7d1e9f9d-4b93-469f-9154-45eaeee465eb"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitCyclicQuadrilateralConcyclicInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side, is",
  FontSlant->"Italic"],
 "]\nUnitCyclicQuadrilateralVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side, is",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.628530819774391*^9, 3.6285308336755757`*^9}, {
   3.628531278168673*^9, 3.6285312824301167`*^9}, {3.62853202397205*^9, 
   3.628532033774407*^9}, {3.628553940352833*^9, 3.628553965153249*^9}, 
   3.628554210410928*^9, {3.630107430635166*^9, 3.630107440446476*^9}, {
   3.632079523083684*^9, 
   3.632079528922903*^9}},ExpressionUUID->"5c691799-4eb9-4916-bfb9-\
68ab2b69e771"],

Cell[TextData[{
 "UnitCyclicQuadrilateralConcyclicInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side",
  FontSlant->"Italic"],
 "] returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "} for a quadrilateral whose corner angles are given in the specified list \
",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["verts",
  FontSlant->"Italic"],
 " is a list of the four vertices on a common circle, ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 " is the circle center, and ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the radius. Only the first two angle values are used; the last two are \
ignored, because a cyclic quadrilateral must have opposite interior angles \
sum to \[Pi]. The first edge is the unit edge (from {0,0} to {1,0}, and ",
 StyleBox["side",
  FontSlant->"Italic"],
 " specifies the length of the ",
 StyleBox["is",
  FontSlant->"Italic"],
 "th edge, with ",
 StyleBox["is",
  FontSlant->"Italic"],
 "=2 or 4 (singularities occur if you choose ",
 StyleBox["is",
  FontSlant->"Italic"],
 "=1 or 3). This is sufficient to fully specify the quadrilateral."
}], "Text",
 CellChangeTimes->{{3.628531309858471*^9, 3.628531428941064*^9}, 
   3.628554210565423*^9, 3.630107441799733*^9, {3.631995321416182*^9, 
   3.631995395808529*^9}, {3.632079542426317*^9, 3.632079542938302*^9}, {
   3.63207965594701*^9, 
   3.632079681073246*^9}},ExpressionUUID->"d077d5c1-98c2-491b-baac-\
64118fd3d482"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicQuadrilateralConcyclicInfo", "[", 
   RowBox[{"angles_List", ",", "side_", ",", " ", 
    RowBox[{"is_", ":", "2"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "v", ",", "v3x", ",", "v3y", ",", "v4x", ",", "v4y", ",", "c", ",", "cy",
       ",", "r", ",", "eqns", ",", "vars", ",", "soln"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v3x", ",", "v3y"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v4x", ",", "v4y"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "cy"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"Mag", "[", "c", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"eqns", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"r1", "=", 
                RowBox[{
                 RowBox[{"v", "\[LeftDoubleBracket]", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"i", "-", "1"}], ",", "4", ",", "1"}], "]"}], 
                  "\[RightDoubleBracket]"}], "-", 
                 RowBox[{
                 "v", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}]}]}], ",", 
               RowBox[{"r2", "=", 
                RowBox[{
                 RowBox[{"v", "\[LeftDoubleBracket]", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"i", "+", "1"}], ",", "4", ",", "1"}], "]"}], 
                  "\[RightDoubleBracket]"}], "-", 
                 RowBox[{
                 "v", "\[LeftDoubleBracket]", "i", 
                  "\[RightDoubleBracket]"}]}]}]}], "}"}], ",", 
             FractionBox[
              RowBox[{"r1", ".", "r2"}], 
              RowBox[{
               RowBox[{"Mag", "[", "r1", "]"}], 
               RowBox[{"Mag", "[", "r2", "]"}]}]]}], "]"}], "\[Equal]", 
           RowBox[{"Cos", "[", 
            RowBox[{
            "angles", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
            "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "2"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Mag", "[", 
            RowBox[{
             RowBox[{
             "v", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "-",
              "c"}], "]"}], "\[Equal]", "r"}], ",", 
          RowBox[{
           RowBox[{"Mag", "[", 
            RowBox[{
             RowBox[{
             "v", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}], "-",
              "c"}], "]"}], "\[Equal]", "r"}], ",", 
          RowBox[{
           RowBox[{"Mag", "[", 
            RowBox[{
             RowBox[{"v", "\[LeftDoubleBracket]", 
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"1", "+", "is"}], ",", "4", ",", "1"}], "]"}], 
              "\[RightDoubleBracket]"}], "-", 
             RowBox[{
             "v", "\[LeftDoubleBracket]", "is", "\[RightDoubleBracket]"}]}], 
            "]"}], "\[Equal]", "side"}]}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"vars", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"cy", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v3x", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v3y", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v4x", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"v4y", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"soln", "=", 
      RowBox[{"FindRoot", "@@", 
       RowBox[{"{", 
        RowBox[{"eqns", ",", "vars"}], "}"}]}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"Chop", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", ",", "c", ",", "r"}], "}"}], "/.", "soln"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.628531439378036*^9, 3.628531530673645*^9}, {
   3.628531581943777*^9, 3.62853174428108*^9}, {3.628531818187661*^9, 
   3.628531827512197*^9}, 3.628531886935397*^9, {3.628532042688854*^9, 
   3.628532046294857*^9}, 3.628554210591806*^9, 3.630107442590094*^9, {
   3.632079531707964*^9, 3.632079535779081*^9}, {3.632079587151548*^9, 
   3.6320795988301277`*^9}},
 CellLabel->
  "In[370]:=",ExpressionUUID->"2f0f8dd1-541f-493c-a1e9-444db2db5e62"],

Cell["Example", "Text",
 CellChangeTimes->{{3.628531758327524*^9, 
  3.62853176342344*^9}},ExpressionUUID->"150ddb4f-6b79-43f6-9939-\
f6f89f2857b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "plist", ",", "ctr", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"95", "\[Degree]"}], ",", 
        RowBox[{"100", "\[Degree]"}], ",", "0", ",", "0"}], "}"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"note", " ", "last", " ", "two", " ", "are", " ", "ignored"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Angles (input)/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{"angles", "/", "\[Degree]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plist", ",", "ctr", ",", "r"}], "}"}], "=", 
      RowBox[{"UnitCyclicQuadrilateralConcyclicInfo", "[", 
       RowBox[{"angles", ",", "0.8", ",", "2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Angles (actual)/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"PolygonAngles", "[", "plist", "]"}], "/", "\[Degree]"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"Append", "[", 
           RowBox[{"plist", ",", 
            RowBox[{
            "plist", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
            "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", "ctr", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Circle", "[", 
          RowBox[{"ctr", ",", "r"}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628524302124075*^9, 3.628524344827406*^9}, {
   3.62852606089177*^9, 3.628526131089645*^9}, {3.628526175044786*^9, 
   3.628526221611435*^9}, {3.628526257527814*^9, 3.628526259256768*^9}, {
   3.628526775929332*^9, 3.628526787334109*^9}, {3.628526944981365*^9, 
   3.628526946692108*^9}, 3.628527498960134*^9, {3.628527895008259*^9, 
   3.628527896518166*^9}, {3.628528078298472*^9, 3.628528112215905*^9}, {
   3.6285284994345827`*^9, 3.6285285247982597`*^9}, {3.628528906741399*^9, 
   3.628528939595236*^9}, {3.628528999663331*^9, 3.628529000049116*^9}, {
   3.628529203141498*^9, 3.628529252431917*^9}, {3.628529462690101*^9, 
   3.628529468376111*^9}, {3.628531770630842*^9, 3.628531810395034*^9}, {
   3.628531868326908*^9, 3.628531930451366*^9}, 3.6285542106048536`*^9, 
   3.630107443762156*^9, {3.6320796255385*^9, 3.632079633453253*^9}, {
   3.632079705614357*^9, 3.632079714132119*^9}},
 CellLabel->
  "In[371]:=",ExpressionUUID->"8aa2b433-4d3c-409e-bc65-13ea7fb0c0d7"],

Cell[TextData[{
 "UnitCyclicQuadrilateralVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side, is",
  FontSlant->"Italic"],
 "] returns just the vertices."
}], "Text",
 CellChangeTimes->{{3.628532053261359*^9, 3.628532068291727*^9}, {
   3.628553940416963*^9, 3.628553965228507*^9}, {3.628554225872428*^9, 
   3.628554226341647*^9}, 3.630107444914573*^9, {3.632079733127132*^9, 
   3.632079734533456*^9}},ExpressionUUID->"8b3b3bc0-01dd-45b7-93e1-\
58649b5ddb40"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicQuadrilateralVertices", "[", 
   RowBox[{"angles_List", ",", "side_", ",", 
    RowBox[{"is_", ":", "2"}]}], "]"}], ":=", 
  RowBox[{"First", "[", 
   RowBox[{"UnitCyclicQuadrilateralConcyclicInfo", "[", 
    RowBox[{"angles", ",", "side", ",", "is"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.628532070594436*^9, 3.628532097522998*^9}, {
   3.628553940439808*^9, 3.628553965251954*^9}, 3.628554210614696*^9, {
   3.630107445651648*^9, 3.630107446668023*^9}, {3.632079737359877*^9, 
   3.632079746751219*^9}},
 CellLabel->
  "In[372]:=",ExpressionUUID->"d36cd739-86f2-4319-a3b6-4db89002060c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitCyclicPolygonConcyclicInfo[",
 StyleBox["angles, side, is",
  FontSlant->"Italic"],
 "]\n",
 "UnitCyclicPolygonVertices",
 "[",
 StyleBox["angles, side, is",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.628532220130005*^9, 3.628532236400595*^9}, {
  3.628532327330812*^9, 3.628532334890388*^9}, {3.628547701080092*^9, 
  3.628547711959373*^9}, {3.628551679369019*^9, 3.628551682769169*^9}, {
  3.628553988517706*^9, 
  3.628554011781561*^9}},ExpressionUUID->"f9f95f7e-f208-4524-b7d6-\
2b10d279b283"],

Cell[TextData[{
 "UnitCyclicPolygonConcyclicInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side",
  FontSlant->"Italic"],
 ", ",
 StyleBox["is",
  FontSlant->"Italic"],
 "] returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 "} of a unit cyclic polygon with corner angles ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " where ",
 StyleBox["verts",
  FontSlant->"Italic"],
 " is a list of its vertices, ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 " is the circumcenter, and ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is the circumradius. If the polygon has an odd number of corner angles, \
there is a unique polygon and the additional arguments ",
 StyleBox["side",
  FontSlant->"Italic"],
 " and ",
 StyleBox["is",
  FontSlant->"Italic"],
 " are ignored. If it has an even number of corner angles, then there is a \
one-parameter famly of solutions and we return the one where the ",
 StyleBox["is",
  FontSlant->"Italic"],
 "th side has length ",
 StyleBox["side",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.628532239786114*^9, 3.628532319171974*^9}, {
   3.62853236035349*^9, 3.628532385239393*^9}, {3.628532419542778*^9, 
   3.628532446131695*^9}, {3.62854771475928*^9, 3.628547924361651*^9}, {
   3.628551686193426*^9, 3.628551697480371*^9}, 3.6285539886822577`*^9, {
   3.628554229277958*^9, 3.628554229637869*^9}, {3.631995476924802*^9, 
   3.6319954903543577`*^9}},ExpressionUUID->"85a7433e-ac4d-4bad-9585-\
0e50652e77eb"],

Cell[TextData[{
 "As with ConcyclicCenterAngles (above), the last angle or last two angles \
will be ignored and replaced with values that satisfy sum of angles = (",
 StyleBox["n",
  FontSlant->"Italic"],
 "-2)\[Pi] (all polygons) and alternating-sum of angles = 0 (only for even \
numbers of angles)."
}], "Text",
 CellChangeTimes->{{3.628547929441451*^9, 3.628547969376927*^9}, {
  3.628548102655203*^9, 
  3.628548133388424*^9}},ExpressionUUID->"c79546b8-54d4-454f-826f-\
a38b1f2e3e58"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicPolygonConcyclicInfo", "[", 
   RowBox[{"angles_List", ",", 
    RowBox[{"side_", ":", "1"}], ",", 
    RowBox[{"is_", ":", "2"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "n", ",", "a", ",", "\[Zeta]", ",", "c", ",", "r", ",", "\[Phi]", ",", 
      "v"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"Length", "[", "angles", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"a", "=", 
      RowBox[{
       RowBox[{"ConcyclicCenterAngles", "[", "angles", "]"}], "+", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"EvenQ", "[", "n", "]"}], ",", " ", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"i", "-", "1"}]], "\[Zeta]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ",", "0"}], "]"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"Cot", "[", 
          RowBox[{
           RowBox[{
           "a", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "/", 
           "2"}], "]"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"Csc", "[", 
        RowBox[{
         RowBox[{"a", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         "/", "2"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"Drop", "[", 
       RowBox[{
        RowBox[{"FoldList", "[", 
         RowBox[{"Plus", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[Pi]"}], "/", "2"}], "-", 
           RowBox[{
            RowBox[{
            "a", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "/", 
            "2"}]}], ",", "a"}], "]"}], ",", 
        RowBox[{"-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"v", "=", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"c", "+", 
           RowBox[{"r", " ", 
            RowBox[{"U", "[", 
             RowBox[{
             "\[Phi]", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
              "]"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "3", ",", "n"}], "}"}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "n", "]"}], ",", 
       RowBox[{"\[Zeta]", "=", 
        RowBox[{"\[Zeta]", "/.", 
         RowBox[{"FindRoot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mag2", "[", 
             RowBox[{
              RowBox[{"v", "\[LeftDoubleBracket]", 
               RowBox[{"Mod", "[", 
                RowBox[{
                 RowBox[{"is", "+", "1"}], ",", "n", ",", "1"}], "]"}], 
               "\[RightDoubleBracket]"}], "-", 
              RowBox[{
              "v", "\[LeftDoubleBracket]", "is", "\[RightDoubleBracket]"}]}], 
             "]"}], "\[Equal]", 
            SuperscriptBox["side", "2"]}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Zeta]", ",", "0"}], "}"}]}], "]"}]}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"v", ",", "c", ",", "r"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.628532447797826*^9, 3.628532462125372*^9}, {
   3.628532496051182*^9, 3.6285326879352694`*^9}, {3.62853277761937*^9, 
   3.628532785987939*^9}, {3.628548066975546*^9, 3.6285480919809093`*^9}, {
   3.628548154265709*^9, 3.628548185895803*^9}, {3.628548216284097*^9, 
   3.628548236419919*^9}, {3.628548283375059*^9, 3.628548329247171*^9}, {
   3.6285483960112677`*^9, 3.628548524426506*^9}, {3.628548620606806*^9, 
   3.628548691129914*^9}, {3.628551199339167*^9, 3.628551218391181*^9}, {
   3.628551273484616*^9, 3.628551327403805*^9}, {3.62855136464879*^9, 
   3.628551483588738*^9}, {3.62855170474701*^9, 3.628551710936174*^9}, 
   3.628551750566502*^9, {3.628551792409609*^9, 3.628551861870737*^9}, {
   3.628551893916933*^9, 3.628551902460476*^9}, {3.62855193748102*^9, 
   3.628551954632756*^9}, {3.628552411067176*^9, 3.628552440857504*^9}, {
   3.628553065241698*^9, 3.628553118975357*^9}, {3.628553209487917*^9, 
   3.628553228435988*^9}, 3.628553988709415*^9},
 CellLabel->
  "In[373]:=",ExpressionUUID->"18871213-829a-4275-8711-c596a587d382"],

Cell["Example: a triangle.", "Text",
 CellChangeTimes->{{3.628548531475465*^9, 
  3.628548534290163*^9}},ExpressionUUID->"ad10861b-8294-4827-b271-\
935f48393b42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "angles", ",", "verts", ",", "ctr", ",", "r", ",", "fooverts", ",", 
      "fooctr", ",", "foorad"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"40", "\[Degree]"}], ",", 
        RowBox[{"60", "\[Degree]"}], ",", 
        RowBox[{"80", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"fooverts", ",", "fooctr", ",", "foorad"}], "}"}], "=", 
      RowBox[{"UnitTriangleConcyclicInfo", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Input angles)/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{"angles", "/", "\[Degree]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"verts", ",", "ctr", ",", "r"}], "}"}], "=", 
      RowBox[{"UnitCyclicPolygonConcyclicInfo", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Corner angles/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"PolygonAngles", "[", "verts", "]"}], "/", "\[Degree]"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"Append", "[", 
           RowBox[{"verts", ",", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
            "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", "ctr", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Circle", "[", 
          RowBox[{"ctr", ",", "r"}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628524302124075*^9, 3.628524344827406*^9}, {
   3.62852606089177*^9, 3.628526131089645*^9}, {3.628526175044786*^9, 
   3.628526221611435*^9}, {3.628526257527814*^9, 3.628526259256768*^9}, {
   3.628526775929332*^9, 3.628526787334109*^9}, {3.628526944981365*^9, 
   3.628526946692108*^9}, 3.628527498960134*^9, {3.628527895008259*^9, 
   3.628527896518166*^9}, {3.628528078298472*^9, 3.628528112215905*^9}, {
   3.6285284994345827`*^9, 3.6285285247982597`*^9}, {3.628528906741399*^9, 
   3.628528939595236*^9}, {3.628528999663331*^9, 3.628529000049116*^9}, {
   3.628529203141498*^9, 3.628529252431917*^9}, {3.628529462690101*^9, 
   3.628529468376111*^9}, {3.628531770630842*^9, 3.628531810395034*^9}, {
   3.628531868326908*^9, 3.628531930451366*^9}, {3.628532705800444*^9, 
   3.628532761789624*^9}, {3.628532793002687*^9, 3.628532848198019*^9}, {
   3.628548543711683*^9, 3.628548582565814*^9}, 3.628548748187559*^9, {
   3.628551003538828*^9, 3.628551087854043*^9}, 3.628552199692766*^9, 
   3.628553988729531*^9},
 CellLabel->
  "In[374]:=",ExpressionUUID->"930f01e8-9540-4e34-9612-f10baa500dd6"],

Cell["Example: a quadrilateral.", "Text",
 CellChangeTimes->{{3.628532695973247*^9, 3.628532696715478*^9}, {
  3.628532873263964*^9, 
  3.628532876335999*^9}},ExpressionUUID->"681b871e-104a-418f-b81b-\
ad6d525db7de"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "verts", ",", "ctr", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"100", "\[Degree]"}], ",", 
        RowBox[{"80", "\[Degree]"}], ",", "0", ",", "0"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Input angles)/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{"angles", "/", "\[Degree]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"verts", ",", "ctr", ",", "r"}], "}"}], "=", 
      RowBox[{"UnitCyclicPolygonConcyclicInfo", "[", 
       RowBox[{"angles", ",", "1", ",", "2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Corner angles/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"PolygonAngles", "[", "verts", "]"}], "/", "\[Degree]"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"Append", "[", 
           RowBox[{"verts", ",", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
            "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", "ctr", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Circle", "[", 
          RowBox[{"ctr", ",", "r"}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628524302124075*^9, 3.628524344827406*^9}, {
   3.62852606089177*^9, 3.628526131089645*^9}, {3.628526175044786*^9, 
   3.628526221611435*^9}, {3.628526257527814*^9, 3.628526259256768*^9}, {
   3.628526775929332*^9, 3.628526787334109*^9}, {3.628526944981365*^9, 
   3.628526946692108*^9}, 3.628527498960134*^9, {3.628527895008259*^9, 
   3.628527896518166*^9}, {3.628528078298472*^9, 3.628528112215905*^9}, {
   3.6285284994345827`*^9, 3.6285285247982597`*^9}, {3.628528906741399*^9, 
   3.628528939595236*^9}, {3.628528999663331*^9, 3.628529000049116*^9}, {
   3.628529203141498*^9, 3.628529252431917*^9}, {3.628529462690101*^9, 
   3.628529468376111*^9}, {3.628531770630842*^9, 3.628531810395034*^9}, {
   3.628531868326908*^9, 3.628531930451366*^9}, {3.628532705800444*^9, 
   3.628532761789624*^9}, {3.628532793002687*^9, 3.628532848198019*^9}, {
   3.628551525320117*^9, 3.628551554921239*^9}, 3.628552346460915*^9, {
   3.62855314657657*^9, 3.628553177861005*^9}, 3.628553988743785*^9, {
   3.630107293334944*^9, 3.630107299188005*^9}, {3.630107339176488*^9, 
   3.630107343082529*^9}},
 CellLabel->
  "In[375]:=",ExpressionUUID->"82ea5874-cde3-4b14-a6c3-1a114517efcd"],

Cell["Example: a pentagon.", "Text",
 CellChangeTimes->{{3.628532695973247*^9, 3.628532696715478*^9}, {
  3.628532873263964*^9, 
  3.628532884111011*^9}},ExpressionUUID->"c34da030-3461-41e0-90c6-\
a628ea0e75bf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "verts", ",", "ctr", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"98", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"118", "\[Degree]"}], ",", 
        RowBox[{"128", "\[Degree]"}], ",", "0"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Input angles)/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{"angles", "/", "\[Degree]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"verts", ",", "ctr", ",", "r"}], "}"}], "=", 
      RowBox[{"UnitCyclicPolygonConcyclicInfo", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Corner angles/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"PolygonAngles", "[", "verts", "]"}], "/", "\[Degree]"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"Append", "[", 
           RowBox[{"verts", ",", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
            "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", "ctr", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Circle", "[", 
          RowBox[{"ctr", ",", "r"}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628524302124075*^9, 3.628524344827406*^9}, {
   3.62852606089177*^9, 3.628526131089645*^9}, {3.628526175044786*^9, 
   3.628526221611435*^9}, {3.628526257527814*^9, 3.628526259256768*^9}, {
   3.628526775929332*^9, 3.628526787334109*^9}, {3.628526944981365*^9, 
   3.628526946692108*^9}, 3.628527498960134*^9, {3.628527895008259*^9, 
   3.628527896518166*^9}, {3.628528078298472*^9, 3.628528112215905*^9}, {
   3.6285284994345827`*^9, 3.6285285247982597`*^9}, {3.628528906741399*^9, 
   3.628528939595236*^9}, {3.628528999663331*^9, 3.628529000049116*^9}, {
   3.628529203141498*^9, 3.628529252431917*^9}, {3.628529462690101*^9, 
   3.628529468376111*^9}, {3.628531770630842*^9, 3.628531810395034*^9}, {
   3.628531868326908*^9, 3.628531930451366*^9}, {3.628532705800444*^9, 
   3.628532761789624*^9}, {3.628532793002687*^9, 3.628532848198019*^9}, {
   3.628532887317194*^9, 3.628532915363517*^9}, {3.628533061332652*^9, 
   3.628533070807818*^9}, 3.628539699719264*^9, {3.628553248130475*^9, 
   3.628553283274732*^9}, 3.628553334355378*^9, 3.628553988758774*^9},
 CellLabel->
  "In[376]:=",ExpressionUUID->"13e620b1-5cc0-4f0d-b394-1b1b4efe0cf0"],

Cell["Example: a hexagon.", "Text",
 CellChangeTimes->{{3.628532695973247*^9, 3.628532696715478*^9}, {
  3.628532873263964*^9, 3.628532884111011*^9}, {3.6285340289601097`*^9, 
  3.62853402994934*^9}},ExpressionUUID->"d276aef6-c21c-4b06-9ad3-\
b0808bafd1da"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "verts", ",", "ctr", ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"110", "\[Degree]"}], ",", 
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"131", "\[Degree]"}], ",", 
        RowBox[{"135", "\[Degree]"}], ",", "0", ",", "0"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Input angles)/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{"angles", "/", "\[Degree]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"verts", ",", "ctr", ",", "r"}], "}"}], "=", 
      RowBox[{"UnitCyclicPolygonConcyclicInfo", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Corner angles/\[Degree] = \>\"", ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"PolygonAngles", "[", "verts", "]"}], "/", "\[Degree]"}], 
        "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"Append", "[", 
           RowBox[{"verts", ",", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
            "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", "ctr", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Circle", "[", 
          RowBox[{"ctr", ",", "r"}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628524302124075*^9, 3.628524344827406*^9}, {
   3.62852606089177*^9, 3.628526131089645*^9}, {3.628526175044786*^9, 
   3.628526221611435*^9}, {3.628526257527814*^9, 3.628526259256768*^9}, {
   3.628526775929332*^9, 3.628526787334109*^9}, {3.628526944981365*^9, 
   3.628526946692108*^9}, 3.628527498960134*^9, {3.628527895008259*^9, 
   3.628527896518166*^9}, {3.628528078298472*^9, 3.628528112215905*^9}, {
   3.6285284994345827`*^9, 3.6285285247982597`*^9}, {3.628528906741399*^9, 
   3.628528939595236*^9}, {3.628528999663331*^9, 3.628529000049116*^9}, {
   3.628529203141498*^9, 3.628529252431917*^9}, {3.628529462690101*^9, 
   3.628529468376111*^9}, {3.628531770630842*^9, 3.628531810395034*^9}, {
   3.628531868326908*^9, 3.628531930451366*^9}, {3.628532705800444*^9, 
   3.628532761789624*^9}, {3.628532793002687*^9, 3.628532848198019*^9}, {
   3.628532887317194*^9, 3.628532915363517*^9}, {3.628533061332652*^9, 
   3.628533070807818*^9}, {3.628534039643647*^9, 3.628534146477766*^9}, {
   3.62853451179991*^9, 3.628534585978403*^9}, {3.628534678690772*^9, 
   3.6285346791933002`*^9}, {3.628553651457026*^9, 3.62855370194954*^9}, 
   3.628553988775749*^9},
 CellLabel->
  "In[377]:=",ExpressionUUID->"1fd6ce7c-25a8-427c-9605-a725f0628107"],

Cell[TextData[{
 "UnitCyclicPolygonVertices[",
 StyleBox["angles, side, is",
  FontSlant->"Italic"],
 "] returns just the vertices."
}], "Text",
 CellChangeTimes->{{3.628694026507496*^9, 
  3.628694030873523*^9}},ExpressionUUID->"81aff7b8-2c52-4d7f-a460-\
4358ccb91b74"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicPolygonVertices", "[", 
   StyleBox[
    RowBox[{"angles_List", ",", " ", 
     RowBox[{"side_", ":", "1"}], ",", " ", 
     RowBox[{"is_", ":", "2"}]}],
    FontSlant->"Italic"], "]"}], ":=", 
  RowBox[{
   RowBox[{"UnitCyclicPolygonConcyclicInfo", "[", 
    RowBox[{"angles", ",", "side", ",", "is"}], "]"}], "\[LeftDoubleBracket]",
    "1", "\[RightDoubleBracket]"}]}]], "Input",
 CellChangeTimes->{{3.628694032190691*^9, 3.62869406372702*^9}},
 CellLabel->
  "In[378]:=",ExpressionUUID->"a4d867dd-43c3-4721-8c5c-cbcd39a3b921"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit Brocard polygons", "Subsection",
 CellChangeTimes->{{3.628708786530016*^9, 3.628708788718368*^9}, {
   3.628724592031744*^9, 3.628724596529708*^9}, 3.628724768398561*^9, {
   3.630106985853478*^9, 3.630106986354616*^9}, {3.631469315323782*^9, 
   3.6314693360850067`*^9}, 
   3.708400993405588*^9},ExpressionUUID->"9121fe13-0d31-44d1-b9f2-\
b04e65203ccb"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.628708791140559*^9, 
  3.62870879145677*^9}},ExpressionUUID->"6330a2fb-2cca-4a2e-8426-\
a3cc8bce9023"],

Cell["\<\
A Brocard polygon is a polygon possessing a single point such the the lines \
from the point to the vertices all make the same angle with the adjacent \
edge. In origami tessellations, a Brocard polygon presents a closed back when \
rendered as a simple twist. We construct the entire twist later, but we \
construct the polygon here with the other special polygons (like cyclic \
polygons).\
\>", "Text",
 CellChangeTimes->{{3.628708793916014*^9, 3.628708803700267*^9}, {
   3.628715341555712*^9, 3.628715359825634*^9}, {3.628723570371594*^9, 
   3.628723577154991*^9}, {3.628724619864238*^9, 3.628724668485308*^9}, {
   3.6291338560339212`*^9, 3.6291338839167852`*^9}, {3.631469348980605*^9, 
   3.631469407367979*^9}, 
   3.6314695265527678`*^9},ExpressionUUID->"ddb1c683-3940-473e-8c2b-\
eb8d14983289"],

Cell["\<\
The defining property of a closed-back twist polygon is, if you draw a line \
from each vertex rotated by the same angle relative to the edge, the lines \
all meet at a single point. This is only possible with certain polygons, and \
there is a pair of solutions for twist angles {\[Alpha], \
\[Pi]\[Dash]\[Alpha]}, that is unique.\
\>", "Text",
 CellChangeTimes->{{3.628724872618449*^9, 3.62872493048461*^9}, {
   3.62913390455493*^9, 3.629133990253706*^9}, 3.630108494140229*^9, {
   3.631469540958981*^9, 
   3.631469550857419*^9}},ExpressionUUID->"9c2bce67-6ee1-459f-9893-\
eb94917ce7fb"],

Cell["\<\
For triangles, symmetric trapezoids, and parallelograms, there is a nice \
analytic solution for all of the information, so we provide separate \
functions that give the analytic expressions, in addition to \
UnitBrocardPolygonInfo, which can find numerical solutions for other polygons.\
\>", "Text",
 CellChangeTimes->{{3.629135526067216*^9, 3.629135612781802*^9}, 
   3.6314696115715103`*^9, 3.6320806464767447`*^9, 
   3.632082199750993*^9},ExpressionUUID->"0220ad53-dfe6-4d9e-ab98-\
577ab5aa86de"],

Cell["\<\
In Brocard triangles, there is the first or positive Brocard point, which \
involves rotation of each edge around its CW-most vertex in the CCW \
direction, and the second or negative Brocard point, which involves rotation \
of each edge around its CCW-most vertex in the CW direction. For consistency \
with the twists that come later, we\[CloseCurlyQuote]ll characterize Brocard \
points and angles by their corresponding twist angles and directions.\
\>", "Text",
 CellChangeTimes->{{3.632085300209667*^9, 
  3.632085443743426*^9}},ExpressionUUID->"be54af83-9118-498e-9ce0-\
9040663da718"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitBrocardPolygonInfoCCW[",
 StyleBox["angles, opts",
  FontSlant->"Italic"],
 "]\n\t(options) BrocardAngle\nUnitBrocardPolygonInfoCW[",
 StyleBox["angles, opts",
  FontSlant->"Italic"],
 "]\n\t(options) ",
 "BrocardAngle"
}], "Subsubsection",
 CellChangeTimes->{{3.629126984994575*^9, 3.629127017371623*^9}, {
  3.629131217840062*^9, 3.629131225394079*^9}, {3.631469613140429*^9, 
  3.63146961423947*^9}, {3.631470124612782*^9, 
  3.631470125598773*^9}},ExpressionUUID->"a2af7435-de4f-445e-9fd9-\
b1e6eebab763"],

Cell[TextData[{
 "UnitBrocardPolygonInfoCCW[",
 StyleBox["angles, opts",
  FontSlant->"Italic"],
 "] takes a list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " of corner angles and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the Brocard angle, Brocard point, and vertices of a unit \
polygon that forms a CCW (\[Alpha]\[Element](0,\[Pi]/2)) Brocard polygon with \
the specified corner angles. The ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " must complete a closed polygon, so the last value is ignored and the \
proper angle is used that closes the polygon. Options are:\n\tBrocardAngle \
\[Rule] \[Alpha] | Automatic. Provide \[Alpha] if you already know the \
Brocard angle \[Alpha] (e.g., analytically) and just want ",
 StyleBox["verts",
  FontSlant->"Italic"],
 " and ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ". If Automatic, the Brocard angle will be found numerically."
}], "Text",
 CellChangeTimes->{{3.6287088379956284`*^9, 3.628708846049489*^9}, {
   3.628708954154705*^9, 3.628709030886157*^9}, 3.628709061116088*^9, {
   3.6287091763657293`*^9, 3.628709180915981*^9}, {3.628709218564127*^9, 
   3.628709219483582*^9}, {3.628709276703737*^9, 3.628709287213367*^9}, {
   3.628709328778688*^9, 3.628709351129108*^9}, {3.628715089020627*^9, 
   3.628715138527026*^9}, {3.628722358562148*^9, 3.6287224066382732`*^9}, {
   3.628723680005795*^9, 3.62872369500455*^9}, {3.6291253335493917`*^9, 
   3.629125358547447*^9}, {3.629125399793298*^9, 3.629125422878981*^9}, {
   3.629125463501098*^9, 3.629125503273936*^9}, {3.629126477595301*^9, 
   3.629126483466712*^9}, {3.629127098476857*^9, 3.629127171422076*^9}, {
   3.6291275958063307`*^9, 3.629127607375794*^9}, {3.629129575770798*^9, 
   3.629129576466245*^9}, 3.6314696151996193`*^9, {3.631469940910707*^9, 
   3.631469944794274*^9}, 3.631470021380952*^9, 3.631470126733658*^9, {
   3.6314900589252667`*^9, 
   3.6314900610742607`*^9}},ExpressionUUID->"8ba0b5c8-e478-4b35-9f05-\
98f119fa15e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"BrocardAngle", "\[Rule]", "Automatic"}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.631470266916353*^9, 3.631470290612633*^9}, 
   3.6320806465062647`*^9, 3.632082199785443*^9},
 CellLabel->
  "In[379]:=",ExpressionUUID->"b51844f9-f518-48e6-81eb-e88589341a0d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitBrocardPolygonInfoCCW", "::", "badangle"}], 
   "=", "\"\<Brocard angle `1` must be in the range (0,\[Pi]/2).\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.629127743069021*^9, 3.629127765820044*^9}, 
   3.631469616342515*^9, 3.631896776119419*^9},
 CellLabel->
  "In[380]:=",ExpressionUUID->"a47b3dfe-a51b-402b-9763-3501e358f08e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitBrocardPolygonInfoCCW", "[", 
   RowBox[{"angles_List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "ta", ",", "n", ",", "\[Theta]", ",", "\[Alpha]", ",", "eqn", ",", 
      "soln", ",", "r1", ",", "ctr", ",", "r", ",", "\[Phi]", ",", "verts"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ta", "=", 
      RowBox[{
       RowBox[{"BrocardAngle", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"Length", "[", "angles", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"CompletePolygonAngles", "[", 
       RowBox[{"Take", "[", 
        RowBox[{"angles", ",", 
         RowBox[{
          RowBox[{"Length", "[", "angles", "]"}], "-", "1"}]}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ta", "===", "Automatic"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "numerically", " ", "solve", " ", "for", " ", "Brocard", " ", 
         "angle"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NumericQ", "[", "ta", "]"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ta", "\[LessEqual]", "0"}], "||", 
             RowBox[{"ta", "\[GreaterEqual]", 
              RowBox[{"\[Pi]", "/", "2"}]}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"UnitBrocardPolygonInfoCCW", "::", "badangle"}], ",", 
             "ta"}], "]"}], ";", 
           RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"eqn", "=", 
         RowBox[{
          RowBox[{"Times", "@@", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"#", "-", "\[Alpha]"}], "]"}], "&"}], "/@", 
             "\[Theta]"}], ")"}]}], "==", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Alpha]", "]"}], "n"]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"soln", "=", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eqn", ",", 
             RowBox[{"\[Alpha]", ">", "0"}], ",", 
             RowBox[{"\[Alpha]", "<", 
              RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}], ",", "\[Alpha]"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"\[Alpha]", "/.", 
          RowBox[{
          "soln", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Brocard", " ", "angle", " ", "provided"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"\[Alpha]", "=", "ta"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "now", " ", "construct", " ", "unit", " ", "polygon", " ", "vertices"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"r1", "=", 
      RowBox[{
       RowBox[{"Sin", "[", "\[Alpha]", "]"}], "/", 
       RowBox[{"Sin", "[", 
        RowBox[{
        "\[Theta]", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "radius", " ", "from", " ", "center", " ", "to", " ", "vertex", " ", 
       "1"}], " ", "*)"}], " ", "\[IndentingNewLine]", 
     RowBox[{"ctr", "=", 
      RowBox[{"r1", " ", 
       RowBox[{"U", "[", 
        RowBox[{
         RowBox[{
         "\[Theta]", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-",
          "\[Alpha]"}], "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"center", " ", "of", " ", "closure"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"Sin", "[", 
            RowBox[{"#2", "-", "\[Alpha]"}], "]"}], 
           RowBox[{"Sin", "[", "\[Alpha]", "]"}]], "#1"}], "&"}], ",", "r1", ",", 
        RowBox[{"Drop", "[", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"\[Phi]", "=", 
      RowBox[{"\[Pi]", "-", "\[Theta]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"exterior", " ", "angles"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"FoldList", "[", 
         RowBox[{"Plus", ",", 
          RowBox[{
           RowBox[{
           "\[Theta]", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
            "-", "\[Alpha]", "-", "\[Pi]"}], ",", 
          RowBox[{"Drop", "[", 
           RowBox[{"\[Phi]", ",", 
            RowBox[{"-", "1"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"2", "\[Pi]"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"absolute", " ", "angles", " ", "to", " ", "vertices"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"verts", "=", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ctr", "+", 
          RowBox[{"#1", " ", 
           RowBox[{"U", "[", "#2", "]"}]}]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "\[Phi]"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"set", " ", "these", " ", "to", " ", "exact", " ", "values"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "ctr", ",", "\[Alpha]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.628708816345845*^9, 3.628708835492923*^9}, {
   3.628709160541443*^9, 3.6287091638902693`*^9}, {3.628709204795407*^9, 
   3.628709234020037*^9}, {3.628709273417184*^9, 3.628709273921464*^9}, {
   3.628709319416746*^9, 3.62870932577393*^9}, {3.628709447832203*^9, 
   3.628709465345669*^9}, {3.628709514221389*^9, 3.628709576869463*^9}, {
   3.6287097131383657`*^9, 3.628709769880481*^9}, {3.628709804572503*^9, 
   3.628709852393659*^9}, {3.628709891653336*^9, 3.6287099027748203`*^9}, {
   3.628709932899091*^9, 3.62870995850682*^9}, {3.628710020819927*^9, 
   3.628710032010418*^9}, {3.628710063715657*^9, 3.628710131614708*^9}, {
   3.628710179971681*^9, 3.62871019049631*^9}, {3.628712642937174*^9, 
   3.628712645853415*^9}, {3.628712703922367*^9, 3.628712792530401*^9}, {
   3.628712849944893*^9, 3.628712893119423*^9}, {3.628712934041681*^9, 
   3.628713067690381*^9}, {3.628713142267136*^9, 3.628713147191361*^9}, {
   3.628713181781657*^9, 3.628713217440946*^9}, {3.628713251282144*^9, 
   3.628713254601749*^9}, {3.628713301269215*^9, 3.628713302949057*^9}, {
   3.628713353440713*^9, 3.628713423060266*^9}, {3.628713479132697*^9, 
   3.628713509300708*^9}, {3.628713555082861*^9, 3.628713667944075*^9}, {
   3.628713756538418*^9, 3.62871379689666*^9}, {3.62871383648772*^9, 
   3.628713885137988*^9}, {3.62871393824598*^9, 3.628714090126793*^9}, {
   3.62871437311418*^9, 3.628714447068716*^9}, {3.628714617683454*^9, 
   3.628714619620532*^9}, {3.628715021377349*^9, 3.628715068754921*^9}, {
   3.628715115650135*^9, 3.628715116194734*^9}, {3.628715162320231*^9, 
   3.628715217504949*^9}, {3.628716580285355*^9, 3.628716593378734*^9}, {
   3.62871665686314*^9, 3.6287167234272146`*^9}, 3.628716764265696*^9, {
   3.62872246479725*^9, 3.628722516384163*^9}, {3.628722772416951*^9, 
   3.628722926408881*^9}, {3.628722994743903*^9, 3.628723004468553*^9}, {
   3.628723068463578*^9, 3.628723078167588*^9}, {3.628723168244656*^9, 
   3.628723173391054*^9}, {3.628780854536687*^9, 3.628780857946508*^9}, {
   3.628787411228211*^9, 3.62878742233486*^9}, {3.628787458312497*^9, 
   3.628787517859686*^9}, {3.628787549731936*^9, 3.628787565396194*^9}, {
   3.629125523038624*^9, 3.629125537389721*^9}, {3.629125578548219*^9, 
   3.629125597574132*^9}, 3.629125645797899*^9, {3.629125834398975*^9, 
   3.629126120336611*^9}, {3.629127192791521*^9, 3.629127197532808*^9}, {
   3.629127241738616*^9, 3.629127281273509*^9}, {3.629127648820424*^9, 
   3.62912764898507*^9}, {3.629127780226843*^9, 3.629127812239272*^9}, {
   3.631469617592435*^9, 3.631469620080764*^9}, {3.631469946624372*^9, 
   3.6314699483801394`*^9}, 3.631470129600041*^9, 3.632080646557384*^9, 
   3.632082199836226*^9, {3.632148769450836*^9, 3.632148783021148*^9}},
 CellLabel->
  "In[381]:=",ExpressionUUID->"2469738d-84ae-45aa-99b0-bde57b7f420e"],

Cell["Example. A general quadrilateral.", "Text",
 CellChangeTimes->{{3.62912782113406*^9, 3.6291278222766533`*^9}, {
  3.629127884354539*^9, 
  3.62912788837593*^9}},ExpressionUUID->"73d41faa-d719-460e-8a01-\
ecedd8927445"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "info", ",", "gfn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"100", "\[Degree]"}], ",", 
        RowBox[{"85", "\[Degree]"}], ",", 
        RowBox[{"55", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info", "=", 
      RowBox[{"UnitBrocardPolygonInfoCCW", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"Append", "[", 
             RowBox[{
              RowBox[{
              "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
              ",", 
              RowBox[{"info", "\[LeftDoubleBracket]", 
               RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
            "]"}], ",", "Black"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"#", ",", 
                RowBox[{
                "info", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
            RowBox[{
            "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
           ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", 
            RowBox[{
            "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
            "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", " ", 
        RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{
           "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
            "\[Degree]"}], "]"}]}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723872668528*^9, 3.628723873789907*^9}, {
   3.628724937122777*^9, 3.628724977311921*^9}, {3.628780682236887*^9, 
   3.628780695018487*^9}, 3.629126168297758*^9, {3.629127856273221*^9, 
   3.629127878998567*^9}, 3.631469621770234*^9, 3.631896777504961*^9},
 CellLabel->
  "In[382]:=",ExpressionUUID->"973b42b6-ab52-4836-bfe9-f4ade73f4311"],

Cell[TextData[{
 "UnitBrocardPolygonInfoCW[",
 StyleBox["angles, opts",
  FontSlant->"Italic"],
 "] takes a list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " of corner angles and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the Brocard angle, Brocard point, and vertices of a unit \
polygon that forms a CW (\[Alpha]\[Element](\[Pi]/2,\[Pi])) closed-back twist \
with the specified corner angles. The ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " must complete a closed polygon, so the last value is ignored and the \
proper angle is used that closes the polygon. Options are:\n\t",
 "BrocardAngle",
 " \[Rule] \[Alpha] | Automatic. Provide \[Alpha] if you already know the \
Brocard angle \[Alpha] (e.g., analytically) and just want ",
 StyleBox["verts",
  FontSlant->"Italic"],
 " and ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ". If Automatic, the Brocard angle will be found numerically."
}], "Text",
 CellChangeTimes->{{3.6287088379956284`*^9, 3.628708846049489*^9}, {
   3.628708954154705*^9, 3.628709030886157*^9}, 3.628709061116088*^9, {
   3.6287091763657293`*^9, 3.628709180915981*^9}, {3.628709218564127*^9, 
   3.628709219483582*^9}, {3.628709276703737*^9, 3.628709287213367*^9}, {
   3.628709328778688*^9, 3.628709351129108*^9}, {3.628715089020627*^9, 
   3.628715138527026*^9}, {3.628722358562148*^9, 3.6287224066382732`*^9}, {
   3.628723680005795*^9, 3.62872369500455*^9}, {3.6291253335493917`*^9, 
   3.629125358547447*^9}, {3.629125399793298*^9, 3.629125422878981*^9}, {
   3.629125463501098*^9, 3.629125503273936*^9}, {3.629126477595301*^9, 
   3.629126483466712*^9}, {3.629127098476857*^9, 3.629127171422076*^9}, {
   3.6291275958063307`*^9, 3.629127634695818*^9}, {3.629129583282273*^9, 
   3.629129583961873*^9}, 3.631469623646127*^9, {3.631469951873456*^9, 
   3.631469955241633*^9}, 3.63147002290633*^9, 
   3.631470132044208*^9},ExpressionUUID->"42b8e575-bc87-4231-8187-\
3a48a8489029"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitBrocardPolygonInfoCW", "::", "badangle"}], 
   "=", "\"\<Brocard angle `1` must be in the range (\[Pi]/2,\[Pi]).\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.629127743069021*^9, 3.629127765820044*^9}, {
   3.629128012219884*^9, 3.629128017305595*^9}, 3.631469624771672*^9, 
   3.6318967789424*^9},
 CellLabel->
  "In[383]:=",ExpressionUUID->"db371961-fb33-4bb4-b5df-0769cec52f7e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitBrocardPolygonInfoCW", "[", 
   RowBox[{"angles_List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "ta", ",", "n", ",", "\[Theta]", ",", "\[Alpha]", ",", "eqn", ",", 
      "soln", ",", "r1", ",", "ctr", ",", "r", ",", "\[Phi]", ",", "verts"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ta", "=", 
      RowBox[{
       RowBox[{"BrocardAngle", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"Length", "[", "angles", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"CompletePolygonAngles", "[", 
       RowBox[{"Take", "[", 
        RowBox[{"angles", ",", 
         RowBox[{
          RowBox[{"Length", "[", "angles", "]"}], "-", "1"}]}], "]"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ta", "===", "Automatic"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "numerically", " ", "solve", " ", "for", " ", "Brocard", " ", 
         "angle"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NumericQ", "[", "ta", "]"}], "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"ta", "\[LessEqual]", 
              RowBox[{"\[Pi]", "/", "2"}]}], "||", 
             RowBox[{"ta", "\[GreaterEqual]", "\[Pi]"}]}], ")"}]}], ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"UnitBrocardPolygonInfoCW", "::", "badangle"}], ",", 
             "ta"}], "]"}], ";", 
           RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"eqn", "=", 
         RowBox[{
          RowBox[{"Times", "@@", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"#", "-", 
                RowBox[{"(", 
                 RowBox[{"\[Pi]", "-", "\[Alpha]"}], ")"}]}], "]"}], "&"}], "/@",
              "\[Theta]"}], ")"}]}], "==", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Alpha]", "]"}], "n"]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"soln", "=", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eqn", ",", 
             RowBox[{"\[Alpha]", ">", 
              RowBox[{"\[Pi]", "/", "2"}]}], ",", 
             RowBox[{"\[Alpha]", "<", "\[Pi]"}]}], "}"}], ",", "\[Alpha]"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"\[Alpha]", "/.", 
          RowBox[{
          "soln", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Brocard", " ", "angle", " ", "provided"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"\[Alpha]", "=", "ta"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "now", " ", "construct", " ", "unit", " ", "polygon", " ", "vertices"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"r1", "=", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{
         "\[Theta]", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "-", 
         RowBox[{"(", 
          RowBox[{"\[Pi]", "-", "\[Alpha]"}], ")"}]}], "]"}], "/", 
       RowBox[{"Sin", "[", 
        RowBox[{
        "\[Theta]", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "radius", " ", "from", " ", "center", " ", "to", " ", "vertex", " ", 
       "1"}], " ", "*)"}], " ", "\[IndentingNewLine]", 
     RowBox[{"ctr", "=", 
      RowBox[{"r1", " ", 
       RowBox[{"U", "[", 
        RowBox[{"\[Pi]", "-", "\[Alpha]"}], "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"center", " ", "of", " ", "closure"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"Sin", "[", 
            RowBox[{"\[Pi]", "-", "\[Alpha]"}], "]"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"#2", "-", 
             RowBox[{"(", 
              RowBox[{"\[Pi]", "-", "\[Alpha]"}], ")"}]}], "]"}]], "#1"}], 
         "&"}], ",", "r1", ",", 
        RowBox[{"Drop", "[", 
         RowBox[{"\[Theta]", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"\[Pi]", "-", 
       RowBox[{"RotateLeft", "[", "\[Theta]", "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"interior", " ", "angles"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"FoldList", "[", 
         RowBox[{"Plus", ",", 
          RowBox[{"-", "\[Alpha]"}], ",", 
          RowBox[{"Drop", "[", 
           RowBox[{"\[Phi]", ",", 
            RowBox[{"-", "1"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"2", "\[Pi]"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"absolute", " ", "angles", " ", "to", " ", "vertices"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"verts", "=", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ctr", "+", 
          RowBox[{"#1", " ", 
           RowBox[{"U", "[", "#2", "]"}]}]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"r", ",", "\[Phi]"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"set", " ", "these", " ", "to", " ", "exact", " ", "values"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "ctr", ",", "\[Alpha]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.628708816345845*^9, 3.628708835492923*^9}, {
   3.628709160541443*^9, 3.6287091638902693`*^9}, {3.628709204795407*^9, 
   3.628709234020037*^9}, {3.628709273417184*^9, 3.628709273921464*^9}, {
   3.628709319416746*^9, 3.62870932577393*^9}, {3.628709447832203*^9, 
   3.628709465345669*^9}, {3.628709514221389*^9, 3.628709576869463*^9}, {
   3.6287097131383657`*^9, 3.628709769880481*^9}, {3.628709804572503*^9, 
   3.628709852393659*^9}, {3.628709891653336*^9, 3.6287099027748203`*^9}, {
   3.628709932899091*^9, 3.62870995850682*^9}, {3.628710020819927*^9, 
   3.628710032010418*^9}, {3.628710063715657*^9, 3.628710131614708*^9}, {
   3.628710179971681*^9, 3.62871019049631*^9}, {3.628712642937174*^9, 
   3.628712645853415*^9}, {3.628712703922367*^9, 3.628712792530401*^9}, {
   3.628712849944893*^9, 3.628712893119423*^9}, {3.628712934041681*^9, 
   3.628713067690381*^9}, {3.628713142267136*^9, 3.628713147191361*^9}, {
   3.628713181781657*^9, 3.628713217440946*^9}, {3.628713251282144*^9, 
   3.628713254601749*^9}, {3.628713301269215*^9, 3.628713302949057*^9}, {
   3.628713353440713*^9, 3.628713423060266*^9}, {3.628713479132697*^9, 
   3.628713509300708*^9}, {3.628713555082861*^9, 3.628713667944075*^9}, {
   3.628713756538418*^9, 3.62871379689666*^9}, {3.62871383648772*^9, 
   3.628713885137988*^9}, {3.62871393824598*^9, 3.628714090126793*^9}, {
   3.62871437311418*^9, 3.628714447068716*^9}, {3.628714617683454*^9, 
   3.628714619620532*^9}, {3.628715021377349*^9, 3.628715068754921*^9}, {
   3.628715115650135*^9, 3.628715116194734*^9}, {3.628715162320231*^9, 
   3.628715217504949*^9}, {3.628716580285355*^9, 3.628716593378734*^9}, {
   3.62871665686314*^9, 3.6287167234272146`*^9}, 3.628716764265696*^9, {
   3.62872246479725*^9, 3.628722516384163*^9}, {3.628722772416951*^9, 
   3.628722926408881*^9}, {3.628722994743903*^9, 3.628723004468553*^9}, {
   3.628723068463578*^9, 3.628723078167588*^9}, {3.628723168244656*^9, 
   3.628723173391054*^9}, {3.628780854536687*^9, 3.628780857946508*^9}, {
   3.628787411228211*^9, 3.62878742233486*^9}, {3.628787458312497*^9, 
   3.628787517859686*^9}, {3.628787549731936*^9, 3.628787565396194*^9}, {
   3.629125523038624*^9, 3.629125537389721*^9}, {3.629125578548219*^9, 
   3.629125597574132*^9}, 3.629125645797899*^9, {3.629125834398975*^9, 
   3.629126120336611*^9}, {3.629127192791521*^9, 3.629127197532808*^9}, {
   3.629127241738616*^9, 3.629127281273509*^9}, {3.629127653264915*^9, 
   3.629127654058399*^9}, {3.629127686467255*^9, 3.629127697248959*^9}, {
   3.629128030611349*^9, 3.629128043232985*^9}, {3.629128384756336*^9, 
   3.629128466100709*^9}, {3.629128597160692*^9, 3.629128601623558*^9}, {
   3.629128640570108*^9, 3.629128642569659*^9}, {3.629128746152009*^9, 
   3.629128753866586*^9}, {3.629128791701033*^9, 3.629128798520392*^9}, {
   3.6291293379687643`*^9, 3.629129349751587*^9}, {3.631469625690909*^9, 
   3.631469628775723*^9}, {3.6314699567960253`*^9, 3.631469958158328*^9}, 
   3.631470133133233*^9, 3.632080646607325*^9, 3.632082199887746*^9},
 CellLabel->
  "In[384]:=",ExpressionUUID->"98bca25b-e9da-4c82-b09a-407726a040bb"],

Cell["Example. A general quadrilateral.", "Text",
 CellChangeTimes->{{3.62912782113406*^9, 3.6291278222766533`*^9}, {
  3.629127884354539*^9, 
  3.62912788837593*^9}},ExpressionUUID->"0ccf89da-cbe1-4985-bbc0-\
08024516e673"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "info", ",", "gfn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"100", "\[Degree]"}], ",", 
        RowBox[{"85", "\[Degree]"}], ",", 
        RowBox[{"55", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info", "=", 
      RowBox[{"UnitBrocardPolygonInfoCW", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"Append", "[", 
             RowBox[{
              RowBox[{
              "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
              ",", 
              RowBox[{"info", "\[LeftDoubleBracket]", 
               RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
            "]"}], ",", "Black"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"#", ",", 
                RowBox[{
                "info", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
            RowBox[{
            "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
           ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", 
            RowBox[{
            "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
            "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", " ", 
        RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{
           "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
            "\[Degree]"}], "]"}]}]}]}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723872668528*^9, 3.628723873789907*^9}, {
   3.628724937122777*^9, 3.628724977311921*^9}, {3.628780682236887*^9, 
   3.628780695018487*^9}, 3.629126168297758*^9, {3.629127856273221*^9, 
   3.629127878998567*^9}, 3.629128668716285*^9, 3.6314696314947577`*^9, 
   3.631896780008165*^9},
 CellLabel->
  "In[385]:=",ExpressionUUID->"bd648117-1c8c-48f6-83cf-c7c7dc1e1d52"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitBrocardPolygonInfo",
 "[",
 StyleBox["angles, opts",
  FontSlant->"Italic"],
 "]\n\t(options) BrocardAngle, TwistDirection"
}], "Subsubsection",
 CellChangeTimes->{{3.628715320611944*^9, 3.628715325195464*^9}, {
   3.6287218781302366`*^9, 3.628721878719617*^9}, {3.628724680236582*^9, 
   3.628724686612406*^9}, {3.629131241399889*^9, 3.629131242838709*^9}, 
   3.631469632843266*^9, 3.631470134628958*^9, 3.632080644888246*^9, 
   3.632082198698402*^9},ExpressionUUID->"add743c8-568f-4a21-a72a-\
0f43bd502052"],

Cell[TextData[{
 "UnitBrocardPolygonInfo",
 "[",
 StyleBox["angles, opts",
  FontSlant->"Italic"],
 "] takes a list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " of corner angles and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the Brocard angle, Brocard point, and vertices of a unit \
polygon that forms a closed-back twist with the specified corner angles. The ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " must complete a closed polygon, so the last value is ignored and the \
proper angle is used that closes the polygon. Options are:\n\tBrocardAngle \
\[Rule] \[Alpha] | Automatic. Automatic calculates the Brocard angle \
according to TwistDirection, otherwise use \[Alpha].\n\tTwistDirection \
\[Rule] CW | CCW. Specify the twist direction. If CCW, \[Alpha]\[Element](0,\
\[Pi]/2). If CW, \[Alpha]\[Element](\[Pi]/2, \[Pi])."
}], "Text",
 CellChangeTimes->{{3.6287088379956284`*^9, 3.628708846049489*^9}, {
   3.628708954154705*^9, 3.628709030886157*^9}, 3.628709061116088*^9, {
   3.6287091763657293`*^9, 3.628709180915981*^9}, {3.628709218564127*^9, 
   3.628709219483582*^9}, {3.628709276703737*^9, 3.628709287213367*^9}, {
   3.628709328778688*^9, 3.628709351129108*^9}, {3.628715089020627*^9, 
   3.628715138527026*^9}, {3.628722358562148*^9, 3.6287224066382732`*^9}, {
   3.628723680005795*^9, 3.62872369500455*^9}, {3.6291253335493917`*^9, 
   3.629125358547447*^9}, {3.629125399793298*^9, 3.629125422878981*^9}, {
   3.629125463501098*^9, 3.629125503273936*^9}, {3.629126477595301*^9, 
   3.629126483466712*^9}, {3.629129461212531*^9, 3.629129496184084*^9}, 
   3.631469634848036*^9, {3.631469960455212*^9, 3.631469961613707*^9}, 
   3.631470024121624*^9, 3.6314701376218023`*^9, 3.6320806451243353`*^9, 
   3.632082198815259*^9},ExpressionUUID->"a9ab37a9-ca32-4181-bc27-\
f095fdb7d1c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BrocardAngle", "::", "usage"}], 
   "=", "\"\<BrocardAngle is an option in twists that specifies the Brocard \
angle of the central polygon.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629125363896994*^9, 3.629125382188225*^9}, {
   3.629125445799841*^9, 3.6291254505114*^9}, 3.631469965259854*^9, {
   3.631470140135985*^9, 3.631470142122873*^9}},
 CellLabel->
  "In[386]:=",ExpressionUUID->"1933e542-ab43-4617-91be-009b5c8ac1a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TwistDirection", "::", "usage"}], 
   "=", "\"\<TwistDirection is an option in twists that specifies the \
direction of rotation of the central polygon in going from the crease pattern \
to the folded form.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.5922467444696503`*^9, 3.5922467852684383`*^9}, {
  3.628722734773632*^9, 3.628722754833795*^9}, {3.629125434265286*^9, 
  3.629125438701179*^9}},
 CellLabel->
  "In[387]:=",ExpressionUUID->"bb582210-863b-4652-944a-d13c9a7f038c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitBrocardPolygonInfo", "::", "inconst"}], 
   "=", "\"\<Specified Brocard angle `1` and twist direction `2` are \
inconsistent.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629129514425538*^9, 3.629129543765858*^9}, 
   3.631469636199602*^9, 3.631469970856598*^9, 3.632080645146772*^9, 
   3.632082198837536*^9},
 CellLabel->
  "In[388]:=",ExpressionUUID->"9e9e628d-de3c-467b-b4c8-b98d92c092d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitBrocardPolygonInfo", "::", "baddir"}], 
   "=", "\"\<Twist direction `1` must be CCW or CW.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629129514425538*^9, 3.629129543765858*^9}, {
   3.629129882178124*^9, 3.629129895704105*^9}, 3.629131640152631*^9, 
   3.631469638952745*^9, 3.632080645186163*^9, 3.632082198881264*^9},
 CellLabel->
  "In[389]:=",ExpressionUUID->"b210a77c-fbbe-41ca-b9cc-1f14bc1e6385"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"BrocardAngle", "\[Rule]", "Automatic"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.628722410331655*^9, 3.628722431262295*^9}, {
   3.629125508212479*^9, 3.629125515731236*^9}, 3.631469640366598*^9, 
   3.631470143929533*^9, 3.632080645236362*^9, 3.632082198931637*^9},
 CellLabel->
  "In[390]:=",ExpressionUUID->"a828c026-0e2b-46ca-a7b5-cf7ad177d74a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitBrocardPolygonInfo", "[", 
   RowBox[{"angles_List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "ta", ",", "td", ",", "n", ",", "\[Theta]", ",", "\[Alpha]", ",", "eqn", 
      ",", "soln", ",", "r1", ",", "ctr", ",", "r", ",", "\[Phi]", ",", 
      "verts"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ta", "=", 
      RowBox[{
       RowBox[{"BrocardAngle", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"td", "=", 
      RowBox[{
       RowBox[{"TwistDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"NumericQ", "[", "ta", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"td", "===", "CCW"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ta", "\[LessEqual]", "0"}], "||", 
              RowBox[{"ta", "\[GreaterEqual]", 
               RowBox[{"\[Pi]", "/", "2"}]}]}], ")"}]}], ")"}], "||", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"td", "===", "CW"}], "&&", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ta", "\[LessEqual]", 
               RowBox[{"\[Pi]", "/", "2"}]}], "||", 
              RowBox[{"ta", "\[GreaterEqual]", "\[Pi]"}]}], ")"}]}], ")"}]}], 
         ",", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"UnitBrocardPolygonInfo", "::", "inconst"}], ",", "ta", ",",
             "td"}], "]"}], ";", 
          RowBox[{"Abort", "[", "]"}]}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"td", ",", "\[IndentingNewLine]", "CCW", ",", 
       RowBox[{"UnitBrocardPolygonInfoCCW", "[", 
        RowBox[{"angles", ",", "opts"}], "]"}], ",", "\[IndentingNewLine]", 
       "CW", ",", 
       RowBox[{"UnitBrocardPolygonInfoCW", "[", 
        RowBox[{"angles", ",", "opts"}], "]"}], ",", "\[IndentingNewLine]", 
       "_", ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"UnitBrocardPolygonInfo", "::", "baddir"}], ",", "td"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.628708816345845*^9, 3.628708835492923*^9}, {
   3.628709160541443*^9, 3.6287091638902693`*^9}, {3.628709204795407*^9, 
   3.628709234020037*^9}, {3.628709273417184*^9, 3.628709273921464*^9}, {
   3.628709319416746*^9, 3.62870932577393*^9}, {3.628709447832203*^9, 
   3.628709465345669*^9}, {3.628709514221389*^9, 3.628709576869463*^9}, {
   3.6287097131383657`*^9, 3.628709769880481*^9}, {3.628709804572503*^9, 
   3.628709852393659*^9}, {3.628709891653336*^9, 3.6287099027748203`*^9}, {
   3.628709932899091*^9, 3.62870995850682*^9}, {3.628710020819927*^9, 
   3.628710032010418*^9}, {3.628710063715657*^9, 3.628710131614708*^9}, {
   3.628710179971681*^9, 3.62871019049631*^9}, {3.628712642937174*^9, 
   3.628712645853415*^9}, {3.628712703922367*^9, 3.628712792530401*^9}, {
   3.628712849944893*^9, 3.628712893119423*^9}, {3.628712934041681*^9, 
   3.628713067690381*^9}, {3.628713142267136*^9, 3.628713147191361*^9}, {
   3.628713181781657*^9, 3.628713217440946*^9}, {3.628713251282144*^9, 
   3.628713254601749*^9}, {3.628713301269215*^9, 3.628713302949057*^9}, {
   3.628713353440713*^9, 3.628713423060266*^9}, {3.628713479132697*^9, 
   3.628713509300708*^9}, {3.628713555082861*^9, 3.628713667944075*^9}, {
   3.628713756538418*^9, 3.62871379689666*^9}, {3.62871383648772*^9, 
   3.628713885137988*^9}, {3.62871393824598*^9, 3.628714090126793*^9}, {
   3.62871437311418*^9, 3.628714447068716*^9}, {3.628714617683454*^9, 
   3.628714619620532*^9}, {3.628715021377349*^9, 3.628715068754921*^9}, {
   3.628715115650135*^9, 3.628715116194734*^9}, {3.628715162320231*^9, 
   3.628715217504949*^9}, {3.628716580285355*^9, 3.628716593378734*^9}, {
   3.62871665686314*^9, 3.6287167234272146`*^9}, 3.628716764265696*^9, {
   3.62872246479725*^9, 3.628722516384163*^9}, {3.628722772416951*^9, 
   3.628722926408881*^9}, {3.628722994743903*^9, 3.628723004468553*^9}, {
   3.628723068463578*^9, 3.628723078167588*^9}, {3.628723168244656*^9, 
   3.628723173391054*^9}, {3.628780854536687*^9, 3.628780857946508*^9}, {
   3.628787411228211*^9, 3.62878742233486*^9}, {3.628787458312497*^9, 
   3.628787517859686*^9}, {3.628787549731936*^9, 3.628787565396194*^9}, {
   3.629125523038624*^9, 3.629125537389721*^9}, {3.629125578548219*^9, 
   3.629125597574132*^9}, 3.629125645797899*^9, {3.629125834398975*^9, 
   3.629126120336611*^9}, {3.629129643782848*^9, 3.62912986985632*^9}, {
   3.629129906942808*^9, 3.629129923530101*^9}, {3.631469641454467*^9, 
   3.631469647290293*^9}, 3.631470153374955*^9, {3.632080645287438*^9, 
   3.632080645455296*^9}, {3.6320821989839*^9, 3.632082199119351*^9}},
 CellLabel->
  "In[391]:=",ExpressionUUID->"b0b76a72-0570-4a7c-98c3-63cca736116e"],

Cell["\<\
Example. Shows CCW and CW closed-back twist polygons for the same angles \
differ even though the two Brocard angles are supplements of one another.\
\>", "Text",
 CellChangeTimes->{{3.628709237222815*^9, 3.628709237960051*^9}, {
   3.628723424503985*^9, 3.628723472673224*^9}, {3.628723505274597*^9, 
   3.628723516438743*^9}, {3.62872355653271*^9, 3.6287235588117247`*^9}, 
   3.6314699757269917`*^9},ExpressionUUID->"6289e07c-2ad8-4582-be6c-\
2a19135245d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "info1", ",", "info2", ",", "gfn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"100", "\[Degree]"}], ",", 
        RowBox[{"85", "\[Degree]"}], ",", 
        RowBox[{"55", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{
               "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                ",", 
               RowBox[{"info", "\[LeftDoubleBracket]", 
                RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
             "]"}], ",", "Black"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
            "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
             "\[Degree]"}], "]"}]}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723872668528*^9, 3.628723873789907*^9}, {
   3.628724937122777*^9, 3.628724977311921*^9}, {3.628780682236887*^9, 
   3.628780695018487*^9}, 3.629126168297758*^9, {3.631469648523541*^9, 
   3.631469649443441*^9}, 3.631896781025762*^9, {3.632080645505131*^9, 
   3.632080645538664*^9}, {3.632082199166482*^9, 3.632082199201756*^9}},
 CellLabel->
  "In[392]:=",ExpressionUUID->"6c6340ac-1020-4ddd-abbc-5613774ea11b"],

Cell["Example. Symmetric trapezoids.", "Text",
 CellChangeTimes->{{3.62872380927934*^9, 
  3.62872381887883*^9}},ExpressionUUID->"3a166754-4539-4001-bbc7-\
bff9f48f1c54"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "info1", ",", "info2", ",", "gfn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"60", "\[Degree]"}], ",", 
        RowBox[{"60", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{
               "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                ",", 
               RowBox[{"info", "\[LeftDoubleBracket]", 
                RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
             "]"}], ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
            "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
             "\[Degree]"}], "]"}]}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.631469650981761*^9, 3.6314696520512238`*^9}, 3.631896782028562*^9, {
   3.632080645588695*^9, 3.632080645621336*^9}, {3.632082199274738*^9, 
   3.632082199303446*^9}},
 CellLabel->
  "In[393]:=",ExpressionUUID->"e68b431f-736e-4945-a8fc-0440e4d78c01"],

Cell["\<\
Example. Parallelograms. Same Brocard angle as the trapezoids, since the \
Brocard angle doesn\[CloseCurlyQuote]t depend on the order of the angles.\
\>", "Text",
 CellChangeTimes->{{3.62872380927934*^9, 3.62872381887883*^9}, {
  3.629126733461069*^9, 3.629126752825465*^9}, {3.6314699789256687`*^9, 
  3.631469980185261*^9}},ExpressionUUID->"9e42e926-4aa7-48bb-b7fd-\
d3e388c4704d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "info1", ",", "info2", ",", "gfn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"60", "\[Degree]"}], ",", 
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"60", "\[Degree]"}], ",", 
        RowBox[{"120", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{
               "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                ",", 
               RowBox[{"info", "\[LeftDoubleBracket]", 
                RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
             "]"}], ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
            "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
             "\[Degree]"}], "]"}]}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.62912676183081*^9, 3.629126774029512*^9}, {3.631469653296767*^9, 
   3.631469654144627*^9}, 3.631896783011411*^9, {3.632080645672137*^9, 
   3.632080645705449*^9}, {3.632082199352896*^9, 3.632082199384989*^9}},
 CellLabel->
  "In[394]:=",ExpressionUUID->"07e82d91-ed31-41f3-9c1a-a64ca4602f5d"],

Cell["Example. A pentagon.", "Text",
 CellChangeTimes->{{3.62872380927934*^9, 3.62872381887883*^9}, {
  3.628725020152525*^9, 
  3.628725022686496*^9}},ExpressionUUID->"5c62a6b4-65ad-4324-985c-\
46785471bb9b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "info1", ",", "info2", ",", "gfn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"90", "\[Degree]"}], ",", 
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"100", "\[Degree]"}], ",", 
        RowBox[{"120", "\[Degree]"}], ",", 
        RowBox[{"110", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitBrocardPolygonInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{
               "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                ",", 
               RowBox[{"info", "\[LeftDoubleBracket]", 
                RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
             "]"}], ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
            "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
             "\[Degree]"}], "]"}]}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.6287251101186447`*^9, 3.628725130784902*^9}, {3.63146965537647*^9, 
   3.631469656182301*^9}, 3.631896783976205*^9, {3.632080645754722*^9, 
   3.632080645789147*^9}, {3.632082199435821*^9, 3.632082199469438*^9}},
 CellLabel->
  "In[395]:=",ExpressionUUID->"0c011cf5-e3e9-4584-b2ad-d3ebde964f1b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitBrocardTrapezoidInfo",
 "[\[Delta], ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) TwistDirection"
}], "Subsubsection",
 CellChangeTimes->{{3.629131196309608*^9, 3.629131213280423*^9}, {
   3.629131350294961*^9, 3.629131350488141*^9}, 3.631469730613653*^9, 
   3.632080658919284*^9, 
   3.632082210785426*^9},ExpressionUUID->"af01db10-4732-45b5-8871-\
c00b1527ae95"],

Cell[TextData[{
 "UnitBrocardTrapezoidInfo",
 "[\[Delta], ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]  takes the base angle \[Delta] of a trapezoid and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the Brocard angle, Brocard point, and vertices of a unit \
trapezoid that forms a closed-back twist with base angles of \[Delta] and top \
angles of \[Pi]-\[Delta]. Result is analytic in \[Delta]. Options are:\n\t\
TwistDirection \[Rule] CW | CCW. Specify the twist direction. If CCW, \
\[Alpha]\[Element](0,\[Pi]/2). If CW, \[Alpha]\[Element](\[Pi]/2, \[Pi])."
}], "Text",
 CellChangeTimes->{{3.629131385565474*^9, 3.629131478543693*^9}, 
   3.631469731675943*^9, 3.631469982561629*^9, 3.6314700252286577`*^9, 
   3.632080659024588*^9, 
   3.632082210876608*^9},ExpressionUUID->"1058e6d8-c80d-479d-987f-\
b8aad21a6618"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitBrocardTrapezoidInfo", "::", "baddir"}], 
   "=", "\"\<Twist direction `1` must be CCW or CW.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629129514425538*^9, 3.629129543765858*^9}, {
   3.629129882178124*^9, 3.629129895704105*^9}, {3.629131640152631*^9, 
   3.629131651585095*^9}, 3.631469732791232*^9, 3.632080659045404*^9, 
   3.632082210898978*^9},
 CellLabel->
  "In[396]:=",ExpressionUUID->"13bab249-c9a7-4df5-adcd-6663d29d3ff3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "UnitBrocardTrapezoidInfo", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"TwistDirection", "\[Rule]", "CCW"}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.629131513492236*^9, 3.62913153360058*^9}, 
   3.631469733685871*^9, 3.632080659085292*^9, 3.632082210943141*^9},
 CellLabel->
  "In[397]:=",ExpressionUUID->"2b7f3853-2319-49a5-a162-8977034fdf25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitBrocardTrapezoidInfo", "[", 
   RowBox[{"\[Delta]_", ",", " ", 
    StyleBox["opts___",
     FontSlant->"Italic"]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"td", ",", "s", ",", "verts", ",", "ctr", ",", "\[Alpha]"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"td", "=", 
      RowBox[{
       RowBox[{"TwistDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardTrapezoidInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"length", " ", "of", " ", "a", " ", "diagonal", " ", "side"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Cos", "[", "\[Delta]", "]"}]}], "+", 
       SqrtBox[
        RowBox[{"2", "-", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"length", " ", "of", " ", "a", " ", "diagonal", " ", "side"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "td", ",", "\[IndentingNewLine]", "CCW", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ctr", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"], "+", 
              RowBox[{
               RowBox[{"Cos", "[", "\[Delta]", "]"}], " ", 
               SqrtBox[
                RowBox[{"2", "-", 
                 SuperscriptBox[
                  RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}]}], ")"}]}],
            ",", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"Sin", "[", "\[Delta]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Delta]", "]"}]}], "+", 
              SqrtBox[
               RowBox[{"2", "-", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"ArcSin", "[", 
          FractionBox[
           RowBox[{"Sin", "[", "\[Delta]", "]"}], 
           SqrtBox["2"]], "]"}]}]}], ",", "\[IndentingNewLine]", "CW", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ctr", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"Cos", "[", 
               RowBox[{"2", " ", "\[Delta]"}], "]"}], "-", 
              RowBox[{
               SqrtBox["2"], " ", 
               RowBox[{"Cos", "[", "\[Delta]", "]"}], " ", 
               SqrtBox[
                RowBox[{"3", "+", 
                 RowBox[{"Cos", "[", 
                  RowBox[{"2", " ", "\[Delta]"}], "]"}]}]]}]}], ")"}]}], ",", 
           
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"Sin", "[", "\[Delta]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Delta]", "]"}]}], "+", 
              SqrtBox[
               RowBox[{"2", "-", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"ArcSin", "[", 
           FractionBox[
            RowBox[{"Sin", "[", "\[Delta]", "]"}], 
            SqrtBox["2"]], "]"}]}]}]}], ",", "\[IndentingNewLine]", "_", ",", 
       
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"UnitBrocardTrapezoidInfo", "::", "baddir"}], ",", "td"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "-", 
           RowBox[{"s", " ", 
            RowBox[{"Cos", "[", "\[Delta]", "]"}]}]}], ",", 
          RowBox[{"s", " ", 
           RowBox[{"Sin", "[", "\[Delta]", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"s", " ", 
           RowBox[{"Cos", "[", "\[Delta]", "]"}]}], ",", 
          RowBox[{"s", " ", 
           RowBox[{"Sin", "[", "\[Delta]", "]"}]}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "ctr", ",", "\[Alpha]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.629131364278666*^9, 3.629131364317513*^9}, {
  3.62913148268155*^9, 3.629131737475334*^9}, {3.62913194304162*^9, 
  3.629132085745845*^9}, {3.6291323432034683`*^9, 3.629132359895045*^9}, {
  3.629132497690414*^9, 3.629132506167293*^9}, {3.629132552237377*^9, 
  3.629132571299543*^9}, {3.629132678048546*^9, 3.629132682547138*^9}, {
  3.629132776853692*^9, 3.629132881490972*^9}, {3.631469734640538*^9, 
  3.631469736609817*^9}, {3.632080659135435*^9, 3.632080659205806*^9}, {
  3.632082210995418*^9, 3.632082211065568*^9}},
 CellLabel->
  "In[398]:=",ExpressionUUID->"823d390a-e81f-48c4-8fc3-82721c3b9a5c"],

Cell["Example", "Text",
 CellChangeTimes->{{3.6291320918747067`*^9, 
  3.629132092573684*^9}},ExpressionUUID->"a1b89fb3-df76-4fc1-9fe9-\
e079c36083ac"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Delta]", ",", "info1", ",", "info2", ",", "gfn"}], "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Delta]", "=", 
      RowBox[{"60", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitBrocardTrapezoidInfo", "[", 
       RowBox[{"\[Delta]", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitBrocardTrapezoidInfo", "[", 
       RowBox[{"\[Delta]", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{
               "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                ",", 
               RowBox[{"info", "\[LeftDoubleBracket]", 
                RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
             "]"}], ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
             "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
              "\[Degree]"}], "//", "N"}], "]"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.629126709840904*^9, 3.629126712594775*^9}, {3.629130656384805*^9, 
   3.62913066396213*^9}, {3.629130730052655*^9, 3.629130810025442*^9}, {
   3.62913089913776*^9, 3.629130918308019*^9}, {3.629131864293854*^9, 
   3.629131883467963*^9}, {3.6291321230885067`*^9, 3.629132160593374*^9}, {
   3.629132447695619*^9, 3.629132448278859*^9}, {3.629132888717511*^9, 
   3.629132894609464*^9}, {3.631469737709538*^9, 3.63146973840952*^9}, 
   3.631896785162936*^9, {3.632080659253162*^9, 3.632080659285705*^9}, {
   3.632082211111943*^9, 3.632082211146504*^9}},
 CellLabel->
  "In[399]:=",ExpressionUUID->"e27cd61d-791c-401d-9964-29a61e78183f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitBrocardParallelogramInfo",
 "[\[Delta], ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) TwistDirection"
}], "Subsubsection",
 CellChangeTimes->{{3.629131196309608*^9, 3.629131213280423*^9}, {
   3.629131350294961*^9, 3.629131350488141*^9}, 3.629133218259864*^9, 
   3.631469776480139*^9, 3.6320806730007463`*^9, 
   3.632082222268922*^9},ExpressionUUID->"ed86496c-4075-4145-96f4-\
a903c7bdb56e"],

Cell[TextData[{
 "UnitBrocardParallelogramInfo",
 "[\[Delta], ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]  takes the base angle \[Delta] of a parallelogram and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the Brocard angle, Brocard point, and vertices of a unit \
parallelogram that forms a closed-back twist with base angles of \[Delta] and \
top angles of \[Pi]-\[Delta]. Result is analytic in \[Delta]. Options are:\n\t\
TwistDirection \[Rule] CW | CCW. Specify the twist direction. If CCW, \
\[Alpha]\[Element](0,\[Pi]/2). If CW, \[Alpha]\[Element](\[Pi]/2, \[Pi])."
}], "Text",
 CellChangeTimes->{{3.629131385565474*^9, 3.629131478543693*^9}, {
   3.6291332051069746`*^9, 3.629133217919558*^9}, 3.631469777392161*^9, 
   3.631469984070713*^9, 3.631470027045456*^9, 3.632080673109791*^9, 
   3.632082222356032*^9},ExpressionUUID->"daedcbac-7278-43fc-963b-\
c81d447e46f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitBrocardParallelogramInfo", "::", "baddir"}], 
   "=", "\"\<Twist direction `1` must be CCW or CW.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629129514425538*^9, 3.629129543765858*^9}, {
   3.629129882178124*^9, 3.629129895704105*^9}, {3.629131640152631*^9, 
   3.629131651585095*^9}, 3.629133217976716*^9, 3.6314697817700157`*^9, 
   3.632080673129837*^9, 3.632082222377438*^9},
 CellLabel->
  "In[400]:=",ExpressionUUID->"9b15a4b1-65ee-49a0-b1ce-226bea34f812"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "UnitBrocardParallelogramInfo", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"TwistDirection", "\[Rule]", "CCW"}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.629131513492236*^9, 3.62913153360058*^9}, 
   3.629133218000963*^9, 3.631469782704331*^9, 3.632080673166897*^9, 
   3.632082222418666*^9},
 CellLabel->
  "In[401]:=",ExpressionUUID->"124cdd99-f5cf-457f-a946-d8fa58ec9e35"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitBrocardParallelogramInfo", "[", 
   RowBox[{"\[Delta]_", ",", " ", 
    StyleBox["opts___",
     FontSlant->"Italic"]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"td", ",", "s", ",", "verts", ",", "ctr", ",", "\[Alpha]"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"td", "=", 
      RowBox[{
       RowBox[{"TwistDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardParallelogramInfo", "]"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"length", " ", "of", " ", "a", " ", "diagonal", " ", "side"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "td", ",", "\[IndentingNewLine]", "CCW", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"s", "=", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Cos", "[", "\[Delta]", "]"}]}], "+", 
          SqrtBox[
           RowBox[{"2", "-", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}]}], ";", 
        RowBox[{"(*", " ", 
         RowBox[{
         "length", " ", "of", " ", "a", " ", "diagonal", " ", "side"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"ctr", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"], "+", 
              RowBox[{
               RowBox[{"Cos", "[", "\[Delta]", "]"}], " ", 
               SqrtBox[
                RowBox[{"2", "-", 
                 SuperscriptBox[
                  RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}]}], ")"}]}],
            ",", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"Sin", "[", "\[Delta]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Delta]", "]"}]}], "+", 
              SqrtBox[
               RowBox[{"2", "-", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"ArcSin", "[", 
          FractionBox[
           RowBox[{"Sin", "[", "\[Delta]", "]"}], 
           SqrtBox["2"]], "]"}]}]}], ",", "\[IndentingNewLine]", "CW", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"s", "=", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Delta]", "]"}], "+", 
          SqrtBox[
           RowBox[{"2", "-", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}]}], ";", 
        RowBox[{"(*", " ", 
         RowBox[{
         "length", " ", "of", " ", "a", " ", "diagonal", " ", "side"}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"ctr", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            FractionBox["1", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"Cos", "[", 
               RowBox[{"2", " ", "\[Delta]"}], "]"}], "+", 
              RowBox[{
               SqrtBox["2"], " ", 
               RowBox[{"Cos", "[", "\[Delta]", "]"}], " ", 
               SqrtBox[
                RowBox[{"3", "+", 
                 RowBox[{"Cos", "[", 
                  RowBox[{"2", " ", "\[Delta]"}], "]"}]}]]}]}], ")"}]}], ",", 
           
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"Sin", "[", "\[Delta]", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Delta]", "]"}], "+", 
              SqrtBox[
               RowBox[{"2", "-", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "\[Delta]", "]"}], "2"]}]]}], ")"}]}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"ArcSin", "[", 
           FractionBox[
            RowBox[{"Sin", "[", "\[Delta]", "]"}], 
            SqrtBox["2"]], "]"}]}]}]}], ",", "\[IndentingNewLine]", "_", ",", 
       
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"UnitBrocardParallelogramInfo", "::", "baddir"}], ",", 
          "td"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"s", " ", 
            RowBox[{"Cos", "[", "\[Delta]", "]"}]}]}], ",", 
          RowBox[{"s", " ", 
           RowBox[{"Sin", "[", "\[Delta]", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"s", " ", 
           RowBox[{"Cos", "[", "\[Delta]", "]"}]}], ",", 
          RowBox[{"s", " ", 
           RowBox[{"Sin", "[", "\[Delta]", "]"}]}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "ctr", ",", "\[Alpha]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.629131364278666*^9, 3.629131364317513*^9}, {
  3.62913148268155*^9, 3.629131737475334*^9}, {3.62913194304162*^9, 
  3.629132085745845*^9}, {3.6291323432034683`*^9, 3.629132359895045*^9}, {
  3.629132497690414*^9, 3.629132506167293*^9}, {3.629132552237377*^9, 
  3.629132571299543*^9}, {3.629132678048546*^9, 3.629132682547138*^9}, {
  3.629132776853692*^9, 3.629132881490972*^9}, {3.629133218041561*^9, 
  3.629133218090397*^9}, {3.629133413856346*^9, 3.629133451366579*^9}, {
  3.629133654264474*^9, 3.62913366719062*^9}, {3.6314697836222153`*^9, 
  3.631469786154252*^9}, {3.632080673218587*^9, 3.632080673288707*^9}, {
  3.632082222471883*^9, 3.6320822225412083`*^9}},
 CellLabel->
  "In[402]:=",ExpressionUUID->"06b3f872-38ca-4e5f-b396-2e1f2b4b5383"],

Cell["Example", "Text",
 CellChangeTimes->{{3.6291320918747067`*^9, 
  3.629132092573684*^9}},ExpressionUUID->"d7522017-73e3-4375-b183-\
1e40a693f705"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Delta]", ",", "info1", ",", "info2", ",", "gfn"}], "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Delta]", "=", 
      RowBox[{"60", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitBrocardParallelogramInfo", "[", 
       RowBox[{"\[Delta]", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitBrocardParallelogramInfo", "[", 
       RowBox[{"\[Delta]", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{
               "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                ",", 
               RowBox[{"info", "\[LeftDoubleBracket]", 
                RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
             "]"}], ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
             "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
              "\[Degree]"}], "//", "N"}], "]"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.629126709840904*^9, 3.629126712594775*^9}, {3.629130656384805*^9, 
   3.62913066396213*^9}, {3.629130730052655*^9, 3.629130810025442*^9}, {
   3.62913089913776*^9, 3.629130918308019*^9}, {3.629131864293854*^9, 
   3.629131883467963*^9}, {3.6291321230885067`*^9, 3.629132160593374*^9}, {
   3.629132447695619*^9, 3.629132448278859*^9}, {3.629132888717511*^9, 
   3.629132894609464*^9}, {3.629133218109194*^9, 3.629133218158152*^9}, {
   3.62913367931262*^9, 3.629133683465057*^9}, {3.631469787591778*^9, 
   3.631469788917276*^9}, 3.6318967861620893`*^9, {3.632080673337878*^9, 
   3.632080673371612*^9}, {3.6320822225889473`*^9, 3.632082222622167*^9}},
 CellLabel->
  "In[403]:=",ExpressionUUID->"2db1ad31-8281-4c61-906c-dd40d243b2e8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitBrocardTriangleInfo",
 "[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) TwistDirection"
}], "Subsubsection",
 CellChangeTimes->{{3.629131196309608*^9, 3.629131213280423*^9}, {
   3.629131350294961*^9, 3.629131350488141*^9}, 3.629133218259864*^9, {
   3.629134530256838*^9, 3.629134535498455*^9}, 3.6314698220395937`*^9, 
   3.63208068576189*^9, 
   3.632082234914448*^9},ExpressionUUID->"c8962384-4d76-4fdc-b82c-\
3b49e8605693"],

Cell[TextData[{
 "UnitBrocardTriangleInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]  takes a set of three angles ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " of a triangle and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the Brocard angle, Brocard point, and vertices of a unit \
triangle that forms a closed-back twist. Result is analytic in ",
 StyleBox["angles",
  FontSlant->"Italic"],
 ". Note that only the first two values in angles are actually used; the \
third is forced to the value that completes a planar triangle. Options are:\n\
\tTwistDirection \[Rule] CW | CCW. Specify the twist direction. If CCW, \
\[Alpha]\[Element](0,\[Pi]/2). If CW, \[Alpha]\[Element](\[Pi]/2, \[Pi])."
}], "Text",
 CellChangeTimes->{{3.629131385565474*^9, 3.629131478543693*^9}, {
   3.6291332051069746`*^9, 3.629133217919558*^9}, {3.629134530358574*^9, 
   3.629134554524872*^9}, 3.629135181294161*^9, {3.629135242823317*^9, 
   3.629135270699594*^9}, 3.6314698229289627`*^9, 3.631469985850319*^9, 
   3.631470028382481*^9, 3.632080685851961*^9, 3.632082234998341*^9, {
   3.632149692653803*^9, 
   3.6321497215556307`*^9}},ExpressionUUID->"928b9933-7597-4430-b69a-\
f75c3f9c83cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitBrocardTriangleInfo", "::", "baddir"}], 
   "=", "\"\<Twist direction `1` must be CCW or CW.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629129514425538*^9, 3.629129543765858*^9}, {
   3.629129882178124*^9, 3.629129895704105*^9}, {3.629131640152631*^9, 
   3.629131651585095*^9}, 3.629133217976716*^9, 3.629134530392404*^9, 
   3.631469823789787*^9, 3.632080685871731*^9, 3.632082235019373*^9},
 CellLabel->
  "In[404]:=",ExpressionUUID->"e6bd3d5f-2246-44bf-966b-2ff76d201a99"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "UnitBrocardTriangleInfo", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"TwistDirection", "\[Rule]", "CCW"}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.629131513492236*^9, 3.62913153360058*^9}, 
   3.629133218000963*^9, 3.6291345304119*^9, 3.631469824603334*^9, 
   3.632080685913026*^9, 3.632082235063957*^9},
 CellLabel->
  "In[405]:=",ExpressionUUID->"22652c1a-e973-4bcc-b686-aa32c14a91f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitBrocardTriangleInfo", "[", 
   RowBox[{"angles_", ",", " ", 
    StyleBox["opts___",
     FontSlant->"Italic"]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "td", ",", "\[Theta]1", ",", "\[Theta]2", ",", "\[Theta]3", ",", 
      "\[Alpha]", ",", "verts", ",", "ctr", ",", "a"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"td", "=", 
      RowBox[{
       RowBox[{"TwistDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardTriangleInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]1", ",", "\[Theta]2", ",", "\[Theta]3"}], "}"}], "=", 
      "angles"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]3", "=", 
      RowBox[{"\[Pi]", "-", "\[Theta]1", "-", "\[Theta]2"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"a", "=", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]1", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]2", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]3", "]"}]}], 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Theta]1", "]"}], 
          RowBox[{"Cos", "[", "\[Theta]2", "]"}], 
          RowBox[{"Cos", "[", "\[Theta]3", "]"}]}]}]], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "td", ",", "\[IndentingNewLine]", "CCW", ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"verts", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"Cos", "[", "\[Theta]2", "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"Cot", "[", "a", "]"}]}], "+", 
                 RowBox[{"Cot", "[", "\[Theta]1", "]"}]}], ")"}], " ", 
               RowBox[{"Sin", "[", "\[Theta]2", "]"}]}]}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Cot", "[", "a", "]"}], "-", 
                RowBox[{"Cot", "[", "\[Theta]1", "]"}]}], ")"}], " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "\[Theta]2", "]"}], "2"]}]}], "}"}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ctr", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Sin", "[", "a", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"Cos", "[", "a", "]"}], " ", 
               RowBox[{"Cot", "[", "\[Theta]1", "]"}]}], "+", 
              RowBox[{"Sin", "[", "a", "]"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Csc", "[", "\[Theta]1", "]"}]}], " ", 
            RowBox[{"Sin", "[", "a", "]"}], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"a", "-", "\[Theta]1"}], "]"}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", "a"}]}], ",", "\[IndentingNewLine]", "CW", ",",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"verts", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Csc", "[", "\[Theta]2", "]"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{"a", "+", "\[Theta]1"}], "]"}], " ", 
                 RowBox[{"Csc", "[", 
                  RowBox[{"a", "+", "\[Theta]1", "+", "\[Theta]2"}], "]"}], " ", 
                 SuperscriptBox[
                  RowBox[{"Sin", "[", "a", "]"}], "2"]}], "-", 
                RowBox[{
                 RowBox[{"Cos", "[", "a", "]"}], " ", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"a", "-", "\[Theta]2"}], "]"}]}]}], ")"}]}], ",", 
             RowBox[{
              RowBox[{"Csc", "[", 
               RowBox[{"a", "+", "\[Theta]1", "+", "\[Theta]2"}], "]"}], " ", 
              
              RowBox[{"Sin", "[", "a", "]"}], " ", 
              RowBox[{"Sin", "[", 
               RowBox[{"\[Theta]1", "+", "\[Theta]2"}], "]"}]}]}], "}"}]}], 
          "}"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ctr", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"Cos", "[", "a", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cos", "[", "a", "]"}], "-", 
              RowBox[{
               RowBox[{"Cot", "[", "\[Theta]2", "]"}], " ", 
               RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Csc", "[", "\[Theta]2", "]"}]}], " ", 
            RowBox[{"Sin", "[", "a", "]"}], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"a", "-", "\[Theta]2"}], "]"}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"\[Pi]", "-", "a"}]}]}], ",", "\[IndentingNewLine]", "_", ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"UnitBrocardTriangleInfo", "::", "baddir"}], ",", "td"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "ctr", ",", "\[Alpha]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQffVVxxkWrteOgppdYNrpfOhtEP3BVP83mA55KMIK
pL/d3a4Goi80PXMD0SZL/niA6PviZlEgujzKNRpEz5jBngiib0/NTAbRG3oP
FoBojabAQhBdFChdC6K5t+l3geiKEMctILrjiROY3lPhF8EGpA07/MH0gnMi
sSD6xSIVMO1zySgRRKuyaaWD6C11mwpA9EmPrbUgWoNnYzeIvn7n8UIQfSZg
2koQXXF9GZiW0apcC6LPL6oC03U39RZU8b12FIubAqaVLux7uoT/teMTpoNg
umBL8vKlQHrC71QwLVr0bcoxIC10V2saiAYAqmiJpg==
  "],
 CellLabel->
  "In[406]:=",ExpressionUUID->"7fcadf65-c4f2-4029-8a59-54b1f1641111"],

Cell["Example", "Text",
 CellChangeTimes->{{3.6291320918747067`*^9, 
  3.629132092573684*^9}},ExpressionUUID->"88e65a21-5efe-4bf7-b41a-\
74dea877a863"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "info1", ",", "info2", ",", "gfn"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"40", "\[Degree]"}], ",", 
        RowBox[{"60", "\[Degree]"}], ",", 
        RowBox[{"80", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitBrocardTriangleInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitBrocardTriangleInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"Append", "[", 
              RowBox[{
               RowBox[{
               "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
                ",", 
               RowBox[{"info", "\[LeftDoubleBracket]", 
                RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], "]"}], 
             "]"}], ",", "Gray"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", "Black"}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
             "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/",
              "\[Degree]"}], "//", "N"}], "]"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.629126709840904*^9, 3.629126712594775*^9}, {3.629130656384805*^9, 
   3.62913066396213*^9}, {3.629130730052655*^9, 3.629130810025442*^9}, {
   3.62913089913776*^9, 3.629130918308019*^9}, {3.629131864293854*^9, 
   3.629131883467963*^9}, {3.6291321230885067`*^9, 3.629132160593374*^9}, {
   3.629132447695619*^9, 3.629132448278859*^9}, {3.629132888717511*^9, 
   3.629132894609464*^9}, {3.629133218109194*^9, 3.629133218158152*^9}, {
   3.629134530520733*^9, 3.629134530534942*^9}, {3.629135133099506*^9, 
   3.6291351494978*^9}, {3.631469830614146*^9, 3.631469831472421*^9}, 
   3.631896808275715*^9, {3.6320806860803227`*^9, 3.632080686113147*^9}, {
   3.632082235240564*^9, 3.632082235266151*^9}},
 CellLabel->
  "In[407]:=",ExpressionUUID->"90bc764c-053d-43d0-9298-90afefec75ec"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "BrocardTriangleInfo",
 "[",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) TwistDirection"
}], "Subsubsection",
 CellChangeTimes->{{3.62878051976374*^9, 3.62878054932134*^9}, {
   3.6287805797596416`*^9, 3.628780588086643*^9}, {3.628780776434309*^9, 
   3.628780781025818*^9}, 3.628781745456794*^9, 3.631469662893271*^9, 
   3.631469902841335*^9, 3.63208069943583*^9, 
   3.632082177248962*^9},ExpressionUUID->"9c0fdd91-2e79-4940-92ce-\
d8bf6b8cdd68"],

Cell[TextData[{
 "BrocardTriangleInfo[",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] takes a list ",
 StyleBox["verts",
  FontSlant->"Italic"],
 " of vertices and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["ctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the Brocard angle, Brocard point, and vertices of a unit \
polygon that forms a closed-back twist with the specified vertices. Options \
are:\n\tTwistDirection \[Rule] CW | CCW. If CCW, \
\[Alpha]\[Element](0,\[Pi]/2). If CW, \[Alpha]\[Element](\[Pi]/2, \[Pi])."
}], "Text",
 CellChangeTimes->{{3.628780627301861*^9, 3.628780658147501*^9}, {
   3.628780716432074*^9, 3.628780722837658*^9}, {3.628780789323931*^9, 
   3.628780842006081*^9}, {3.628781745777552*^9, 3.628781756635822*^9}, 
   3.63146966435437*^9, 3.63146990380527*^9, 3.631469987695538*^9, 
   3.631470030270862*^9, 3.632080699553627*^9, {3.6320808575905*^9, 
   3.6320808591286*^9}, 3.632082177356114*^9, {3.632082254877419*^9, 
   3.632082255851799*^9}},ExpressionUUID->"ab5a0316-504a-402a-8100-\
f54f334f55da"],

Cell["\<\
We make use of the fact that the Brocard point has simple barycentric \
coordinates in a triangle to compute the point location first, then the angle.\
\>", "Text",
 CellChangeTimes->{{3.632082262195516*^9, 3.63208230673657*^9}, {
  3.632085248411836*^9, 
  3.632085256683282*^9}},ExpressionUUID->"a51c49f0-8689-4a71-bb8c-\
edeaad21bdd9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BrocardTriangleInfo", "::", "baddir"}], 
   "=", "\"\<Twist direction `1` must be CCW or CW.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629129514425538*^9, 3.629129543765858*^9}, {
   3.629129882178124*^9, 3.629129895704105*^9}, {3.629131640152631*^9, 
   3.629131651585095*^9}, 3.629133217976716*^9, 3.629134530392404*^9, 
   3.631469823789787*^9, 3.632080685871731*^9, 3.632082235019373*^9, {
   3.6320825650206833`*^9, 3.632082565546613*^9}},
 CellLabel->
  "In[408]:=",ExpressionUUID->"80f5cb54-aed9-4970-a300-a5aa10f74e3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "BrocardTriangleInfo", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"TwistDirection", "\[Rule]", "CCW"}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.629131513492236*^9, 3.62913153360058*^9}, 
   3.629133218000963*^9, 3.6291345304119*^9, 3.631469824603334*^9, 
   3.632080685913026*^9, 3.632082235063957*^9, {3.632082567586143*^9, 
   3.632082568129612*^9}},
 CellLabel->
  "In[409]:=",ExpressionUUID->"59945d77-93bc-4bde-848f-bc80aebd219a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"BrocardTriangleInfo", "[", 
   RowBox[{
    StyleBox["verts_List",
     FontSlant->"Italic"], ",", " ", 
    StyleBox["opts___",
     FontSlant->"Italic"]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "td", ",", "sides", ",", "angles", ",", "tverts", ",", "ctr", ",", 
      "weights", ",", "\[Alpha]", ",", "s", ",", "r", ",", "o"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"td", "=", 
      RowBox[{
       RowBox[{"TwistDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "BrocardTriangleInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"sides", "=", 
      RowBox[{"PolygonSides", "[", "verts", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"weights", " ", "=", " ", 
      FractionBox[
       SuperscriptBox["sides", 
        RowBox[{"-", "2"}]], 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         SuperscriptBox["sides", 
          RowBox[{"-", "2"}]], ")"}]}]]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"td", ",", "\[IndentingNewLine]", "CCW", ",", 
       RowBox[{
        RowBox[{"ctr", "=", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"weights", " ", "verts"}], ")"}]}]}], ";", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"RotationAngle", "[", 
          RowBox[{
           RowBox[{"ctr", "-", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
            ",", 
           RowBox[{
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", "CW", ",", 
       RowBox[{
        RowBox[{"ctr", "=", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"RotateRight", "[", "weights", "]"}], " ", "verts"}], 
           ")"}]}]}], ";", 
        RowBox[{"\[Alpha]", "=", 
         RowBox[{"RotationAngle", "[", 
          RowBox[{
           RowBox[{"ctr", "-", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
            ",", 
           RowBox[{
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-", 
            RowBox[{
            "verts", "\[LeftDoubleBracket]", "2", 
             "\[RightDoubleBracket]"}]}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", "_", ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"BrocardTriangleInfo", "::", "baddir"}], ",", "td"}], "]"}],
         ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "ctr", ",", "\[Alpha]"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.628780599080532*^9, 3.628780612248921*^9}, {
   3.628780822432721*^9, 3.628780827703155*^9}, {3.6287808836551847`*^9, 
   3.628780948491214*^9}, {3.628781101535334*^9, 3.628781162041438*^9}, {
   3.628781204019989*^9, 3.628781224004062*^9}, {3.628781409375499*^9, 
   3.628781418847535*^9}, {3.628781503034424*^9, 3.628781527624419*^9}, {
   3.628781681974747*^9, 3.628781684005297*^9}, 3.628781745799726*^9, 
   3.628786247355291*^9, 3.629135310518367*^9, 3.631469665454577*^9, 
   3.631469839816983*^9, 3.631469904636498*^9, {3.632080686163403*^9, 
   3.632080699574885*^9}, 3.632082177465267*^9, 3.63208223531793*^9, {
   3.632082346371067*^9, 3.632082438623579*^9}, {3.632082490996262*^9, 
   3.6320826773267508`*^9}, {3.632082720702914*^9, 3.632082917128234*^9}, {
   3.6320830165877447`*^9, 3.6320830180902433`*^9}, {3.632083139092016*^9, 
   3.632083171040894*^9}, {3.632083259389988*^9, 3.6320832971047487`*^9}, {
   3.632083329494079*^9, 3.632083344221979*^9}, {3.632083765748806*^9, 
   3.632083766514862*^9}, {3.632083813159717*^9, 3.6320838774359093`*^9}, {
   3.632084010409685*^9, 3.632084043425229*^9}, {3.6320840849519444`*^9, 
   3.632084086000473*^9}, {3.632084321840583*^9, 3.632084323846833*^9}, {
   3.632084364004966*^9, 3.632084368372341*^9}, {3.632084401026267*^9, 
   3.63208454201249*^9}, {3.632084634710005*^9, 3.63208463529514*^9}, {
   3.632084672946069*^9, 3.632084673889387*^9}, {3.632084710112355*^9, 
   3.632084812149977*^9}, {3.632084873369775*^9, 3.6320849285491753`*^9}, 
   3.632084965861875*^9, {3.6320850084022903`*^9, 3.632085011810658*^9}, {
   3.632085058566656*^9, 3.6320850649273043`*^9}, {3.778749050135363*^9, 
   3.778749050138074*^9}},
 CellLabel->
  "In[410]:=",ExpressionUUID->"59635c44-5928-4d9e-9291-58ba86384beb"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.628780977293933*^9, 3.62878097802888*^9}, {
   3.629135449712089*^9, 3.629135491268952*^9}, 
   3.632085267226521*^9},ExpressionUUID->"eabfbcfc-2edf-49e2-935b-\
680dfc98b2c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"verts", ",", "ctr", ",", "info"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "/", "2"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"5", "/", "3"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info", "=", 
      RowBox[{
       RowBox[{"BrocardTriangleInfo", "[", 
        RowBox[{"verts", ",", 
         RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}], "//", 
       "Simplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "info", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
         "info", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], "/", 
         "\[Degree]"}], "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"ctr", "=", 
      RowBox[{
      "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<CCW angles/\[Degree] = \>\"", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"RotationAngle", "[", 
            RowBox[{
             RowBox[{"ctr", "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", 
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
               "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RotationAngle", "[", 
            RowBox[{
             RowBox[{"ctr", "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "3", 
               "\[RightDoubleBracket]"}]}], ",", 
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
               "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "3", 
               "\[RightDoubleBracket]"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RotationAngle", "[", 
            RowBox[{
             RowBox[{"ctr", "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}]}], ",", 
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
               "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}]}]}], "]"}]}], "}"}], "/", 
         "\[Degree]"}], "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<CW angles/\[Degree] = \>\"", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"RotationAngle", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
               "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}]}], ",", 
             RowBox[{"ctr", "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "1", 
               "\[RightDoubleBracket]"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RotationAngle", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}],
               "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}], ",", 
             RowBox[{"ctr", "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "2", 
               "\[RightDoubleBracket]"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RotationAngle", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
               "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "3", 
               "\[RightDoubleBracket]"}]}], ",", 
             RowBox[{"ctr", "-", 
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "3", 
               "\[RightDoubleBracket]"}]}]}], "]"}]}], "}"}], "/", 
         "\[Degree]"}], "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"AppendFirst", "[", "verts", "]"}], "]"}], ",", "Gray"}], 
          "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "ctr", "]"}], ",", "Black"}], "]"}]}], "}"}],
        ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628781242919928*^9, 3.628781394143865*^9}, {
   3.628781537192068*^9, 3.62878153944602*^9}, {3.628781577132876*^9, 
   3.628781665458008*^9}, 3.628781745834297*^9, {3.628852706990315*^9, 
   3.628852713732045*^9}, {3.629135321333998*^9, 3.629135321958496*^9}, {
   3.629135355402729*^9, 3.6291353568674*^9}, {3.629135423808652*^9, 
   3.629135438061979*^9}, 3.631469666400659*^9, 3.631469905669899*^9, 
   3.631896811066514*^9, 3.632080699610943*^9, 3.632082177883408*^9, {
   3.632082466461196*^9, 3.632082471850227*^9}, {3.632083972740212*^9, 
   3.632083992265047*^9}, {3.63208433176372*^9, 3.632084346554296*^9}, 
   3.6320846605028048`*^9, 3.632084976572227*^9, 3.632085027728805*^9, {
   3.63208508596551*^9, 3.632085219453674*^9}, 3.632085274194228*^9, {
   3.778749050150154*^9, 3.778749050167333*^9}},
 CellLabel->
  "In[411]:=",ExpressionUUID->"cfa3699e-7744-4e1f-8efc-9d8d0242fd41"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit cyclic Brocard polygons", "Subsection",
 CellChangeTimes->{{3.631895653696733*^9, 3.631895666541279*^9}, 
   3.708400990841297*^9},ExpressionUUID->"26546a00-8de6-4c6d-b6f8-\
637a17ccc301"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.63189566975892*^9, 
  3.6318956701403728`*^9}},ExpressionUUID->"aaa767b5-6e31-4178-ad96-\
607b636f27dc"],

Cell["\<\
Unit cyclic Brocard polygons are Brocard polygons that have concyclic \
vertices. They arise in offset twist tilings, see below.\
\>", "Text",
 CellChangeTimes->{{3.63189567828465*^9, 3.631895711873567*^9}, {
  3.631895845243525*^9, 3.631895877800397*^9}, {3.6320854809087744`*^9, 
  3.632085483949357*^9}},ExpressionUUID->"6a5ed8f0-ead3-4193-a15d-\
9f58be8fa2ea"],

Cell["\<\
All triangles are of course cyclic Brocard polygons. For quadrilaterals, we \
can specify two of the four angles and the other two angles are the \
supplements of the diagonally opposite angles, required by concyclicity.\
\>", "Text",
 CellChangeTimes->{{3.63208549505199*^9, 3.632085530441811*^9}, {
  3.6335368311474543`*^9, 
  3.633536855312408*^9}},ExpressionUUID->"74ef3856-efd1-412e-b420-\
dd7e0562b3cf"],

Cell["\<\
For higher-order polygons, things get trickier, but in general, we can \
specify any two angles.\
\>", "Text",
 CellChangeTimes->{{3.632087068131844*^9, 3.632087079415281*^9}, {
  3.633536857080476*^9, 
  3.633536863088167*^9}},ExpressionUUID->"7d15c37e-c5f4-4670-ad15-\
43d29e7f8310"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitCyclicBrocardTriangleInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) TwistDirection"
}], "Subsubsection",
 CellChangeTimes->{{3.631895735296613*^9, 3.631895786534774*^9}, {
  3.6320871438595333`*^9, 3.632087144315221*^9}, {3.632087394693214*^9, 
  3.632087395427306*^9}},ExpressionUUID->"e2c8101b-a22a-4012-a4f4-\
ac21f42802e1"],

Cell[TextData[{
 "UnitCyclicBrocardTriangleInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] taks a list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " of corner angles and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["angles1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the vertices ",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", circumcenter ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", circumradius ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", Brocard point ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", Brocard angle \[Alpha], and complete corner angles ",
 StyleBox["angles1",
  FontSlant->"Italic"],
 " for a unit Brocard triangle that has concyclic vertices. Note that only \
the first two angles in the list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " are used; the third value is ignored in favor of the value that it must be \
to be a planar triangle. Options are:\n\tTwistDirection\[Rule]CCW | CW, \
specifies the twist direction."
}], "Text",
 CellChangeTimes->{{3.63189577288864*^9, 3.631895824322875*^9}, {
  3.6320860025835533`*^9, 3.63208600437981*^9}, {3.632086037281715*^9, 
  3.632086110940962*^9}, {3.632087152467066*^9, 3.632087190080473*^9}, {
  3.632087400509651*^9, 3.632087432856992*^9}, {3.632149157369384*^9, 
  3.632149188462918*^9}, {3.6321493766517053`*^9, 
  3.63214942452721*^9}},ExpressionUUID->"20955b28-8594-4bea-84da-\
d9076bb1a9c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicBrocardTriangleInfo", "[", 
   RowBox[{"angles_List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "td", ",", "\[Theta]1", ",", "\[Theta]2", ",", "ba", ",", "verts", ",", 
      "bctr", ",", "cctr", ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]1", ",", "\[Theta]2"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{"angles", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"verts", ",", "bctr", ",", "ba"}], "}"}], "=", 
      RowBox[{"UnitBrocardTriangleInfo", "[", 
       RowBox[{"angles", ",", "opts"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cctr", ",", "r"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{"ConcyclicInfo", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"verts", ",", "3"}], "]"}], "]"}], ",", "2"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "cctr", ",", "r", ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]1", ",", "\[Theta]2", ",", 
         RowBox[{"\[Pi]", "-", "\[Theta]1", "-", "\[Theta]2"}]}], "}"}], ",", 
       "bctr", ",", "ba"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.63209200143321*^9, 3.632092048072023*^9}, 
   3.632092096558611*^9, {3.6321494354453907`*^9, 3.632149447491658*^9}, {
   3.632149958057119*^9, 3.632149967518883*^9}, {3.632150132096396*^9, 
   3.632150156141039*^9}},
 CellLabel->
  "In[412]:=",ExpressionUUID->"4246e507-9163-4f4b-bbb5-e14874361387"],

Cell["Examples", "Text",
 CellChangeTimes->{{3.632092057075811*^9, 
  3.632092068849993*^9}},ExpressionUUID->"2ef8ee98-be66-4487-9bcc-\
9310c779c683"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]1", ",", "\[Theta]2", ",", "angles", ",", "info1", ",", "info2",
       ",", "gfn"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]1", "=", 
      RowBox[{"60", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]2", "=", 
      RowBox[{"75", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{"\[Theta]1", ",", "\[Theta]2", ",", "Null"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitCyclicBrocardTriangleInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitCyclicBrocardTriangleInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"AppendFirst", "[", 
              RowBox[{
              "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
              "]"}], "]"}], ",", "Black"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{
              "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
              ",", 
              RowBox[{
              "info", "\[LeftDoubleBracket]", "3", 
               "\[RightDoubleBracket]"}]}], "]"}], ",", "Green"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "5", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", 
            RowBox[{"Darker", "[", "Green", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}], 
             "]"}], ",", 
            RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
             "info", "\[LeftDoubleBracket]", "6", "\[RightDoubleBracket]"}], "/",
              "\[Degree]"}], "//", "N"}], "]"}], "<>", "\"\<\\r\>\"", 
          "<>", "\"\<Corner angles/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
             "info", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}], "/",
              "\[Degree]"}], "//", "N"}], "]"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.631469650981761*^9, 3.6314696520512238`*^9}, {3.631896522372604*^9, 
   3.631896585657536*^9}, {3.631896740304953*^9, 3.631896740776146*^9}, 
   3.631896814686269*^9, {3.632086351677274*^9, 3.63208641116031*^9}, {
   3.6320864560148907`*^9, 3.632086528938429*^9}, {3.632087255435614*^9, 
   3.632087295392936*^9}, {3.632092075863245*^9, 3.632092133603245*^9}, {
   3.632149471364343*^9, 3.632149481483801*^9}, {3.632149630484824*^9, 
   3.632149641571513*^9}, {3.632149743113957*^9, 3.632149744055636*^9}, {
   3.632149795560563*^9, 3.632149921015504*^9}, 3.632149981035449*^9, {
   3.632150015814819*^9, 3.632150088836299*^9}},
 CellLabel->
  "In[413]:=",ExpressionUUID->"07322beb-30d9-4059-b9ca-4bea8811cec9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitCyclicBrocardQuadrilateralInfo",
 "[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]\n\t(options) TwistDirection"
}], "Subsubsection",
 CellChangeTimes->{{3.631895735296613*^9, 3.631895786534774*^9}, {
   3.6320871438595333`*^9, 3.632087144315221*^9}, 3.6320919813284073`*^9, 
   3.63214896916238*^9},ExpressionUUID->"e7bfb842-4271-41de-9689-\
ef6e57861745"],

Cell[TextData[{
 "UnitCyclicBrocardQuadrilateralInfo[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "] takes a list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " of corner angles and returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["angles1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the vertices ",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", circumcenter ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", circumradius ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", corner angles ",
 StyleBox["angles1",
  FontSlant->"Italic"],
 ", Brocard point ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", and Brocard angle \[Alpha] for a unit Brocard polygon that has concyclic \
vertices. Note that only the first two angles in the input list ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " are used; the other two are ignored in favor of the values that must hold \
for concyclicity: \[Theta]3=\[Pi]-\[Theta]1, \[Theta]4=\[Pi]-\[Theta]2. \
Options are:\n\tTwistDirection\[Rule]CCW | CW, specifies the twist \
direction."
}], "Text",
 CellChangeTimes->{{3.63189577288864*^9, 3.631895824322875*^9}, {
  3.6320860025835533`*^9, 3.63208600437981*^9}, {3.632086037281715*^9, 
  3.632086110940962*^9}, {3.632087152467066*^9, 3.632087190080473*^9}, {
  3.6321489852947073`*^9, 3.632148985755299*^9}, {3.632149016913986*^9, 
  3.6321490287767344`*^9}, {3.632149204997527*^9, 3.632149228332097*^9}, {
  3.632149502055965*^9, 
  3.632149545015375*^9}},ExpressionUUID->"82ddd8d3-6449-4d48-8821-\
6fc81a503913"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicBrocardQuadrilateralInfo", "[", 
   RowBox[{"angles_List", ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "td", ",", "\[Theta]1", ",", "\[Theta]2", ",", "ba", ",", "verts", ",", 
      "bctr", ",", "cctr", ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"td", "=", 
      RowBox[{
       RowBox[{"TwistDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]1", ",", "\[Theta]2"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{"angles", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ba", "=", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"Sin", "[", "\[Theta]1", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]2", "]"}]}], 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"Cos", "[", "\[Theta]1", "]"}], "2"], 
           SuperscriptBox[
            RowBox[{"Cos", "[", "\[Theta]2", "]"}], "2"]}]}]]], "]"}]}], ";", 
     
     RowBox[{"(*", " ", 
      RowBox[{
      "analytic", " ", "solution", " ", "for", " ", "Brocard", " ", "angle"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{
      "td", ",", "\[IndentingNewLine]", "CCW", ",", "Null", ",", 
       "\[IndentingNewLine]", "CW", ",", 
       RowBox[{"ba", "=", 
        RowBox[{"\[Pi]", "-", "ba"}]}], ",", "\[IndentingNewLine]", "_", ",", 
       
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"UnitBrocardPolygonInfo", "::", "baddir"}], ",", "td"}], 
         "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"verts", ",", "bctr"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{"UnitBrocardPolygonInfo", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\[Theta]1", ",", "\[Theta]2", ",", 
            RowBox[{"\[Pi]", "-", "\[Theta]1"}], ",", 
            RowBox[{"\[Pi]", "-", "\[Theta]2"}]}], "}"}], ",", 
          RowBox[{"BrocardAngle", "\[Rule]", "ba"}], ",", "opts"}], "]"}], ",",
         "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cctr", ",", "r"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{"ConcyclicInfo", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"verts", ",", "3"}], "]"}], "]"}], ",", "2"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"verts", ",", "cctr", ",", "r", ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]1", ",", "\[Theta]2", ",", 
         RowBox[{"\[Pi]", "-", "\[Theta]1"}], ",", 
         RowBox[{"\[Pi]", "-", "\[Theta]2"}]}], "}"}], ",", "bctr", ",", 
       "ba"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.631896171595271*^9, 3.631896390918247*^9}, {
   3.631896643198425*^9, 3.631896651860217*^9}, {3.631896729592131*^9, 
   3.631896730233942*^9}, {3.632080645838855*^9, 3.6320806459062233`*^9}, {
   3.632082199520767*^9, 3.632082199587884*^9}, {3.6320861567191477`*^9, 
   3.632086277976818*^9}, {3.632086316808401*^9, 3.632086316975001*^9}, {
   3.63208637665212*^9, 3.63208639326863*^9}, {3.632086434903364*^9, 
   3.632086438622724*^9}, {3.632087201006752*^9, 3.632087230070376*^9}, {
   3.632087323511203*^9, 3.6320873318324966`*^9}, 3.632087362446619*^9, {
   3.632149550862948*^9, 3.632149565406595*^9}},
 CellLabel->
  "In[414]:=",ExpressionUUID->"3dc5a952-c34e-4bf8-a44b-bee3178acaa5"],

Cell["Example. 90\[Degree] kites. Show Brocard points and circumcircles.", \
"Text",
 CellChangeTimes->{{3.62872380927934*^9, 3.62872381887883*^9}, {
  3.631896511175795*^9, 3.631896515295692*^9}, {3.63208654091508*^9, 
  3.632086549609699*^9}},ExpressionUUID->"488c89cf-b327-4990-9080-\
9fb08279faed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]1", ",", "\[Theta]2", ",", "angles", ",", "info1", ",", "info2",
       ",", "gfn"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]1", "=", 
      RowBox[{"60", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]2", "=", 
      RowBox[{"90", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{"\[Theta]1", ",", "\[Theta]2", ",", "Null", ",", "Null"}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"info1", "=", 
      RowBox[{"UnitCyclicBrocardQuadrilateralInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CCW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"info2", "=", 
      RowBox[{"UnitCyclicBrocardQuadrilateralInfo", "[", 
       RowBox[{"angles", ",", 
        RowBox[{"TwistDirection", "\[Rule]", "CW"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "info_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"AppendFirst", "[", 
              RowBox[{
              "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
              "]"}], "]"}], ",", "Black"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{
              "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
              ",", 
              RowBox[{
              "info", "\[LeftDoubleBracket]", "3", 
               "\[RightDoubleBracket]"}]}], "]"}], ",", "Green"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"#", ",", 
                 RowBox[{
                 "info", "\[LeftDoubleBracket]", "5", 
                  "\[RightDoubleBracket]"}]}], "}"}], "]"}], "&"}], "/@", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
             ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
             "]"}], ",", 
            RowBox[{"Darker", "[", "Green", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{
             "info", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}], 
             "]"}], ",", 
            RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"Frame", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", " ", 
         RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
             "info", "\[LeftDoubleBracket]", "6", "\[RightDoubleBracket]"}], "/",
              "\[Degree]"}], "//", "N"}], "]"}], "<>", "\"\<\\r\>\"", 
          "<>", "\"\<Corner angles/\[Degree] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
             "info", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}], "/",
              "\[Degree]"}], "//", "N"}], "]"}]}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "info1", "]"}], ",", 
        RowBox[{"gfn", "[", "info2", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.631469650981761*^9, 3.6314696520512238`*^9}, {3.631896522372604*^9, 
   3.631896585657536*^9}, {3.631896740304953*^9, 3.631896740776146*^9}, 
   3.631896814686269*^9, {3.632086351677274*^9, 3.63208641116031*^9}, {
   3.6320864560148907`*^9, 3.632086528938429*^9}, {3.632087255435614*^9, 
   3.632087295392936*^9}, 3.632092121973342*^9, {3.632149571383851*^9, 
   3.632149582926095*^9}, 3.632150118066739*^9},
 CellLabel->
  "In[415]:=",ExpressionUUID->"f8cc9c90-4b19-474c-a88b-1948fc2f40cf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitCyclicBrocardPolygonInfoCCW[",
 StyleBox["n, angle1, angle2, i1, i2",
  FontSlant->"Italic"],
 "]\nUnitCyclicBrocardPolygonInfoCW[",
 StyleBox["n, angle1, angle2, i1, i2",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.632149041286981*^9, 3.632149058287021*^9}, {
   3.633535112377786*^9, 3.633535112736658*^9}, {3.63353582211661*^9, 
   3.633535830123307*^9}, {3.633537867001195*^9, 3.633537872560129*^9}, {
   3.6335379323319607`*^9, 3.633537935115757*^9}, 
   3.633537975994933*^9},ExpressionUUID->"e3259db1-e6ca-4752-bd51-\
fabe6744918b"],

Cell[TextData[{
 "UnitCyclicBrocardPolygonInfoCCW[",
 StyleBox["n, angle1, angle2, i1, i2",
  FontSlant->"Italic"],
 "] returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the vertices ",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", circumcenter ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", circumradius ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", Brocard point ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", and Brocard angle \[Alpha] of a CCW (\[Alpha]\[Element](0,\[Pi]/2)) unit \
Brocard ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-gon that has concyclic vertices where the ",
 StyleBox["i1",
  FontSlant->"Italic"],
 "th corner angle is ",
 StyleBox["angle1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["i2",
  FontSlant->"Italic"],
 "th corner angle is ",
 StyleBox["angle2.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.63189577288864*^9, 3.631895824322875*^9}, {
  3.6320860025835533`*^9, 3.63208600437981*^9}, {3.632086037281715*^9, 
  3.632086110940962*^9}, {3.632087152467066*^9, 3.632087190080473*^9}, {
  3.6321489852947073`*^9, 3.632148985755299*^9}, {3.632149016913986*^9, 
  3.6321490287767344`*^9}, {3.6321490957039967`*^9, 3.632149101732361*^9}, {
  3.632149251498913*^9, 3.632149315270188*^9}, {3.63214935107572*^9, 
  3.632149361491554*^9}, {3.633535149927103*^9, 3.6335351669723*^9}, {
  3.633535204350705*^9, 3.633535222801099*^9}, {3.6335379424118433`*^9, 
  3.633537947187182*^9}, {3.633537985441727*^9, 
  3.633538045060652*^9}},ExpressionUUID->"93b7bd77-d4fb-42a6-8c4a-\
e2bd1cb39afb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicBrocardPolygonInfoCCW", "[", 
   RowBox[{"n_", ",", "angle1_", ",", "angle2_", ",", 
    RowBox[{"i1_", ":", "1"}], ",", 
    RowBox[{"i2_", ":", "2"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "q", ",", "\[Theta]", ",", "\[Alpha]", ",", "eqn", ",", "r1", ",", 
      "bctr", ",", "br", ",", "\[Phi]", ",", "verts", ",", "cctr", ",", "cr", 
      ",", "eqns", ",", "vars", ",", "addineq", ",", "qmin", ",", "qmax", ",",
       "soln"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]", "=", 
      RowBox[{"CompletePolygonAngles", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"q", "[", "i", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"angle", " ", "variables"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"eqn", "=", 
      RowBox[{
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"#", "-", "\[Alpha]"}], "]"}], "&"}], "/@", "\[Theta]"}], 
         ")"}]}], "==", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Alpha]", "]"}], "n"]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "now", " ", "construct", " ", "unit", " ", "polygon", " ", "vertices"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"r1", "=", 
      RowBox[{
       RowBox[{"Sin", "[", "\[Alpha]", "]"}], "/", 
       RowBox[{"Sin", "[", 
        RowBox[{
        "\[Theta]", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "radius", " ", "from", " ", "center", " ", "to", " ", "vertex", " ", 
       "1"}], " ", "*)"}], " ", "\[IndentingNewLine]", 
     RowBox[{"bctr", "=", 
      RowBox[{"r1", " ", 
       RowBox[{"U", "[", 
        RowBox[{
         RowBox[{
         "\[Theta]", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-",
          "\[Alpha]"}], "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"center", " ", "of", " ", "closure"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"br", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"Sin", "[", 
            RowBox[{"#2", "-", "\[Alpha]"}], "]"}], 
           RowBox[{"Sin", "[", "\[Alpha]", "]"}]], "#1"}], "&"}], ",", "r1", ",", 
        RowBox[{"Drop", "[", 
         RowBox[{"\[Theta]", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"(*", " ", 
      RowBox[{
      "angles", " ", "to", " ", "vertices", " ", "from", " ", "bctr"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{"Plus", ",", 
        RowBox[{
         RowBox[{
         "\[Theta]", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "-",
          "\[Alpha]", "-", "\[Pi]"}], ",", 
        RowBox[{"\[Pi]", "-", 
         RowBox[{"Drop", "[", 
          RowBox[{"\[Theta]", ",", 
           RowBox[{"-", "1"}]}], "]"}]}]}], "]"}]}], ";", 
     RowBox[{"verts", "=", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"bctr", "+", 
          RowBox[{"#1", " ", 
           RowBox[{"U", "[", "#2", "]"}]}]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"br", ",", "\[Phi]"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"set", " ", "these", " ", "to", " ", "exact", " ", "values"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"find", " ", "circumcenter", " ", "and", " ", "radius"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cctr", ",", "cr"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{"ConcyclicInfo", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"verts", ",", "3"}], "]"}], "]"}], ",", "2"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"eqns", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"eqn", ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mag2", "[", 
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
               "-", "cctr"}], "]"}], "\[Equal]", 
            SuperscriptBox["cr", "2"]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "4", ",", "n"}], "}"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"q", "[", "i1", "]"}], "\[Equal]", "angle1"}], ",", 
         RowBox[{
          RowBox[{"q", "[", "i2", "]"}], "\[Equal]", "angle2"}]}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vars", "=", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"q", "[", "i", "]"}], ",", 
            RowBox[{"\[Pi]", "-", 
             FractionBox[
              RowBox[{"2", "\[Pi]"}], "n"]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{
           FractionBox["\[Pi]", "2"], "-", 
           FractionBox["\[Pi]", "n"]}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"start", " ", "with", " ", "regular", " ", "n"}], "-", "gon"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"soln", "=", 
      RowBox[{"FindRoot", "@@", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", "eqns", "}"}], ",", "vars"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "verts", ",", "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",", 
        "\[Alpha]"}], "}"}], "/.", "soln"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.632150219338834*^9, 3.632150244067092*^9}, {
   3.632150330007702*^9, 3.632150337927593*^9}, {3.632150412475391*^9, 
   3.632150415203724*^9}, {3.632150475448728*^9, 3.632150496646637*^9}, 
   3.632150536572426*^9, {3.632150575577038*^9, 3.632150610871339*^9}, {
   3.632150641530072*^9, 3.6321506554654617`*^9}, {3.632153184914654*^9, 
   3.632153279358798*^9}, {3.632153311811366*^9, 3.632153368016264*^9}, {
   3.632153404463816*^9, 3.632153422060646*^9}, {3.632153499104756*^9, 
   3.632153518519456*^9}, {3.632153550974229*^9, 3.6321538141113997`*^9}, {
   3.632153916866598*^9, 3.632154018856378*^9}, {3.632163935331975*^9, 
   3.632163982263493*^9}, {3.632169998379306*^9, 3.632170000449341*^9}, {
   3.632170050129622*^9, 3.632170067255054*^9}, {3.632170897957065*^9, 
   3.6321710238012533`*^9}, {3.632171061405411*^9, 3.632171065175907*^9}, {
   3.632171148230499*^9, 3.632171148992514*^9}, {3.632171206281322*^9, 
   3.63217120703042*^9}, 3.6321712380768013`*^9, 3.63217136009375*^9, {
   3.632171398637799*^9, 3.6321714640183983`*^9}, {3.6321715038535013`*^9, 
   3.632171511139514*^9}, {3.632171552968395*^9, 3.632171572744781*^9}, {
   3.632172550368351*^9, 3.632172552140472*^9}, {3.6321728685348263`*^9, 
   3.6321729274453487`*^9}, {3.63217299934606*^9, 3.632173133066901*^9}, 
   3.6321731974159*^9, {3.632174320309994*^9, 3.63217445206356*^9}, {
   3.632174500498238*^9, 3.632174523920292*^9}, {3.632174585944458*^9, 
   3.632174604275835*^9}, 3.632175763266831*^9, {3.632175867948779*^9, 
   3.632175877468609*^9}, {3.632175922368103*^9, 3.632175938727087*^9}, {
   3.632224996175332*^9, 3.63222503461383*^9}, {3.6322250823518867`*^9, 
   3.632225239457192*^9}, {3.63222531439629*^9, 3.6322254014669867`*^9}, {
   3.632225435551569*^9, 3.6322254507104683`*^9}, 3.632225494042761*^9, {
   3.632225526927547*^9, 3.632225603334612*^9}, {3.632225634316506*^9, 
   3.632225699017661*^9}, {3.632225818782794*^9, 3.632225826601881*^9}, 
   3.632233079749769*^9, {3.6322331154649763`*^9, 3.632233128707998*^9}, {
   3.6322332395240927`*^9, 3.632233242235144*^9}, {3.632233276435651*^9, 
   3.632233279842783*^9}, {3.632238990215882*^9, 3.632238991244027*^9}, {
   3.632239531953993*^9, 3.6322396397339373`*^9}, {3.632239701194975*^9, 
   3.632239733892087*^9}, {3.633533471081125*^9, 3.633533473632568*^9}, {
   3.633533684062056*^9, 3.633533704140415*^9}, {3.633534363160061*^9, 
   3.633534377735276*^9}, {3.633534649382839*^9, 3.633534685509456*^9}, {
   3.633534886875873*^9, 3.633534914018602*^9}, {3.63353495159079*^9, 
   3.63353497844204*^9}, {3.633538052696479*^9, 3.633538110701079*^9}, {
   3.705603694035585*^9, 3.705603719118944*^9}, {3.705603805338109*^9, 
   3.705603815627788*^9}, {3.705603884214028*^9, 3.7056038926228857`*^9}, {
   3.705603925160675*^9, 3.705603933960575*^9}, {3.705604450620152*^9, 
   3.705604458153722*^9}, 3.705604953691179*^9, {3.705604992439032*^9, 
   3.705605092130525*^9}},
 CellLabel->
  "In[416]:=",ExpressionUUID->"30b5fa64-c876-46fb-a37a-849e091a0359"],

Cell["\<\
Example. A generic hexagon. Show the circumcenter and circumcircle and the \
Brocard point. Brocard angle for bottom edge is at vertex at {1,0}.\
\>", "Text",
 CellChangeTimes->{{3.633535342673539*^9, 3.63353534892069*^9}, {
  3.633535434652711*^9, 3.633535449026184*^9}, {3.6335362332481833`*^9, 
  3.6335362803906736`*^9}, {3.705605293863564*^9, 
  3.705605298064133*^9}},ExpressionUUID->"330f6749-8445-425d-b945-\
081ff4e901af"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]1", ",", "\[Theta]2", ",", "i1", ",", "i2", ",", "verts", ",", 
      "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",", "\[Alpha]"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]1", "=", 
      RowBox[{"110", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]2", "=", 
      RowBox[{"140", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"i1", "=", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"i2", "=", "3"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "verts", ",", "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",", 
        "\[Alpha]"}], "}"}], "=", 
      RowBox[{"UnitCyclicBrocardPolygonInfoCCW", "[", 
       RowBox[{
       "6", ",", "\[Theta]1", ",", "\[Theta]2", ",", "i1", ",", "i2"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"2", "\[Pi]"}], ",", 
        RowBox[{"-", "\[Pi]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", " ", 
      RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "/", "\[Degree]"}], "//", "N"}], "]"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Corner angles/\[Degree] = \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"\[Theta]", "/", "\[Degree]"}], "//", "N"}], "]"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"AppendFirst", "[", "verts", "]"}], "]"}], ",", "Black"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{"cctr", ",", "cr"}], "]"}], ",", 
           RowBox[{"Lighter", "[", "Blue", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"#", ",", "cctr"}], "}"}], "]"}], "&"}], "/@", 
            "verts"}], ",", 
           RowBox[{"Lighter", "[", "Blue", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"#", ",", "bctr"}], "}"}], "]"}], "&"}], "/@", 
            "verts"}], ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "cctr", "]"}], ",", 
           RowBox[{"Darker", "[", "Blue", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "bctr", "]"}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "False"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.631469650981761*^9, 3.6314696520512238`*^9}, {3.631896522372604*^9, 
   3.631896585657536*^9}, {3.631896740304953*^9, 3.631896740776146*^9}, 
   3.631896814686269*^9, {3.632086351677274*^9, 3.63208641116031*^9}, {
   3.6320864560148907`*^9, 3.632086528938429*^9}, {3.632087255435614*^9, 
   3.632087295392936*^9}, 3.632092121973342*^9, {3.632149571383851*^9, 
   3.632149582926095*^9}, 3.632150118066739*^9, {3.632153855719671*^9, 
   3.632153909293779*^9}, {3.632171305190218*^9, 3.632171308382295*^9}, {
   3.6321714796418133`*^9, 3.632171517221983*^9}, {3.632172531221692*^9, 
   3.632172533424046*^9}, {3.632172599157946*^9, 3.632172619604333*^9}, {
   3.632173237822047*^9, 3.6321733067767897`*^9}, {3.632173765378152*^9, 
   3.632173770190013*^9}, {3.632175497099807*^9, 3.632175534790475*^9}, {
   3.632175769691438*^9, 3.632175775901917*^9}, 3.632225687597191*^9, 
   3.632225834689466*^9, {3.6322332626356697`*^9, 3.632233267511651*^9}, 
   3.633466920515627*^9, {3.6334670311246223`*^9, 3.633467046043049*^9}, {
   3.633467086096776*^9, 3.633467092841539*^9}, {3.6334671233524113`*^9, 
   3.633467277019007*^9}, {3.633467356865262*^9, 3.633467445331894*^9}, {
   3.633534390023617*^9, 3.633534390225051*^9}, {3.633534434228344*^9, 
   3.633534449469531*^9}, {3.633534508223596*^9, 3.633534524662283*^9}, {
   3.633534761119866*^9, 3.63353485250323*^9}, {3.633535306268609*^9, 
   3.633535306470222*^9}, {3.633535377897003*^9, 3.633535426932914*^9}, {
   3.633535461928732*^9, 3.633535470120373*^9}, {3.633535661934371*^9, 
   3.633535702899942*^9}, 3.633536162445759*^9, {3.63353628333412*^9, 
   3.63353628494937*^9}, {3.633538116968324*^9, 3.633538140661468*^9}},
 CellLabel->
  "In[417]:=",ExpressionUUID->"397b2784-0104-44af-8143-5a9bb1c8ef4e"],

Cell[TextData[{
 "UnitCyclicBrocardPolygonInfoCW[",
 StyleBox["n, angle1, angle2, i1, i2",
  FontSlant->"Italic"],
 "] returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the vertices ",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", circumcenter ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", circumradius ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", Brocard point ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", and Brocard angle \[Alpha] of a CW (\[Alpha]\[Element](\[Pi]/2,\[Pi])) \
unit Brocard ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-gon that has concyclic vertices where the ",
 StyleBox["i1",
  FontSlant->"Italic"],
 "th corner angle is ",
 StyleBox["angle1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["i2",
  FontSlant->"Italic"],
 "th corner angle is ",
 StyleBox["angle2.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.63189577288864*^9, 3.631895824322875*^9}, {
  3.6320860025835533`*^9, 3.63208600437981*^9}, {3.632086037281715*^9, 
  3.632086110940962*^9}, {3.632087152467066*^9, 3.632087190080473*^9}, {
  3.6321489852947073`*^9, 3.632148985755299*^9}, {3.632149016913986*^9, 
  3.6321490287767344`*^9}, {3.6321490957039967`*^9, 3.632149101732361*^9}, {
  3.632149251498913*^9, 3.632149315270188*^9}, {3.63214935107572*^9, 
  3.632149361491554*^9}, {3.633535149927103*^9, 3.6335351669723*^9}, {
  3.633535204350705*^9, 3.633535222801099*^9}, {3.6335379424118433`*^9, 
  3.633537947187182*^9}, {3.633537985441727*^9, 3.633538045060652*^9}, {
  3.633538165230092*^9, 
  3.6335381720608683`*^9}},ExpressionUUID->"8506bab0-c70b-4471-a37b-\
d6603d63f540"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicBrocardPolygonInfoCW", "[", 
   RowBox[{"n_", ",", "angle1_", ",", "angle2_", ",", 
    RowBox[{"i1_", ":", "1"}], ",", 
    RowBox[{"i2_", ":", "2"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "q", ",", "\[Theta]", ",", "\[Alpha]", ",", "eqn", ",", "r1", ",", 
      "bctr", ",", "br", ",", "\[Phi]", ",", "verts", ",", "cctr", ",", "cr", 
      ",", "eqns", ",", "vars", ",", "addineq", ",", "qmin", ",", "qmax", ",",
       "soln"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]", "=", 
      RowBox[{"CompletePolygonAngles", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"q", "[", "i", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"angle", " ", "variables"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"eqn", "=", 
      RowBox[{
       RowBox[{"Times", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"#", "-", 
             RowBox[{"(", 
              RowBox[{"\[Pi]", "-", "\[Alpha]"}], ")"}]}], "]"}], "&"}], "/@",
           "\[Theta]"}], ")"}]}], "==", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Alpha]", "]"}], "n"]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "now", " ", "construct", " ", "unit", " ", "polygon", " ", "vertices"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"r1", "=", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{
         "\[Theta]", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "-", 
         RowBox[{"(", 
          RowBox[{"\[Pi]", "-", "\[Alpha]"}], ")"}]}], "]"}], "/", 
       RowBox[{"Sin", "[", 
        RowBox[{
        "\[Theta]", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
      "radius", " ", "from", " ", "center", " ", "to", " ", "vertex", " ", 
       "1"}], " ", "*)"}], " ", "\[IndentingNewLine]", 
     RowBox[{"bctr", "=", 
      RowBox[{"r1", " ", 
       RowBox[{"U", "[", 
        RowBox[{"\[Pi]", "-", "\[Alpha]"}], "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"center", " ", "of", " ", "closure"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"br", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox[
           RowBox[{"Sin", "[", 
            RowBox[{"\[Pi]", "-", "\[Alpha]"}], "]"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"#2", "-", 
             RowBox[{"(", 
              RowBox[{"\[Pi]", "-", "\[Alpha]"}], ")"}]}], "]"}]], "#1"}], 
         "&"}], ",", "r1", ",", 
        RowBox[{"Drop", "[", 
         RowBox[{"\[Theta]", ",", "1"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "absolute", " ", "angles", " ", "to", " ", "vertices", " ", "from", " ",
        "bctr"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"\[Phi]", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{"Plus", ",", 
        RowBox[{"-", "\[Alpha]"}], ",", 
        RowBox[{"\[Pi]", "-", 
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"RotateLeft", "[", "\[Theta]", "]"}], ",", 
           RowBox[{"-", "1"}]}], "]"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"verts", "=", 
      RowBox[{"MapThread", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"bctr", "+", 
          RowBox[{"#1", " ", 
           RowBox[{"U", "[", "#2", "]"}]}]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"br", ",", "\[Phi]"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
       "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"set", " ", "these", " ", "to", " ", "exact", " ", "values"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"find", " ", "circumcenter", " ", "and", " ", "radius"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cctr", ",", "cr"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{
        RowBox[{"ConcyclicInfo", "[", 
         RowBox[{"Take", "[", 
          RowBox[{"verts", ",", "3"}], "]"}], "]"}], ",", "2"}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"eqns", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"eqn", ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Mag2", "[", 
             RowBox[{
              RowBox[{
              "verts", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}],
               "-", "cctr"}], "]"}], "\[Equal]", 
            SuperscriptBox["cr", "2"]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "4", ",", "n"}], "}"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"q", "[", "i1", "]"}], "\[Equal]", "angle1"}], ",", 
         RowBox[{
          RowBox[{"q", "[", "i2", "]"}], "\[Equal]", "angle2"}]}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vars", "=", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"q", "[", "i", "]"}], ",", 
            RowBox[{"\[Pi]", "-", 
             FractionBox[
              RowBox[{"2", "\[Pi]"}], "n"]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{
           FractionBox["\[Pi]", "2"], "+", 
           FractionBox["\[Pi]", "n"]}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"start", " ", "with", " ", "regular", " ", "n"}], "-", "gon"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"soln", "=", 
      RowBox[{"FindRoot", "@@", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", "eqns", "}"}], ",", "vars"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "verts", ",", "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",", 
        "\[Alpha]"}], "}"}], "/.", "soln"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.632150219338834*^9, 3.632150244067092*^9}, {
   3.632150330007702*^9, 3.632150337927593*^9}, {3.632150412475391*^9, 
   3.632150415203724*^9}, {3.632150475448728*^9, 3.632150496646637*^9}, 
   3.632150536572426*^9, {3.632150575577038*^9, 3.632150610871339*^9}, {
   3.632150641530072*^9, 3.6321506554654617`*^9}, {3.632153184914654*^9, 
   3.632153279358798*^9}, {3.632153311811366*^9, 3.632153368016264*^9}, {
   3.632153404463816*^9, 3.632153422060646*^9}, {3.632153499104756*^9, 
   3.632153518519456*^9}, {3.632153550974229*^9, 3.6321538141113997`*^9}, {
   3.632153916866598*^9, 3.632154018856378*^9}, {3.632163935331975*^9, 
   3.632163982263493*^9}, {3.632169998379306*^9, 3.632170000449341*^9}, {
   3.632170050129622*^9, 3.632170067255054*^9}, {3.632170897957065*^9, 
   3.6321710238012533`*^9}, {3.632171061405411*^9, 3.632171065175907*^9}, {
   3.632171148230499*^9, 3.632171148992514*^9}, {3.632171206281322*^9, 
   3.63217120703042*^9}, 3.6321712380768013`*^9, 3.63217136009375*^9, {
   3.632171398637799*^9, 3.6321714640183983`*^9}, {3.6321715038535013`*^9, 
   3.632171511139514*^9}, {3.632171552968395*^9, 3.632171572744781*^9}, {
   3.632172550368351*^9, 3.632172552140472*^9}, {3.6321728685348263`*^9, 
   3.6321729274453487`*^9}, {3.63217299934606*^9, 3.632173133066901*^9}, 
   3.6321731974159*^9, {3.632174320309994*^9, 3.63217445206356*^9}, {
   3.632174500498238*^9, 3.632174523920292*^9}, {3.632174585944458*^9, 
   3.632174604275835*^9}, 3.632175763266831*^9, {3.632175867948779*^9, 
   3.632175877468609*^9}, {3.632175922368103*^9, 3.632175938727087*^9}, {
   3.632224996175332*^9, 3.63222503461383*^9}, {3.6322250823518867`*^9, 
   3.632225239457192*^9}, {3.63222531439629*^9, 3.6322254014669867`*^9}, {
   3.632225435551569*^9, 3.6322254507104683`*^9}, 3.632225494042761*^9, {
   3.632225526927547*^9, 3.632225603334612*^9}, {3.632225634316506*^9, 
   3.632225699017661*^9}, {3.632225818782794*^9, 3.632225826601881*^9}, 
   3.632233079749769*^9, {3.6322331154649763`*^9, 3.632233128707998*^9}, {
   3.6322332395240927`*^9, 3.632233242235144*^9}, {3.632233276435651*^9, 
   3.632233279842783*^9}, {3.632238990215882*^9, 3.632238991244027*^9}, {
   3.632239531953993*^9, 3.6322396397339373`*^9}, {3.632239701194975*^9, 
   3.632239733892087*^9}, {3.633533471081125*^9, 3.633533473632568*^9}, {
   3.633533684062056*^9, 3.633533704140415*^9}, {3.633534363160061*^9, 
   3.633534377735276*^9}, {3.633534649382839*^9, 3.633534685509456*^9}, {
   3.633534886875873*^9, 3.633534914018602*^9}, {3.63353495159079*^9, 
   3.63353497844204*^9}, 3.633535887890458*^9, {3.633535928393717*^9, 
   3.633536006059149*^9}, 3.633536089054688*^9, {3.6335381907555513`*^9, 
   3.633538205871303*^9}, {3.705605108027903*^9, 3.705605153888904*^9}},
 CellLabel->
  "In[418]:=",ExpressionUUID->"ae62c491-cacf-4cd9-83af-b2fce02a34a1"],

Cell["\<\
Example. A generic hexagon. Show the circumcenter and circumcircle and the \
Brocard point. Brocard angle for bottom edge is at vertex at {0,0}.\
\>", "Text",
 CellChangeTimes->{{3.633535342673539*^9, 3.63353534892069*^9}, {
  3.633535434652711*^9, 3.633535449026184*^9}, {3.633536242687874*^9, 
  3.633536275477579*^9}, {3.705605305119953*^9, 
  3.705605307865855*^9}},ExpressionUUID->"4b3b7260-8d2f-49e0-8857-\
ed3f6d95e929"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]1", ",", "\[Theta]2", ",", "i1", ",", "i2", ",", "angles", ",", 
      "verts", ",", "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",", 
      "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]1", "=", 
      RowBox[{"110", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]2", "=", 
      RowBox[{"140", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"i1", "=", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"i2", "=", "3"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "verts", ",", "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",", 
        "\[Alpha]"}], "}"}], "=", 
      RowBox[{"UnitCyclicBrocardPolygonInfoCW", "[", 
       RowBox[{
       "6", ",", "\[Theta]1", ",", "\[Theta]2", ",", "i1", ",", "i2"}], 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]", "=", 
      RowBox[{"Mod", "[", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"2", "\[Pi]"}], ",", 
        RowBox[{"-", "\[Pi]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", " ", 
      RowBox[{"\"\<Brocard angle/\[Degree] = \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "/", "\[Degree]"}], "//", "N"}], "]"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Corner angles/\[Degree] = \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"\[Theta]", "/", "\[Degree]"}], "//", "N"}], "]"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"AppendFirst", "[", "verts", "]"}], "]"}], ",", "Black"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{"cctr", ",", "cr"}], "]"}], ",", 
           RowBox[{"Lighter", "[", "Blue", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"#", ",", "cctr"}], "}"}], "]"}], "&"}], "/@", 
            "verts"}], ",", 
           RowBox[{"Lighter", "[", "Blue", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"#", ",", "bctr"}], "}"}], "]"}], "&"}], "/@", 
            "verts"}], ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "cctr", "]"}], ",", 
           RowBox[{"Darker", "[", "Blue", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "bctr", "]"}], ",", 
           RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Frame", "\[Rule]", "False"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.631469650981761*^9, 3.6314696520512238`*^9}, {3.631896522372604*^9, 
   3.631896585657536*^9}, {3.631896740304953*^9, 3.631896740776146*^9}, 
   3.631896814686269*^9, {3.632086351677274*^9, 3.63208641116031*^9}, {
   3.6320864560148907`*^9, 3.632086528938429*^9}, {3.632087255435614*^9, 
   3.632087295392936*^9}, 3.632092121973342*^9, {3.632149571383851*^9, 
   3.632149582926095*^9}, 3.632150118066739*^9, {3.632153855719671*^9, 
   3.632153909293779*^9}, {3.632171305190218*^9, 3.632171308382295*^9}, {
   3.6321714796418133`*^9, 3.632171517221983*^9}, {3.632172531221692*^9, 
   3.632172533424046*^9}, {3.632172599157946*^9, 3.632172619604333*^9}, {
   3.632173237822047*^9, 3.6321733067767897`*^9}, {3.632173765378152*^9, 
   3.632173770190013*^9}, {3.632175497099807*^9, 3.632175534790475*^9}, {
   3.632175769691438*^9, 3.632175775901917*^9}, 3.632225687597191*^9, 
   3.632225834689466*^9, {3.6322332626356697`*^9, 3.632233267511651*^9}, 
   3.633466920515627*^9, {3.6334670311246223`*^9, 3.633467046043049*^9}, {
   3.633467086096776*^9, 3.633467092841539*^9}, {3.6334671233524113`*^9, 
   3.633467277019007*^9}, {3.633467356865262*^9, 3.633467445331894*^9}, {
   3.633534390023617*^9, 3.633534390225051*^9}, {3.633534434228344*^9, 
   3.633534449469531*^9}, {3.633534508223596*^9, 3.633534524662283*^9}, {
   3.633534761119866*^9, 3.63353485250323*^9}, {3.633535306268609*^9, 
   3.633535306470222*^9}, {3.633535377897003*^9, 3.633535426932914*^9}, {
   3.633535461928732*^9, 3.633535470120373*^9}, {3.633535661934371*^9, 
   3.633535702899942*^9}, 3.633536033821957*^9, {3.633536072945421*^9, 
   3.633536102847677*^9}, 3.633536157980191*^9, {3.633536308619375*^9, 
   3.633536310404193*^9}, {3.633538214065296*^9, 3.633538232959426*^9}},
 CellLabel->
  "In[419]:=",ExpressionUUID->"bb113d36-201b-4a36-b205-96f2cdc5aae2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitCyclicBrocardPolygonInfo[",
 StyleBox["n, angle1, angle2, i1, i2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["opts",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.632149041286981*^9, 3.632149058287021*^9}, 
   3.633538254912878*^9, {3.701379143530642*^9, 3.7013791479954457`*^9}, {
   3.701382275014717*^9, 3.701382275228984*^9}, 
   3.705605340377013*^9},ExpressionUUID->"e794580e-1b1f-4a2d-ab51-\
77555ed9cfd3"],

Cell[TextData[{
 "UnitCyclicBrocardPolygonInfo[",
 StyleBox["n, angle1, angle2, i1, i2",
  FontSlant->"Italic"],
 "] returns a list {",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", \[Alpha]} of the vertices ",
 StyleBox["verts",
  FontSlant->"Italic"],
 ", circumcenter ",
 StyleBox["cctr",
  FontSlant->"Italic"],
 ", circumradius ",
 StyleBox["r",
  FontSlant->"Italic"],
 ", Brocard point ",
 StyleBox["bctr",
  FontSlant->"Italic"],
 ", and Brocard angle \[Alpha] of a unit Brocard ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-gon that has concyclic vertices where the ",
 StyleBox["i1",
  FontSlant->"Italic"],
 "th corner angle is ",
 StyleBox["angle1",
  FontSlant->"Italic"],
 " and ",
 StyleBox["i2",
  FontSlant->"Italic"],
 "th corner angle is ",
 StyleBox["angle2. ",
  FontSlant->"Italic"],
 "Options are:\n\tTwistDirection\[Rule]CCW | CW, specifies the twist \
direction."
}], "Text",
 CellChangeTimes->{{3.63189577288864*^9, 3.631895824322875*^9}, {
  3.6320860025835533`*^9, 3.63208600437981*^9}, {3.632086037281715*^9, 
  3.632086110940962*^9}, {3.632087152467066*^9, 3.632087190080473*^9}, {
  3.6321489852947073`*^9, 3.632148985755299*^9}, {3.632149016913986*^9, 
  3.6321490287767344`*^9}, {3.6321490957039967`*^9, 3.632149101732361*^9}, {
  3.632149251498913*^9, 3.632149315270188*^9}, {3.63214935107572*^9, 
  3.632149361491554*^9}, {3.633535149927103*^9, 3.6335351669723*^9}, {
  3.633535204350705*^9, 3.633535222801099*^9}, {3.6335379424118433`*^9, 
  3.633537947187182*^9}, {3.633537985441727*^9, 3.633538045060652*^9}, {
  3.633538165230092*^9, 3.6335381720608683`*^9}, {3.633538273447268*^9, 
  3.6335382869413443`*^9}},ExpressionUUID->"dd1d5d18-aa8a-4e30-845a-\
79f00e64fe44"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitCyclicBrocardPolygonInfo", "::", "baddir"}], 
   "=", "\"\<Twist direction `1` must be CCW or CW.\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.629129514425538*^9, 3.629129543765858*^9}, {
   3.629129882178124*^9, 3.629129895704105*^9}, 3.629131640152631*^9, 
   3.631469638952745*^9, 3.632080645186163*^9, 3.632082198881264*^9, 
   3.633536507131476*^9},
 CellLabel->
  "In[420]:=",ExpressionUUID->"6bcaaeb4-eb15-40d7-8f1b-50678af4df41"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitCyclicBrocardPolygonInfo", "[", 
   RowBox[{"n_", ",", "angle1_", ",", "angle2_", ",", 
    RowBox[{"i1_", ":", "1"}], ",", 
    RowBox[{"i2_", ":", "2"}], ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "td", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"td", "=", 
      RowBox[{
       RowBox[{"TwistDirection", "/.", 
        RowBox[{"{", "opts", "}"}]}], "/.", 
       RowBox[{"Options", "[", "UnitBrocardPolygonInfo", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Switch", "[", 
      RowBox[{"td", ",", "\[IndentingNewLine]", "CCW", ",", 
       RowBox[{"UnitCyclicBrocardPolygonInfoCCW", "[", 
        RowBox[{"n", ",", "angle1", ",", "angle2", ",", "i1", ",", "i2"}], 
        "]"}], ",", "\[IndentingNewLine]", "CW", ",", 
       RowBox[{"UnitCyclicBrocardPolygonInfoCW", "[", 
        RowBox[{"n", ",", "angle1", ",", "angle2", ",", "i1", ",", "i2"}], 
        "]"}], ",", "\[IndentingNewLine]", "_", ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"UnitCyclicBrocardPolygonInfo", "::", "baddir"}], ",", 
          "td"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.632150219338834*^9, 3.632150244067092*^9}, {
   3.632150330007702*^9, 3.632150337927593*^9}, {3.632150412475391*^9, 
   3.632150415203724*^9}, {3.632150475448728*^9, 3.632150496646637*^9}, 
   3.632150536572426*^9, {3.632150575577038*^9, 3.632150610871339*^9}, {
   3.632150641530072*^9, 3.6321506554654617`*^9}, {3.633536334513362*^9, 
   3.633536408107563*^9}, {3.633536473238097*^9, 3.63353650850275*^9}, {
   3.6335383142666473`*^9, 3.633538341391786*^9}},
 CellLabel->
  "In[421]:=",ExpressionUUID->"4f5c23bc-9098-4e0c-bfdb-a71a818d517f"],

Cell["Example. Show CW and CCW pentagons.", "Text",
 CellChangeTimes->{{3.633536519703722*^9, 
  3.633536531813306*^9}},ExpressionUUID->"eb1b7b3d-ee3c-49e4-b342-\
5fb401a6cf5b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\[Theta]1", ",", "\[Theta]2", ",", "i1", ",", "i2", ",", "gfn"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"\[Theta]1", "=", 
      RowBox[{"110", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Theta]2", "=", 
      RowBox[{"140", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"i1", "=", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"i2", "=", "3"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gfn", "[", "dir_", "]"}], ":=", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "verts", ",", "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",", 
          "\[Alpha]"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "verts", ",", "cctr", ",", "cr", ",", "\[Theta]", ",", "bctr", ",",
             "\[Alpha]"}], "}"}], "=", 
          RowBox[{"UnitCyclicBrocardPolygonInfo", "[", 
           RowBox[{
           "5", ",", "\[Theta]1", ",", "\[Theta]2", ",", "i1", ",", "i2", ",", 
            RowBox[{"TwistDirection", "\[Rule]", "dir"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"\[Theta]", "=", 
          RowBox[{"Mod", "[", 
           RowBox[{"\[Theta]", ",", 
            RowBox[{"2", "\[Pi]"}], ",", 
            RowBox[{"-", "\[Pi]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", " ", 
          RowBox[{
           RowBox[{"ToString", "[", "dir", "]"}], 
           ",", "\"\<: Brocard angle/\[Degree] = \>\"", ",", 
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"\[Alpha]", "/", "\[Degree]"}], "//", "N"}], "]"}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", 
          RowBox[{
           RowBox[{"ToString", "[", "dir", "]"}], 
           ",", "\"\<: Corner angles/\[Degree] = \>\"", ",", 
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"\[Theta]", "/", "\[Degree]"}], "//", "N"}], "]"}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"AppendFirst", "[", "verts", "]"}], "]"}], ",", 
               "Black"}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Circle", "[", 
                RowBox[{"cctr", ",", "cr"}], "]"}], ",", 
               RowBox[{"Lighter", "[", "Blue", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{"#", ",", "cctr"}], "}"}], "]"}], "&"}], "/@", 
                "verts"}], ",", 
               RowBox[{"Lighter", "[", "Blue", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{"#", ",", "bctr"}], "}"}], "]"}], "&"}], "/@", 
                "verts"}], ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "[", "cctr", "]"}], ",", 
               RowBox[{"Darker", "[", "Blue", "]"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Point", "[", "bctr", "]"}], ",", 
               RowBox[{"Darker", "[", "Red", "]"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "False"}], ",", 
           RowBox[{"Axes", "\[Rule]", "True"}], ",", 
           RowBox[{"PlotLabel", "\[Rule]", 
            RowBox[{"ToString", "[", "dir", "]"}]}]}], "]"}]}]}], "]"}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gfn", "[", "CCW", "]"}], ",", 
        RowBox[{"gfn", "[", "CW", "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.628709241227737*^9, 3.628709261795113*^9}, {
   3.628709369195771*^9, 3.628709438768053*^9}, {3.628715148466177*^9, 
   3.628715155930793*^9}, {3.628715367595931*^9, 3.628715526482132*^9}, {
   3.628717467791655*^9, 3.628717483900696*^9}, {3.628717522621991*^9, 
   3.628717525027079*^9}, {3.62872293499326*^9, 3.62872294056795*^9}, {
   3.628723099406774*^9, 3.628723108461956*^9}, 3.6287231805408697`*^9, 
   3.628723215753614*^9, {3.628723299546214*^9, 3.628723415850993*^9}, {
   3.628723477094182*^9, 3.628723478413952*^9}, {3.628723655932304*^9, 
   3.628723659199089*^9}, {3.628723781277317*^9, 3.628723784961607*^9}, {
   3.628724425626158*^9, 3.628724460394103*^9}, 3.628724994184537*^9, {
   3.631469650981761*^9, 3.6314696520512238`*^9}, {3.631896522372604*^9, 
   3.631896585657536*^9}, {3.631896740304953*^9, 3.631896740776146*^9}, 
   3.631896814686269*^9, {3.632086351677274*^9, 3.63208641116031*^9}, {
   3.6320864560148907`*^9, 3.632086528938429*^9}, {3.632087255435614*^9, 
   3.632087295392936*^9}, 3.632092121973342*^9, {3.632149571383851*^9, 
   3.632149582926095*^9}, 3.632150118066739*^9, {3.632153855719671*^9, 
   3.632153909293779*^9}, {3.632171305190218*^9, 3.632171308382295*^9}, {
   3.6321714796418133`*^9, 3.632171517221983*^9}, {3.632172531221692*^9, 
   3.632172533424046*^9}, {3.632172599157946*^9, 3.632172619604333*^9}, {
   3.632173237822047*^9, 3.6321733067767897`*^9}, {3.632173765378152*^9, 
   3.632173770190013*^9}, {3.632175497099807*^9, 3.632175534790475*^9}, {
   3.632175769691438*^9, 3.632175775901917*^9}, 3.632225687597191*^9, 
   3.632225834689466*^9, {3.6322332626356697`*^9, 3.632233267511651*^9}, 
   3.633466920515627*^9, {3.6334670311246223`*^9, 3.633467046043049*^9}, {
   3.633467086096776*^9, 3.633467092841539*^9}, {3.6334671233524113`*^9, 
   3.633467277019007*^9}, {3.633467356865262*^9, 3.633467445331894*^9}, {
   3.633534390023617*^9, 3.633534390225051*^9}, {3.633534434228344*^9, 
   3.633534449469531*^9}, {3.633534508223596*^9, 3.633534524662283*^9}, {
   3.633534761119866*^9, 3.63353485250323*^9}, {3.633535306268609*^9, 
   3.633535306470222*^9}, {3.633535377897003*^9, 3.633535426932914*^9}, {
   3.633535461928732*^9, 3.633535470120373*^9}, {3.633535661934371*^9, 
   3.633535702899942*^9}, 3.633536033821957*^9, {3.633536072945421*^9, 
   3.633536102847677*^9}, 3.633536157980191*^9, {3.633536308619375*^9, 
   3.633536310404193*^9}, {3.633536563164659*^9, 3.63353674007898*^9}, {
   3.633538357290251*^9, 3.633538401541963*^9}, {3.701380031734001*^9, 
   3.70138004369022*^9}, {3.705605326133556*^9, 3.705605336783334*^9}},
 CellLabel->
  "In[422]:=",ExpressionUUID->"c26f6628-9433-43ce-b0a4-e7d6546855e3"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit equilateral polygons", "Subsection",
 CellChangeTimes->{{3.631092731277279*^9, 3.631092735914654*^9}, 
   3.708400987940646*^9},ExpressionUUID->"a78485c5-ee90-4ca2-bcda-\
c708ce8001c5"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.631092746898581*^9, 
  3.631092747314148*^9}},ExpressionUUID->"0b0c967c-bb9b-434f-a2a2-\
d5d24b248dfd"],

Cell["\<\
Equilateral pentagons arise in certain edge-to-edge tilings, and they are \
most readily specified by their corner angles.\
\>", "Text",
 CellChangeTimes->{{3.631092749124055*^9, 3.631092754481447*^9}, {
  3.6310928029186707`*^9, 
  3.63109288249761*^9}},ExpressionUUID->"27d5855d-5555-447a-af2a-\
768828ad03b2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "EquilateralPolygonClosure[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.63110318043773*^9, 3.63110318623737*^9}, 
   3.631103277238791*^9},ExpressionUUID->"4ae138da-dea8-40cd-b95c-\
a3c0af9fcacf"],

Cell[TextData[{
 "EquilateralPolygonClosure[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "] returns a pair {dx,dy} that captures the closure condition for a set of \
angles to give rise to an equilateral polygon with the specified corner \
angles; the polygon with those corner angles is equilateral if and only if \
both dx and dy are equal to zero. This can be used to solve for specific \
corner angles."
}], "Text",
 CellChangeTimes->{{3.631103216910269*^9, 3.631103281606593*^9}, {
  3.631103320275923*^9, 
  3.631103404814658*^9}},ExpressionUUID->"dee2d4d4-529e-4a24-9494-\
3da9180e500d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"EquilateralPolygonClosure", "[", "angles_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ba", ",", "aa", ",", "verts"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ba", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Pi]", "-", "#"}], "&"}], "/@", "angles"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"bend", " ", "angles"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"aa", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{"Plus", ",", "0", ",", 
        RowBox[{"RotateRight", "[", "ba", "]"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"absolute", " ", "angles"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"verts", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#1", "+", 
          RowBox[{"U", "[", "#2", "]"}]}], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"Drop", "[", 
         RowBox[{"aa", ",", 
          RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"vertices", " ", "of", " ", "a", " ", "unit", " ", "polygon"}], 
      " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"verts", "\[LeftDoubleBracket]", 
       RowBox[{"-", "1"}], "\[RightDoubleBracket]"}], "-", 
      RowBox[{
      "verts", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.631103201349717*^9, 3.631103207239758*^9}, 
   3.631103297519994*^9, {3.631103422586925*^9, 3.631103478136937*^9}, {
   3.631120808189502*^9, 3.631120826786838*^9}, {3.631120861893986*^9, 
   3.63112088282794*^9}, {3.631120934386288*^9, 3.631120952400164*^9}, {
   3.631121405038431*^9, 3.631121408941608*^9}},
 CellLabel->
  "In[423]:=",ExpressionUUID->"2ab87ce8-8478-427a-a259-6dc669e7b960"],

Cell["Example. A regular pentagon.", "Text",
 CellChangeTimes->{{3.631103481723165*^9, 
  3.631103489565242*^9}},ExpressionUUID->"c0fe779b-64aa-45a8-95cc-\
e0ed10be28f8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "verts"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Simplify", "[", 
      RowBox[{"EquilateralPolygonClosure", "[", "angles", "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.631103507917358*^9, 3.631103551783294*^9}, {
  3.631103589667802*^9, 3.63110359228633*^9}},
 CellLabel->
  "In[424]:=",ExpressionUUID->"7b999d05-0c3e-4e89-a40a-cbcf4f260468"],

Cell["Example. A Cairo tiling pentagon (symbolic expression).", "Text",
 CellChangeTimes->{{3.631103596122839*^9, 3.6311036043615*^9}, {
  3.6311214266002893`*^9, 
  3.631121430455419*^9}},ExpressionUUID->"9a515c55-3342-4e3f-b841-\
7de417cd75a1"],

Cell[BoxData[
 RowBox[{"foovals", "=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"angles", ",", "verts"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"angles", "=", 
       RowBox[{"CompletePolygonAngles", "[", 
        RowBox[{"{", 
         RowBox[{"\[Delta]1", ",", "\[Delta]2", ",", "\[Delta]3", ",", 
          RowBox[{"\[Pi]", "-", "\[Delta]1"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Simplify", "[", 
       RowBox[{"EquilateralPolygonClosure", "[", "angles", "]"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]}]], "Input",
 CellChangeTimes->{{3.631103507917358*^9, 3.631103551783294*^9}, {
  3.631103589667802*^9, 3.63110359228633*^9}, {3.631103628931682*^9, 
  3.631103666040528*^9}, {3.631121067393042*^9, 3.631121084688476*^9}},
 CellLabel->
  "In[425]:=",ExpressionUUID->"07e08743-5015-4f01-a7d4-3506e7ecfa87"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitEquilateralPolygonVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.631092905207981*^9, 3.631092915447336*^9}, {
  3.631103418247843*^9, 
  3.631103419719215*^9}},ExpressionUUID->"304c7ead-77e5-448d-a641-\
b85a9d9c1457"],

Cell[TextData[{
 "UnitEquilateralPolygonVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "] returns a list of the vertices of a unit equilateral pentagon with the \
specified corner angles. Note that if you don\[CloseCurlyQuote]t specify a \
proper set of corner angles, it won\[CloseCurlyQuote]t be equilateral and no \
warning will be issued."
}], "Text",
 CellChangeTimes->{{3.631092947458234*^9, 3.63109296748386*^9}, {
  3.631098828892908*^9, 
  3.631098894654185*^9}},ExpressionUUID->"6d9f741a-0bad-444e-b201-\
b17c9bae9d47"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitEquilateralPolygonVertices", "[", "angles_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ba", ",", "aa"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ba", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Pi]", "-", "#"}], "&"}], "/@", 
       RowBox[{"Drop", "[", 
        RowBox[{"angles", ",", "1"}], "]"}]}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"bend", " ", "angles"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"aa", "=", 
      RowBox[{"FoldList", "[", 
       RowBox[{"Plus", ",", "0", ",", "ba"}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"absolute", " ", "angles"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"FoldList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"#1", "+", 
         RowBox[{"U", "[", "#2", "]"}]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Drop", "[", 
        RowBox[{"aa", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.631092932832315*^9, 3.631092941071929*^9}, {
  3.631092985469188*^9, 3.631092987734972*^9}, {3.631093056057263*^9, 
  3.631093127004184*^9}, {3.6310973161133966`*^9, 3.631097318790066*^9}, {
  3.63109736314942*^9, 3.631097376425524*^9}, {3.631097415170539*^9, 
  3.631097472227523*^9}, {3.631098614571273*^9, 3.631098688614616*^9}},
 CellLabel->
  "In[426]:=",ExpressionUUID->"0804248f-6f4a-4809-98d5-976c204d24cb"],

Cell["Example. Regular pentagon.", "Text",
 CellChangeTimes->{{3.631097474914169*^9, 3.631097475680341*^9}, {
  3.631121966739023*^9, 
  3.631121970194875*^9}},ExpressionUUID->"48c3ce2a-626d-4fbc-a769-\
c10cb96855b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"angles", ",", "verts"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"angles", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}], ",", 
        RowBox[{"108", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"verts", "=", 
      RowBox[{"UnitEquilateralPolygonVertices", "[", "angles", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", 
       RowBox[{"AppendFirst", "[", "verts", "]"}], "]"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.631097479993168*^9, 3.6310974814912233`*^9}, {
   3.631098516082036*^9, 3.631098604889781*^9}, 3.631121964128275*^9},
 CellLabel->
  "In[427]:=",ExpressionUUID->"b18d7dee-8a9b-4f9b-a3bc-3f9ad42f3010"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit regular polygons", "Subsection",
 CellChangeTimes->{{3.4577121885958433`*^9, 3.457712189953725*^9}, {
   3.4579202479961653`*^9, 3.457920248607415*^9}, 3.457920319464107*^9, {
   3.595975220144129*^9, 3.595975222382164*^9}, {3.62733972067495*^9, 
   3.627339721465081*^9}, 3.6285218167415137`*^9, 
   3.7084009847242937`*^9},ExpressionUUID->"39f89da8-6de9-4859-9277-\
85b64da6b176"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.457703099214657*^9, 
  3.4577030996209297`*^9}},ExpressionUUID->"1dd3f2b4-5604-4d05-8b0a-\
5691d62613af"],

Cell[TextData[{
 "UnitRegularPolygon",
 " functions return information about a unit polygon with ",
 StyleBox["n",
  FontSlant->"Italic"],
 " sides. By definition, one vertex is at the origin, one vertex is on the ",
 StyleBox["x",
  FontSlant->"Italic"],
 " axis (so is at {1,0}), and the entire polygon lies in the upper half plane."
}], "Text",
 CellChangeTimes->{{3.5894659011473*^9, 3.58946590587402*^9}, 
   3.627339699576158*^9},ExpressionUUID->"8143cf75-0978-416f-9b38-\
165152e75d86"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitRegularPolygonCenter[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]\nUnitRegularPolygonInteriorAngle[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]\nUnitRegularPolygonRotationAngle[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]\nUnitRegularPolygonInradius[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]\nUnitRegularPolygonCircumradius[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]\nUnitRegularPolygonVertex[",
 StyleBox["j",
  FontSlant->"Italic"],
 ", ",
 StyleBox["n",
  FontSlant->"Italic"],
 "]\n",
 "UnitRegularPolygon",
 "Vertices[",
 StyleBox["n",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.457920650766198*^9, 3.457920671957011*^9}, {
  3.462294583578731*^9, 3.462294589856713*^9}, {3.627339699699005*^9, 
  3.627339700478207*^9}},ExpressionUUID->"53e0d549-a22b-486b-a8e6-\
7f518d0d86b8"],

Cell[TextData[{
 "UnitRegularPolygon",
 "Center[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns the point at the center of the unit ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-gon."
}], "Text",
 CellChangeTimes->{
  3.627339700609725*^9},ExpressionUUID->"08c7c548-9099-487d-9265-\
b6dc71d42390"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularPolygonCenter", "[", "n_", "]"}], ":=", 
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", 
      RowBox[{"Cot", "[", 
       FractionBox["\[Pi]", "n"], "]"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{3.627339700703347*^9},
 CellLabel->
  "In[428]:=",ExpressionUUID->"84fe8fc1-4fad-48f8-a1ca-314dc3e35a3d"],

Cell[TextData[{
 "UnitRegularPolygon",
 "InteriorAngle[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns the interior angle at a vertex of a unit ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-gon."
}], "Text",
 CellChangeTimes->{
  3.627339700821129*^9},ExpressionUUID->"2d6192cd-b73e-4b41-872b-\
6ecc7fa7fcc4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularPolygonInteriorAngle", "[", "n_", "]"}], " ", ":=", 
   RowBox[{
    FractionBox["\[Pi]", "2"], "-", " ", 
    FractionBox["\[Pi]", "n"]}]}], ";"}]], "Input",
 CellChangeTimes->{3.627339700920298*^9},
 CellLabel->
  "In[429]:=",ExpressionUUID->"63063966-de0d-4499-929c-091742dd40ce"],

Cell[TextData[{
 "UnitRegularPolygon",
 "RotationAngle[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns 1/",
 StyleBox["n",
  FontSlant->"Italic"],
 "th of a circle, which is the rotation angle under which the unit polygon \
remains unchanged."
}], "Text",
 CellChangeTimes->{
  3.627339701043807*^9},ExpressionUUID->"01c5ce90-e04f-4048-8bc5-\
35de920bec88"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularPolygonRotationAngle", "[", "n_", "]"}], " ", ":=", 
   " ", 
   FractionBox[
    RowBox[{"2", "\[Pi]"}], "n"]}], ";"}]], "Input",
 CellChangeTimes->{3.627339701138315*^9},
 CellLabel->
  "In[430]:=",ExpressionUUID->"0acf9a84-0f6e-40ef-a673-851f3275d0f2"],

Cell[TextData[{
 "UnitRegularPolygon",
 "Inradius[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns the inradius (radius of inscribed circle) of the given unit \
polygon."
}], "Text",
 CellChangeTimes->{{3.462294596680417*^9, 3.462294616926903*^9}, 
   3.627339701258079*^9},ExpressionUUID->"cea27c0d-540b-41a3-b4b1-\
ecf82cef178f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularPolygonInradius", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"UnitRegularPolygonInradius", "[", "n", "]"}], "=", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"Cot", "[", 
      FractionBox["\[Pi]", "n"], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.462294623544668*^9, 3.46229467374395*^9}, {
  3.627339701354907*^9, 3.627339701420576*^9}},
 CellLabel->
  "In[431]:=",ExpressionUUID->"04d50dcc-acb7-4887-8d3e-129355d3ebed"],

Cell[TextData[{
 "UnitRegularPolygon",
 "Circumradius[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns the circumradius (radius of circumscribing circle) of the given \
unit polygon."
}], "Text",
 CellChangeTimes->{{3.457920562490625*^9, 3.457920576485923*^9}, {
   3.4622946848055077`*^9, 3.462294690307257*^9}, 
   3.627339701542382*^9},ExpressionUUID->"fed4db92-4fc4-466b-b9e2-\
566f1fd6a62e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularPolygonCircumradius", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"UnitRegularPolygonCircumradius", "[", "n", "]"}], "=", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Csc", "[", 
      FractionBox["\[Pi]", "n"], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.457920626181568*^9, 3.45792064546655*^9}, {
  3.627339701639048*^9, 3.627339701705201*^9}},
 CellLabel->
  "In[432]:=",ExpressionUUID->"89c725cc-1294-4f9c-8306-8305cfac8c98"],

Cell[TextData[{
 "UnitRegularPolygon",
 "Vertex[",
 StyleBox["j, n",
  FontSlant->"Italic"],
 "] returns the ",
 StyleBox["j",
  FontSlant->"Italic"],
 "th vertex of a unit ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-gon, where the ",
 StyleBox["j",
  FontSlant->"Italic"],
 "=1 vertex is located at the origin."
}], "Text",
 CellChangeTimes->{
  3.627339701826465*^9},ExpressionUUID->"c22f44b0-7534-41fc-acde-\
a0a8e931c5f6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularPolygonVertex", "[", 
    RowBox[{"j_", ",", " ", "n_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", "=", 
       RowBox[{"UnitRegularPolygonCenter", "[", "n", "]"}]}], "}"}], ",", 
     RowBox[{"c", "-", 
      RowBox[{
       RowBox[{"RotationMatrix2D", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"2", "\[Pi]"}], "n"], 
         RowBox[{"(", 
          RowBox[{"j", "-", "1"}], ")"}]}], "]"}], ".", "c"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.627339701921274*^9, 3.627339701989255*^9}, 
   3.688166836037679*^9},
 CellLabel->
  "In[433]:=",ExpressionUUID->"9cccbaf1-0938-41db-ac12-39c7e169f4b8"],

Cell[TextData[{
 "UnitRegularPolygon",
 "Vertices[",
 StyleBox["n",
  FontSlant->"Italic"],
 "] returns a list of all of the vertices of the given unit polygon. Observe \
that we remember the list for the future."
}], "Text",
 CellChangeTimes->{
  3.6273397021101513`*^9},ExpressionUUID->"e354aa4c-5de9-4266-af17-\
4d1a53114aa0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularPolygonVertices", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"UnitRegularPolygonVertices", "[", "n", "]"}], "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"UnitRegularPolygonVertex", "[", 
       RowBox[{"j", ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.62733970220622*^9, 3.627339702339019*^9}},
 CellLabel->
  "In[434]:=",ExpressionUUID->"b132d741-301b-44b6-a47f-6be2a10e2397"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit regular star polygons", "Subsection",
 CellChangeTimes->{{3.643133697746516*^9, 3.643133702857008*^9}, 
   3.708400981653216*^9},ExpressionUUID->"d2444829-ac8b-4b61-a427-\
df4b4f607b78"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.64313370979384*^9, 
  3.643133710232057*^9}},ExpressionUUID->"cf1ba8d6-895b-4fe9-adc6-\
16536fdde86d"],

Cell["\<\
Unit regular star polygons are used in certain types of tessellations and are \
parameterized by the \[OpenCurlyDoubleQuote]point\[CloseCurlyDoubleQuote] \
angle \[Alpha] (typically acute for a star polygon). Like other polygons, we \
assume a standard position with a point vertex at the original, the next \
reflex vertex at {1,0}, and circulation counterclockwise. Note that if you \
choose \[Alpha] to be the interior angle of a regular 2n-gon, the polygon \
will be a regular 2n-gon. Choosing larger values of \[Alpha] gives a star \
polygon with the reflex vertex at the origin.\
\>", "Text",
 CellChangeTimes->{{3.6431337219357157`*^9, 
  3.643133869510096*^9}},ExpressionUUID->"12cdf13c-7f03-41ae-8cf0-\
54f6e5626786"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitRegularStarPolygonCenter[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]]\nUnitRegularStarPolygonPointRadius[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]]\nUnitRegularStarPolygonOtherRadius[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]]\nUnitRegularStarPolygonInradius[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]]\nUnitRegularStarPolygonCircumradius[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]]\nUnitRegularStarPolygonVertex[",
 StyleBox["j",
  FontSlant->"Italic"],
 ", ",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]]\nUnitRegularStarPolygonVertices[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]]"
}], "Subsubsection",
 CellChangeTimes->{{3.643133873893718*^9, 3.643133885164405*^9}, {
   3.643133955608238*^9, 3.6431340155693913`*^9}, 3.643134258100274*^9, 
   3.643134367681306*^9, {3.643134540530353*^9, 
   3.64313456199962*^9}},ExpressionUUID->"d3af1cc1-691d-4db5-bc29-\
ac71f97dd4cf"],

Cell[TextData[{
 "UnitRegularStarPolygonCenter[n, \[Alpha]] returns the center of an ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-pointed unit regular star polygon with point angle \[Alpha]."
}], "Text",
 CellChangeTimes->{{3.643134391723096*^9, 
  3.643134426408946*^9}},ExpressionUUID->"bb401f3a-5056-49dd-8e83-\
3631c7dde6b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularStarPolygonCenter", "[", 
    RowBox[{"n_", ",", "\[Alpha]_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"\[Alpha]", "/", "2"}], "]"}], 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Pi]", "/", "n"}], "]"}]], 
     RowBox[{"U", "[", 
      RowBox[{
       FractionBox["\[Alpha]", "2"], "+", 
       FractionBox["\[Pi]", "n"]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.643134104654634*^9, 3.643134229262227*^9}, 
   3.643134338769045*^9, {3.643135445295263*^9, 3.643135450240681*^9}},
 CellLabel->
  "In[435]:=",ExpressionUUID->"9ebb5fb5-cd26-4e22-b5d5-71b3fcdbff39"],

Cell[TextData[{
 "UnitRegularStarPolygonPointRadius[n, \[Alpha]] returns the radius that \
passed through the \[Alpha]-points of an ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-pointed unit regular star polygon with point angle \[Alpha]."
}], "Text",
 CellChangeTimes->{{3.6431344458107986`*^9, 
  3.643134486380643*^9}},ExpressionUUID->"96b3299b-5ffe-4bd7-9b71-\
bc62776b6be8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularStarPolygonPointRadius", "[", 
    RowBox[{"n_", ",", " ", "\[Alpha]_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"\[Alpha]", "/", "2"}], "-", 
      RowBox[{"\[Pi]", "/", "n"}]}], "]"}], 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Pi]", "/", "n"}], "]"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.643134283774146*^9, 3.643134337913626*^9}, {
   3.643134385559441*^9, 3.643134387728215*^9}, {3.643134440892284*^9, 
   3.643134441097772*^9}, {3.643134533646343*^9, 3.643134534090978*^9}, 
   3.643134583630266*^9, {3.64313545533579*^9, 3.643135462249796*^9}},
 CellLabel->
  "In[436]:=",ExpressionUUID->"b4372617-a0e6-494d-a130-10738ba52cee"],

Cell[TextData[{
 "UnitRegularStarPolygonReflexRadius[n, \[Alpha]] returns the radius that \
passed through the other (non-\[Alpha]) points of an ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-pointed unit regular star polygon with point angle \[Alpha]."
}], "Text",
 CellChangeTimes->{{3.6431344458107986`*^9, 
  3.643134519890346*^9}},ExpressionUUID->"71b6d6d8-d9dd-4221-ad6a-\
8e825afaf2f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitRegularStarPolygonOtherRadius", "[", 
    RowBox[{"n_", ",", " ", "\[Alpha]_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"\[Alpha]", "/", "2"}], "]"}], 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Pi]", "/", "n"}], "]"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.643134283774146*^9, 3.643134337913626*^9}, {
  3.643134385559441*^9, 3.643134387728215*^9}, {3.643134440892284*^9, 
  3.643134441097772*^9}, {3.643134580085132*^9, 3.643134600744519*^9}, {
  3.643135468254936*^9, 3.643135468550468*^9}},
 CellLabel->
  "In[437]:=",ExpressionUUID->"32c9a100-67ec-42fb-a287-b6ff4c2ba7cc"],

Cell[TextData[{
 "UnitRegularStarPolygonInradius[n, \[Alpha]] returns the radius that \
inscribes an ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-pointed unit regular star polygon with point angle \[Alpha]."
}], "Text",
 CellChangeTimes->{{3.6431344458107986`*^9, 3.643134486380643*^9}, {
  3.643134617550432*^9, 
  3.643134635978082*^9}},ExpressionUUID->"fca388e7-10c9-4610-acde-\
1cd48ba5147b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitRegularStarPolygonInradius", "[", 
   RowBox[{"n_", ",", " ", "\[Alpha]_"}], "]"}], ":=", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{"UnitRegularStarPolygonPointRadius", "[", 
     RowBox[{"n", ",", "\[Alpha]"}], "]"}], ",", 
    RowBox[{"UnitRegularStarPolygonOtherRadius", "[", 
     RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.643134283774146*^9, 3.643134337913626*^9}, {
   3.643134385559441*^9, 3.643134387728215*^9}, {3.643134440892284*^9, 
   3.643134441097772*^9}, {3.643134533646343*^9, 3.643134534090978*^9}, 
   3.643134583630266*^9, {3.643134644996653*^9, 3.643134686706942*^9}},
 CellLabel->
  "In[438]:=",ExpressionUUID->"22589c19-7df4-44b8-8b84-310ad437cc24"],

Cell[TextData[{
 "UnitRegularStarPolygonCircumradius[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]] returns the radius that circumscribes an ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-pointed unit regular star polygon with point angle \[Alpha]."
}], "Text",
 CellChangeTimes->{{3.6431344458107986`*^9, 3.643134486380643*^9}, {
  3.643134617550432*^9, 3.643134635978082*^9}, {3.643134697072399*^9, 
  3.643134704174122*^9}},ExpressionUUID->"aacbed20-ba73-4a29-bfa2-\
c806c39d53e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitRegularStarPolygonCircumradius", "[", 
   RowBox[{"n_", ",", " ", "\[Alpha]_"}], "]"}], ":=", 
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{"UnitRegularStarPolygonPointRadius", "[", 
     RowBox[{"n", ",", "\[Alpha]"}], "]"}], ",", 
    RowBox[{"UnitRegularStarPolygonOtherRadius", "[", 
     RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.643134283774146*^9, 3.643134337913626*^9}, {
   3.643134385559441*^9, 3.643134387728215*^9}, {3.643134440892284*^9, 
   3.643134441097772*^9}, {3.643134533646343*^9, 3.643134534090978*^9}, 
   3.643134583630266*^9, {3.643134644996653*^9, 3.643134713568314*^9}},
 CellLabel->
  "In[439]:=",ExpressionUUID->"6649a0eb-e2e0-4b81-82c6-9960a1b07eba"],

Cell[TextData[{
 "UnitRegularStarPolygonVertex[",
 StyleBox["j",
  FontSlant->"Italic"],
 ", ",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]] returns the ",
 StyleBox["j",
  FontSlant->"Italic"],
 "th vertex of an ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-pointed unit regular star polygon with point angle \[Alpha], where the ",
 StyleBox["j",
  FontSlant->"Italic"],
 "=1 vertex is located at the origin."
}], "Text",
 CellChangeTimes->{{3.6431344458107986`*^9, 3.643134486380643*^9}, {
  3.643134617550432*^9, 3.643134635978082*^9}, {3.643134697072399*^9, 
  3.643134704174122*^9}, {3.643134853663604*^9, 3.643134908417233*^9}, {
  3.643135051727436*^9, 
  3.643135052495614*^9}},ExpressionUUID->"a0c9610d-b789-43fd-9171-\
80d394caf736"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitRegularStarPolygonVertex", "[", 
   RowBox[{
    StyleBox["j_",
     FontSlant->"Italic"], ",", " ", 
    StyleBox["n_",
     FontSlant->"Italic"], ",", " ", "\[Alpha]_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", "=", 
      RowBox[{"UnitRegularStarPolygonCenter", "[", 
       RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], "}"}], ",", 
    RowBox[{"c", "-", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"OddQ", "[", "j", "]"}], ",", 
        RowBox[{"UnitRegularStarPolygonPointRadius", "[", 
         RowBox[{"n", ",", "\[Alpha]"}], "]"}], ",", 
        RowBox[{"UnitRegularStarPolygonOtherRadius", "[", 
         RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], "]"}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"j", "-", "1"}], ")"}], 
         RowBox[{"\[Pi]", "/", "n"}]}], "+", 
        RowBox[{"\[Alpha]", "/", "2"}]}], "]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.643134763109041*^9, 3.643134820329238*^9}, {
   3.643134930177188*^9, 3.643135019283372*^9}, {3.643135536261426*^9, 
   3.643135563193258*^9}, {3.643135660552441*^9, 3.643135661202426*^9}, 
   3.643135691519329*^9},
 CellLabel->
  "In[440]:=",ExpressionUUID->"ebc641fc-5b24-480e-a321-855af15e3c43"],

Cell[TextData[{
 "UnitRegularStarPolygonVertices[",
 StyleBox["n",
  FontSlant->"Italic"],
 ", \[Alpha]] returns a list of the vertices of an ",
 StyleBox["n",
  FontSlant->"Italic"],
 "-pointed unit regular star polygon with point angle \[Alpha]. Unlike unit \
regular polygons, we don\[CloseCurlyQuote]t remember the list for the future, \
since \[Alpha] can vary continuously."
}], "Text",
 CellChangeTimes->{{3.6431344458107986`*^9, 3.643134486380643*^9}, {
  3.643134617550432*^9, 3.643134635978082*^9}, {3.643134697072399*^9, 
  3.643134704174122*^9}, {3.643134853663604*^9, 3.643134908417233*^9}, {
  3.6431350434660883`*^9, 
  3.64313512347031*^9}},ExpressionUUID->"5b1ef010-e1a2-4c2b-90c2-\
86072d8a1b2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitRegularStarPolygonVertices", "[", 
   RowBox[{
    StyleBox["n_",
     FontSlant->"Italic"], ",", " ", "\[Alpha]_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"c", "=", 
       RowBox[{"UnitRegularStarPolygonCenter", "[", 
        RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], ",", 
      RowBox[{"ro", "=", 
       RowBox[{"UnitRegularStarPolygonPointRadius", "[", 
        RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], ",", 
      RowBox[{"ri", "=", 
       RowBox[{"UnitRegularStarPolygonOtherRadius", "[", 
        RowBox[{"n", ",", "\[Alpha]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"c", "-", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"OddQ", "[", "j", "]"}], ",", "ro", ",", "ri"}], "]"}], 
        RowBox[{"U", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"j", "-", "1"}], ")"}], 
           RowBox[{"\[Pi]", "/", "n"}]}], "+", 
          RowBox[{"\[Alpha]", "/", "2"}]}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", 
        RowBox[{"2", "n"}]}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.643135086147949*^9, 3.643135090415261*^9}, {
  3.643135126740054*^9, 3.643135196084592*^9}, {3.643135544435782*^9, 
  3.643135552361114*^9}, {3.643135671394722*^9, 3.643135684762635*^9}},
 CellLabel->
  "In[441]:=",ExpressionUUID->"92049a8d-a9bd-4409-9243-ae22431de33f"],

Cell["Example", "Text",
 CellChangeTimes->{{3.643135199565476*^9, 
  3.643135201093449*^9}},ExpressionUUID->"798a1b0d-afd2-4529-9809-\
1f12162c28ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", "\[Alpha]", ",", "ctr"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", "5"}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Alpha]", "=", 
      RowBox[{"36", "\[Degree]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ctr", "=", 
      RowBox[{"UnitRegularStarPolygonCenter", "[", 
       RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Point", "[", "ctr", "]"}], ",", 
           RowBox[{"PointSize", "[", ".02", "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"AppendFirst", "[", 
             RowBox[{"UnitRegularStarPolygonVertices", "[", 
              RowBox[{"n", ",", "\[Alpha]"}], "]"}], "]"}], "]"}], ",", 
           "Blue"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{"ctr", ",", 
             RowBox[{"UnitRegularStarPolygonPointRadius", "[", 
              RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], "]"}], ",", "Red"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Circle", "[", 
            RowBox[{"ctr", ",", 
             RowBox[{"UnitRegularStarPolygonOtherRadius", "[", 
              RowBox[{"n", ",", "\[Alpha]"}], "]"}]}], "]"}], ",", "Green"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"ToString", "[", "j", "]"}], ",", 
               RowBox[{"UnitRegularStarPolygonVertex", "[", 
                RowBox[{"j", ",", "n", ",", "\[Alpha]"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", 
               RowBox[{"2", "n"}]}], "}"}]}], "]"}], ",", "Black"}], "]"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.643135207763076*^9, 3.643135423228578*^9}, {
  3.643135581321273*^9, 3.64313563214866*^9}},
 CellLabel->
  "In[442]:=",ExpressionUUID->"c68a859b-4d65-4c0e-bfef-dcc8cc042bfa"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unit quadrilaterals", "Subsection",
 CellChangeTimes->{{3.630106998971417*^9, 3.630107002203305*^9}, 
   3.70840097884039*^9},ExpressionUUID->"8980a85e-c209-48aa-b2be-\
003f40d1f7e8"],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection",
 CellChangeTimes->{{3.630107005121952*^9, 
  3.630107005593856*^9}},ExpressionUUID->"333558f0-71b0-41ba-bd53-\
4ccd5a416ba5"],

Cell["\<\
A useful way of specifying a unit quadrilateral is by the corner angles plus \
the length of one of the other three sides.\
\>", "Text",
 CellChangeTimes->{{3.630107023992184*^9, 3.630107050111185*^9}, 
   3.795279759734872*^9},ExpressionUUID->"43e807b8-39c8-480c-9ad4-\
db092e60fccc"],

Cell["\<\
Alternatively, we can just try to find one whose side lengths are as \
well-balanced as possible.\
\>", "Text",
 CellChangeTimes->{{3.7952797725818377`*^9, 3.7952798120524187`*^9}, {
  3.795279895405561*^9, 
  3.795279899292862*^9}},ExpressionUUID->"2ec8dd9f-5277-42f3-8ae3-\
1e233ee8cc31"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "UnitQuadrilateralVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side",
  FontSlant->"Italic"],
 ", ",
 StyleBox["is",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.6301071652792473`*^9, 
  3.630107219187219*^9}},ExpressionUUID->"60245649-38ae-44f1-9121-\
47eb39596958"],

Cell[TextData[{
 "UnitQuadrilateralVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", ",
 StyleBox["side",
  FontSlant->"Italic"],
 ", ",
 StyleBox["is",
  FontSlant->"Italic"],
 "] returns the vertices of a unit quadrilateral with corner angles ",
 StyleBox["angles",
  FontSlant->"Italic"],
 ", and the ",
 StyleBox["is",
  FontSlant->"Italic"],
 "-th side length is ",
 StyleBox["side",
  FontSlant->"Italic"],
 ". The last element of ",
 StyleBox["angles",
  FontSlant->"Italic"],
 " is ignored."
}], "Text",
 CellChangeTimes->{{3.630107500109829*^9, 3.630107535255574*^9}, {
  3.630108174359024*^9, 
  3.630108186185303*^9}},ExpressionUUID->"a081acdf-c6a6-40a6-b186-\
022a753e110d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UnitQuadrilateralVertices", "::", "badis"}], 
   "=", "\"\<Side length specifier `1` must be 2, 3, or 4.\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.630107555200094*^9, 3.630107575582885*^9}},
 CellLabel->
  "In[443]:=",ExpressionUUID->"5c4b0146-c6d9-4041-b492-ac05249fc9d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitQuadrilateralVertices", "[", 
   RowBox[{"angles_List", ",", " ", "side_", ",", " ", "is_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "verts", ",", "s2", ",", "s3", ",", "s4", ",", "v3", ",", "v4a", ",", 
      "v4b", ",", "eqns"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"v3", "=", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "+", 
       RowBox[{"s2", " ", 
        RowBox[{"U", "[", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{
          "angles", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
         "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"v4a", "=", 
      RowBox[{"v3", "+", 
       RowBox[{"s3", " ", 
        RowBox[{"U", "[", 
         RowBox[{
          RowBox[{"2", "\[Pi]"}], "-", 
          RowBox[{
          "angles", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "-", 
          RowBox[{
          "angles", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
         "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"v4b", "=", 
      RowBox[{"s4", " ", 
       RowBox[{"U", "[", 
        RowBox[{
        "angles", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"eqns", "=", 
      RowBox[{"Append", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "\[Equal]", "0"}], "&"}], "/@", 
         RowBox[{"(", 
          RowBox[{"v4a", "-", "v4b"}], ")"}]}], ",", 
        RowBox[{"Switch", "[", 
         RowBox[{"is", ",", "\[IndentingNewLine]", "2", ",", 
          RowBox[{"s2", "\[Equal]", "side"}], ",", "\[IndentingNewLine]", "3",
           ",", 
          RowBox[{"s3", "\[Equal]", "side"}], ",", "\[IndentingNewLine]", "4",
           ",", 
          RowBox[{"s4", "\[Equal]", "side"}], ",", "\[IndentingNewLine]", "_",
           ",", 
          RowBox[{
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"UnitQuadrilateralVertices", "::", "badis"}], ",", 
             "is"}], "]"}], ";", 
           RowBox[{"Abort", "[", "]"}]}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", "v3", ",", "v4a"}], "}"}], "/.", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{"eqns", ",", 
         RowBox[{"{", 
          RowBox[{"s2", ",", "s3", ",", "s4"}], "}"}]}], "]"}], "\[LeftDoubleBracket]",
        "1", "\[RightDoubleBracket]"}]}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.63010758409634*^9, 3.630107666686191*^9}, {
  3.630107723880464*^9, 3.630107792770894*^9}, {3.630107866209551*^9, 
  3.6301081416381197`*^9}},
 CellLabel->
  "In[444]:=",ExpressionUUID->"8a9fd877-8764-4f08-8aa0-f291bd9ecf40"],

Cell["Example", "Text",
 CellChangeTimes->{{3.630108145602402*^9, 
  3.630108146336698*^9}},ExpressionUUID->"3c3bf411-7a07-4886-9796-\
dac32d894eda"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "verts", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"verts", "=", 
      RowBox[{"UnitQuadrilateralVertices", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"90", "\[Degree]"}], ",", 
          RowBox[{"80", "\[Degree]"}], ",", 
          RowBox[{"110", "\[Degree]"}], ",", "0"}], "}"}], ",", ".6", ",", 
        "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"PrintThis", "[", "verts", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"AppendFirst", "[", "verts", "]"}], "]"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.63010821580811*^9, 3.630108333497298*^9}},
 CellLabel->
  "In[445]:=",ExpressionUUID->"6b507599-7c58-4a78-b11a-f4c3c648cb8c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "NiceUnitQuadrilateralVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.795279720878826*^9, 3.795279722164485*^9}, {
  3.795279830452323*^9, 
  3.795279860045193*^9}},ExpressionUUID->"43853b4b-011d-48ec-834f-\
32ba59013106"],

Cell[TextData[{
 "NiceUnitQuadrilateralVertices[",
 StyleBox["angles",
  FontSlant->"Italic"],
 "] takes a list of 3 or 4 corner angles and constructs a \
\[OpenCurlyDoubleQuote]nice\[CloseCurlyDoubleQuote] quadrilateral whose first \
edge runs from {0,0} to {1,0} and whose other 3 edges are as close as \
possible to unit length."
}], "Text",
 CellChangeTimes->{{3.7952788172772818`*^9, 3.795278869996984*^9}, {
   3.795279616618899*^9, 3.795279617811099*^9}, 3.7952798349303713`*^9, 
   3.7952798733421993`*^9},ExpressionUUID->"e8e68fb2-71e4-4544-b8e3-\
cabeda22b182"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["angles",
  FontSlant->"Italic"],
 " \[LongDash] a list of 3 (or 4) corner angles of the quadrilateral. Only \
the first 3 matter."
}], "Text",
 CellChangeTimes->{{3.7952795710490713`*^9, 3.795279595393692*^9}, 
   3.795279836503001*^9},ExpressionUUID->"aa8fc5f8-564d-441e-9432-\
ac0d1a5d9075"],

Cell["Returns: a list of the four vertices of the quadrilateral.", "Text",
 CellChangeTimes->{{3.795279597569638*^9, 
  3.795279608442386*^9}},ExpressionUUID->"97b256a0-046d-44b3-b351-\
388168808fff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NiceUnitQuadrilateralVertices", "[", "alist_List", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "p3", ",", "p4", ",", "a1", ",", "a2", ",", "a3", ",",
       "l2", ",", "l3", ",", "l4", ",", "soln"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a1", ",", "a2", ",", "a3"}], "}"}], "=", 
      RowBox[{"Take", "[", 
       RowBox[{"alist", ",", "3"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"p3", "=", 
      RowBox[{"p2", "+", 
       RowBox[{"l2", " ", 
        RowBox[{"U", "[", 
         RowBox[{"\[Pi]", "-", "a2"}], "]"}]}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p4", "=", 
      RowBox[{"LineInt2D", "[", 
       RowBox[{"p3", ",", 
        RowBox[{"U", "[", 
         RowBox[{"\[Pi]", "-", "a2", "+", "\[Pi]", "-", "a3"}], "]"}], ",", 
        "p1", ",", 
        RowBox[{"U", "[", "a1", "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"l3", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{"p4", "-", "p3"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"l4", "=", 
      RowBox[{"Mag", "[", 
       RowBox[{"p4", "-", "p1"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"soln", "=", 
      RowBox[{"FindMinimum", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"l2", "-", "1"}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"l3", "-", "1"}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"l4", "-", "1"}], ")"}], "2"]}], ",", 
          RowBox[{
           RowBox[{
           "p4", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], ">", 
           "0"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"l2", ",", "0"}], "}"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4"}], "}"}], "/.", 
      RowBox[{
      "soln", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7952787894050703`*^9, 3.79527880276506*^9}, {
   3.795278885325665*^9, 3.795278941758439*^9}, {3.795278983270218*^9, 
   3.795279263751787*^9}, 3.795279298258226*^9, {3.795279330571501*^9, 
   3.795279351450211*^9}, {3.7952794017404118`*^9, 3.79527943106629*^9}, {
   3.795279514196404*^9, 3.795279555002909*^9}, {3.795279622385*^9, 
   3.795279656879329*^9}, 3.795279874561091*^9, {3.796582556803562*^9, 
   3.7965825820257196`*^9}, {3.79658265334997*^9, 3.796582671972665*^9}},
 CellLabel->
  "In[446]:=",ExpressionUUID->"da888ece-7d46-4124-97f6-e786d1120ce1"],

Cell["Example.", "Text",
 CellChangeTimes->{{3.795279266039065*^9, 
  3.795279267887545*^9}},ExpressionUUID->"d89efddf-5a27-4386-bf80-\
1d042ada64a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"alist", ",", "plist"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"alist", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"90.", "\[Degree]"}], ",", 
        RowBox[{"95.", "\[Degree]"}], ",", 
        RowBox[{"88.", "\[Degree]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"plist", "=", 
      RowBox[{"NiceUnitQuadrilateralVertices", "[", "alist", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"AppendFirst", "[", "plist", "]"}], "]"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.795279268870914*^9, 3.79527930697685*^9}, 
   3.795279623752688*^9, {3.795279665173239*^9, 3.795279703819549*^9}, {
   3.795279875841455*^9, 3.795279889764982*^9}},
 CellLabel->
  "In[447]:=",ExpressionUUID->"227f3a5c-3abe-4cf8-8a8c-e96ef1e770b0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Star polygons", "Subsection",
 CellChangeTimes->{{3.79483048976143*^9, 
  3.794830505977067*^9}},ExpressionUUID->"4d91195e-0207-4e88-9fab-\
18639bb5d722"],

Cell[CellGroupData[{

Cell[TextData[{
 "TriangleStarTwistTriangle[",
 StyleBox["plist",
  FontSlant->"Italic"],
 ", ",
 StyleBox["dir",
  FontSlant->"Italic"],
 "]"
}], "Subsubsection",
 CellChangeTimes->{{3.794830508760944*^9, 3.794830544281656*^9}, {
  3.7948657350151997`*^9, 
  3.7948657358705873`*^9}},ExpressionUUID->"ea847e13-8661-420e-9e42-\
360da4f4d225"],

Cell[TextData[{
 "TriangleStarTwistTriangle[",
 StyleBox["plistIdir",
  FontSlant->"Italic"],
 "] take a list of 6 points forming a triangle star polygon with isoceles \
points and returns the vertices of the central triangle that allows it to be \
folded into a flat triangular twist."
}], "Text",
 CellChangeTimes->{{3.794830557868016*^9, 3.794830643386423*^9}, {
  3.794865742839894*^9, 
  3.794865750503686*^9}},ExpressionUUID->"f1a54ef9-0b04-402e-bc97-\
e555b4ff75e2"],

Cell[TextData[{
 "Arguments:\n\t",
 StyleBox["plist",
  FontSlant->"Italic"],
 " \[LongDash] a list {",
 StyleBox["p1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p3",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p4",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p5",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p6",
  FontSlant->"Italic"],
 "} of the vertices of the star, starting with one of the points, proceeding \
in CCW order.\n\tdir \[LongDash] +1 gives a CCW star twist, -1 gives a CW \
star twist."
}], "Text",
 CellChangeTimes->{{3.794830861444212*^9, 3.794830892931761*^9}, {
  3.794837107464466*^9, 3.794837113008745*^9}, {3.7948670386088133`*^9, 
  3.79486705817693*^9}},ExpressionUUID->"7bf1f1a9-9d66-4bcd-8590-\
cbdf2f1801dc"],

Cell[TextData[{
 "Returns: a list {",
 StyleBox["q1",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q3",
  FontSlant->"Italic"],
 ", ",
 StyleBox["q5",
  FontSlant->"Italic"],
 "} of the vertices of the central triangle. These are sufficent to construct \
the twist."
}], "Text",
 CellChangeTimes->{{3.794830895803956*^9, 3.7948309154201803`*^9}, {
  3.794837122776078*^9, 
  3.794837129320024*^9}},ExpressionUUID->"f2783943-fa40-4d6d-a990-\
b387331de1bf"],

Cell[TextData[{
 "The vertices should be given in CCW order. Note that the points of the star \
triangle must be isosceles triangles; the triangle formed by {",
 StyleBox["p2",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p4",
  FontSlant->"Italic"],
 ", ",
 StyleBox["p6",
  FontSlant->"Italic"],
 "} can be anything."
}], "Text",
 CellChangeTimes->{{3.794830918171267*^9, 3.794830934124454*^9}, {
  3.794831019421143*^9, 
  3.794831066788712*^9}},ExpressionUUID->"977b442a-4f1a-44ce-b26a-\
eb95498ac56c"],

Cell["\<\
This is used in the construction of tilted-pleat flagstone tessellations for \
interior vertices of the tiling of degree 3.\
\>", "Text",
 CellChangeTimes->{{3.794837032327627*^9, 3.794837098432273*^9}, {
  3.795114261610206*^9, 
  3.795114263162442*^9}},ExpressionUUID->"5f900421-7005-43ea-88d3-\
864e4984f598"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TriangleStarTwistTriangle", "::", "badlen"}], 
   "=", "\"\<List `1` must contain exactly six 2D points.\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.794831095317655*^9, 3.794831121117369*^9}},
 CellLabel->
  "In[448]:=",ExpressionUUID->"9644db9e-338b-45af-abbc-5e550938405c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangleStarTwistTriangle", "[", 
   RowBox[{"plist_List", ",", 
    RowBox[{"dir_", ":", "1"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6", ",", "u1", ",",
       "u3", ",", "u5", ",", "r1", ",", "r3", ",", "r5", ",", "c", ",", 
      "r1max", ",", "r3max", ",", "r5max", ",", "r1min", ",", "r3min", ",", 
      "r5min", ",", "q1", ",", "q3", ",", "q5", ",", "s2", ",", "s4", ",", 
      "s6", ",", "soln"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "plist", "]"}], "\[NotEqual]", "6"}], ",", 
       RowBox[{
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"TriangleStarTwistTriangle", "::", "badlen"}], ",", 
          "plist"}], "]"}], ";", 
        RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6"}], 
       "}"}], "=", "plist"}], ";", "\[IndentingNewLine]", 
     RowBox[{"u1", "=", 
      RowBox[{"NormalizeReal", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"p6", "+", "p2"}], "2"], "-", "p1"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"u3", "=", 
      RowBox[{"NormalizeReal", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"p2", "+", "p4"}], "2"], "-", "p3"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"u5", "=", 
      RowBox[{"NormalizeReal", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"p4", "+", "p6"}], "2"], "-", "p5"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "parameterized", " ", "points", " ", "along", " ", "bisectors", " ", 
       "of", " ", "sharp", " ", "points", " ", "to", " ", "form", " ", 
       "central", " ", "triangle"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"q1", "=", 
      RowBox[{"p1", "+", 
       RowBox[{"r1", " ", "u1"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q3", "=", 
      RowBox[{"p3", "+", 
       RowBox[{"r3", " ", "u3"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"q5", "=", 
      RowBox[{"p5", "+", 
       RowBox[{"r5", " ", "u5"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "max", " ", "values", " ", "of", " ", "r", " ", "come", " ", "from", " ",
        "the", " ", "intersection", " ", "point", " ", "of", " ", "any", " ", 
       "two", " ", "bisectors"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c", "=", 
      RowBox[{"LineInt2D", "[", 
       RowBox[{"p1", ",", "u1", ",", "p3", ",", "u3"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"r1max", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", "p1"}], ")"}], ".", "u1"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"r3max", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", "p3"}], ")"}], ".", "u3"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"r5max", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "-", "p5"}], ")"}], ".", "u5"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
        "minimum", " ", "values", " ", "come", " ", "from", " ", "twist", " ",
          "direction"}], ";", " ", 
        RowBox[{"dir", "=", 
         RowBox[{
          RowBox[{"+", "1"}], " ", "is", " ", "CCW"}]}]}], ",", " ", 
       RowBox[{"dir", "=", 
        RowBox[{
         RowBox[{"-", "1"}], " ", "is", " ", "CW"}]}]}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"dir", "\[Equal]", 
        RowBox[{"+", "1"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"CCW", " ", "twist"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"r1min", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LineInt2D1", "[", 
               RowBox[{"p1", ",", 
                RowBox[{"p1", "+", "u1"}], ",", "p5", ",", "p6"}], "]"}], "-",
               "p1"}], ")"}], ".", "u1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r3min", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LineInt2D1", "[", 
               RowBox[{"p3", ",", 
                RowBox[{"p3", "+", "u3"}], ",", "p1", ",", "p2"}], "]"}], "-",
               "p3"}], ")"}], ".", "u3"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r5min", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LineInt2D1", "[", 
               RowBox[{"p5", ",", 
                RowBox[{"p5", "+", "u5"}], ",", "p3", ",", "p4"}], "]"}], "-",
               "p5"}], ")"}], ".", "u5"}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"CW", " ", "twist"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"r1min", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LineInt2D1", "[", 
               RowBox[{"p1", ",", 
                RowBox[{"p1", "+", "u1"}], ",", "p3", ",", "p2"}], "]"}], "-",
               "p1"}], ")"}], ".", "u1"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r3min", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LineInt2D1", "[", 
               RowBox[{"p3", ",", 
                RowBox[{"p3", "+", "u3"}], ",", "p5", ",", "p4"}], "]"}], "-",
               "p3"}], ")"}], ".", "u3"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"r5min", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"LineInt2D1", "[", 
               RowBox[{"p5", ",", 
                RowBox[{"p5", "+", "u5"}], ",", "p1", ",", "p6"}], "]"}], "-",
               "p5"}], ")"}], ".", "u5"}]}], "]"}]}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Reflect", " ", "reflex", " ", "corners", " ", "through", " ", "sides", 
       " ", "of", " ", "central", " ", "triangle"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"s2", "=", 
      RowBox[{"Reflect2D", "[", 
       RowBox[{"p2", ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q3"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"s4", "=", 
      RowBox[{"Reflect2D", "[", 
       RowBox[{"p4", ",", 
        RowBox[{"{", 
         RowBox[{"q3", ",", "q5"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"s6", "=", 
      RowBox[{"Reflect2D", "[", 
       RowBox[{"p6", ",", 
        RowBox[{"{", 
         RowBox[{"q5", ",", "q1"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Minimize", " ", "the", " ", "area", " ", "of", " ", "the", " ", 
       "resulting", " ", 
       RowBox[{"triangle", ".", " ", "Should"}], " ", "be", " ", "very", " ", 
       "close", " ", "to", " ", 
       RowBox[{"zero", ".", " ", "Suppress"}], " ", "warning", " ", 
       "messages", " ", "about", " ", 
       RowBox[{"tolerance", "."}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"soln", "=", 
      RowBox[{"Quiet", "[", 
       RowBox[{
        RowBox[{"FindMinimum", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"Det", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"s6", "-", "s4"}], ",", 
                RowBox[{"s2", "-", "s4"}]}], "}"}], "]"}], "2"], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"r1", "<", "r1max"}], ",", 
              RowBox[{"r3", "<", "r3max"}], ",", 
              RowBox[{"r5", "<", "r5max"}], ",", 
              RowBox[{"r1", ">", "r1min"}], ",", 
              RowBox[{"r3", ">", "r3min"}], ",", 
              RowBox[{"r5", ">", "r5min"}]}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"r1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"r3", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"r5", ",", "0"}], "}"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"FindMinimum", "::", "lstol"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q3", ",", "q5"}], "}"}], "/.", 
      RowBox[{
      "soln", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.794830820433764*^9, 3.794830849427984*^9}, {
  3.794831083902591*^9, 3.79483108645263*^9}, {3.794831125021162*^9, 
  3.794831150366047*^9}, {3.794831694762697*^9, 3.794832135205022*^9}, {
  3.794832195605631*^9, 3.794832278574259*^9}, {3.794834544415896*^9, 
  3.794834544972947*^9}, {3.794834790841562*^9, 3.794834897447509*^9}, {
  3.794835729994771*^9, 3.794835735160378*^9}, {3.794836666441327*^9, 
  3.794836747890019*^9}, {3.794865260224983*^9, 3.794865558959604*^9}, {
  3.794865647587227*^9, 3.794865683448739*^9}, {3.794865720818071*^9, 
  3.794865781234503*^9}, {3.794865864701*^9, 3.794865927130763*^9}, {
  3.794866103292474*^9, 3.794866117901025*^9}, {3.794866157165401*^9, 
  3.794866268510347*^9}, {3.794866339542837*^9, 3.794866399286853*^9}, {
  3.7948664850116777`*^9, 3.79486655316031*^9}, {3.794866636339818*^9, 
  3.794866639817541*^9}},
 CellLabel->
  "In[449]:=",ExpressionUUID->"fa1d2e32-e006-43a0-a132-65f8d96c4376"],

Cell["Example: a CCW triangle start twist.", "Text",
 CellChangeTimes->{{3.794831155629176*^9, 3.794831156437441*^9}, 
   3.794836750973656*^9, {3.794866687430545*^9, 
   3.794866702342241*^9}},ExpressionUUID->"f1b82850-7620-419c-bfe6-\
3db5a63fe5d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6", ",", 
      "plist", ",", "q1", ",", "q3", ",", "q5", ",", "qlist", ",", "s"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{"p4", "=", 
      RowBox[{"{", 
       RowBox[{"1.4", ",", "1"}], "}"}]}], ";", 
     RowBox[{"p6", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".3"}], ",", "1.4"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p1", "=", 
      RowBox[{
       RowBox[{"1.5", 
        RowBox[{
         RowBox[{"RotationMatrix2D", "[", 
          RowBox[{"\[Pi]", "/", "2"}], "]"}], ".", 
         RowBox[{"(", 
          RowBox[{"p6", "-", "p2"}], ")"}]}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p6", "+", "p2"}], ")"}], "/", "2"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p3", "=", 
      RowBox[{
       RowBox[{"1.2", 
        RowBox[{
         RowBox[{"RotationMatrix2D", "[", 
          RowBox[{"\[Pi]", "/", "2"}], "]"}], ".", 
         RowBox[{"(", 
          RowBox[{"p2", "-", "p4"}], ")"}]}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p2", "+", "p4"}], ")"}], "/", "2"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p5", "=", 
      RowBox[{
       RowBox[{"1.4", 
        RowBox[{
         RowBox[{"RotationMatrix2D", "[", 
          RowBox[{"\[Pi]", "/", "2"}], "]"}], ".", 
         RowBox[{"(", 
          RowBox[{"p4", "-", "p6"}], ")"}]}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p4", "+", "p6"}], ")"}], "/", "2"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"plist", "=", 
      RowBox[{"{", 
       RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6"}], 
       "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"qlist", "=", 
      RowBox[{"TriangleStarTwistTriangle", "[", 
       RowBox[{"plist", ",", 
        RowBox[{"+", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q1", ",", "q3", ",", "q5"}], "}"}], "=", "qlist"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"s", "=", 
      RowBox[{"Reflect2D", "[", 
       RowBox[{"p2", ",", 
        RowBox[{"{", 
         RowBox[{"q1", ",", "q3"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"MapThread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"#1", ",", "#2", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], "&"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\"\<p1\>\"", ",", "\"\<p2\>\"", ",", "\"\<p3\>\"", 
               ",", "\"\<p4\>\"", ",", "\"\<p5\>\"", ",", "\"\<p6\>\""}], 
              "}"}], ",", "plist"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"MapThread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{"#1", ",", "#2", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0"}], "}"}]}], "]"}], "&"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<q1\>\"", ",", "\"\<q3\>\"", ",", "\"\<q5\>\""}], 
              "}"}], ",", "qlist"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{"\"\<s\>\"", ",", "s", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"AppendFirst", "[", "plist", "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"p1", ",", "q1"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"p3", ",", "q3"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"p5", ",", "q5"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q1", ",", "q3", ",", "q5", ",", "q1"}], "}"}], 
              "]"}]}], "}"}], ",", "Red"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q1", ",", "s"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q3", ",", "s"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q5", ",", "s"}], "}"}], "]"}]}], "}"}], ",", 
           "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q1", ",", "p2"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q3", ",", "p4"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q5", ",", "p6"}], "}"}], "]"}]}], "}"}], ",", 
           "LightGray"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q1", ",", "p6"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q3", ",", "p2"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"q5", ",", "p4"}], "}"}], "]"}]}], "}"}], ",", 
           "Blue"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "/@", "plist"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "/@", "qlist"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", "s", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", "ShowExample"}]], "Input",
 CellChangeTimes->{{3.794831158518945*^9, 3.79483154732972*^9}, {
  3.794831578548337*^9, 3.794831682336982*^9}, {3.794832044341076*^9, 
  3.794832047731716*^9}, {3.79483228444837*^9, 3.794832355861258*^9}, {
  3.794834476824183*^9, 3.794834498229343*^9}, {3.794834934609324*^9, 
  3.794834996149297*^9}, {3.794835041700327*^9, 3.794835077539422*^9}, {
  3.794836779016938*^9, 3.794836953834412*^9}, {3.794837181653582*^9, 
  3.794837183545561*^9}, {3.794866660721559*^9, 3.794866665143204*^9}, {
  3.794866757635939*^9, 3.794866848802165*^9}, {3.794867021645071*^9, 
  3.794867023672833*^9}},
 CellLabel->
  "In[450]:=",ExpressionUUID->"f65c2556-b56f-4d49-af52-f6b1afb21c25"],

Cell["Example: a CW triangle star twist with the same vertices.", "Text",
 CellChangeTimes->{{3.794831155629176*^9, 3.794831156437441*^9}, 
   3.794836750973656*^9, {3.794866687430545*^9, 3.7948667105101027`*^9}, 
   3.79486691115352*^9, {3.795017716399174*^9, 
   3.795017719648411*^9}},ExpressionUUID->"e4d1d28e-6c8d-4bbc-b9bd-\
a1ce7705f01e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6", ",", 
      "plist", ",", "q1", ",", "q3", ",", "q5", ",", "qlist", ",", "s"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"p2", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", 
     RowBox[{"p4", "=", 
      RowBox[{"{", 
       RowBox[{"1.4", ",", "1"}], "}"}]}], ";", 
     RowBox[{"p6", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".3"}], ",", "1.4"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p1", "=", 
      RowBox[{
       RowBox[{"1.5", 
        RowBox[{
         RowBox[{"RotationMatrix2D", "[", 
          RowBox[{"\[Pi]", "/", "2"}], "]"}], ".", 
         RowBox[{"(", 
          RowBox[{"p6", "-", "p2"}], ")"}]}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p6", "+", "p2"}], ")"}], "/", "2"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"p3", "=", 
      RowBox[{
       RowBox[{"1.2", 
        RowBox[{
         RowBox[{"Ro